/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.tasklist.core.Task;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;

public final class TLUtils {
    public static final Logger LOGGER = TLUtils.getLogger(TLUtils.class);

    public static String toHTML(String string) {
        StringBuffer stringBuffer = new StringBuffer(2 * string.length());
        int n = string.length();
        block7: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '\n': {
                    stringBuffer.append("<br>");
                    continue block7;
                }
                default: {
                    stringBuffer.append(string.charAt(i));
                }
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createBackup(File file) throws IOException {
        File file2 = file.getParentFile();
        File file3 = new File(file2, file.getName() + "~");
        if (file3.exists() && !file3.delete()) {
            throw new IOException("Cannot delete the file");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file3);
            try {
                FileChannel fileChannel = fileInputStream.getChannel();
                FileChannel fileChannel2 = fileOutputStream.getChannel();
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(16384);
                byteBuffer.clear();
                while (fileChannel.read(byteBuffer) >= 0 || byteBuffer.hasRemaining()) {
                    byteBuffer.flip();
                    fileChannel2.write(byteBuffer);
                    byteBuffer.compact();
                }
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
                throw throwable;
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
            throw throwable;
        }
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }

    public static Line getLineByNumber(DataObject dataObject, int n) {
        try {
            Line.Set set;
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (lineCookie != null && (set = lineCookie.getLineSet()) != null) {
                Line line = set.getCurrent(n - 1);
                return line;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (Exception exception) {
            ErrorManager.getDefault().log(16, "getLineByNumber - file " + dataObject + " and lineno=" + n);
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        return null;
    }

    public static void appendSurroundingLine(StringBuffer stringBuffer, Line line, int n) {
        DataObject dataObject = DataEditorSupport.findDataObject((Line)line);
        try {
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (lineCookie == null) {
                return;
            }
            Line.Set set = lineCookie.getLineSet();
            if (set == null) {
                return;
            }
            int n2 = line.getLineNumber();
            if (n2 + n < 0) {
                return;
            }
            Line line2 = set.getCurrent(n2 + n);
            TLUtils.appendHTMLString(stringBuffer, line2.getText());
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
    }

    public static int firstDiff(String string, String string2) {
        int n;
        int n2 = string.length();
        int n3 = n2 < (n = string2.length()) ? n2 : n;
        for (int i = 0; i < n3; ++i) {
            if (string.charAt(i) == string2.charAt(i)) continue;
            return i;
        }
        return n3;
    }

    public static int lastDiff(String string, String string2) {
        int n = string.length() - 1;
        int n2 = string2.length() - 1;
        int n3 = 0;
        while (n2 >= 0 && n >= 0) {
            if (string.charAt(n) != string2.charAt(n2)) {
                return n3;
            }
            --n2;
            --n;
            ++n3;
        }
        return n3;
    }

    public static void appendHTMLChar(StringBuffer stringBuffer, char c) {
        switch (c) {
            case '<': {
                stringBuffer.append("&lt;");
                break;
            }
            case '>': {
                stringBuffer.append("&gt;");
                break;
            }
            case '&': {
                stringBuffer.append("&amp;");
                break;
            }
            case '\"': {
                stringBuffer.append("&quot;");
                break;
            }
            case ' ': {
                stringBuffer.append("&nbsp;");
                break;
            }
            case '\n': {
                stringBuffer.append("<br>");
                break;
            }
            default: {
                stringBuffer.append(c);
            }
        }
    }

    public static void appendHTMLString(StringBuffer stringBuffer, String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            TLUtils.appendHTMLChar(stringBuffer, string.charAt(i));
        }
    }

    public static void appendAttributed(StringBuffer stringBuffer, String string, int n, int n2, boolean bl, boolean bl2) {
        if (n != -1) {
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                TLUtils.appendHTMLChar(stringBuffer, string.charAt(n3));
            }
            if (bl) {
                stringBuffer.append("<u>");
            }
            if (bl2) {
                stringBuffer.append("<b>");
            }
            for (n3 = n; n3 < n2; ++n3) {
                TLUtils.appendHTMLChar(stringBuffer, string.charAt(n3));
            }
            if (bl) {
                stringBuffer.append("</u>");
            }
            if (bl2) {
                stringBuffer.append("</b>");
            }
            n3 = string.length();
            for (int i = n2; i < n3; ++i) {
                TLUtils.appendHTMLChar(stringBuffer, string.charAt(i));
            }
        } else {
            TLUtils.appendHTMLString(stringBuffer, string);
        }
    }

    public static Element getElement(Document document, Line line) {
        if (document == null) {
            ErrorManager.getDefault().log(256, "d was null");
            return null;
        }
        if (!(document instanceof StyledDocument)) {
            ErrorManager.getDefault().log(256, "Not a styleddocument");
            return null;
        }
        StyledDocument styledDocument = (StyledDocument)document;
        Element element = styledDocument.getParagraphElement(0).getParentElement();
        if (element == null) {
            element = styledDocument.getDefaultRootElement();
        }
        int n = line.getLineNumber();
        Element element2 = element.getElement(n);
        return element2;
    }

    public static Document getDocument(Line line) {
        DataObject dataObject = DataEditorSupport.findDataObject((Line)line);
        if (!dataObject.isValid()) {
            return null;
        }
        return TLUtils.getDocument(dataObject);
    }

    public static Document getDocument(DataObject dataObject) {
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return null;
        }
        StyledDocument styledDocument = editorCookie.getDocument();
        return styledDocument;
    }

    public static boolean deleteLine(Line line, String string) {
        Document document = TLUtils.getDocument(line);
        Element element = TLUtils.getElement(document, line);
        if (element == null) {
            return false;
        }
        int n = element.getStartOffset();
        int n2 = element.getEndOffset();
        try {
            String string2 = document.getText(n, n2 - n);
            if (!string2.startsWith(string)) {
                return false;
            }
            document.remove(n, n2 - n);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify(16, (Throwable)badLocationException);
        }
        return false;
    }

    public static boolean commentLine(Line line, String string) {
        Document document = TLUtils.getDocument(line);
        Element element = TLUtils.getElement(document, line);
        if (element == null) {
            return false;
        }
        int n = element.getStartOffset();
        int n2 = element.getEndOffset();
        try {
            String string2 = document.getText(n, n2 - n);
            if (!string2.startsWith(string)) {
                return false;
            }
            document.insertString(n, "// ", null);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify(16, (Throwable)badLocationException);
        }
        return false;
    }

    public static String toURL(FileObject fileObject) {
        return URLMapper.findURL((FileObject)fileObject, (int)0).toExternalForm();
    }

    public static FileObject[] fromURL(String string) {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        return URLMapper.findFileObjects((URL)uRL);
    }

    public static int getChildrenCountRecursively(Node node) {
        if (node == null) {
            return 0;
        }
        Children children = node.getChildren();
        if (children.getNodesCount() == 0) {
            return 0;
        }
        int n = 0;
        Node[] nodeArray = children.getNodes();
        for (int i = 0; i < nodeArray.length; ++i) {
            n += TLUtils.getChildrenCountRecursively(nodeArray[i]) + 1;
        }
        return n;
    }

    public static Node.Property getProperty(Node node, String string) {
        Node.PropertySet[] propertySetArray = node.getPropertySets();
        for (int i = 0; i < propertySetArray.length; ++i) {
            Node.Property[] propertyArray = propertySetArray[i].getProperties();
            for (int j = 0; j < propertyArray.length; ++j) {
                if (!propertyArray[j].getName().equals(string)) continue;
                return propertyArray[j];
            }
        }
        return null;
    }

    public static Logger getLogger(Class clazz) {
        Logger logger = Logger.getLogger(clazz.getName());
        logger.setUseParentHandlers(false);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.FINE);
        logger.addHandler(consoleHandler);
        logger.setLevel(Level.WARNING);
        return logger;
    }

    public static void traceFocus(final Container container) {
        container.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                System.err.println("Component " + container + " gained focus.");
                Thread.dumpStack();
            }

            public void focusLost(FocusEvent focusEvent) {
                System.err.println("Component " + container + " lost focus.");
                Thread.dumpStack();
            }
        });
        Component[] componentArray = container.getComponents();
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof Container)) continue;
                TLUtils.traceFocus((Container)componentArray[i]);
            }
        }
    }

    public static int recursiveCount(Iterator iterator) {
        if (iterator == null) {
            return 0;
        }
        int n = 0;
        while (iterator.hasNext()) {
            Task task = (Task)iterator.next();
            n += task.getSubtaskCountRecursively() + 1;
        }
        return n;
    }

    public static void nodeRecursivePrint(Node node, int n) {
        if (n > 20) {
            Thread.dumpStack();
            return;
        }
        for (int i = 0; i < n; ++i) {
            System.err.print("   ");
        }
        System.err.println(node.getDisplayName());
        if (node.getChildren() != null && node.getChildren().getNodes() != null) {
            Node[] nodeArray = node.getChildren().getNodes();
            for (int i = 0; i < nodeArray.length; ++i) {
                TLUtils.nodeRecursivePrint(nodeArray[i], n + 1);
            }
        }
    }

    static {
        LOGGER.setLevel(Level.FINE);
    }
}

