/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.modules.tasklist.core.Task;
import org.netbeans.modules.tasklist.core.TaskAnnotation;
import org.netbeans.modules.tasklist.core.TaskListView;
import org.netbeans.modules.tasklist.core.TaskViewListener;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;

public final class TaskEditorListener
implements TaskViewListener,
PropertyChangeListener {
    private transient Annotation taskMarker = null;
    private static TaskEditorListener deflt = null;

    public TaskEditorListener() {
        deflt = this;
    }

    static TaskEditorListener getDefault() {
        return deflt == null ? new TaskEditorListener() : deflt;
    }

    public void showTask(Task task, Annotation annotation) {
        this.hideTask();
        if (task == null) {
            return;
        }
        Line line = task.getLine();
        if (line != null) {
            this.taskMarker = annotation != null ? annotation : new TaskAnnotation(task);
            this.taskMarker.attach((Annotatable)line);
            line.addPropertyChangeListener((PropertyChangeListener)this);
            TaskListView taskListView = TaskListView.getCurrent();
            if (taskListView.getClientProperty("isSliding") == Boolean.TRUE) {
                line.show(1);
            } else {
                line.show(2);
            }
        }
    }

    public void hideTask() {
        if (this.taskMarker != null) {
            Annotatable annotatable = this.taskMarker.getAttachedAnnotatable();
            annotatable.removePropertyChangeListener((PropertyChangeListener)this);
            this.taskMarker.detach();
            this.taskMarker = null;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("text".equals(propertyChangeEvent.getPropertyName())) {
            this.hideTask();
        }
    }
}

