/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.netbeans.modules.tasklist.core.ObservableList;
import org.netbeans.modules.tasklist.core.TLUtils;
import org.netbeans.modules.tasklist.core.Task;
import org.netbeans.modules.tasklist.core.TaskListener;

public class TaskList
implements ObservableList,
TaskListener {
    static final String USER_CATEGORY = "usertasks";
    private List tasks = new LinkedList();
    private List listCopy;
    private final ArrayList listeners = new ArrayList(67);
    protected boolean needSave = false;
    protected boolean dontSave = false;

    protected void setNeedSave(boolean bl) {
        this.needSave = bl;
    }

    protected void setDontSave(boolean bl) {
        this.dontSave = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List getTasks() {
        List list = this.tasks;
        synchronized (list) {
            if (this.listCopy == null) {
                this.listCopy = Collections.unmodifiableList(new ArrayList(this.tasks));
            }
            return this.listCopy;
        }
    }

    public void addRemove(List list, List list2, boolean bl, Task task, Task task2) {
        Task task3;
        Iterator iterator;
        this.setSilentUpdate(true, false);
        boolean bl2 = false;
        if (list2 != null) {
            iterator = list2.iterator();
            while (iterator.hasNext()) {
                task3 = (Task)iterator.next();
                if (task != null) {
                    task.removeSubtask(task3);
                    task3.removeTaskListener(this);
                } else {
                    this.removeTask(task3);
                }
                bl2 = true;
            }
        }
        if (list != null && list.size() > 0) {
            bl2 = true;
            if (task != null) {
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    task3 = (Task)iterator.next();
                    task3.addTaskListener(this);
                }
                task.addSubtasks(list, bl, task2);
            } else if (task2 != null) {
                this.addTasks(list, task2);
            } else {
                this.addTasks(list, bl);
            }
        }
        this.setSilentUpdate(false, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTasks(List list, boolean bl) {
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            List list2;
            Task task = (Task)iterator.next();
            task.addTaskListener(this);
            if (bl) {
                list2 = this.tasks;
                synchronized (list2) {
                    this.tasks.add(task);
                    this.listCopy = null;
                }
            }
            list2 = this.tasks;
            synchronized (list2) {
                this.tasks.add(n++, task);
                this.listCopy = null;
            }
            this.fireAdded(task);
        }
    }

    private void addTasks(List list, Task task) {
        int n = list.indexOf(task);
        if (n == -1) {
            this.addTasks(list, true);
        } else {
            list.addAll(n + 1, list);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Task task2 = (Task)iterator.next();
                task2.addTaskListener(this);
                this.fireAdded(task2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void appendTask(Task task) {
        task.addTaskListener(this);
        List list = this.tasks;
        synchronized (list) {
            this.tasks.add(task);
            this.listCopy = null;
        }
        this.fireAdded(task);
    }

    public final void removeTasks(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Task task = (Task)iterator.next();
            this.removeTask(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeTask(Task task) {
        int n;
        task.removeTaskListener(this);
        boolean bl = false;
        List list = this.tasks;
        synchronized (list) {
            n = this.tasks.indexOf(task);
            bl = this.tasks.remove(task);
            this.listCopy = null;
        }
        if (bl) {
            this.fireRemoved(null, task, n);
        }
    }

    public void markChanged() {
        this.needSave = true;
        this.save();
    }

    public void save() {
        this.needSave = false;
    }

    final void setSilentUpdate(boolean bl, boolean bl2) {
        this.dontSave = bl;
        this.needSave = true;
        if (!this.dontSave && bl2) {
            this.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskListener(TaskListener taskListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(taskListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaskListener(TaskListener taskListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(taskListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireAdded(Task task) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            int n = this.listeners.size();
            for (int i = 0; i < n; ++i) {
                TaskListener taskListener = (TaskListener)this.listeners.get(i);
                taskListener.addedTask(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireStructureChanged(Task task) {
        TaskListener[] taskListenerArray;
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            taskListenerArray = new TaskListener[this.listeners.size()];
            taskListenerArray = this.listeners.toArray(taskListenerArray);
        }
        for (int i = 0; i < taskListenerArray.length; ++i) {
            taskListenerArray[i].structureChanged(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRemoved(Task task, Task task2, int n) {
        TaskListener[] taskListenerArray;
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            taskListenerArray = new TaskListener[this.listeners.size()];
            taskListenerArray = this.listeners.toArray(taskListenerArray);
        }
        for (int i = 0; i < taskListenerArray.length; ++i) {
            taskListenerArray[i].removedTask(task, task2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        List list = this.tasks;
        synchronized (list) {
            return TLUtils.recursiveCount(this.tasks.iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List list = this.tasks;
        synchronized (list) {
            this.tasks.clear();
            this.listCopy = null;
        }
        this.fireStructureChanged(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print() {
        System.err.println("\nTask List:\n-------------");
        List list = this.tasks;
        synchronized (list) {
            Iterator iterator = this.tasks.iterator();
            while (iterator.hasNext()) {
                Task task = (Task)iterator.next();
                this.recursivePrint(task, 0);
            }
        }
        System.err.println("\n\n");
    }

    private void recursivePrint(Task task, int n) {
        if (n > 20) {
            Thread.dumpStack();
            return;
        }
        for (int i = 0; i < n; ++i) {
            System.err.print("   ");
        }
        System.err.println(task);
        if (task.getSubtasks() != null) {
            List list = task.getSubtasks();
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                Task task2 = (Task)listIterator.next();
                this.recursivePrint(task2, n + 1);
            }
        }
    }

    public void selectedTask(Task task) {
    }

    public void warpedTask(Task task) {
    }

    public void addedTask(Task task) {
        this.fireAdded(task);
    }

    public void removedTask(Task task, Task task2, int n) {
        this.fireRemoved(task, task2, n);
    }

    public void structureChanged(Task task) {
        this.fireStructureChanged(task);
    }

    public boolean isEmpty() {
        return this.tasks.size() == 0;
    }
}

