/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.tasklist.core.TLUtils;
import org.netbeans.modules.tasklist.core.Task;
import org.netbeans.modules.tasklist.core.TaskNode;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;

public final class TaskTransfer
implements ExClipboard.Convertor {
    private static final Logger LOGGER = TLUtils.getLogger(TaskNode.class);
    public static final DataFlavor TODO_FLAVOR;

    public Transferable convert(final Transferable transferable) {
        boolean bl = transferable.isDataFlavorSupported(DataFlavor.stringFlavor);
        boolean bl2 = transferable.isDataFlavorSupported(TODO_FLAVOR);
        if (bl && !bl2) {
            ExTransferable exTransferable = ExTransferable.create((Transferable)transferable);
            exTransferable.put(new ExTransferable.Single(TODO_FLAVOR){

                protected Object getData() throws IOException, UnsupportedFlavorException {
                    String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    return Task.parse(new StringReader(string));
                }
            });
            return exTransferable;
        }
        if (!bl && bl2) {
            ExTransferable exTransferable = ExTransferable.create((Transferable)transferable);
            exTransferable.put(new ExTransferable.Single(DataFlavor.stringFlavor){

                protected Object getData() throws IOException, UnsupportedFlavorException {
                    Task task = (Task)transferable.getTransferData(TODO_FLAVOR);
                    StringWriter stringWriter = new StringWriter();
                    Task.generate(task, stringWriter);
                    return stringWriter.toString();
                }
            });
            return exTransferable;
        }
        if (transferable.isDataFlavorSupported(ExTransferable.multiFlavor)) {
            LOGGER.fine("multi selection");
            try {
                final MultiTransferObject multiTransferObject = (MultiTransferObject)transferable.getTransferData(ExTransferable.multiFlavor);
                boolean bl3 = multiTransferObject.areDataFlavorsSupported(new DataFlavor[]{TODO_FLAVOR});
                if (bl3) {
                    LOGGER.fine("multi selection all supports todo");
                    ExTransferable exTransferable = ExTransferable.create((Transferable)transferable);
                    if (!bl) {
                        exTransferable.put(new ExTransferable.Single(DataFlavor.stringFlavor){

                            protected Object getData() throws IOException, UnsupportedFlavorException {
                                StringWriter stringWriter = new StringWriter();
                                for (int i = 0; i < multiTransferObject.getCount(); ++i) {
                                    Task task = (Task)multiTransferObject.getTransferData(i, TODO_FLAVOR);
                                    Task.generate(task, stringWriter);
                                }
                                return stringWriter.toString();
                            }
                        });
                    }
                    return exTransferable;
                }
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
        return transferable;
    }

    static {
        LOGGER.setLevel(Level.OFF);
        TODO_FLAVOR = new DataFlavor(Task.class, NbBundle.getMessage((Class)TaskTransfer.class, (String)"LBL_todo_flavor"));
    }
}

