/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.checklist;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.KeyStroke;
import org.netbeans.modules.tasklist.core.checklist.AbstractCheckListModel;
import org.netbeans.modules.tasklist.core.checklist.CheckListModel;
import org.netbeans.modules.tasklist.core.checklist.DefaultCheckListCellRenderer;
import org.netbeans.modules.tasklist.core.checklist.DefaultCheckListModel;

public class CheckList
extends JList {
    private static final long serialVersionUID = 1L;

    public CheckList(CheckListModel checkListModel) {
        super(checkListModel);
        this.setCellRenderer(new DefaultCheckListCellRenderer());
        CheckAction checkAction = new CheckAction();
        this.getActionMap().put("check", checkAction);
        this.registerKeyboardAction(checkAction, KeyStroke.getKeyStroke(' '), 0);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                CheckListModel checkListModel;
                JList jList = (JList)mouseEvent.getComponent();
                int n = jList.locationToIndex(mouseEvent.getPoint());
                if (n < 0) {
                    return;
                }
                if (mouseEvent.getX() > 15) {
                    return;
                }
                checkListModel.setChecked(n, !(checkListModel = (CheckListModel)CheckList.this.getModel()).isChecked(n));
                mouseEvent.consume();
                CheckList.this.repaint();
            }
        });
    }

    public CheckList(boolean[] blArray, Object[] objectArray) {
        this(new DefaultCheckListModel(blArray, objectArray));
    }

    public CheckList() {
        this(new AbstractCheckListModel(){

            public boolean isChecked(int n) {
                return false;
            }

            public void setChecked(int n, boolean bl) {
            }

            public int getSize() {
                return 0;
            }

            public Object getElementAt(int n) {
                return null;
            }
        });
    }

    public void setModel(CheckListModel checkListModel) {
        super.setModel(checkListModel);
    }

    public static class CheckAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public void actionPerformed(ActionEvent actionEvent) {
            CheckListModel checkListModel;
            JList jList = (JList)actionEvent.getSource();
            int n = jList.getSelectedIndex();
            if (n < 0) {
                return;
            }
            checkListModel.setChecked(n, !(checkListModel = (CheckListModel)jList.getModel()).isChecked(n));
        }
    }
}

