/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.columns;

import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.tasklist.core.ColumnProperty;
import org.netbeans.modules.tasklist.core.TaskListView;

public class ColumnsConfiguration {
    private ArrayList listeners = new ArrayList();
    private int[] widths;
    private String[] properties;
    private String sortingColumn;
    private boolean ascending;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ColumnsConfiguration(String[] stringArray, int[] nArray, String string, boolean bl) {
        this.properties = stringArray;
        this.widths = nArray;
        this.sortingColumn = string;
        this.ascending = bl;
    }

    public void setValues(String[] stringArray, int[] nArray, String string, boolean bl) {
        this.properties = stringArray;
        this.widths = nArray;
        this.sortingColumn = string;
        this.ascending = bl;
        this.fireChange();
    }

    public int[] getWidths() {
        return this.widths;
    }

    public String[] getProperties() {
        return this.properties;
    }

    public String getSortingColumn() {
        return this.sortingColumn;
    }

    public boolean getSortingOrder() {
        return this.ascending;
    }

    public void setSortingOrder(boolean bl) {
        this.ascending = bl;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    protected final void fireChange() {
        ChangeEvent changeEvent = null;
        for (int i = 0; i < this.listeners.size(); ++i) {
            ChangeListener changeListener = (ChangeListener)this.listeners.get(i);
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            changeListener.stateChanged(changeEvent);
        }
    }

    public static void loadColumnsFrom(TaskListView taskListView, ColumnsConfiguration columnsConfiguration) {
        Object object;
        Object object2;
        ColumnProperty[] columnPropertyArray = taskListView.getColumns();
        ColumnProperty columnProperty = null;
        for (int i = 0; i < columnPropertyArray.length; ++i) {
            Object object3 = columnPropertyArray[i].getValue("TreeColumnTTV");
            if (!(object3 instanceof Boolean) || !((Boolean)object3).booleanValue()) continue;
            columnProperty = columnPropertyArray[i];
            break;
        }
        if (!$assertionsDisabled && columnProperty == null) {
            throw new AssertionError();
        }
        ColumnProperty columnProperty2 = null;
        boolean bl = false;
        for (int i = 0; i < columnPropertyArray.length; ++i) {
            object2 = (Boolean)columnPropertyArray[i].getValue("SortingColumnTTV");
            if (object2 == null || !((Boolean)object2).booleanValue()) continue;
            columnProperty2 = columnPropertyArray[i];
            object = (Boolean)columnPropertyArray[i].getValue("DescendingOrderTTV");
            bl = object != Boolean.TRUE;
        }
        TableColumnModel tableColumnModel = taskListView.getTable().getColumnModel();
        object2 = new int[tableColumnModel.getColumnCount()];
        object = new String[tableColumnModel.getColumnCount()];
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            ColumnProperty columnProperty3 = null;
            for (int j = 0; j < columnPropertyArray.length; ++j) {
                if (!columnPropertyArray[j].getDisplayName().equals(tableColumn.getHeaderValue())) continue;
                columnProperty3 = columnPropertyArray[j];
            }
            object[i] = columnProperty3 != null ? columnProperty3.getName() : columnProperty.getName();
            object2[i] = tableColumn.getWidth();
        }
        columnsConfiguration.setValues((String[])object, (int[])object2, columnProperty2 == null ? null : columnProperty2.getName(), bl);
    }

    public static void configureColumns(TaskListView taskListView, ColumnsConfiguration columnsConfiguration) {
        ColumnProperty columnProperty;
        int n;
        String[] stringArray = columnsConfiguration.getProperties();
        int[] nArray = columnsConfiguration.getWidths();
        String string = columnsConfiguration.getSortingColumn();
        boolean bl = columnsConfiguration.getSortingOrder();
        ColumnProperty[] columnPropertyArray = taskListView.getColumns();
        for (n = 0; n < columnPropertyArray.length; ++n) {
            columnPropertyArray[n].setValue("InvisibleInTreeTableView", Boolean.TRUE);
        }
        for (n = 0; n < stringArray.length; ++n) {
            ColumnProperty columnProperty2 = ColumnsConfiguration.findColumn(columnPropertyArray, stringArray[n]);
            if (columnProperty2 == null) continue;
            columnProperty2.setValue("InvisibleInTreeTableView", Boolean.FALSE);
            columnProperty2.width = nArray[n];
        }
        if (string != null && (columnProperty = ColumnsConfiguration.findColumn(columnPropertyArray, string)) != null) {
            columnProperty.setValue("SortingColumnTTV", Boolean.TRUE);
            columnProperty.setValue("DescendingOrderTTV", !bl ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    private static ColumnProperty findColumn(ColumnProperty[] columnPropertyArray, String string) {
        for (int i = 0; i < columnPropertyArray.length; ++i) {
            if (!columnPropertyArray[i].getName().equals(string)) continue;
            return columnPropertyArray[i];
        }
        return null;
    }

    static {
        $assertionsDisabled = !ColumnsConfiguration.class.desiredAssertionStatus();
    }
}

