/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.editors;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;
import javax.swing.JLabel;
import org.netbeans.modules.tasklist.client.SuggestionPriority;
import org.netbeans.modules.tasklist.core.PriorityListCellRenderer;

public final class PriorityPropertyEditor
extends PropertyEditorSupport {
    private static final String[] TAGS = SuggestionPriority.getPriorityNames();
    private static final JLabel LABEL = new JLabel();

    public String getAsText() {
        Object object = this.getValue();
        if (object instanceof SuggestionPriority) {
            int n = ((SuggestionPriority)object).intValue();
            return TAGS[n - 1];
        }
        return "";
    }

    public void setAsText(String string) throws IllegalArgumentException {
        int n = -1;
        for (int i = 0; i < TAGS.length; ++i) {
            if (!string.equals(TAGS[i])) continue;
            n = i;
            break;
        }
        if (n == -1) {
            throw new IllegalArgumentException("Unknown priority");
        }
        this.setValue(SuggestionPriority.getPriority((int)(n + 1)));
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        Object object = this.getValue();
        if (object instanceof SuggestionPriority) {
            graphics.translate(rectangle.x, rectangle.y);
            int n = ((SuggestionPriority)object).intValue();
            LABEL.setForeground(PriorityListCellRenderer.COLORS[n - 1]);
            LABEL.setText(this.getAsText());
            LABEL.setSize(rectangle.width, rectangle.height);
            LABEL.paint(graphics);
            graphics.translate(-rectangle.x, -rectangle.y);
        }
    }

    public String[] getTags() {
        return TAGS;
    }
}

