/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.export;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.netbeans.modules.tasklist.core.util.SimpleWizardPanel;
import org.openide.util.NbBundle;

public class OpenFilePanel
extends JPanel {
    private SimpleWizardPanel panel;
    private JFileChooser jFileChooser;

    public OpenFilePanel() {
        this.initComponents();
    }

    public void setWizardPanel(SimpleWizardPanel simpleWizardPanel) {
        this.panel = simpleWizardPanel;
    }

    private void initComponents() {
        this.jFileChooser = new JFileChooser();
        this.setLayout(new BorderLayout());
        this.setName(NbBundle.getBundle((Class)OpenFilePanel.class).getString("ChooseSource"));
        this.jFileChooser.setControlButtonsAreShown(false);
        this.jFileChooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                OpenFilePanel.this.jFileChooserPropertyChange(propertyChangeEvent);
            }
        });
        this.add((Component)this.jFileChooser, "Center");
    }

    private void jFileChooserPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "SelectedFileChangedProperty") {
            this.check();
        }
    }

    public JFileChooser getFileChooser() {
        return this.jFileChooser;
    }

    public void setFile(File file) {
        this.jFileChooser.setSelectedFile(file);
        this.check();
    }

    public File getFile() {
        return this.jFileChooser.getSelectedFile();
    }

    private void check() {
        File file = this.jFileChooser.getSelectedFile();
        if (file == null) {
            this.panel.setErrorMessage(NbBundle.getMessage((Class)OpenFilePanel.class, (String)"EmptyFileName2"));
            return;
        }
        try {
            System.getSecurityManager().checkRead(file.getAbsolutePath());
            this.panel.setErrorMessage(null);
        }
        catch (SecurityException securityException) {
            this.panel.setErrorMessage(securityException.getLocalizedMessage());
        }
    }
}

