/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.filter;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.netbeans.modules.tasklist.core.filter.AppliedFilterCondition;
import org.netbeans.modules.tasklist.core.filter.Filter;
import org.netbeans.modules.tasklist.core.filter.FilterCondition;
import org.netbeans.modules.tasklist.core.filter.SuggestionProperties;
import org.netbeans.modules.tasklist.core.filter.SuggestionProperty;
import org.netbeans.spi.settings.DOMConvertor;
import org.netbeans.spi.settings.Saver;
import org.openide.ErrorManager;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class FilterConvertor
extends DOMConvertor
implements PropertyChangeListener {
    private static final String ATTR_ALLTRUE = "allTrue";
    private static final String ELEM_FILTER = "Filter";
    private static final String ELEM_CONDITION = "Condition";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_PROPID = "propertyId";
    private Saver saver;

    protected FilterConvertor(String string) {
        this("-//NetBeans org.netbeans.modules.tasklist//DTD " + string + " 1.0//EN", "http://tasklist.netbeans.org/dtd/filter-1_0.dtd", string);
    }

    protected FilterConvertor(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    protected abstract Filter createFilter();

    protected SuggestionProperty getProperty(String string) {
        return SuggestionProperties.getProperty(string);
    }

    protected Object readElement(Element element) throws IOException, ClassNotFoundException {
        Filter filter = this.createFilter();
        this.readFilter(element, filter);
        return filter;
    }

    protected void readFilter(Element element, Filter filter) throws IOException, ClassNotFoundException {
        filter.setMatchAll(Boolean.valueOf(element.getAttribute(ATTR_ALLTRUE)));
        filter.setName(element.getAttribute(ATTR_NAME));
        LinkedList<AppliedFilterCondition> linkedList = new LinkedList<AppliedFilterCondition>();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            FilterCondition filterCondition = (FilterCondition)FilterConvertor.delegateRead((Element)((Element)node));
            String string = ((Element)node).getAttribute(ATTR_PROPID);
            AppliedFilterCondition appliedFilterCondition = new AppliedFilterCondition(this.getProperty(string), filterCondition);
            linkedList.add(appliedFilterCondition);
        }
        filter.setConditions(linkedList);
    }

    protected void writeElement(Document document, Element element, Object object) throws IOException, DOMException {
        Filter filter = (Filter)object;
        this.writeFilter(document, element, filter);
    }

    protected void writeFilter(Document document, Element element, Filter filter) throws IOException, DOMException {
        element.setAttribute(ATTR_ALLTRUE, Boolean.toString(filter.matchAll()));
        element.setAttribute(ATTR_NAME, filter.getName());
        Iterator iterator = filter.getConditions().iterator();
        while (iterator.hasNext()) {
            AppliedFilterCondition appliedFilterCondition = (AppliedFilterCondition)iterator.next();
            Element element2 = FilterConvertor.delegateWrite((Document)document, (Object)appliedFilterCondition.getCondition());
            element2.setAttribute(ATTR_PROPID, appliedFilterCondition.getProperty().getID());
            element.appendChild(element2);
        }
    }

    public void registerSaver(Object object, Saver saver) {
        this.saver = saver;
        ((Filter)object).addPropertyChangeListener(this);
    }

    public void unregisterSaver(Object object, Saver saver) {
        if (saver == null || saver != this.saver) {
            ErrorManager.getDefault().notify(65536, (Throwable)new IllegalArgumentException("Wrong argument for unregisterSaver(Object=" + object + ", Saver=" + saver + ")"));
        }
        ((Filter)object).removePropertyChangeListener(this);
        this.saver = null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        try {
            this.saver.requestSave();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }
}

