/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.filter;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.netbeans.modules.tasklist.core.filter.Filter;

public final class FilterRepository
implements List {
    public static final String PROP_FILTERS = "propFilters";
    public static final String PROP_ACTIVE_FILTER = "propActiveFilter";
    private PropertyChangeSupport pcs = null;
    private LinkedList filters = new LinkedList();
    private int active = -1;
    private PropertyChangeListener filterChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FilterRepository.this.fireFiltersChanged();
        }
    };

    public void assign(FilterRepository filterRepository) {
        if (filterRepository != this) {
            this.filters.clear();
            Iterator iterator = filterRepository.filters.iterator();
            while (iterator.hasNext()) {
                this.filters.add(((Filter)iterator.next()).clone());
            }
            this.active = filterRepository.active;
            this.fireFiltersChanged();
        }
    }

    public Object clone() {
        FilterRepository filterRepository = new FilterRepository();
        filterRepository.assign(this);
        return filterRepository;
    }

    public boolean add(Object object) {
        if (this.filters.add(object)) {
            ((Filter)object).addPropertyChangeListener(this.filterChangeListener);
            this.fireFiltersChanged();
            return true;
        }
        return false;
    }

    public boolean addAll(Collection collection) {
        boolean bl = this.filters.addAll(collection);
        if (bl) {
            this.hookCollection(collection);
            this.fireFiltersChanged();
        }
        return bl;
    }

    public void add(int n, Object object) {
        this.filters.add(n, object);
        ((Filter)object).addPropertyChangeListener(this.filterChangeListener);
        this.fireFiltersChanged();
    }

    public boolean addAll(int n, Collection collection) {
        if (this.filters.addAll(n, collection)) {
            this.hookCollection(collection);
            this.fireFiltersChanged();
            return true;
        }
        return false;
    }

    public void clear() {
        if (!this.filters.isEmpty()) {
            this.setActive(null);
            this.unhookCollection(this.filters);
            this.filters.clear();
            this.fireFiltersChanged();
        }
    }

    public boolean contains(Object object) {
        return this.filters.contains(object);
    }

    public boolean remove(Object object) {
        if (object == this.getActive()) {
            this.setActive(null);
        }
        if (this.filters.remove(object)) {
            ((Filter)object).removePropertyChangeListener(this.filterChangeListener);
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.filters.isEmpty();
    }

    public Iterator iterator() {
        return this.filters.iterator();
    }

    public boolean removeAll(Collection collection) {
        if (collection.contains(this.getActive())) {
            this.setActive(null);
        }
        this.unhookCollection(collection);
        boolean bl = this.filters.removeAll(collection);
        if (bl) {
            this.fireFiltersChanged();
        }
        return bl;
    }

    public Object[] toArray() {
        return this.filters.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.filters.toArray(objectArray);
    }

    public boolean containsAll(Collection collection) {
        return this.filters.containsAll(collection);
    }

    public boolean retainAll(Collection collection) {
        if (this.getActive() != null && !collection.contains(this.getActive())) {
            this.setActive(null);
        }
        this.unhookCollection(this.filters);
        boolean bl = this.filters.retainAll(collection);
        this.hookCollection(this.filters);
        if (bl) {
            this.fireFiltersChanged();
        }
        return bl;
    }

    public int size() {
        return this.filters.size();
    }

    public boolean equals(Object object) {
        if (object instanceof FilterRepository && object != null) {
            FilterRepository filterRepository = (FilterRepository)object;
            return this.filters.equals(filterRepository.filters) && this.active == filterRepository.active;
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.filters.hashCode() + (this.active == -1 ? 0 : this.getActive().hashCode());
    }

    private PropertyChangeSupport getPCS() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPCS().addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    private final void fireActiveChanged(Filter filter, Filter filter2) {
        if (this.pcs != null) {
            this.getPCS().firePropertyChange(PROP_ACTIVE_FILTER, filter, filter2);
        }
    }

    private final void fireFiltersChanged() {
        if (this.pcs != null) {
            this.getPCS().firePropertyChange(PROP_FILTERS, null, null);
        }
    }

    public Filter getFilterByName(String string) {
        Iterator iterator = this.filters.iterator();
        while (iterator.hasNext()) {
            Filter filter = (Filter)iterator.next();
            if (!filter.getName().equals(string)) continue;
            return filter;
        }
        return null;
    }

    public Filter getActive() {
        return this.active == -1 ? null : (Filter)this.filters.get(this.active);
    }

    public void setActive(Filter filter) {
        if (filter == null) {
            if (this.active != -1) {
                Filter filter2 = this.getActive();
                this.active = -1;
                this.fireActiveChanged(filter2, null);
            }
        } else {
            int n = this.filters.indexOf(filter);
            if (n != -1) {
                Filter filter3 = this.getActive();
                this.active = n;
                this.fireActiveChanged(filter3, filter);
            } else {
                throw new IllegalArgumentException("newactive not in collection");
            }
        }
    }

    public Object get(int n) {
        return this.filters.get(n);
    }

    public int indexOf(Object object) {
        return this.filters.indexOf(object);
    }

    public int lastIndexOf(Object object) {
        return this.filters.lastIndexOf(object);
    }

    public ListIterator listIterator() {
        return this.filters.listIterator();
    }

    public ListIterator listIterator(int n) {
        return this.filters.listIterator(n);
    }

    public Object remove(int n) {
        Object e = this.filters.remove(n);
        if (e != null) {
            ((Filter)e).removePropertyChangeListener(this.filterChangeListener);
            this.fireFiltersChanged();
        }
        return e;
    }

    public Object set(int n, Object object) {
        Object object2 = this.filters.set(n, object);
        ((Filter)object2).removePropertyChangeListener(this.filterChangeListener);
        ((Filter)object).addPropertyChangeListener(this.filterChangeListener);
        this.fireFiltersChanged();
        return object2;
    }

    public List subList(int n, int n2) {
        return this.filters.subList(n, n2);
    }

    private void unhookCollection(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ((Filter)iterator.next()).removePropertyChangeListener(this.filterChangeListener);
        }
    }

    private void hookCollection(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ((Filter)iterator.next()).addPropertyChangeListener(this.filterChangeListener);
        }
    }
}

