/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.filter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.netbeans.modules.tasklist.client.SuggestionPriority;
import org.netbeans.modules.tasklist.core.checklist.CheckList;
import org.netbeans.modules.tasklist.core.checklist.DefaultCheckListModel;
import org.netbeans.modules.tasklist.core.filter.FilterCondition;
import org.netbeans.modules.tasklist.core.filter.Util;
import org.openide.util.NbBundle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PriorityCondition
extends FilterCondition {
    private static int NPRIORITIES = 5;
    private boolean[] priorities = new boolean[NPRIORITIES];

    public static PriorityCondition[] createConditions() {
        return new PriorityCondition[]{new PriorityCondition()};
    }

    public PriorityCondition() {
        Arrays.fill(this.priorities, true);
    }

    public PriorityCondition(PriorityCondition priorityCondition) {
        super(priorityCondition);
        for (int i = 0; i < NPRIORITIES; ++i) {
            this.priorities[i] = priorityCondition.priorities[i];
        }
    }

    public Object clone() {
        return new PriorityCondition(this);
    }

    public boolean isTrue(Object object) {
        SuggestionPriority suggestionPriority = (SuggestionPriority)object;
        return this.priorities[suggestionPriority.intValue() - 1];
    }

    public JComponent createConstantComponent() {
        CheckList checkList = new CheckList(new DefaultCheckListModel(this.priorities, SuggestionPriority.getPriorityNames()));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.setBorder(BorderFactory.createCompoundBorder(UIManager.getBorder("TextField.border"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        jPanel.add((Component)checkList, "Center");
        jPanel.setToolTipText(Util.getString("prio_desc"));
        checkList.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)PriorityCondition.class, (String)"LBL_PriorityCheckList"));
        checkList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PriorityCondition.class, (String)"LBL_PriorityCheckList"));
        return jPanel;
    }

    public void getConstantFrom(JComponent jComponent) {
    }

    protected String getDisplayName() {
        return NbBundle.getMessage((Class)PriorityCondition.class, (String)"IsOneOf");
    }

    static /* synthetic */ boolean[] access$102(PriorityCondition priorityCondition, boolean[] blArray) {
        priorityCondition.priorities = blArray;
        return blArray;
    }

    private static class Convertor
    extends FilterCondition.Convertor {
        private static final String ELEM_PRIORITY_CONDITION = "PriorityCondition";
        private static final String ATTR_PRIORITIES = "priorities";

        public Convertor() {
            super(ELEM_PRIORITY_CONDITION);
        }

        public static Convertor create() {
            return new Convertor();
        }

        protected Object readElement(Element element) throws IOException, ClassNotFoundException {
            PriorityCondition priorityCondition = new PriorityCondition();
            super.readCondition(element, priorityCondition);
            String string = element.getAttribute(ATTR_PRIORITIES);
            boolean[] blArray = new boolean[NPRIORITIES];
            for (int i = 0; i < NPRIORITIES; ++i) {
                blArray[i] = string.charAt(i) == '+';
            }
            PriorityCondition.access$102(priorityCondition, blArray);
            return priorityCondition;
        }

        protected void writeElement(Document document, Element element, Object object) throws IOException, DOMException {
            PriorityCondition priorityCondition = (PriorityCondition)object;
            super.writeCondition(document, element, priorityCondition);
            StringBuffer stringBuffer = new StringBuffer(NPRIORITIES);
            for (int i = 0; i < NPRIORITIES; ++i) {
                stringBuffer.append(priorityCondition.priorities[i] ? (char)'+' : '-');
            }
            element.setAttribute(ATTR_PRIORITIES, stringBuffer.toString());
        }
    }
}

