/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public final class IndentedWriter
extends PrintWriter {
    private boolean needIndent = true;
    private String indent = "";

    public IndentedWriter(Writer writer, boolean bl) {
        super(writer, bl);
    }

    public IndentedWriter(Writer writer) {
        super(writer);
    }

    public IndentedWriter(OutputStream outputStream, boolean bl) {
        super(outputStream, bl);
    }

    public IndentedWriter(OutputStream outputStream) {
        super(outputStream);
    }

    public void println() {
        super.println();
        this.needIndent = true;
    }

    public void write(String string) {
        if (this.needIndent) {
            super.write(this.indent);
            this.needIndent = false;
        }
        super.write(string);
    }

    public void indent() {
        this.indent = this.indent + "    ";
    }

    public void unindent() {
        this.indent = this.indent.substring(4);
    }
}

