/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.util;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;

public class TextPositionsMapper {
    private String text;
    private int[] offsets;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TextPositionsMapper(String string) {
        int n;
        this.text = string;
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(new Integer(0));
        for (n = 0; n < string.length(); ++n) {
            char c = string.charAt(n);
            if (c == '\r') {
                if (n + 1 < string.length() && string.charAt(n + 1) == '\n') {
                    arrayList.add(new Integer(++n + 1));
                    continue;
                }
                arrayList.add(new Integer(n + 1));
                continue;
            }
            if (c != '\n') continue;
            arrayList.add(new Integer(n + 1));
        }
        this.offsets = new int[arrayList.size()];
        for (n = 0; n < this.offsets.length; ++n) {
            this.offsets[n] = (Integer)arrayList.get(n);
        }
    }

    public void findPosition(int n, int[] nArray) {
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError((Object)"offset couldn't be negative");
        }
        int n2 = Arrays.binarySearch(this.offsets, n);
        if (n2 >= 0) {
            nArray[0] = n2;
            nArray[1] = 0;
        } else {
            n2 = -(n2 + 1);
            if (!$assertionsDisabled && n2 == 0) {
                throw new AssertionError((Object)"offset couldn't be negative");
            }
            nArray[0] = n2 - 1;
            nArray[1] = n - this.offsets[n2 - 1];
        }
    }

    public String getText() {
        return this.text;
    }

    public String getLine(int n) {
        int n2 = this.offsets[n];
        int n3 = this.offsets.length > n + 1 ? this.offsets[n + 1] : this.text.length();
        return this.text.substring(n2, n3);
    }

    static {
        $assertionsDisabled = !TextPositionsMapper.class.desiredAssertionStatus();
    }
}

