/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.Format;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.java.Util;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.text.FilterDocument;
import org.openide.text.IndentEngine;

public abstract class IndentFileEntry
extends FileEntry.Format {
    private static final String NEWLINE = "\n";
    private static final String EA_PREFORMATTED = "org-netbeans-modules-java-preformattedSource";
    private ThreadLocal indentEngine;

    IndentFileEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        super(multiDataObject, fileObject);
    }

    private EditorKit createEditorKit(String string) {
        EditorKit editorKit = JEditorPane.createEditorKitForContentType(string);
        if (editorKit == null) {
            editorKit = new DefaultEditorKit();
        }
        return editorKit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setIndentEngine(IndentEngine indentEngine) {
        IndentFileEntry indentFileEntry = this;
        synchronized (indentFileEntry) {
            if (this.indentEngine == null) {
                this.indentEngine = new ThreadLocal();
            }
        }
        this.indentEngine.set(indentEngine);
    }

    final void initializeIndentEngine() {
        StyledDocument styledDocument = this.createDocument(this.createEditorKit(this.getFile().getMIMEType()));
        IndentEngine indentEngine = IndentEngine.find((Document)styledDocument);
        this.setIndentEngine(indentEngine);
    }

    private StyledDocument createDocument(EditorKit editorKit) {
        Document document = editorKit.createDefaultDocument();
        if (document instanceof StyledDocument) {
            return (StyledDocument)document;
        }
        return new FilterDocument(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileObject createFromTemplate(FileObject fileObject, String string) throws IOException {
        String string2 = this.getFile().getExt();
        String string3 = System.getProperty("line.separator");
        if (string == null) {
            string = FileUtil.findFreeFileName((FileObject)fileObject, (String)this.getFile().getName(), (String)string2);
        }
        FileObject fileObject2 = fileObject.createData(string, string2);
        Format format = this.createFormat(fileObject, string, string2);
        InputStream inputStream = this.getFile().getInputStream();
        String string4 = Util.getFileEncoding(this.getFile());
        InputStreamReader inputStreamReader = string4 == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string4);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StyledDocument styledDocument = this.createDocument(this.createEditorKit(fileObject2.getMIMEType()));
        IndentEngine indentEngine = (IndentEngine)this.indentEngine.get();
        if (indentEngine == null) {
            indentEngine = IndentEngine.find((Document)styledDocument);
        }
        Object object = this.getFile().getAttribute(EA_PREFORMATTED);
        boolean bl = false;
        if (object != null && object instanceof Boolean) {
            bl = (Boolean)object;
        }
        try {
            FileLock fileLock = fileObject2.lock();
            try {
                string4 = Util.getFileEncoding(fileObject2);
                OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                OutputStreamWriter outputStreamWriter = string4 == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter(outputStream, string4);
                try {
                    String string5;
                    String string6 = null;
                    int n = 0;
                    while ((string5 = bufferedReader.readLine()) != null) {
                        if (string6 != null) {
                            styledDocument.insertString(n, NEWLINE, null);
                            ++n;
                        }
                        string6 = format.format(string5);
                        if (!bl || !string6.equals(string5)) {
                            string6 = IndentFileEntry.fixupGuardedBlocks(IndentFileEntry.safeIndent(indentEngine, string6, styledDocument, n));
                        }
                        styledDocument.insertString(n, string6, null);
                        n += string6.length();
                    }
                    styledDocument.insertString(styledDocument.getLength(), NEWLINE, null);
                    String string7 = styledDocument.getText(0, styledDocument.getLength());
                    outputStreamWriter.write(string7.replaceAll(NEWLINE, string3));
                }
                catch (BadLocationException badLocationException) {
                }
                finally {
                    outputStreamWriter.close();
                }
            }
            finally {
                fileLock.releaseLock();
            }
        }
        finally {
            bufferedReader.close();
        }
        FileUtil.copyAttributes((FileObject)this.getFile(), (FileObject)fileObject2);
        fileObject2.setAttribute("template", null);
        return fileObject2;
    }

    static String fixupGuardedBlocks(String string) {
        int n = string.indexOf("//GEN-");
        if (n == -1) {
            return string;
        }
        int n2 = string.indexOf(10);
        if (n2 == -1 || n2 > n) {
            return string;
        }
        int n3 = string.indexOf(10, n);
        StringBuffer stringBuffer = new StringBuffer(string.length());
        stringBuffer.append(string.substring(0, n2));
        if (n3 != -1) {
            stringBuffer.append(string.substring(n, n3));
        } else {
            stringBuffer.append(string.substring(n));
        }
        stringBuffer.append(string.substring(n2, n));
        if (n3 != -1) {
            stringBuffer.append(string.substring(n3));
        }
        return stringBuffer.toString();
    }

    public static String safeIndent(IndentEngine indentEngine, String string, StyledDocument styledDocument, int n) {
        if (indentEngine == null) {
            return string;
        }
        try {
            StringWriter stringWriter = new StringWriter();
            Writer writer = indentEngine.createWriter((Document)styledDocument, n, (Writer)stringWriter);
            writer.write(string);
            writer.close();
            return stringWriter.toString();
        }
        catch (Exception exception) {
            ErrorManager.getDefault().annotate((Throwable)exception, 16, "Indentation engine error", Util.getString("EXMSG_IndentationEngineError"), (Throwable)exception, null);
            ErrorManager.getDefault().notify((Throwable)exception);
            return string;
        }
    }
}

