/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.text.DateFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.IndentFileEntry;
import org.netbeans.modules.java.JMapFormat;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.settings.JavaSettings;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.NbBundle;

public class JavaDataLoader
extends MultiFileLoader {
    public static final String JAVA_EXTENSION = "java";
    public static final String PROP_PARSER_ENGINE = "parserEngine";
    static ArrayList parsingListeners = new ArrayList();
    static final long serialVersionUID = -6286836352608877232L;

    public JavaDataLoader() {
        this("org.netbeans.modules.java.JavaDataObject");
    }

    public JavaDataLoader(String string) {
        super(string);
    }

    public JavaDataLoader(Class clazz) {
        super(clazz);
    }

    protected String actionsContext() {
        return "Loaders/text/x-java/Actions/";
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage((Class)JavaDataLoader.class, (String)"PROP_JavaLoader_Name");
    }

    protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
        return new JavaDataObject(fileObject, this);
    }

    protected FileObject findPrimaryFile(FileObject fileObject) {
        if (fileObject.isFolder()) {
            return null;
        }
        if (fileObject.getExt().equals(JAVA_EXTENSION)) {
            return fileObject;
        }
        return null;
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        return new JavaFileEntry(multiDataObject, fileObject);
    }

    protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        ErrorManager.getDefault().log("Subclass of JavaDataLoader (" + ((Object)((Object)this)).getClass().getName() + ") has secondary entries but does not override createSecondaryEntries (MultidataObject, FileObject) method.");
        return new FileEntry.Numb(multiDataObject, fileObject);
    }

    protected Map createStringsMap() {
        Properties properties = JavaSettings.getDefault().getReplaceableStringsProps();
        properties.put("DATE", DateFormat.getDateInstance(1).format(new Date()));
        properties.put("TIME", DateFormat.getTimeInstance(3).format(new Date()));
        return properties;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        if (objectInput.available() > 0) {
            int n = objectInput.readInt();
            if (n >= 1) {
                objectInput.readObject();
            }
            if (n >= 2) {
                objectInput.readBoolean();
            }
        }
    }

    public class JavaFileEntry
    extends IndentFileEntry {
        static final long serialVersionUID = 8244159045498569616L;
        boolean disableInputStream;
        private Collection activeReaders;

        public JavaFileEntry(MultiDataObject multiDataObject, FileObject fileObject) {
            super(multiDataObject, fileObject);
        }

        protected Format createFormat(FileObject fileObject, String string, String string2) {
            Map map = JavaDataLoader.this.createStringsMap();
            this.modifyMap(map, fileObject, string, string2);
            JMapFormat jMapFormat = new JMapFormat(map);
            jMapFormat.setLeftBrace("__");
            jMapFormat.setRightBrace("__");
            jMapFormat.setCondDelimiter("$");
            jMapFormat.setExactMatch(false);
            return jMapFormat;
        }

        protected void modifyMap(Map map, FileObject fileObject, String string, String string2) {
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            String string3 = "";
            if (classPath != null) {
                string3 = classPath.getResourceName(fileObject);
            } else {
                ErrorManager.getDefault().log(16, "No classpath was found for folder: " + fileObject);
            }
            map.put("NAME", string);
            map.put("PACKAGE", string3.replace('/', '.'));
            map.put("PACKAGE_SLASHES", string3);
            if (fileObject.isRoot()) {
                map.put("PACKAGE_AND_NAME", string);
                map.put("PACKAGE_AND_NAME_SLASHES", string);
            } else {
                map.put("PACKAGE_AND_NAME", string3.replace('/', '.') + '.' + string);
                map.put("PACKAGE_AND_NAME_SLASHES", string3 + '/' + string);
            }
            map.put("QUOTES", "\"");
        }

        public synchronized void addReader(InputStream inputStream) {
            if (this.activeReaders == null) {
                this.activeReaders = new LinkedList();
            }
            this.activeReaders.add(inputStream);
        }

        public synchronized void removeReader(InputStream inputStream) {
            if (this.activeReaders == null) {
                return;
            }
            this.activeReaders.remove(inputStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete() throws IOException {
            JavaFileEntry javaFileEntry = this;
            synchronized (javaFileEntry) {
                int n;
                if (this.activeReaders != null && (n = this.activeReaders.size()) > 0) {
                    InputStream[] inputStreamArray = this.activeReaders.toArray(new InputStream[n]);
                    for (int i = 0; i < inputStreamArray.length; ++i) {
                        inputStreamArray[i].close();
                    }
                }
                this.activeReaders = null;
                this.disableInputStream = true;
            }
            super.delete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream getInputStream() throws FileNotFoundException {
            FileObject fileObject = this.getFile();
            JavaFileEntry javaFileEntry = this;
            synchronized (javaFileEntry) {
                if (this.disableInputStream) {
                    throw new FileNotFoundException("File is being deleted.");
                }
                NotifyInputStream notifyInputStream = new NotifyInputStream(fileObject.getInputStream());
                this.addReader(notifyInputStream);
                return notifyInputStream;
            }
        }

        private class NotifyInputStream
        extends FilterInputStream {
            public NotifyInputStream(InputStream inputStream) {
                super(inputStream);
            }

            public void close() throws IOException {
                super.close();
                JavaFileEntry.this.removeReader(this);
            }
        }
    }
}

