/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.IndentFileEntry;
import org.netbeans.modules.java.JavaEditor;
import org.netbeans.modules.java.JavaElementNodeFactory;
import org.netbeans.modules.java.JavaNode;
import org.netbeans.modules.java.JavaParserGlue;
import org.netbeans.modules.java.NodeFactoryPool;
import org.netbeans.modules.java.bridge.DefaultLangModel;
import org.netbeans.modules.java.bridge.SrcElementImpl;
import org.netbeans.modules.java.parser.JavaParser;
import org.netbeans.modules.java.ui.nodes.SourceNodes;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceClassImpl;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.src.SourceElement;
import org.openide.src.nodes.ElementNodeFactory;
import org.openide.src.nodes.FilterFactory;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class JavaDataObject
extends MultiDataObject
implements CookieSet.Factory {
    static final long serialVersionUID = -6035788991669336965L;
    private transient JavaEditor editorSupport;
    protected transient AbstractNode alteranteParent;
    private transient FileChangeListener fileChangeListener;
    private transient FileChangeListener fileChangeListenerHook;
    private transient String previousFileName;
    private transient Object lock;
    private transient boolean initialized;
    private transient JavaParserGlue parserGlue;
    private transient SourceElement source = null;
    private transient DefaultLangModel model = null;
    private static NodeFactoryPool explorerFactories;
    private static NodeFactoryPool browserFactories;
    private static ElementNodeFactory basicBrowser;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JavaDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        this.init();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    private void init() {
        MultiDataObject.Entry entry = this.getPrimaryEntry();
        CookieSet cookieSet = this.getCookieSet();
        Class[] classArray = new Class[]{JavaEditor.class, JavaParser.class, SourceCookie.Editor.class};
        cookieSet.add(classArray, (CookieSet.Factory)this);
        PrimaryListener primaryListener = new PrimaryListener();
        this.addPropertyChangeListener(primaryListener);
        this.fileChangeListenerHook = primaryListener;
        this.fileChangeListener = FileUtil.weakFileChangeListener((FileChangeListener)this.fileChangeListenerHook, (Object)entry.getFile());
        this.lock = new Object();
        this.addSourceChangeListener(null);
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DefaultLangModel getModel() {
        if (this.model == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.model == null) {
                    this.model = new DefaultLangModel(this);
                }
            }
        }
        return this.model;
    }

    void firePropertyChange0(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaParser initializeParsingSupport() {
        if (this.parserGlue != null) {
            return this.parserGlue.getParser();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.parserGlue != null) {
                return this.parserGlue.getParser();
            }
            this.parserGlue = new JavaParserGlue(this.getPrimaryEntry());
            if (this.editorSupport != null) {
                this.parserGlue.cloneableSupportCreated((CloneableEditorSupport)this.editorSupport);
            }
        }
        return this.parserGlue.getParser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValid(boolean bl) throws PropertyVetoException {
        super.setValid(bl);
        if (!bl) {
            JavaDataObject javaDataObject = this;
            synchronized (javaDataObject) {
                if (this.parserGlue != null) {
                    this.parserGlue.suspendDocumentChanges();
                }
            }
        }
    }

    protected CloneableEditorSupport findCloneableEditorSupport() {
        return (JavaEditor)this.getCookie(JavaEditor.class);
    }

    void addSourceChangeListener(FileObject fileObject) {
        if (fileObject != null) {
            fileObject.removeFileChangeListener(this.fileChangeListener);
        }
        this.getPrimaryEntry().getFile().addFileChangeListener(this.fileChangeListener);
    }

    void addSaveCookie(SaveCookie saveCookie) {
        this.getCookieSet().add((Node.Cookie)saveCookie);
    }

    void removeSaveCookie(SaveCookie saveCookie) {
        this.getCookieSet().remove((Node.Cookie)saveCookie);
    }

    public void resumeSupports() {
        this.parserGlue.resumeDocumentChanges();
    }

    public void suspendSupports() {
        this.initializeParsingSupport();
        this.parserGlue.suspendDocumentChanges();
    }

    boolean isJavaFileReadOnly() {
        FileObject fileObject = this.getPrimaryFile();
        if (!this.isValid() || !fileObject.isValid()) {
            return true;
        }
        return !fileObject.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataObject handleCopy(DataFolder dataFolder) throws IOException {
        String string = this.getName();
        DataObject dataObject = super.handleCopy(dataFolder);
        if (!Repository.getDefault().getDefaultFileSystem().equals(dataObject.getPrimaryFile().getFileSystem())) {
            JavaMetamodel.getDefaultRepository().beginTrans(true);
            boolean bl = true;
            try {
                ClassPath classPath = ClassPath.getClassPath((FileObject)dataObject.getPrimaryFile(), (String)"classpath/source");
                if (classPath != null) {
                    JavaModelPackage javaModelPackage = JavaMetamodel.getManager().resolveJavaExtent(classPath.findOwnerRoot(dataObject.getPrimaryFile()));
                    if (javaModelPackage == null) {
                        ErrorManager.getDefault().log(16, "JavaDataObject: Extent for " + dataObject.getName() + " not found");
                        bl = false;
                        DataObject dataObject2 = dataObject;
                        return dataObject2;
                    }
                    ResourceClassImpl resourceClassImpl = (ResourceClassImpl)javaModelPackage.getResource();
                    String string2 = classPath.getResourceName(dataObject.getPrimaryFile());
                    Resource resource = resourceClassImpl.resolveResource(string2, true, false);
                    resource.setPackageName(classPath.getResourceName(dataFolder.getPrimaryFile()).replace('/', '.'));
                    Iterator iterator = resource.getClassifiers().iterator();
                    while (iterator.hasNext()) {
                        JavaClass javaClass = (JavaClass)iterator.next();
                        if (!javaClass.getSimpleName().equals(string)) continue;
                        javaClass.setSimpleName(dataObject.getName());
                    }
                }
                bl = false;
            }
            finally {
                JavaMetamodel.getDefaultRepository().endTrans(bl);
            }
        }
        return dataObject;
    }

    protected FileObject handleRename(String string) throws IOException {
        if (!"package-info".equals(string) && !Utilities.isJavaIdentifier((String)string)) {
            throw new IOException(NbBundle.getMessage((Class)JavaDataObject.class, (String)"FMT_Not_Valid_FileName", (Object)string));
        }
        FileObject fileObject = super.handleRename(string);
        return fileObject;
    }

    protected FileObject handleMove(DataFolder dataFolder) throws IOException {
        FileObject fileObject = super.handleMove(dataFolder);
        SrcElementImpl srcElementImpl = (SrcElementImpl)this.getSource().getCookie(SrcElementImpl.class);
        srcElementImpl.invalidateDelegate();
        return fileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataObject handleCreateFromTemplate(DataFolder dataFolder, String string) throws IOException {
        DataObject dataObject;
        if (string == null) {
            string = FileUtil.findFreeFileName((FileObject)dataFolder.getPrimaryFile(), (String)this.getPrimaryFile().getName(), (String)"java");
        } else if (!"package-info".equals(string) && !Utilities.isJavaIdentifier((String)string)) {
            throw new IOException(NbBundle.getMessage((Class)JavaDataObject.class, (String)"FMT_Not_Valid_FileName", (Object)string));
        }
        IndentFileEntry indentFileEntry = (IndentFileEntry)this.getPrimaryEntry();
        indentFileEntry.initializeIndentEngine();
        boolean bl = true;
        JavaMetamodel.getDefaultRepository().beginTrans(true);
        try {
            dataObject = this.createDataObject(dataFolder, string);
            ClassPath classPath = ClassPath.getClassPath((FileObject)dataFolder.getPrimaryFile(), (String)"classpath/source");
            if (classPath != null) {
                String string2 = classPath.getResourceName(dataFolder.getPrimaryFile(), '.', false);
                if (!$assertionsDisabled && string2 == null) {
                    throw new AssertionError();
                }
                JavaModelPackage javaModelPackage = JavaMetamodel.getManager().resolveJavaExtent(classPath.findOwnerRoot(dataObject.getPrimaryFile()));
                ResourceClassImpl resourceClassImpl = (ResourceClassImpl)javaModelPackage.getResource();
                String string3 = classPath.getResourceName(dataObject.getPrimaryFile());
                Resource resource = resourceClassImpl.resolveResource(string3, true, false);
                resource.setName(string3);
                Iterator iterator = resource.getClassifiers().iterator();
                if (iterator.hasNext()) {
                    JavaClass javaClass = (JavaClass)iterator.next();
                    javaClass.setSimpleName(string);
                }
                if (!"".equals(resource.getPackageName())) {
                    resource.setPackageName(string2);
                }
            } else {
                ErrorManager.getDefault().log("Can not update source while creating from template, destination folder " + dataFolder.getPrimaryFile().getPath() + " is not in any project.");
            }
            bl = false;
        }
        finally {
            JavaMetamodel.getDefaultRepository().endTrans(bl);
            indentFileEntry.setIndentEngine(null);
        }
        return dataObject;
    }

    private DataObject createDataObject(DataFolder dataFolder, String string) throws IOException {
        DataObject dataObject = super.handleCreateFromTemplate(dataFolder, string);
        try {
            dataObject.setValid(false);
            dataObject = DataObject.find((FileObject)dataObject.getPrimaryFile());
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return dataObject;
    }

    protected JavaEditor createJavaEditor() {
        JavaEditor javaEditor = new JavaEditor((DataObject)this);
        return javaEditor;
    }

    protected Node createNodeDelegate() {
        JavaNode javaNode = new JavaNode(this);
        return javaNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceElement getSource() {
        if (this.source == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.source == null) {
                    this.source = new SourceElement((SourceElement.Impl)new SrcElementImpl(this));
                }
            }
        }
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaEditor getJavaEditor() {
        if (this.editorSupport == null) {
            JavaDataObject javaDataObject = this;
            synchronized (javaDataObject) {
                this.editorSupport = this.createJavaEditor();
                if (this.parserGlue != null) {
                    this.parserGlue.cloneableSupportCreated((CloneableEditorSupport)this.editorSupport);
                } else {
                    this.initializeParsingSupport();
                }
            }
        }
        return this.editorSupport;
    }

    static synchronized ElementNodeFactory createBasicExplorerFactory() {
        return JavaElementNodeFactory.DEFAULT;
    }

    static synchronized ElementNodeFactory createBasicBrowserFactory() {
        if (basicBrowser == null) {
            basicBrowser = SourceNodes.createElementNodeFactory(SourceNodes.getBrowserFactory());
        }
        return basicBrowser;
    }

    public static ElementNodeFactory getExplorerFactory() {
        NodeFactoryPool nodeFactoryPool = JavaDataObject.createExplorerFactory();
        ElementNodeFactory elementNodeFactory = null;
        if (nodeFactoryPool != null) {
            elementNodeFactory = nodeFactoryPool.getHead();
        }
        if (elementNodeFactory == null) {
            elementNodeFactory = JavaDataObject.createBasicExplorerFactory();
        }
        return elementNodeFactory;
    }

    public static ElementNodeFactory getBrowserFactory() {
        ErrorManager.getDefault().notify(16, (Throwable)new IllegalStateException("JavaDataObject.getBrowserFactory is deprecated. Use SourceNodes.getBrowserFactory() instead."));
        return JavaDataObject.createBasicBrowserFactory();
    }

    static NodeFactoryPool createFactoryPool(String string, ElementNodeFactory elementNodeFactory) {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(string);
        if (fileObject == null) {
            return null;
        }
        try {
            DataFolder dataFolder = (DataFolder)DataObject.find((FileObject)fileObject).getCookie(DataFolder.class);
            return new NodeFactoryPool(dataFolder, elementNodeFactory);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
    }

    static synchronized NodeFactoryPool createBrowserFactory() {
        if (browserFactories != null) {
            return browserFactories;
        }
        browserFactories = JavaDataObject.createFactoryPool("/NodeFactories/java/objectbrowser", JavaDataObject.createBasicBrowserFactory());
        return browserFactories;
    }

    static synchronized NodeFactoryPool createExplorerFactory() {
        if (explorerFactories != null) {
            return explorerFactories;
        }
        explorerFactories = JavaDataObject.createFactoryPool("/NodeFactories/java/explorer", JavaDataObject.createBasicExplorerFactory());
        return explorerFactories;
    }

    public static void addExplorerFilterFactory(FilterFactory filterFactory) {
        NodeFactoryPool nodeFactoryPool = JavaDataObject.createExplorerFactory();
        if (nodeFactoryPool != null) {
            nodeFactoryPool.addFactory(filterFactory);
        }
    }

    public static void removeExplorerFilterFactory(FilterFactory filterFactory) {
        NodeFactoryPool nodeFactoryPool = JavaDataObject.createExplorerFactory();
        if (nodeFactoryPool != null) {
            nodeFactoryPool.removeFactory(filterFactory);
        }
    }

    public static void addBrowserFilterFactory(FilterFactory filterFactory) {
        NodeFactoryPool nodeFactoryPool = JavaDataObject.createBrowserFactory();
        if (nodeFactoryPool != null) {
            nodeFactoryPool.addFactory(filterFactory);
        }
    }

    public static void removeBrowserFilterFactory(FilterFactory filterFactory) {
        NodeFactoryPool nodeFactoryPool = JavaDataObject.createBrowserFactory();
        if (nodeFactoryPool != null) {
            nodeFactoryPool.removeFactory(filterFactory);
        }
    }

    protected static boolean isValidPackageName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (Utilities.isJavaIdentifier((String)string2)) continue;
            return false;
        }
        return true;
    }

    protected void primaryFileMoved(FileObject fileObject, FileObject fileObject2) {
        this.addSourceChangeListener(fileObject);
    }

    protected void primaryFileChanged() {
    }

    Date getLastModified() {
        EditorCookie editorCookie;
        SaveCookie saveCookie = (SaveCookie)this.getCookie(SaveCookie.class);
        if (saveCookie != null && (editorCookie = (EditorCookie)this.getCookie(EditorCookie.class)) != null && editorCookie.isModified()) {
            return new Date();
        }
        return this.getPrimaryFile().lastModified();
    }

    public Node.Cookie createCookie(Class clazz) {
        if (clazz.isAssignableFrom(JavaEditor.class)) {
            return this.getJavaEditor();
        }
        if (SourceCookie.class.isAssignableFrom(clazz) || JavaParser.class.isAssignableFrom(clazz)) {
            if (this.initializeParsingSupport() == null) {
                return null;
            }
            if (clazz.isAssignableFrom(this.parserGlue.getClass())) {
                return this.parserGlue;
            }
            return this.parserGlue.getParser();
        }
        return null;
    }

    public Collection getCompiledClasses() {
        Thread.dumpStack();
        return Collections.EMPTY_LIST;
    }

    static {
        $assertionsDisabled = !JavaDataObject.class.desiredAssertionStatus();
    }

    private class PrimaryListener
    extends FileChangeAdapter
    implements PropertyChangeListener {
        private PrimaryListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!JavaDataObject.this.initialized) {
                return;
            }
            String string = propertyChangeEvent.getPropertyName();
            if ("primaryFile".equals(string)) {
                JavaDataObject.this.primaryFileMoved((FileObject)propertyChangeEvent.getOldValue(), (FileObject)propertyChangeEvent.getNewValue());
            } else if ("name".equals(string)) {
                JavaDataObject.this.previousFileName = (String)propertyChangeEvent.getOldValue();
                JavaDataObject.this.primaryFileMoved(JavaDataObject.this.getPrimaryFile(), JavaDataObject.this.getPrimaryFile());
            }
        }

        public void fileChanged(FileEvent fileEvent) {
            if (!JavaDataObject.this.initialized) {
                return;
            }
            JavaDataObject.this.primaryFileChanged();
        }
    }
}

