/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jmi.reflect.InvalidObjectException;
import javax.jmi.reflect.JmiException;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Attribute;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.EnumConstant;
import org.netbeans.jmi.javamodel.ErrorInfo;
import org.netbeans.jmi.javamodel.ErrorTypeEnum;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Initializer;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.JavaEditor;
import org.netbeans.modules.java.JavaUpToDateStatusProvider;
import org.netbeans.modules.java.OverrideAnnotationSupport;
import org.netbeans.modules.java.ParserAnnotation;
import org.netbeans.modules.java.Util;
import org.netbeans.modules.java.settings.JavaSettings;
import org.netbeans.modules.java.ui.nodes.SourceNodeFactory;
import org.netbeans.modules.java.ui.nodes.SourceNodes;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.RepositoryUpdater;
import org.netbeans.modules.javacore.RequestPoster;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.ParsingListener;
import org.netbeans.modules.javacore.internalapi.UndoManager;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.UndoRedo;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.src.SourceElement;
import org.openide.text.Annotation;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;

public class JavaEditor
extends DataEditorSupport
implements PropertyChangeListener,
Node.Cookie,
OpenCookie,
EditorCookie.Observable,
CloseCookie,
PrintCookie {
    static final String MAGIC_PREFIX = "//GEN-";
    private static String[] SECTION_MAGICS;
    private static final int LONGEST_ITEM = 10;
    private static final int T_LINE = 0;
    private static final int T_BEGIN = 1;
    private static final int T_END = 2;
    private static final int T_HEADER = 3;
    private static final int T_HEADEREND = 4;
    private static final int T_FIRST = 5;
    private static final int T_LAST = 6;
    HashMap sections = null;
    Timer timer;
    static final byte NEW_LINE_N = 0;
    static final byte NEW_LINE_R = 1;
    static final byte NEW_LINE_RN = 2;
    byte newLineType;
    private transient boolean hasAnnotations = false;
    private boolean reloading = false;
    private static final Comparator SECTION_COMPARATOR;
    private ArrayList errorAnnotations = new ArrayList();
    private static final RequestProcessor ERROR_ANNOTATION_QUEUE;
    private boolean parsingAttached;
    private ParsingListener wParsingL;
    private OverrideAnnotationSupport overriddensSupport;
    private Reference sourceClasspath;
    private Reference librariesClasspath;
    private Reference bootClasspath;
    private UndoRedo.Manager undoRedo = null;
    private boolean undoRedoPrecreated = false;
    private transient String resourceMofId = null;
    private transient WeakReference resource = null;
    private final ParsingListener listener = new ParsingListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resourceParsed(Resource resource) {
            JavaMetamodel.getDefaultRepository().beginTrans(false);
            try {
                if (resource == JavaEditor.this.getResource()) {
                    JavaEditor.this.notifyParsingDone();
                }
            }
            finally {
                JavaMetamodel.getDefaultRepository().endTrans();
            }
        }
    };
    private boolean forceParseOnComponentActivated = false;
    static /* synthetic */ Class class$org$openide$cookies$LineCookie;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;
    static /* synthetic */ Class class$org$netbeans$jmi$javamodel$Element;

    public JavaEditor(DataObject dataObject) {
        super(dataObject, (CloneableEditorSupport.Env)new JavaEditorEnv(dataObject));
        this.addChangeListener(new JavaEditorChangeListener());
        JavaMetamodel.getUndoManager().addPropertyChangeListener((PropertyChangeListener)new UndoManagerListener(this));
    }

    private void changeTimeoutElapsed() {
        this.parseSource(false, true);
    }

    protected boolean notifyModified() {
        if (!super.notifyModified()) {
            return false;
        }
        JavaDataObject javaDataObject = (JavaDataObject)this.getDataObject();
        if (javaDataObject.getCookie(SaveCookie.class) == null) {
            javaDataObject.addSaveCookie(new Save());
        }
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        JavaDataObject javaDataObject = (JavaDataObject)this.getDataObject();
        SaveCookie saveCookie = (SaveCookie)javaDataObject.getCookie(SaveCookie.class);
        if (saveCookie != null) {
            javaDataObject.removeSaveCookie(saveCookie);
        }
    }

    private void parseSource(final boolean bl, final boolean bl2) {
        ERROR_ANNOTATION_QUEUE.post(new Runnable(){

            public void run() {
                StyledDocument styledDocument;
                if (bl) {
                    JavaMetamodel.getManager().addModified(JavaEditor.this.getDataObject().getPrimaryFile());
                } else if (JavaEditor.this.forceParseOnComponentActivated && (styledDocument = (ResourceImpl)JavaEditor.this.getResource()) != null) {
                    styledDocument.resetErrors();
                }
                styledDocument = JavaEditor.this.getDocument();
                if (styledDocument != null) {
                    JavaUpToDateStatusProvider.get(styledDocument).notifyParsingStarted();
                }
                JavaMetamodel.getDefaultRepository().beginTrans(true);
                JavaMetamodel.getDefaultRepository().endTrans(false);
                if (bl2) {
                    JavaEditor.this.refreshAnnotations();
                }
                if (styledDocument != null) {
                    JavaUpToDateStatusProvider.get(styledDocument).notifyParsingFinished();
                }
            }
        });
    }

    private void classpathChanged() {
        this.parseSource(true, true);
    }

    private void parsingErrorsChanged(PropertyChangeEvent propertyChangeEvent) {
        int n = JavaSettings.getDefault().getParsingErrors();
        Integer n2 = (Integer)propertyChangeEvent.getOldValue();
        int n3 = 100;
        if (n2 != null) {
            n3 = n2;
        }
        if (n3 == n) {
            return;
        }
        if (n == 0 && !this.errorAnnotations.isEmpty()) {
            JavaEditor.detachAnnotations(this.errorAnnotations);
            this.errorAnnotations.clear();
            return;
        }
        if (n3 == this.errorAnnotations.size() || n < this.errorAnnotations.size()) {
            this.refreshAnnotations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showOverridingChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getOpenedPanes() == null) {
            return;
        }
        boolean bl = JavaSettings.getDefault().getShowOverriding();
        if (bl) {
            this.overriddensSupport.processOverriddenAnnotation();
        } else {
            JavaEditor javaEditor = this;
            synchronized (javaEditor) {
                this.overriddensSupport.suspend();
                this.overriddensSupport = new OverrideAnnotationSupport(this);
            }
        }
    }

    private synchronized void attachParsingListener() {
        if (!this.parsingAttached) {
            if (this.wParsingL == null) {
                this.wParsingL = new WParsingListener(this.listener);
            }
            JavaMetamodel.addParsingListener((ParsingListener)this.wParsingL);
            this.parsingAttached = true;
        }
        if (this.overriddensSupport == null) {
            this.overriddensSupport = new OverrideAnnotationSupport(this);
        }
    }

    private synchronized void removeParsingListener() {
        if (this.parsingAttached) {
            JavaMetamodel.removeParsingListener((ParsingListener)this.wParsingL);
            this.parsingAttached = false;
        }
    }

    void restartTimer(boolean bl) {
        this.restartTimer(bl, false);
    }

    private void restartTimer(boolean bl, boolean bl2) {
        int n;
        boolean bl3;
        boolean bl4 = bl3 = this.timer != null && this.timer.isRunning();
        if (bl && !bl3) {
            return;
        }
        if (!bl) {
            this.forceParseOnComponentActivated = bl2;
        }
        if ((n = JavaSettings.getDefault().getAutoParsingDelay()) <= 0) {
            return;
        }
        if (this.timer == null) {
            this.timer = new Timer(0, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JavaEditor.this.changeTimeoutElapsed();
                }
            });
            this.timer.setRepeats(false);
        }
        this.timer.setInitialDelay(n);
        this.timer.restart();
    }

    private void stopTimerIfPossible() {
        if (this.forceParseOnComponentActivated && this.timer != null) {
            this.timer.stop();
        }
    }

    public void openAtPosition(PositionRef positionRef) {
        this.openAt(positionRef, -1).getComponent().requestActive();
    }

    public void openAt(PositionRef positionRef) {
        this.openAtPosition(positionRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyClosed() {
        JavaEditor javaEditor = this;
        synchronized (javaEditor) {
            this.removeParsingListener();
            if (this.overriddensSupport != null) {
                this.overriddensSupport.suspend();
            }
            this.overriddensSupport = null;
            this.hasAnnotations = false;
        }
        boolean bl = this.isModified();
        CloneableTopComponent.Ref ref = this.allEditors;
        synchronized (ref) {
            super.notifyClosed();
            this.clearSections();
        }
        if (bl) {
            this.parseSource(true, false);
        }
    }

    protected void notifyParsingDone() {
    }

    private void refreshAnnotations() {
        Resource resource;
        ((JMManager)JMManager.getManager()).waitScanFinished();
        if (JMManager.PERF_DEBUG) {
            Thread.dumpStack();
        }
        if ((resource = this.getResource()) != null) {
            try {
                final List list = resource.getErrors();
                list.size();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JavaEditor.this.processAnnotations(list);
                    }
                });
            }
            catch (InvalidObjectException invalidObjectException) {
                // empty catch block
            }
        }
    }

    public Resource getResource() {
        Resource resource;
        Resource resource2 = resource = this.resource == null ? null : (Resource)this.resource.get();
        if (resource != null) {
            try {
                resource.refImmediateComposite();
            }
            catch (InvalidObjectException invalidObjectException) {
                this.resourceMofId = null;
                resource = null;
            }
        }
        if (resource == null || !resource.isValid()) {
            if (this.resourceMofId != null) {
                resource = (Resource)JavaMetamodel.getDefaultRepository().getByMofId(this.resourceMofId);
            }
            if (resource == null || !resource.isValid()) {
                resource = JavaMetamodel.getManager().getResource(this.getDataObject().getPrimaryFile());
                if (resource == null) {
                    return null;
                }
                this.resourceMofId = resource.refMofId();
            }
            this.resource = new WeakReference<Resource>(resource);
        }
        return resource;
    }

    protected void loadFromStreamToKit(StyledDocument styledDocument, InputStream inputStream, EditorKit editorKit) throws IOException, BadLocationException {
        this.sections = new HashMap(10);
        GuardedReader guardedReader = new GuardedReader(inputStream, false, Util.getFileEncoding(this.getDataObject().getPrimaryFile()));
        editorKit.read(guardedReader, (Document)styledDocument, 0);
        this.fillSections(guardedReader, styledDocument);
        this.newLineType = guardedReader.getNewLineType();
        boolean bl = this.reloading;
        this.reloading = false;
        if (bl) {
            ERROR_ANNOTATION_QUEUE.post(new Runnable(){

                public void run() {
                    JavaEditor.this.refreshAnnotations();
                }
            });
        }
    }

    protected void saveFromKitToStream(StyledDocument styledDocument, EditorKit editorKit, OutputStream outputStream) throws IOException, BadLocationException {
        Object object;
        NewLineOutputStream newLineOutputStream = new NewLineOutputStream(outputStream, this.newLineType);
        String string = Util.getFileEncoding(this.getDataObject().getPrimaryFile());
        if (this.sections != null && ((ArrayList)(object = new ArrayList(this.sections.values()))).size() > 0) {
            GuardedWriter guardedWriter = new GuardedWriter(newLineOutputStream, (ArrayList)object, string);
            editorKit.write(guardedWriter, (Document)styledDocument, 0, styledDocument.getLength());
            return;
        }
        object = string == null ? new OutputStreamWriter(newLineOutputStream) : new OutputStreamWriter((OutputStream)newLineOutputStream, string);
        editorKit.write((Writer)object, (Document)styledDocument, 0, styledDocument.getLength());
    }

    public void saveDocument() throws IOException {
        this.saveDocument(true);
    }

    private void saveDocument(boolean bl) throws IOException {
        if (bl || this.isModified()) {
            if (!this.checkCharsetConversion(Util.getFileEncoding(this.getDataObject().getPrimaryFile()))) {
                return;
            }
            RepositoryUpdater.getDefault().addFileObjectToSave(this.getDataObject().getPrimaryFile());
            super.saveDocument();
        }
    }

    private boolean checkCharsetConversion(String string) {
        if (string == null) {
            return true;
        }
        boolean bl = true;
        try {
            CharsetEncoder charsetEncoder = Charset.forName(string).newEncoder();
            if (!charsetEncoder.canEncode(this.getDocument().getText(0, this.getDocument().getLength()))) {
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage((Class)JavaEditor.class, (String)"MSG_BadCharConversion", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), string}), 0, 2);
                confirmation.setValue(NotifyDescriptor.NO_OPTION);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                if (confirmation.getValue() != NotifyDescriptor.YES_OPTION) {
                    bl = false;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
        }
        return bl;
    }

    private void processAnnotations(List list) {
        Collection collection = this.getAnnotations(list);
        ArrayList arrayList = new ArrayList(collection);
        arrayList.removeAll(this.errorAnnotations);
        ArrayList arrayList2 = new ArrayList(this.errorAnnotations);
        arrayList2.retainAll(collection);
        ArrayList arrayList3 = this.errorAnnotations;
        arrayList3.removeAll(collection);
        JavaEditor.detachAnnotations(arrayList3);
        if (!arrayList.isEmpty() && this.isDocumentLoaded()) {
            final ArrayList arrayList4 = arrayList;
            StyledDocument styledDocument = this.getDocument();
            Runnable runnable = new Runnable(){

                public void run() {
                    LineCookie lineCookie = (LineCookie)JavaEditor.this.getDataObject().getCookie(class$org$openide$cookies$LineCookie == null ? (class$org$openide$cookies$LineCookie = JavaEditor.class$("org.openide.cookies.LineCookie")) : class$org$openide$cookies$LineCookie);
                    Line.Set set = lineCookie.getLineSet();
                    Iterator iterator = arrayList4.iterator();
                    while (iterator.hasNext()) {
                        ParserAnnotation parserAnnotation = (ParserAnnotation)iterator.next();
                        parserAnnotation.attachToLineSet(set);
                    }
                }
            };
            if (styledDocument != null) {
                styledDocument.render(runnable);
            } else {
                runnable.run();
            }
        }
        this.errorAnnotations = arrayList2;
        this.errorAnnotations.addAll(arrayList);
    }

    private Collection getAnnotations(List list) {
        HashMap<Integer, ParserAnnotation> hashMap = new HashMap<Integer, ParserAnnotation>(2 * list.size());
        int n = JavaSettings.getDefault().getParsingErrors();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ErrorInfo errorInfo = (ErrorInfo)iterator.next();
            int n2 = errorInfo.getLineNumber();
            if (n2 <= 0) continue;
            int n3 = errorInfo.getColumn();
            String string = errorInfo.getDescription();
            ParserAnnotation parserAnnotation = new ParserAnnotation(n2, n3, errorInfo.getSeverity(), string);
            Integer n4 = new Integer(n2);
            ParserAnnotation parserAnnotation2 = (ParserAnnotation)hashMap.get(n4);
            if (parserAnnotation2 != null) {
                if (parserAnnotation2.getSeverity().equals(ErrorTypeEnum.WARNING)) {
                    hashMap.put(n4, parserAnnotation);
                    parserAnnotation.chain(parserAnnotation2);
                    continue;
                }
                parserAnnotation2.chain(parserAnnotation);
                continue;
            }
            if (hashMap.size() >= n) continue;
            hashMap.put(n4, parserAnnotation);
        }
        return hashMap.values();
    }

    private static void detachAnnotations(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Annotation annotation = (Annotation)iterator.next();
            if (annotation.getAttachedAnnotatable() == null) continue;
            annotation.detach();
        }
    }

    private ClassPath getBootClassPath() {
        ClassPath classPath;
        if ((this.bootClasspath == null || (classPath = (ClassPath)this.bootClasspath.get()) == null) && (classPath = ClassPath.getClassPath((FileObject)this.getDataObject().getPrimaryFile(), (String)"classpath/boot")) != null) {
            this.bootClasspath = new WeakReference<ClassPath>(classPath);
        }
        return classPath;
    }

    private ClassPath getLibrariesPath() {
        ClassPath classPath;
        if ((this.librariesClasspath == null || (classPath = (ClassPath)this.librariesClasspath.get()) == null) && (classPath = ClassPath.getClassPath((FileObject)this.getDataObject().getPrimaryFile(), (String)"classpath/compile")) != null) {
            this.librariesClasspath = new WeakReference<ClassPath>(classPath);
        }
        return classPath;
    }

    private ClassPath getSourcePath() {
        ClassPath classPath;
        if (this.sourceClasspath == null || (classPath = (ClassPath)this.sourceClasspath.get()) == null) {
            classPath = ClassPath.getClassPath((FileObject)this.getDataObject().getPrimaryFile(), (String)"classpath/source");
            this.sourceClasspath = new WeakReference<ClassPath>(classPath);
        }
        return classPath;
    }

    public SourceElement getSource() {
        return ((JavaDataObject)this.getDataObject()).getSource();
    }

    public Element sourceToText(org.openide.src.Element element) {
        return null;
    }

    public org.openide.src.Element textToSource(Element element) throws NoSuchElementException {
        throw new NoSuchElementException();
    }

    public org.openide.src.Element findElement(int n) {
        return null;
    }

    public SimpleSection createSimpleSection(PositionRef positionRef, String string) throws IllegalArgumentException, BadLocationException {
        this.checkOverlap(positionRef);
        return this.doCreateSimpleSection(positionRef, string);
    }

    public SimpleSection createSimpleSection(PositionBounds positionBounds, String string) throws IllegalArgumentException, BadLocationException {
        this.checkOverlap(positionBounds);
        return this.doCreateSimpleSection(positionBounds, string);
    }

    private void checkOverlap(PositionRef positionRef) {
        Iterator iterator = this.sections.values().iterator();
        while (iterator.hasNext()) {
            GuardedSection guardedSection = (GuardedSection)iterator.next();
            if (!guardedSection.contains(positionRef, false)) continue;
            throw new IllegalArgumentException("Sections overlap");
        }
    }

    public boolean testOverlap(PositionBounds positionBounds) {
        try {
            this.openDocument();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException();
        }
        try {
            this.checkOverlap(positionBounds, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    private void checkOverlap(PositionBounds positionBounds) throws IllegalArgumentException {
        this.checkOverlap(positionBounds, false);
    }

    private void checkOverlap(PositionBounds positionBounds, boolean bl) throws IllegalArgumentException {
        TreeSet treeSet = new TreeSet(new GuardedPositionComparator());
        treeSet.addAll(this.sections.values());
        Iterator iterator = treeSet.iterator();
        PositionRef positionRef = positionBounds.getBegin();
        PositionRef positionRef2 = positionBounds.getEnd();
        int n = positionRef.getOffset();
        int n2 = positionRef2.getOffset();
        Object var9_9 = null;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            GuardedSection guardedSection = (GuardedSection)iterator.next();
            if (guardedSection.contains(positionRef, bl) || guardedSection.contains(positionRef2, bl)) {
                throw new IllegalArgumentException("Sections overlap");
            }
            if (guardedSection.getBegin().getOffset() <= n) continue;
            if (guardedSection.getBegin().getOffset() >= n2) break;
            throw new IllegalArgumentException("Sections overlap");
        }
    }

    private SimpleSection doCreateSimpleSection(final PositionBounds positionBounds, final String string) throws IllegalArgumentException, BadLocationException {
        StyledDocument styledDocument = null;
        try {
            styledDocument = this.openDocument();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot load document");
        }
        final StyledDocument styledDocument2 = styledDocument;
        final SimpleSection[] simpleSectionArray = new SimpleSection[]{null};
        Util.ExceptionRunnable exceptionRunnable = new Util.ExceptionRunnable(){

            public void run() throws Exception {
                simpleSectionArray[0] = new SimpleSection(string, JavaEditor.this.createBounds(positionBounds.getBegin().getOffset(), positionBounds.getEnd().getOffset(), false));
                JavaEditor.this.sections.put(simpleSectionArray[0].getName(), simpleSectionArray[0]);
                simpleSectionArray[0].markGuarded(styledDocument2);
            }
        };
        try {
            Util.runAtomic(styledDocument2, exceptionRunnable);
            this.notifyModified();
        }
        catch (Exception exception) {
            if (exception instanceof BadLocationException) {
                throw (BadLocationException)exception;
            }
            throw new IllegalArgumentException();
        }
        return simpleSectionArray[0];
    }

    private SimpleSection doCreateSimpleSection(final PositionRef positionRef, final String string) throws IllegalArgumentException, BadLocationException {
        StyledDocument styledDocument = null;
        try {
            styledDocument = this.openDocument();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException();
        }
        final StyledDocument styledDocument2 = styledDocument;
        final SimpleSection[] simpleSectionArray = new SimpleSection[]{null};
        Util.ExceptionRunnable exceptionRunnable = new Util.ExceptionRunnable(){

            public void run() throws Exception {
                int n = positionRef.getOffset();
                styledDocument2.insertString(n, "\n \n", null);
                simpleSectionArray[0] = new SimpleSection(string, JavaEditor.this.createBounds(n + 1, n + 3, false));
                JavaEditor.this.sections.put(simpleSectionArray[0].getName(), simpleSectionArray[0]);
                simpleSectionArray[0].markGuarded(styledDocument2);
            }
        };
        try {
            Util.runAtomic(styledDocument2, exceptionRunnable);
            this.notifyModified();
        }
        catch (Exception exception) {
            if (exception instanceof BadLocationException) {
                throw (BadLocationException)exception;
            }
            throw new IllegalArgumentException();
        }
        return simpleSectionArray[0];
    }

    public SimpleSection createSimpleSectionAfter(GuardedSection guardedSection, String string) throws IllegalArgumentException, BadLocationException {
        PositionBounds positionBounds = guardedSection instanceof SimpleSection ? ((SimpleSection)guardedSection).bounds : ((InteriorSection)guardedSection).bottom;
        if (guardedSection == null || !guardedSection.valid) {
            throw new IllegalArgumentException("Invalid guarded block");
        }
        return this.doCreateSimpleSection(positionBounds.getEnd(), string);
    }

    public InteriorSection createInteriorSection(PositionRef positionRef, String string) throws IllegalArgumentException, BadLocationException {
        this.checkOverlap(positionRef);
        return this.doCreateInteriorSection(positionRef, string);
    }

    public InteriorSection createInteriorSectionAfter(GuardedSection guardedSection, String string) throws IllegalArgumentException, BadLocationException {
        PositionBounds positionBounds = guardedSection instanceof SimpleSection ? ((SimpleSection)guardedSection).bounds : ((InteriorSection)guardedSection).bottom;
        if (guardedSection == null || !guardedSection.valid) {
            throw new IllegalArgumentException("Invalid guarded block");
        }
        return this.doCreateInteriorSection(positionBounds.getEnd(), string);
    }

    public InteriorSection createInteriorSection(PositionBounds positionBounds, PositionBounds positionBounds2, String string) throws IllegalArgumentException, BadLocationException {
        this.checkOverlap(positionBounds);
        if (positionBounds.getBegin().getOffset() > positionBounds2.getEnd().getOffset() || positionBounds.getEnd().getOffset() < positionBounds2.getEnd().getOffset()) {
            throw new IllegalArgumentException("Interior is not nested.");
        }
        return this.doCreateInteriorSection(positionBounds, positionBounds2, string);
    }

    private InteriorSection doCreateInteriorSection(final PositionBounds positionBounds, final PositionBounds positionBounds2, final String string) throws IllegalArgumentException, BadLocationException {
        StyledDocument styledDocument = null;
        try {
            styledDocument = this.openDocument();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot load document");
        }
        final StyledDocument styledDocument2 = styledDocument;
        final InteriorSection[] interiorSectionArray = new InteriorSection[]{null};
        Util.ExceptionRunnable exceptionRunnable = new Util.ExceptionRunnable(){

            public void run() {
                interiorSectionArray[0] = new InteriorSection(string, JavaEditor.this.createBounds(positionBounds.getBegin().getOffset(), positionBounds2.getBegin().getOffset(), false), JavaEditor.this.createBounds(positionBounds2.getBegin().getOffset(), positionBounds2.getEnd().getOffset(), true), JavaEditor.this.createBounds(positionBounds2.getEnd().getOffset(), positionBounds.getEnd().getOffset(), false));
                JavaEditor.this.sections.put(interiorSectionArray[0].getName(), interiorSectionArray[0]);
                interiorSectionArray[0].markGuarded(styledDocument2);
            }
        };
        try {
            Util.runAtomic(styledDocument2, exceptionRunnable);
            this.notifyModified();
        }
        catch (Exception exception) {
            if (exception instanceof BadLocationException) {
                throw (BadLocationException)exception;
            }
            throw new IllegalArgumentException();
        }
        return interiorSectionArray[0];
    }

    private InteriorSection doCreateInteriorSection(final PositionRef positionRef, final String string) throws IllegalArgumentException, BadLocationException {
        StyledDocument styledDocument = null;
        try {
            styledDocument = this.openDocument();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException();
        }
        final StyledDocument styledDocument2 = styledDocument;
        final InteriorSection[] interiorSectionArray = new InteriorSection[]{null};
        Util.ExceptionRunnable exceptionRunnable = new Util.ExceptionRunnable(){

            public void run() throws Exception {
                int n = positionRef.getOffset();
                styledDocument2.insertString(n, "\n \n \n \n", null);
                interiorSectionArray[0] = new InteriorSection(string, JavaEditor.this.createBounds(n + 1, n + 3, false), JavaEditor.this.createBounds(n + 3, n + 5, true), JavaEditor.this.createBounds(n + 5, n + 7, false));
                JavaEditor.this.sections.put(interiorSectionArray[0].getName(), interiorSectionArray[0]);
                interiorSectionArray[0].markGuarded(styledDocument2);
            }
        };
        try {
            Util.runAtomic(styledDocument2, exceptionRunnable);
            this.notifyModified();
        }
        catch (Exception exception) {
            if (exception instanceof BadLocationException) {
                throw (BadLocationException)exception;
            }
            throw new IllegalArgumentException();
        }
        return interiorSectionArray[0];
    }

    public SimpleSection findSimpleSection(String string) {
        GuardedSection guardedSection = this.findSection(string);
        return guardedSection instanceof SimpleSection ? (SimpleSection)guardedSection : null;
    }

    public InteriorSection findInteriorSection(String string) {
        GuardedSection guardedSection = this.findSection(string);
        return guardedSection instanceof InteriorSection ? (InteriorSection)guardedSection : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GuardedSection findSection(String string) {
        try {
            StyledDocument styledDocument = this.openDocument();
            JavaEditor javaEditor = this;
            synchronized (javaEditor) {
                if (this.sections != null) {
                    return (GuardedSection)this.sections.get(string);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getGuardedSections() {
        try {
            StyledDocument styledDocument = this.openDocument();
            JavaEditor javaEditor = this;
            synchronized (javaEditor) {
                if (this.sections != null) {
                    return ((HashMap)this.sections.clone()).values().iterator();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Collections.EMPTY_SET.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getGuardedSectionNames() {
        try {
            StyledDocument styledDocument = this.openDocument();
            JavaEditor javaEditor = this;
            synchronized (javaEditor) {
                if (this.sections != null) {
                    return ((HashMap)this.sections.clone()).keySet().iterator();
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return Collections.EMPTY_SET.iterator();
    }

    public PositionRef findFreePosition(PositionBounds positionBounds) {
        GuardedSection guardedSection;
        PositionRef positionRef;
        try {
            StyledDocument styledDocument = this.openDocument();
        }
        catch (IOException iOException) {
            return null;
        }
        PositionRef positionRef2 = positionBounds.getBegin();
        int n = positionRef2.getOffset();
        TreeSet treeSet = new TreeSet(SECTION_COMPARATOR);
        treeSet.addAll(this.sections.values());
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext() && (positionRef = (guardedSection = (GuardedSection)iterator.next()).getBegin()).getOffset() <= n) {
            if (!guardedSection.contains(positionRef2, false)) continue;
            PositionRef positionRef3 = guardedSection.getPositionAfter();
            if (positionRef3.getOffset() > positionBounds.getEnd().getOffset()) {
                return null;
            }
            return positionRef3;
        }
        return positionRef2;
    }

    protected CloneableEditor createCloneableEditor() {
        return new JavaEditorComponent((CloneableEditorSupport)this);
    }

    synchronized void clearSections() {
        if (this.sections != null) {
            Iterator iterator = ((HashMap)this.sections.clone()).values().iterator();
            while (iterator.hasNext()) {
                GuardedSection guardedSection = (GuardedSection)iterator.next();
                guardedSection.valid = false;
            }
            this.sections = null;
        }
    }

    PositionRef findUnguarded(PositionRef positionRef, boolean bl, boolean bl2) {
        Iterator iterator = this.getGuardedSections();
        while (iterator.hasNext()) {
            GuardedSection guardedSection = (GuardedSection)iterator.next();
            if (!guardedSection.contains(positionRef, bl)) continue;
            if (bl2) {
                return guardedSection.getPositionAfter();
            }
            return guardedSection.getPositionBefore();
        }
        return positionRef;
    }

    private void fillSections(GuardedReader guardedReader, StyledDocument styledDocument) {
        SectionDesc sectionDesc = null;
        Iterator iterator = guardedReader.list.iterator();
        while (iterator.hasNext()) {
            SectionDesc sectionDesc2 = (SectionDesc)iterator.next();
            GuardedSection guardedSection = null;
            switch (sectionDesc2.type) {
                case 0: {
                    guardedSection = new SimpleSection(sectionDesc2.name, this.createBounds(sectionDesc2.begin, sectionDesc2.end, false));
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    sectionDesc = sectionDesc2;
                    break;
                }
                case 4: {
                    if (sectionDesc != null && (sectionDesc.type == 3 || sectionDesc.type == 5) && sectionDesc2.name.equals(sectionDesc.name)) {
                        sectionDesc.end = sectionDesc2.end;
                        break;
                    }
                    sectionDesc = null;
                    break;
                }
                case 2: 
                case 6: {
                    if (sectionDesc != null && sectionDesc.name.equals(sectionDesc2.name)) {
                        if (sectionDesc.type == 1 && sectionDesc2.type == 2) {
                            guardedSection = new SimpleSection(sectionDesc2.name, this.createBounds(sectionDesc.begin, sectionDesc2.end, false));
                            break;
                        }
                        if (sectionDesc.type == 5 && sectionDesc2.type == 6 || sectionDesc.type == 3 && sectionDesc2.type == 2) {
                            guardedSection = new InteriorSection(sectionDesc2.name, this.createBounds(sectionDesc.begin, sectionDesc.end, false), this.createBounds(sectionDesc.end, sectionDesc2.begin, true), this.createBounds(sectionDesc2.begin, sectionDesc2.end, false));
                            break;
                        }
                    }
                    sectionDesc = null;
                }
            }
            if (guardedSection == null) continue;
            this.sections.put(guardedSection.getName(), guardedSection);
            sectionDesc = null;
            guardedSection.markGuarded(styledDocument);
        }
    }

    public PositionBounds createBounds(int n, int n2, boolean bl) {
        if (!bl) {
            return new PositionBounds(this.createPositionRef(n, Position.Bias.Forward), this.createPositionRef(n2, Position.Bias.Backward));
        }
        return new PositionBounds(this.createPositionRef(n, Position.Bias.Backward), this.createPositionRef(n2, Position.Bias.Forward));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        UndoManager undoManager = JavaMetamodel.getUndoManager();
        if (undoManager.isUndoAvailable() || undoManager.isRedoAvailable()) {
            this.getUndoRedo().discardAllEdits();
        }
    }

    static /* synthetic */ OverrideAnnotationSupport access$1200(JavaEditor javaEditor) {
        return javaEditor.overriddensSupport;
    }

    static /* synthetic */ void access$1800(JavaEditor javaEditor) {
        javaEditor.classpathChanged();
    }

    static /* synthetic */ void access$1900(JavaEditor javaEditor, PropertyChangeEvent propertyChangeEvent) {
        javaEditor.parsingErrorsChanged(propertyChangeEvent);
    }

    static /* synthetic */ void access$2000(JavaEditor javaEditor, PropertyChangeEvent propertyChangeEvent) {
        javaEditor.showOverridingChanged(propertyChangeEvent);
    }

    static {
        StringBuffer stringBuffer = new StringBuffer(MAGIC_PREFIX);
        int n = stringBuffer.length();
        SECTION_MAGICS = new String[7];
        JavaEditor.SECTION_MAGICS[0] = stringBuffer.append("LINE:").toString();
        stringBuffer.setLength(n);
        JavaEditor.SECTION_MAGICS[1] = stringBuffer.append("BEGIN:").toString();
        stringBuffer.setLength(n);
        JavaEditor.SECTION_MAGICS[2] = stringBuffer.append("END:").toString();
        stringBuffer.setLength(n);
        JavaEditor.SECTION_MAGICS[3] = stringBuffer.append("HEADER:").toString();
        stringBuffer.setLength(n);
        JavaEditor.SECTION_MAGICS[4] = stringBuffer.append("HEADEREND:").toString();
        stringBuffer.setLength(n);
        JavaEditor.SECTION_MAGICS[5] = stringBuffer.append("FIRST:").toString();
        stringBuffer.setLength(n);
        JavaEditor.SECTION_MAGICS[6] = stringBuffer.append("LAST:").toString();
        SECTION_COMPARATOR = new GuardedPositionComparator();
        ERROR_ANNOTATION_QUEUE = new RequestProcessor("Error Annotation Queue", 1);
    }

    private static class UndoManagerListener
    implements PropertyChangeListener {
        private WeakReference ref;

        UndoManagerListener(JavaEditor javaEditor) {
            this.ref = new ActiveQueueReference(javaEditor, Utilities.activeReferenceQueue());
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            UndoManager undoManager = JavaMetamodel.getUndoManager();
            JavaEditor javaEditor = (JavaEditor)this.ref.get();
            if (javaEditor == null) {
                undoManager.removePropertyChangeListener((PropertyChangeListener)this);
                return;
            }
            if (undoManager.isUndoAvailable() || undoManager.isRedoAvailable()) {
                javaEditor.getUndoRedo().discardAllEdits();
            }
        }

        private class ActiveQueueReference
        extends WeakReference
        implements Runnable {
            public ActiveQueueReference(Object object, ReferenceQueue referenceQueue) {
                super(object, referenceQueue);
            }

            public void run() {
                UndoManager undoManager = JavaMetamodel.getUndoManager();
                undoManager.removePropertyChangeListener((PropertyChangeListener)UndoManagerListener.this);
            }
        }
    }

    static class WParsingListener
    extends WeakReference
    implements ParsingListener,
    Runnable {
        WParsingListener(ParsingListener parsingListener) {
            super(parsingListener, Utilities.activeReferenceQueue());
        }

        public void run() {
            JavaMetamodel.removeParsingListener((ParsingListener)this);
        }

        ParsingListener getListener() {
            Object t = this.get();
            if (t == null) {
                JavaMetamodel.removeParsingListener((ParsingListener)this);
            }
            return (ParsingListener)t;
        }

        public void resourceParsed(Resource resource) {
            ParsingListener parsingListener = this.getListener();
            if (parsingListener != null) {
                parsingListener.resourceParsed(resource);
            }
        }
    }

    private static class NewLineOutputStream
    extends OutputStream {
        OutputStream stream;
        byte newLineType;

        public NewLineOutputStream(OutputStream outputStream, byte by) {
            this.stream = outputStream;
            this.newLineType = by;
        }

        public void write(int n) throws IOException {
            if (n == 10) {
                switch (this.newLineType) {
                    case 1: {
                        this.stream.write(13);
                        break;
                    }
                    case 2: {
                        this.stream.write(13);
                    }
                    case 0: {
                        this.stream.write(10);
                    }
                }
            } else {
                this.stream.write(n);
            }
        }
    }

    static class GuardedWriter
    extends Writer {
        BufferedWriter writer;
        Iterator sections;
        SectionDesc current;
        int offsetCounter;
        boolean wasNewLine;
        int spaces;

        GuardedWriter(OutputStream outputStream, ArrayList arrayList, String string) throws IOException {
            this.writer = string == null ? new BufferedWriter(new OutputStreamWriter(outputStream)) : new BufferedWriter(new OutputStreamWriter(outputStream, string));
            this.offsetCounter = 0;
            this.sections = this.prepareSections(arrayList);
            this.nextSection();
            this.wasNewLine = false;
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            for (int i = 0; i < n2; ++i) {
                this.writeOneChar(cArray[i + n]);
            }
        }

        public void close() throws IOException {
            this.writer.flush();
        }

        public void flush() throws IOException {
            this.writer.flush();
        }

        private Iterator prepareSections(ArrayList arrayList) {
            LinkedList<SectionDesc> linkedList = new LinkedList<SectionDesc>();
            Collections.sort(arrayList, new GuardedPositionComparator());
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                SectionDesc sectionDesc;
                GuardedSection guardedSection = (GuardedSection)iterator.next();
                if (guardedSection instanceof SimpleSection) {
                    sectionDesc = new SectionDesc(0);
                    sectionDesc.name = guardedSection.name;
                    sectionDesc.begin = ((SimpleSection)guardedSection).bounds.getBegin().getOffset();
                    sectionDesc.end = ((SimpleSection)guardedSection).bounds.getEnd().getOffset();
                    linkedList.add(sectionDesc);
                    continue;
                }
                sectionDesc = new SectionDesc(3);
                sectionDesc.begin = ((InteriorSection)guardedSection).header.getBegin().getOffset();
                sectionDesc.end = ((InteriorSection)guardedSection).header.getEnd().getOffset();
                sectionDesc.name = guardedSection.name;
                linkedList.add(sectionDesc);
                sectionDesc = new SectionDesc(2);
                sectionDesc.begin = ((InteriorSection)guardedSection).bottom.getBegin().getOffset();
                sectionDesc.end = ((InteriorSection)guardedSection).bottom.getEnd().getOffset();
                sectionDesc.name = guardedSection.name;
                linkedList.add(sectionDesc);
            }
            return linkedList.iterator();
        }

        void writeOneChar(int n) throws IOException {
            if (n == 13) {
                return;
            }
            if (this.current != null) {
                if (this.offsetCounter == this.current.begin) {
                    this.wasNewLine = false;
                }
                if (n == 10 && this.current.begin <= this.offsetCounter) {
                    switch (this.current.type) {
                        case 0: {
                            if (!this.wasNewLine) {
                                if (this.offsetCounter + 1 >= this.current.end) {
                                    this.writeMagic(0, this.current.name);
                                    this.nextSection();
                                    break;
                                }
                                this.writeMagic(1, this.current.name);
                                this.wasNewLine = true;
                                break;
                            }
                            if (this.offsetCounter + 1 < this.current.end) break;
                            this.writeMagic(2, this.current.name);
                            this.nextSection();
                            break;
                        }
                        case 3: {
                            if (!this.wasNewLine) {
                                if (this.offsetCounter + 1 >= this.current.end) {
                                    this.writeMagic(5, this.current.name);
                                    this.nextSection();
                                    break;
                                }
                                this.writeMagic(5, this.current.name);
                                this.wasNewLine = true;
                                break;
                            }
                            if (this.offsetCounter + 1 < this.current.end) break;
                            this.writeMagic(4, this.current.name);
                            this.nextSection();
                            break;
                        }
                        case 2: {
                            this.writeMagic(6, this.current.name);
                            this.nextSection();
                        }
                    }
                }
            }
            if (n == 32) {
                ++this.spaces;
            } else {
                char[] cArray = new char[this.spaces];
                Arrays.fill(cArray, ' ');
                this.writer.write(cArray);
                this.writer.write(n);
                this.spaces = 0;
            }
            ++this.offsetCounter;
        }

        private void nextSection() {
            this.current = this.sections.hasNext() ? this.sections.next() : null;
        }

        private void writeMagic(int n, String string) throws IOException {
            this.spaces = 0;
            this.writer.write(SECTION_MAGICS[n], 0, SECTION_MAGICS[n].length());
            this.writer.write(string, 0, string.length());
        }
    }

    static class GuardedReader
    extends Reader {
        Reader reader;
        char[] charBuff;
        char[] readBuff;
        int howmany;
        Pattern magicsAsRE;
        boolean justFilter;
        int position;
        LinkedList list;
        final int[] newLineTypes;

        GuardedReader(InputStream inputStream, boolean bl) throws IOException {
            this(inputStream, bl, null);
        }

        GuardedReader(InputStream inputStream, boolean bl, String string) throws IOException {
            this.reader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
            this.justFilter = bl;
            this.position = 0;
            this.list = new LinkedList();
            this.newLineTypes = new int[]{0, 0, 0};
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            if (this.charBuff == null) {
                this.readCharBuff();
                this.translateToCharBuff();
            }
            if (this.howmany <= 0) {
                return -1;
            }
            int n3 = Math.min(n2, this.howmany);
            System.arraycopy(this.charBuff, this.position, cArray, n, n3);
            this.howmany -= n3;
            this.position += n3;
            return n3;
        }

        final void readCharBuff() throws IOException {
            int n;
            char[] cArray = new char[2048];
            ArrayList<char[]> arrayList = new ArrayList<char[]>(20);
            while (true) {
                n = this.readFully(cArray);
                arrayList.add(cArray);
                if (n < 2048) break;
                cArray = new char[2048];
            }
            int n2 = arrayList.size() - 1;
            int n3 = n2 * 2048 + n;
            this.readBuff = new char[n3];
            this.charBuff = new char[n3];
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                char[] cArray2 = (char[])arrayList.get(i);
                System.arraycopy(cArray2, 0, this.readBuff, n4, 2048);
                n4 += 2048;
            }
            System.arraycopy(cArray, 0, this.readBuff, n4, n);
        }

        final int readFully(char[] cArray) throws IOException {
            int n = 0;
            int n2 = 0;
            while ((n2 += (n = this.reader.read(cArray, n2, cArray.length - n2))) < cArray.length && n > 0) {
            }
            return n2 + 1;
        }

        final void translateToCharBuff() {
            char c;
            this.position = 0;
            int n = 0;
            int n2 = this.readBuff.length - 1;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = JavaEditor.MAGIC_PREFIX.length();
            while (n3 < n2) {
                int n7;
                CharBuffer charBuffer;
                c = this.readBuff[n3];
                switch (c) {
                    case '\n': {
                        this.newLineTypes[0] = this.newLineTypes[0] + 1;
                        this.charBuff[n++] = 10;
                        n4 = n;
                        ++n3;
                        break;
                    }
                    case '\r': {
                        char c2 = this.readBuff[n3 + 1];
                        if (c2 != '\n') {
                            this.newLineTypes[1] = this.newLineTypes[1] + 1;
                            ++n3;
                        } else {
                            n3 += 2;
                            this.newLineTypes[2] = this.newLineTypes[2] + 1;
                        }
                        this.charBuff[n++] = 10;
                        n4 = n;
                        break;
                    }
                    default: {
                        this.charBuff[n++] = this.readBuff[n3++];
                    }
                }
                switch (n5) {
                    case 0: {
                        if (c == '/') {
                            ++n5;
                            break;
                        }
                        n5 = 0;
                        break;
                    }
                    case 1: {
                        if (c == '/') {
                            ++n5;
                            break;
                        }
                        n5 = 0;
                        break;
                    }
                    case 2: {
                        if (c == 'G') {
                            ++n5;
                            break;
                        }
                        if (c == '/') {
                            n5 = 2;
                            break;
                        }
                        n5 = 0;
                        break;
                    }
                    case 3: {
                        if (c == 'E') {
                            ++n5;
                            break;
                        }
                        n5 = 0;
                        break;
                    }
                    case 4: {
                        if (c == 'N') {
                            ++n5;
                            break;
                        }
                        n5 = 0;
                        break;
                    }
                    case 5: {
                        if (c == '-') {
                            ++n5;
                            break;
                        }
                        n5 = 0;
                        break;
                    }
                    default: {
                        n5 = 0;
                    }
                }
                if (n5 != n6) continue;
                n5 = 0;
                Pattern pattern = this.getMagicsAsRE();
                Matcher matcher = pattern.matcher(charBuffer = CharBuffer.wrap(this.readBuff, n3, n7 = Math.min(10, this.readBuff.length - n3)));
                if (!matcher.find()) continue;
                String string = matcher.group();
                n -= n6;
                int n8 = this.toNewLine(n3 += string.length());
                int n9 = n6 + string.length() + n8;
                if (!this.justFilter) {
                    int n10 = GuardedReader.string2Type(string);
                    SectionDesc sectionDesc = new SectionDesc(n10);
                    sectionDesc.begin = n4;
                    sectionDesc.end = n + n9 + 1;
                    sectionDesc.name = new String(this.readBuff, n3, n8);
                    this.list.add(sectionDesc);
                }
                n3 += n8;
                Arrays.fill(this.charBuff, n, n + n9, ' ');
                n += n9;
            }
            if (n3 == n2) {
                c = this.readBuff[n3];
                switch (c) {
                    case '\n': {
                        this.newLineTypes[0] = this.newLineTypes[0] + 1;
                        this.charBuff[n++] = 10;
                        break;
                    }
                    case '\r': {
                        this.newLineTypes[1] = this.newLineTypes[1] + 1;
                        this.charBuff[n++] = 10;
                        break;
                    }
                    default: {
                        this.charBuff[n++] = this.readBuff[n3++];
                    }
                }
            }
            if (!this.justFilter && this.list.size() > 0) {
                SectionDesc sectionDesc = (SectionDesc)this.list.getLast();
                if (sectionDesc.end > n) {
                    sectionDesc.end = n;
                }
            }
            this.howmany = n;
            this.readBuff = null;
        }

        static int string2Type(String string) {
            StringBuffer stringBuffer = new StringBuffer(JavaEditor.MAGIC_PREFIX);
            stringBuffer.append(string);
            string = stringBuffer.toString();
            int n = SECTION_MAGICS.length;
            for (int i = 0; i < n; ++i) {
                if (!string.equals(SECTION_MAGICS[i])) continue;
                return i;
            }
            return -1;
        }

        final int toNewLine(int n) {
            int n2 = n;
            int n3 = this.readBuff.length;
            while (n2 < n3) {
                char c;
                if ((c = this.readBuff[n2++]) != '\r' && c != '\n') continue;
                --n2;
                break;
            }
            return n2 - n;
        }

        final Pattern getMagicsAsRE() {
            if (this.magicsAsRE == null) {
                this.magicsAsRE = Pattern.compile(this.makeOrRegexp());
            }
            return this.magicsAsRE;
        }

        final String makeOrRegexp() {
            StringBuffer stringBuffer = new StringBuffer(100);
            int n = JavaEditor.MAGIC_PREFIX.length();
            int n2 = SECTION_MAGICS.length - 1;
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append(SECTION_MAGICS[i].substring(n));
                stringBuffer.append('|');
            }
            stringBuffer.append(SECTION_MAGICS[n2].substring(n));
            return stringBuffer.toString();
        }

        byte getNewLineType() {
            if (this.newLineTypes[0] == this.newLineTypes[1] && this.newLineTypes[1] == this.newLineTypes[2]) {
                String string = System.getProperty("line.separator");
                if ("\r".equals(string)) {
                    return 1;
                }
                if ("\r\n".equals(string)) {
                    return 2;
                }
                return 0;
            }
            if (this.newLineTypes[0] > this.newLineTypes[1]) {
                return this.newLineTypes[0] > this.newLineTypes[2] ? (byte)0 : 2;
            }
            return this.newLineTypes[1] > this.newLineTypes[2] ? (byte)1 : 2;
        }

        public void close() throws IOException {
            this.reader.close();
        }
    }

    private static class SectionDesc {
        int type;
        String name;
        int begin;
        int end;

        SectionDesc(int n) {
            this.type = n;
            this.name = null;
            this.begin = 0;
            this.end = 0;
        }
    }

    private static class GuardedPositionComparator
    implements Comparator {
        private GuardedPositionComparator() {
        }

        public int compare(Object object, Object object2) {
            return this.getOffset(object) - this.getOffset(object2);
        }

        private int getOffset(Object object) {
            if (object instanceof SimpleSection) {
                return ((SimpleSection)object).bounds.getBegin().getOffset();
            }
            return ((InteriorSection)object).header.getBegin().getOffset();
        }
    }

    private class JavaEditorChangeListener
    implements ChangeListener {
        private PropertyChangeListener classpathListener;
        private PropertyChangeListener settingListener;

        private JavaEditorChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JavaSettings javaSettings = JavaSettings.getDefault();
            if (this.classpathListener == null) {
                this.classpathListener = new PropertyChangeListener(this){
                    private final /* synthetic */ JavaEditorChangeListener this$1;
                    {
                        this.this$1 = javaEditorChangeListener;
                    }

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if ("roots".equals(propertyChangeEvent.getPropertyName())) {
                            JavaEditor.access$1800(JavaEditorChangeListener.access$1700(this.this$1));
                        }
                    }
                };
            }
            if (this.settingListener == null) {
                this.settingListener = new PropertyChangeListener(this){
                    private final /* synthetic */ JavaEditorChangeListener this$1;
                    {
                        this.this$1 = javaEditorChangeListener;
                    }

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if ("parsingErrors".equals(propertyChangeEvent.getPropertyName())) {
                            JavaEditor.access$1900(JavaEditorChangeListener.access$1700(this.this$1), propertyChangeEvent);
                        }
                        if ("showOverriding".equals(propertyChangeEvent.getPropertyName())) {
                            JavaEditor.access$2000(JavaEditorChangeListener.access$1700(this.this$1), propertyChangeEvent);
                        }
                    }
                };
            }
            ClassPath classPath = JavaEditor.this.getSourcePath();
            ClassPath classPath2 = JavaEditor.this.getLibrariesPath();
            ClassPath classPath3 = JavaEditor.this.getBootClassPath();
            if (classPath != null) {
                classPath.removePropertyChangeListener(this.classpathListener);
            }
            if (classPath2 != null) {
                classPath2.removePropertyChangeListener(this.classpathListener);
            }
            if (classPath3 != null) {
                classPath3.removePropertyChangeListener(this.classpathListener);
            }
            javaSettings.removePropertyChangeListener(this.settingListener);
            if (JavaEditor.this.isDocumentLoaded()) {
                if (classPath != null) {
                    classPath.addPropertyChangeListener(this.classpathListener);
                }
                if (classPath2 != null) {
                    classPath2.addPropertyChangeListener(this.classpathListener);
                }
                if (classPath3 != null) {
                    classPath3.addPropertyChangeListener(this.classpathListener);
                }
                javaSettings.addPropertyChangeListener(this.settingListener);
            }
        }

        static /* synthetic */ JavaEditor access$1700(JavaEditorChangeListener javaEditorChangeListener) {
            return javaEditorChangeListener.JavaEditor.this;
        }
    }

    public final class InteriorSection
    extends GuardedSection {
        PositionBounds header;
        PositionBounds body;
        PositionBounds bottom;

        InteriorSection(String string, PositionBounds positionBounds, PositionBounds positionBounds2, PositionBounds positionBounds3) {
            super(string);
            this.header = positionBounds;
            this.body = positionBounds2;
            this.bottom = positionBounds3;
        }

        public boolean setBody(String string) {
            return this.setText(this.body, string, false);
        }

        public boolean setHeader(String string) {
            return this.setText(this.header, string, true);
        }

        public String getHeader() {
            if (!this.isValid()) {
                return null;
            }
            try {
                return this.header.getText();
            }
            catch (IOException iOException) {
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return null;
        }

        public boolean setBottom(String string) {
            int n;
            boolean bl = string.endsWith("\n");
            int n2 = string.indexOf(10);
            if (n2 != (n = string.lastIndexOf(10)) || bl && n2 != -1) {
                if (bl) {
                    string = string.substring(0, string.length() - 1);
                }
                string = string.replace('\n', ' ');
            }
            return this.setText(this.bottom, string, true);
        }

        public String getBottom() throws IOException, BadLocationException {
            if (!this.isValid()) {
                return null;
            }
            try {
                return this.bottom.getText();
            }
            catch (IOException iOException) {
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return null;
        }

        public PositionRef getBegin() {
            return this.body.getBegin();
        }

        void deleteText() throws BadLocationException, IOException {
            this.header.setText("");
            this.body.setText("");
            this.bottom.setText("");
            this.deleteNewLineBeforeBlock(this.header.getBegin().getOffset());
        }

        void markGuarded(StyledDocument styledDocument) {
            this.markGuarded(styledDocument, this.header, true);
            this.markGuarded(styledDocument, this.bottom, true);
        }

        void unmarkGuarded(StyledDocument styledDocument) {
            this.markGuarded(styledDocument, this.header, false);
            this.markGuarded(styledDocument, this.bottom, false);
            JavaEditor.this.notifyModified();
        }

        public String getText() {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                stringBuffer.append(this.header.getText());
                stringBuffer.append(this.body.getText());
                stringBuffer.append(this.bottom.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return stringBuffer.toString();
        }

        public boolean contains(PositionRef positionRef, boolean bl) {
            if (!bl) {
                return this.header.getBegin().getOffset() <= positionRef.getOffset() && this.bottom.getEnd().getOffset() >= positionRef.getOffset();
            }
            if (this.header.getBegin().getOffset() <= positionRef.getOffset() && this.header.getEnd().getOffset() >= positionRef.getOffset()) {
                return true;
            }
            return this.bottom.getBegin().getOffset() <= positionRef.getOffset() && this.bottom.getEnd().getOffset() >= positionRef.getOffset();
        }

        public PositionRef getPositionBefore() {
            return JavaEditor.this.createPositionRef(this.header.getBegin().getOffset(), Position.Bias.Forward);
        }

        public PositionRef getPositionAfter() {
            return JavaEditor.this.createPositionRef(this.bottom.getEnd().getOffset(), Position.Bias.Backward);
        }
    }

    public final class SimpleSection
    extends GuardedSection {
        PositionBounds bounds;

        SimpleSection(String string, PositionBounds positionBounds) {
            super(string);
            this.bounds = positionBounds;
        }

        public boolean setText(String string) {
            return this.setText(this.bounds, string, true);
        }

        void deleteText() throws BadLocationException, IOException {
            this.bounds.setText("");
            this.deleteNewLineBeforeBlock(this.bounds.getBegin().getOffset());
        }

        void markGuarded(StyledDocument styledDocument) {
            this.markGuarded(styledDocument, this.bounds, true);
        }

        void unmarkGuarded(StyledDocument styledDocument) {
            this.markGuarded(styledDocument, this.bounds, false);
            JavaEditor.this.notifyModified();
        }

        public PositionRef getBegin() {
            return this.bounds.getBegin();
        }

        public String getText() {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                stringBuffer.append(this.bounds.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return stringBuffer.toString();
        }

        public PositionRef getPositionAfter() {
            return JavaEditor.this.createPositionRef(this.bounds.getEnd().getOffset(), Position.Bias.Backward);
        }

        public boolean contains(PositionRef positionRef, boolean bl) {
            return this.bounds.getBegin().getOffset() <= positionRef.getOffset() && this.bounds.getEnd().getOffset() >= positionRef.getOffset();
        }

        public PositionRef getPositionBefore() {
            return JavaEditor.this.createPositionRef(this.bounds.getBegin().getOffset(), Position.Bias.Forward);
        }
    }

    public abstract class GuardedSection {
        String name;
        boolean valid;

        public String getName() {
            return this.name;
        }

        GuardedSection(String string) {
            this.name = string;
            this.valid = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setName(String string) throws PropertyVetoException {
            if (!this.name.equals(string)) {
                JavaEditor javaEditor = JavaEditor.this;
                synchronized (javaEditor) {
                    if (this.valid) {
                        if (JavaEditor.this.sections.get(string) != null) {
                            throw new PropertyVetoException("", new PropertyChangeEvent(this, "name", this.name, string));
                        }
                        JavaEditor.this.sections.remove(this.name);
                        this.name = string;
                        JavaEditor.this.sections.put(string, this);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean deleteSection() {
            JavaEditor javaEditor = JavaEditor.this;
            synchronized (javaEditor) {
                if (this.valid) {
                    try {
                        JavaEditor.this.sections.remove(this.name);
                        this.unmarkGuarded(JavaEditor.this.getDocument());
                        this.deleteText();
                        this.valid = false;
                        return true;
                    }
                    catch (BadLocationException badLocationException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return false;
            }
        }

        public boolean isValid() {
            return this.valid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeSection() {
            JavaEditor javaEditor = JavaEditor.this;
            synchronized (javaEditor) {
                if (!this.valid) {
                    return false;
                }
                JavaEditor.this.sections.remove(this.name);
                this.unmarkGuarded(JavaEditor.this.getDocument());
                this.valid = false;
                return true;
            }
        }

        void deleteNewLineBeforeBlock(int n) {
            if (n > 1) {
                try {
                    PositionBounds positionBounds = JavaEditor.this.createBounds(n - 1, n, true);
                    String string = positionBounds.getText();
                    if (string.equals("\n")) {
                        positionBounds.setText("");
                    }
                }
                catch (IOException iOException) {
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        public void openAt() {
            JavaEditor.this.openAt(this.getBegin());
        }

        protected boolean setText(PositionBounds positionBounds, String string, boolean bl) {
            if (!this.valid) {
                return false;
            }
            if (bl) {
                if (string.length() == 0) {
                    string = " \n";
                } else if (string.length() == 1) {
                    String string2 = string = string.equals("\n") ? " \n" : string + "\n";
                }
            }
            if (!string.endsWith("\n")) {
                string = string + "\n";
            }
            try {
                positionBounds.setText(string);
                return true;
            }
            catch (BadLocationException badLocationException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }

        void markGuarded(StyledDocument styledDocument, PositionBounds positionBounds, boolean bl) {
            int n = positionBounds.getBegin().getOffset();
            int n2 = positionBounds.getEnd().getOffset();
            if (bl) {
                NbDocument.markGuarded((StyledDocument)styledDocument, (int)n, (int)(n2 - n));
            } else {
                NbDocument.unmarkGuarded((StyledDocument)styledDocument, (int)n, (int)(n2 - n));
            }
        }

        abstract void markGuarded(StyledDocument var1);

        abstract void unmarkGuarded(StyledDocument var1);

        abstract void deleteText() throws BadLocationException, IOException;

        public abstract PositionRef getBegin();

        public abstract String getText();

        public abstract boolean contains(PositionRef var1, boolean var2);

        public abstract PositionRef getPositionAfter();

        public abstract PositionRef getPositionBefore();
    }

    public static class JavaEditorComponent
    extends CloneableEditor {
        static final int SELECTED_NODES_DELAY = 1000;
        Timer timerSelNodes;
        JavaEditor support;
        CaretListener caretListener;
        Component toolBar;
        int lastCaretOffset = -1;
        static final long serialVersionUID = 6223349196427270209L;
        private transient RequestProcessor.Task selectionTask = null;
        private final RequestPoster elementSelectionPoster = new RequestPoster();

        public JavaEditorComponent() {
        }

        public JavaEditorComponent(CloneableEditorSupport cloneableEditorSupport) {
            super(cloneableEditorSupport);
            this.initialize();
        }

        void selectElementsAtOffset(int n) {
            this.elementSelectionPoster.post(new Runnable(this, n){
                private final /* synthetic */ int val$offset;
                private final /* synthetic */ JavaEditorComponent this$0;
                {
                    this.this$0 = javaEditorComponent;
                    this.val$offset = n;
                }

                public void run() {
                    ((JMManager)JMManager.getManager()).waitScanFinished();
                    DataObject dataObject = this.this$0.support.getDataObject();
                    if (!this.this$0.isActiveTC() || dataObject == null || !dataObject.isValid() || dataObject.isTemplate()) {
                        return;
                    }
                    Node node = (Node)Children.MUTEX.readAccess(new Mutex.Action(this, dataObject){
                        private final /* synthetic */ DataObject val$d;
                        private final /* synthetic */ 11 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$d = dataObject;
                        }

                        public Object run() {
                            return JavaEditorComponent.access$900(11.access$800(this.this$1), 11.access$700(this.this$1), this.val$d);
                        }
                    });
                    SwingUtilities.invokeLater(new Runnable(this, node){
                        private final /* synthetic */ Node val$n;
                        private final /* synthetic */ 11 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$n = node;
                        }

                        public void run() {
                            Node[] nodeArray;
                            JavaEditorComponent javaEditorComponent = 11.access$800(this.this$1);
                            if (this.val$n != null) {
                                Node[] nodeArray2 = new Node[1];
                                nodeArray = nodeArray2;
                                nodeArray2[0] = this.val$n;
                            } else {
                                nodeArray = new Node[]{};
                            }
                            javaEditorComponent.setActivatedNodes(nodeArray);
                        }
                    });
                }

                static /* synthetic */ int access$700(11 var0) {
                    return var0.val$offset;
                }

                static /* synthetic */ JavaEditorComponent access$800(11 var0) {
                    return var0.this$0;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Node createNode(int n, DataObject dataObject) {
            SourceNodeFactory sourceNodeFactory = SourceNodes.getExplorerFactory();
            Node object = null;
            org.netbeans.jmi.javamodel.Element element2 = null;
            Node[] nodeArray = this.getActivatedNodes();
            if (nodeArray != null && nodeArray.length == 1) {
                element2 = (org.netbeans.jmi.javamodel.Element)nodeArray[0].getLookup().lookup(class$org$netbeans$jmi$javamodel$Element == null ? (class$org$netbeans$jmi$javamodel$Element = JavaEditor.class$("org.netbeans.jmi.javamodel.Element")) : class$org$netbeans$jmi$javamodel$Element);
            }
            try {
                JMManager.getTransactionMutex().addPriorityThread();
                JavaMetamodel.getDefaultRepository().beginTrans(false);
                try {
                    org.netbeans.jmi.javamodel.Element element;
                    FileObject fileObject = dataObject.getPrimaryFile();
                    JavaModel.setClassPath((FileObject)fileObject);
                    Resource resource = JavaMetamodel.getManager().getResource(fileObject);
                    org.netbeans.jmi.javamodel.Element element3 = element = resource == null ? null : JavaEditorComponent.findElement(resource, n);
                    if (element != null && element2 != null && element.isValid() && element2.isValid() && element.equals(element2)) {
                        Node node = nodeArray[0];
                        return node;
                    }
                    if (element instanceof Field) {
                        object = sourceNodeFactory.createFieldNode((Field)element);
                        return object;
                    }
                    if (element instanceof Attribute) {
                        object = sourceNodeFactory.createAnnotationTypeMethodNode((Attribute)element);
                        return object;
                    }
                    if (element instanceof AnnotationType) {
                        object = sourceNodeFactory.createAnnotationTypeNode((AnnotationType)element);
                        return object;
                    }
                    if (element instanceof Constructor) {
                        object = sourceNodeFactory.createConstructorNode((Constructor)element);
                        return object;
                    }
                    if (element instanceof EnumConstant) {
                        object = sourceNodeFactory.createEnumConstantNode((EnumConstant)element);
                        return object;
                    }
                    if (element instanceof Initializer) {
                        object = sourceNodeFactory.createInitializerNode((Initializer)element);
                        return object;
                    }
                    if (element instanceof Method) {
                        object = sourceNodeFactory.createMethodNode((Method)element);
                        return object;
                    }
                    if (element instanceof JavaEnum) {
                        object = sourceNodeFactory.createEnumNode((JavaEnum)element);
                        return object;
                    }
                    if (element instanceof JavaClass) {
                        object = sourceNodeFactory.createClassNode((JavaClass)element);
                        return object;
                    }
                    if (element instanceof Resource) {
                        object = dataObject.getNodeDelegate();
                        return object;
                    }
                    object = null;
                    return object;
                }
                finally {
                    JavaMetamodel.getDefaultRepository().endTrans();
                }
            }
            catch (JmiException jmiException) {
                ErrorManager.getDefault().notify(16, (Throwable)jmiException);
            }
            return object;
        }

        private static org.netbeans.jmi.javamodel.Element findElement(Resource resource, int n) {
            Iterator iterator = resource.getClassifiers().iterator();
            Resource resource2 = resource;
            while (iterator.hasNext()) {
                JavaClass javaClass = (JavaClass)iterator.next();
                PositionBounds positionBounds = JavaMetamodel.getManager().getElementPosition((org.netbeans.jmi.javamodel.Element)javaClass);
                if (positionBounds == null || n < positionBounds.getBegin().getOffset() || n > positionBounds.getEnd().getOffset()) continue;
                resource2 = JavaEditorComponent.findElement(javaClass, n);
                break;
            }
            return resource2;
        }

        private static org.netbeans.jmi.javamodel.Element findElement(JavaClass javaClass, int n) {
            Iterator iterator = javaClass.getFeatures().iterator();
            JavaClass javaClass2 = javaClass;
            while (iterator.hasNext()) {
                ClassMember classMember = (ClassMember)iterator.next();
                PositionBounds positionBounds = JavaMetamodel.getManager().getElementPosition((org.netbeans.jmi.javamodel.Element)classMember);
                if (n < positionBounds.getBegin().getOffset() || n > positionBounds.getEnd().getOffset()) continue;
                if (classMember instanceof JavaClass) {
                    javaClass2 = JavaEditorComponent.findElement((JavaClass)classMember, n);
                    break;
                }
                javaClass2 = classMember;
                break;
            }
            return javaClass2;
        }

        protected boolean isActiveTC() {
            return JavaEditorComponent.getRegistry().getActivated() == this;
        }

        protected void notifyParsingDone() {
        }

        public SystemAction[] getSystemActions() {
            this.selectElementsAtOffset(this.lastCaretOffset);
            this.timerSelNodes.stop();
            return super.getSystemActions();
        }

        private void initialize() {
            this.support = (JavaEditor)this.cloneableEditorSupport();
            if (this.support == null) {
                return;
            }
            this.timerSelNodes = new Timer(200, new ActionListener(this){
                private final /* synthetic */ JavaEditorComponent this$0;
                {
                    this.this$0 = javaEditorComponent;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Caret caret;
                    Timer timer = this.this$0.support.timer;
                    if (timer != null && timer.isRunning()) {
                        this.this$0.timerSelNodes.restart();
                        return;
                    }
                    if (!this.this$0.isActiveTC()) {
                        return;
                    }
                    if (this.this$0.lastCaretOffset == -1 && this.this$0.getEditorPane() != null && (caret = this.this$0.getEditorPane().getCaret()) != null) {
                        this.this$0.lastCaretOffset = caret.getDot();
                    }
                    this.this$0.selectElementsAtOffset(this.this$0.lastCaretOffset);
                }
            });
            this.timerSelNodes.setInitialDelay(200);
            this.timerSelNodes.setRepeats(false);
            this.caretListener = new CaretListener(this){
                private final /* synthetic */ JavaEditorComponent this$0;
                {
                    this.this$0 = javaEditorComponent;
                }

                public void caretUpdate(CaretEvent caretEvent) {
                    this.this$0.support.restartTimer(true);
                    this.this$0.restartTimerSelNodes(caretEvent.getDot());
                }
            };
            this.timerSelNodes.restart();
        }

        void restartTimerSelNodes(int n) {
            this.timerSelNodes.setInitialDelay(1000);
            this.timerSelNodes.restart();
            this.lastCaretOffset = n;
        }

        protected void componentActivated() {
            JEditorPane jEditorPane = this.getEditorPane();
            if (jEditorPane != null) {
                jEditorPane.addCaretListener(this.caretListener);
            }
            super.componentActivated();
            if (jEditorPane != null) {
                jEditorPane.requestFocusInWindow();
            }
            if (this.support.timer == null || !this.support.timer.isRunning()) {
                this.support.restartTimer(false, true);
            }
            if (!this.support.hasAnnotations) {
                ERROR_ANNOTATION_QUEUE.post(new Runnable(this){
                    private final /* synthetic */ JavaEditorComponent this$0;
                    {
                        this.this$0 = javaEditorComponent;
                    }

                    public void run() {
                        if (JavaEditor.access$1200(this.this$0.support) != null) {
                            JavaEditor.access$1200(this.this$0.support).processOverriddenAnnotation();
                        }
                    }
                }, 1000, 1);
            }
            this.support.attachParsingListener();
        }

        public void requestFocus() {
            super.requestFocus();
            JEditorPane jEditorPane = this.getEditorPane();
            if (jEditorPane != null) {
                jEditorPane.requestFocus();
            }
        }

        public boolean requestFocusInWindow() {
            super.requestFocusInWindow();
            JEditorPane jEditorPane = this.getEditorPane();
            if (jEditorPane != null) {
                return jEditorPane.requestFocusInWindow();
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void componentDeactivated() {
            JEditorPane jEditorPane = this.getEditorPane();
            if (jEditorPane != null) {
                jEditorPane.removeCaretListener(this.caretListener);
            }
            this.support.removeParsingListener();
            JavaEditorComponent javaEditorComponent = this;
            synchronized (javaEditorComponent) {
                if (this.selectionTask != null) {
                    this.selectionTask.cancel();
                    this.selectionTask = null;
                }
            }
            this.support.stopTimerIfPossible();
            super.componentDeactivated();
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            super.readExternal(objectInput);
            this.initialize();
        }

        static /* synthetic */ Node access$900(JavaEditorComponent javaEditorComponent, int n, DataObject dataObject) {
            return javaEditorComponent.createNode(n, dataObject);
        }
    }

    private static class JavaEditorEnv
    extends DataEditorSupport.Env {
        static final long serialVersionUID = -6792511207355520950L;

        public JavaEditorEnv(DataObject dataObject) {
            super(dataObject);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((JavaDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (CloneableOpenSupport)this.getDataObject().getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = JavaEditor.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
        }
    }

    private class Save
    implements SaveCookie {
        private Save() {
        }

        public void save() throws IOException {
            JavaEditor.this.saveDocument();
            JavaEditor.this.getDataObject().setModified(false);
        }
    }
}

