/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jmi.reflect.InvalidObjectException;
import javax.jmi.reflect.JmiException;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.api.mdr.events.ExtentEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.MDRChangeSource;
import org.netbeans.api.queries.FileBuiltQuery;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.RenameHandler;
import org.netbeans.modules.java.Util;
import org.netbeans.modules.java.settings.JavaSettings;
import org.netbeans.modules.java.tools.BadgeCache;
import org.netbeans.modules.java.ui.nodes.SourceNodes;
import org.netbeans.modules.java.ui.nodes.elements.SourceChildren;
import org.netbeans.modules.java.ui.nodes.elements.SourceEditSupport;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.ParsingListener;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.datatransfer.NewType;

public class JavaNode
extends DataNode {
    private static final boolean DONT_RESOLVE_JAVA_BADGES = Boolean.getBoolean("perf.dont.resolve.java.badges");
    private static final String SHEETNAME_TEXT_PROPERTIES = "textProperties";
    private static final String PROP_ENCODING = "encoding";
    private static final long serialVersionUID = -7396485743899766258L;
    private static final String ICON_BASE = "org/netbeans/modules/java/resources/";
    private static final String BADGE_MAIN = "org/netbeans/modules/java/resources/executable-badge";
    private static final String BADGE_ERROR = "org/netbeans/modules/java/resources/error-badge";
    private static final String BADGE_NEEDS_COMPILE = "org/netbeans/modules/java/resources/needs-compile";
    private static final String[] ICON_ATTRS_NONE = new String[0];
    protected static final String ICON_ATTR_NEEDS_COMPILE = "needsCompile";
    protected static final String ICON_ATTR_MAIN = "mainClass";
    protected static final String ICON_ATTR_ERROR = "error";
    private static final int ICON_REFRESH_DELAY_MSECS = 1000;
    private BadgeCache iconCache;
    private HashSet currentBadges;
    private StatePropagator statePropagator;

    public JavaNode(JavaDataObject javaDataObject) {
        this(javaDataObject, (Children)(javaDataObject.isTemplate() ? Children.LEAF : new JavaSourceChildren(javaDataObject)));
        this.currentBadges = new HashSet();
    }

    protected void initializeBadges(BadgeCache badgeCache) {
        badgeCache.registerBadge(ICON_ATTR_MAIN, BADGE_MAIN, 9, 8);
        badgeCache.registerBadge(ICON_ATTR_ERROR, BADGE_ERROR, 8, 8);
        badgeCache.registerBadge(ICON_ATTR_NEEDS_COMPILE, BADGE_NEEDS_COMPILE, 16, 0);
    }

    public JavaNode(JavaDataObject javaDataObject, Children children) {
        super((DataObject)javaDataObject, children);
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIconBase(String string) {
        super.setIconBase(string);
        JavaNode javaNode = this;
        synchronized (javaNode) {
            this.iconCache = BadgeCache.getCache(string);
            this.initializeBadges(this.iconCache);
        }
    }

    private void initialize() {
        this.setIconBase(this.getBareIconBase());
        StateUpdater.registerNode(this);
    }

    protected void requestResolveIcons() {
        StateUpdater.registerNode(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initialize();
    }

    static final void wrapThrowable(Throwable throwable, Throwable throwable2, String string) {
        ErrorManager.getDefault().annotate(throwable, 256, null, string, throwable2, null);
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        if (JavaNode.getRenameHandler() != null) {
            sheet.get("properties").put(this.createNameProperty());
        }
        Sheet.Set set = new Sheet.Set();
        set.setName(SHEETNAME_TEXT_PROPERTIES);
        set.setDisplayName(Util.getString("PROP_textfileSetName"));
        set.setShortDescription(Util.getString("HINT_textfileSetName"));
        set.put((Node.Property)new PropertySupport.ReadWrite(PROP_ENCODING, String.class, Util.getString("PROP_fileEncoding"), Util.getString("HINT_fileEncoding")){

            public Object getValue() {
                String string = Util.getFileEncoding0(JavaNode.this.getDataObject().getPrimaryFile());
                if (string == null) {
                    return "";
                }
                return string;
            }

            public void setValue(Object object) throws InvocationTargetException {
                String string = (String)object;
                if (string != null) {
                    if (!"".equals(string)) {
                        try {
                            Charset.forName(string);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            InvocationTargetException invocationTargetException = new InvocationTargetException(illegalArgumentException);
                            JavaNode.wrapThrowable(invocationTargetException, illegalArgumentException, MessageFormat.format(Util.getString("FMT_UnsupportedEncoding"), string));
                            throw invocationTargetException;
                        }
                    } else {
                        string = null;
                    }
                }
                try {
                    Util.setFileEncoding(JavaNode.this.getDataObject().getPrimaryFile(), string);
                    ((JavaDataObject)JavaNode.this.getDataObject()).firePropertyChange0(JavaNode.PROP_ENCODING, null, null);
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }
        });
        sheet.put(set);
        set = new Sheet.Set();
        set.setName("classpaths");
        set.setDisplayName(NbBundle.getMessage((Class)JavaNode.class, (String)"LBL_JavaNode_sheet_classpaths"));
        set.setShortDescription(NbBundle.getMessage((Class)JavaNode.class, (String)"HINT_JavaNode_sheet_classpaths"));
        set.put(new Node.Property[]{new ClasspathProperty("classpath/compile", NbBundle.getMessage((Class)JavaNode.class, (String)"PROP_JavaNode_compile_classpath"), NbBundle.getMessage((Class)JavaNode.class, (String)"HINT_JavaNode_compile_classpath")), new ClasspathProperty("classpath/execute", NbBundle.getMessage((Class)JavaNode.class, (String)"PROP_JavaNode_execute_classpath"), NbBundle.getMessage((Class)JavaNode.class, (String)"HINT_JavaNode_execute_classpath")), new ClasspathProperty("classpath/boot", NbBundle.getMessage((Class)JavaNode.class, (String)"PROP_JavaNode_boot_classpath"), NbBundle.getMessage((Class)JavaNode.class, (String)"HINT_JavaNode_boot_classpath"))});
        sheet.put(set);
        return sheet;
    }

    private Node.Property createNameProperty() {
        PropertySupport.ReadWrite readWrite = new PropertySupport.ReadWrite("name", String.class, NbBundle.getMessage((Class)DataObject.class, (String)"PROP_name"), NbBundle.getMessage((Class)DataObject.class, (String)"HINT_name")){

            public Object getValue() {
                return JavaNode.this.getName();
            }

            public Object getValue(String string) {
                if ("suppressCustomEditor".equals(string)) {
                    return Boolean.TRUE;
                }
                return super.getValue(string);
            }

            public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                if (!this.canWrite()) {
                    throw new IllegalAccessException();
                }
                if (!(object instanceof String)) {
                    throw new IllegalArgumentException();
                }
                JavaNode.this.setName((String)object);
            }

            public boolean canWrite() {
                return JavaNode.this.canRename();
            }
        };
        return readWrite;
    }

    protected JavaDataObject getJavaDataObject() {
        return (JavaDataObject)this.getDataObject();
    }

    public Image getIcon(int n) {
        return this.iconCache.getIcon(super.getIcon(n), this.getBadges());
    }

    public Image getOpenedIcon(int n) {
        return this.iconCache.getIcon(super.getOpenedIcon(n), this.getBadges());
    }

    public void setName(String string) {
        RenameHandler renameHandler = JavaNode.getRenameHandler();
        if (renameHandler == null) {
            super.setName(string);
        } else {
            try {
                renameHandler.handleRename((Node)this, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                super.setName(string);
            }
        }
    }

    private static synchronized RenameHandler getRenameHandler() {
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(RenameHandler.class));
        List list = (List)result.allInstances();
        if (list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            ErrorManager.getDefault().log(16, "Multiple instances of RenameHandler found in Lookup; only using first one: " + list);
        }
        return (RenameHandler)list.get(0);
    }

    protected String getIconBase() {
        return ICON_BASE;
    }

    protected String getBareIconBase() {
        return this.getIconBase() + this.getIcons()[0];
    }

    protected String[] getIcons() {
        return new String[]{"class"};
    }

    protected String[] getBadges() {
        if (this.currentBadges.isEmpty()) {
            return null;
        }
        return this.currentBadges.toArray(new String[this.currentBadges.size()]);
    }

    protected void setBadges(String[] stringArray) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        if (this.currentBadges.size() == stringArray.length) {
            boolean bl = true;
            for (int i = 0; i < stringArray.length; ++i) {
                if (this.currentBadges.contains(stringArray[i])) continue;
                bl = false;
                break;
            }
            if (bl) {
                return;
            }
        }
        this.currentBadges = new HashSet<String>(Arrays.asList(stringArray));
        this.fireIconChange();
        this.fireOpenedIconChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveIcons() {
        String string;
        Object object;
        boolean bl;
        if (DONT_RESOLVE_JAVA_BADGES) {
            return;
        }
        if (this.statePropagator == null) {
            this.statePropagator = StatePropagator.getDefault(this);
        }
        JavaDataObject javaDataObject = this.getJavaDataObject();
        FileObject fileObject = javaDataObject.getPrimaryFile();
        try {
            bl = fileObject.getFileSystem().isDefault() && javaDataObject.isTemplate();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            bl = false;
        }
        if (bl) {
            return;
        }
        if (fileObject.isVirtual()) {
            return;
        }
        final ArrayList<String> arrayList = new ArrayList<String>(3);
        String string2 = "";
        boolean bl2 = false;
        JavaModel.getJavaRepository().beginTrans(false);
        try {
            JavaModel.setClassPath((FileObject)fileObject);
            object = JavaModel.getResource((FileObject)fileObject);
            boolean bl3 = bl2 = object != null && object.isValid();
            if (bl2) {
                string2 = object.getPackageName();
            }
        }
        finally {
            JavaModel.getJavaRepository().endTrans();
        }
        if (bl2) {
            object = fileObject.getParent();
            ClassPath classPath = ClassPath.getClassPath((FileObject)object, (String)"classpath/source");
            String string3 = classPath == null ? null : classPath.getResourceName((FileObject)object, '.', false);
            string = string3 == null || !string3.equals(string2) ? new MessageFormat(Util.getString("FMT_Bad_Package")).format(new Object[]{string2}) : null;
            if (this.hasMain()) {
                arrayList.add(ICON_ATTR_MAIN);
            }
        } else {
            if (this.currentBadges.contains(ICON_ATTR_MAIN)) {
                arrayList.add(ICON_ATTR_MAIN);
            }
            string = this.getShortDescription();
        }
        if (!bl && (object = this.resolveCompileBadge()) != null) {
            arrayList.add((String)object);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JavaNode.this.setShortDescription(string);
                if (arrayList.isEmpty()) {
                    JavaNode.this.setBadges(ICON_ATTRS_NONE);
                } else {
                    JavaNode.this.setBadges(arrayList.toArray(new String[arrayList.size()]));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasMain() {
        FileObject fileObject = this.getJavaDataObject().getPrimaryFile();
        if (!fileObject.isValid()) {
            return false;
        }
        JavaModel.getJavaRepository().beginTrans(false);
        try {
            JavaModel.setClassPath((FileObject)fileObject);
            Resource resource = JavaModel.getResource((FileObject)fileObject);
            boolean bl = resource != null && !resource.getMain().isEmpty();
            return bl;
        }
        finally {
            JavaModel.getJavaRepository().endTrans();
        }
    }

    protected String resolveCompileBadge() {
        if (!JavaSettings.getDefault().isCompileStatusEnabled()) {
            return null;
        }
        FileBuiltQuery.Status status = FileBuiltQuery.getStatus((FileObject)this.getDataObject().getPrimaryFile());
        return status != null && !status.isBuilt() ? ICON_ATTR_NEEDS_COMPILE : null;
    }

    public NewType[] getNewTypes() {
        if (this.getJavaDataObject().isJavaFileReadOnly()) {
            return super.getNewTypes();
        }
        return SourceEditSupport.createJavaNodeNewTypes(this);
    }

    private static final class WeakParsingListener
    extends WeakReference
    implements Runnable,
    ParsingListener {
        public WeakParsingListener(ParsingListener parsingListener) {
            super(parsingListener, Utilities.activeReferenceQueue());
        }

        public void run() {
            JavaMetamodel.removeParsingListener((ParsingListener)this);
        }

        public void resourceParsed(Resource resource) {
            ParsingListener parsingListener = (ParsingListener)this.get();
            if (parsingListener != null) {
                parsingListener.resourceParsed(resource);
            }
        }
    }

    private static final class StatePropagator
    extends WeakReference
    implements PropertyChangeListener,
    ChangeListener,
    ParsingListener,
    Runnable {
        private FileBuiltQuery.Status upToDate;
        private final DataObject dobj;
        private final PropertyChangeListener weakPropLsnr;
        private final ParsingListener weakParsingLsnr;

        private StatePropagator(JavaNode javaNode) {
            super(javaNode, Utilities.activeReferenceQueue());
            this.dobj = javaNode.getDataObject();
            this.dobj.addPropertyChangeListener((PropertyChangeListener)this);
            this.registerBuildStatusListener();
            this.weakPropLsnr = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)((Object)JavaSettings.getDefault()));
            JavaSettings.getDefault().addPropertyChangeListener(this.weakPropLsnr);
            this.weakParsingLsnr = new WeakParsingListener(this);
            JavaMetamodel.addParsingListener((ParsingListener)this.weakParsingLsnr);
        }

        public static StatePropagator getDefault(JavaNode javaNode) {
            return new StatePropagator(javaNode);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            JavaNode javaNode = this.getJavaNode();
            if (("showCompileStatus".equals(string) || string == null) && object == JavaSettings.getDefault()) {
                this.registerBuildStatusListener();
                StateUpdater.registerNode(javaNode);
            } else if (("primaryFile".equals(string) || string == null) && object == javaNode.getDataObject()) {
                this.registerBuildStatusListener();
                StateUpdater.registerNode(javaNode);
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JavaNode javaNode = this.getJavaNode();
            if (javaNode != null && JavaSettings.getDefault().isCompileStatusEnabled()) {
                StateUpdater.registerNode(javaNode);
            }
        }

        public void resourceParsed(Resource resource) {
            JavaNode javaNode = this.getJavaNode();
            if (javaNode != null) {
                FileObject fileObject = javaNode.getDataObject().getPrimaryFile();
                try {
                    if (fileObject.getPath().endsWith(resource.getName()) && fileObject.equals(JavaModel.getFileObject((Resource)resource))) {
                        StateUpdater.registerNode(javaNode);
                    }
                }
                catch (InvalidObjectException invalidObjectException) {
                    // empty catch block
                }
            }
        }

        public void run() {
            JavaSettings.getDefault().removePropertyChangeListener(this.weakPropLsnr);
            this.dobj.removePropertyChangeListener((PropertyChangeListener)this);
            if (this.upToDate != null) {
                this.upToDate.removeChangeListener((ChangeListener)this);
            }
        }

        private JavaNode getJavaNode() {
            return (JavaNode)((Object)this.get());
        }

        private void registerBuildStatusListener() {
            JavaNode javaNode = this.getJavaNode();
            if (javaNode != null) {
                FileBuiltQuery.Status status = this.upToDate;
                if (status != null) {
                    status.removeChangeListener((ChangeListener)this);
                }
                if (JavaSettings.getDefault().isCompileStatusEnabled()) {
                    status = FileBuiltQuery.getStatus((FileObject)javaNode.getDataObject().getPrimaryFile());
                    if (status != null) {
                        status.addChangeListener((ChangeListener)this);
                    }
                } else {
                    status = null;
                }
                this.upToDate = status;
            }
        }
    }

    private static final class StateUpdater
    implements Runnable {
        private static StateUpdater INSTANCE;
        private Set registeredNodes = new HashSet(37);
        private final RequestProcessor QUEUE = new RequestProcessor("Java Node State Updater");
        private RequestProcessor.Task task;

        private StateUpdater() {
        }

        public static void registerNode(JavaNode javaNode) {
            StateUpdater.init();
            INSTANCE.scheduleNode(javaNode);
        }

        private static void init() {
            if (INSTANCE == null) {
                INSTANCE = new StateUpdater();
            }
        }

        private synchronized void scheduleNode(JavaNode javaNode) {
            if (!this.registeredNodes.contains((Object)javaNode)) {
                this.registeredNodes.add(javaNode);
                if (this.task == null) {
                    this.task = this.QUEUE.post((Runnable)this, 1000);
                } else {
                    this.task.schedule(1000);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ArrayList arrayList;
            StateUpdater stateUpdater = this;
            synchronized (stateUpdater) {
                arrayList = new ArrayList(this.registeredNodes);
                this.registeredNodes.clear();
            }
            this.updateNodes(arrayList);
        }

        private void updateNodes(List list) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                JavaNode javaNode = (JavaNode)((Object)iterator.next());
                if (javaNode == null) continue;
                javaNode.resolveIcons();
            }
        }
    }

    private final class ClasspathProperty
    extends PropertySupport.ReadOnly {
        private final String id;
        static final /* synthetic */ boolean $assertionsDisabled;

        public ClasspathProperty(String string, String string2, String string3) {
            super(string, class$java$lang$String == null ? (class$java$lang$String = JavaNode.class$("java.lang.String")) : class$java$lang$String, string2, string3);
            this.id = string;
            this.setValue("oneline", Boolean.FALSE);
        }

        public Object getValue() {
            ClassPath classPath = ClassPath.getClassPath((FileObject)JavaNode.this.getDataObject().getPrimaryFile(), (String)this.id);
            if (classPath != null) {
                StringBuffer stringBuffer = new StringBuffer();
                Iterator iterator = classPath.entries().iterator();
                while (iterator.hasNext()) {
                    ClassPath.Entry entry = (ClassPath.Entry)iterator.next();
                    URL uRL = entry.getURL();
                    this.append(stringBuffer, uRL);
                }
                return stringBuffer.toString();
            }
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$java$JavaNode == null ? (class$org$netbeans$modules$java$JavaNode = JavaNode.class$("org.netbeans.modules.java.JavaNode")) : class$org$netbeans$modules$java$JavaNode), (String)"LBL_JavaNode_classpath_unknown");
        }

        private void append(StringBuffer stringBuffer, URL uRL) {
            String string = uRL.toExternalForm();
            if (uRL.getProtocol().equals("file")) {
                string = new File(URI.create(string)).getAbsolutePath();
            } else if (uRL.getProtocol().equals("jar") && string.endsWith("!/")) {
                URL uRL2 = FileUtil.getArchiveFile((URL)uRL);
                if (!$assertionsDisabled && uRL2 == null) {
                    throw new AssertionError(uRL);
                }
                if (uRL2.getProtocol().equals("file")) {
                    string = new File(URI.create(uRL2.toExternalForm())).getAbsolutePath();
                }
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            stringBuffer.append(string);
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$java$JavaNode == null ? (class$org$netbeans$modules$java$JavaNode = JavaNode.class$("org.netbeans.modules.java.JavaNode")) : class$org$netbeans$modules$java$JavaNode).desiredAssertionStatus();
        }
    }

    private static final class JavaSourceChildren
    extends SourceChildren {
        JavaDataObject jdo;
        private ExtentListener wExtentL;

        public JavaSourceChildren(JavaDataObject javaDataObject) {
            super(SourceNodes.getExplorerFactory());
            this.jdo = javaDataObject;
        }

        protected void removeNotify() {
            super.removeNotify();
            this.setElement(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Resource createResource() {
            Resource resource = null;
            JavaModel.getJavaRepository().beginTrans(false);
            try {
                resource = JavaModel.getResource((FileObject)this.jdo.getPrimaryFile());
            }
            catch (JmiException jmiException) {
            }
            finally {
                JavaModel.getJavaRepository().endTrans();
            }
            return resource;
        }

        public void setElement(Resource resource) {
            MDRepository mDRepository = JavaModel.getJavaRepository();
            if (this.element == null && resource != null) {
                if (this.wExtentL == null) {
                    this.wExtentL = new ExtentListener(this, (MDRChangeSource)mDRepository);
                }
                mDRepository.addListener((MDRChangeListener)this.wExtentL);
            } else if (resource == null) {
                mDRepository.removeListener((MDRChangeListener)this.wExtentL);
            }
            super.setElement(resource);
        }

        private static final class ExtentListener
        extends WeakReference
        implements MDRChangeListener,
        Runnable {
            private final MDRChangeSource source;

            public ExtentListener(JavaSourceChildren javaSourceChildren, MDRChangeSource mDRChangeSource) {
                super(javaSourceChildren, Utilities.activeReferenceQueue());
                this.source = mDRChangeSource;
            }

            public void change(MDRChangeEvent mDRChangeEvent) {
                JavaSourceChildren javaSourceChildren = (JavaSourceChildren)this.get();
                if (javaSourceChildren == null) {
                    return;
                }
                if (mDRChangeEvent instanceof ExtentEvent && ((ExtentEvent)mDRChangeEvent).getType() == 134283266) {
                    javaSourceChildren.setElement(JavaModel.getResource((FileObject)javaSourceChildren.jdo.getPrimaryFile()));
                }
            }

            public void run() {
                this.source.removeListener((MDRChangeListener)this);
            }
        }
    }
}

