/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import javax.swing.text.StyledDocument;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.modules.java.LineSetAnnotation;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.cookies.SourceCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Annotatable;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

class OverrideAnnotation
extends LineSetAnnotation {
    private static final String OVERRIDE_ANNOTATION_TYPE = "org-netbeans-modules-java-override_annotation";
    private static final String IMPLEMENT_ANNOTATION_TYPE = "org-netbeans-modules-java-implement_annotation";
    private Descriptor descriptor;
    private int attachedToLine = -1;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie$Editor;

    private OverrideAnnotation(Descriptor descriptor) {
        this.descriptor = descriptor;
    }

    public String getAnnotationType() {
        return this.descriptor.isOverriding() ? OVERRIDE_ANNOTATION_TYPE : IMPLEMENT_ANNOTATION_TYPE;
    }

    public String getShortDescription() {
        String string = this.descriptor.isOverriding() ? "TXT_Overrides" : "TXT_Implements";
        return MessageFormat.format(NbBundle.getMessage((Class)OverrideAnnotation.class, (String)string), this.descriptor.getMethodName(), this.descriptor.getOriginalClassQName());
    }

    public void attachToLineSet(Line.Set set) {
        this.attachToLineSet(set, this.descriptor.getLine());
    }

    private void attachToLineSet(Line.Set set, int n) {
        if (n < 0) {
            return;
        }
        Line line = set.getCurrent(n);
        Line.Part part = line.createPart(0, 0);
        this.attach((Annotatable)part);
        this.attachedToLine = n;
    }

    public void updateLine(Line.Set set) {
        int n = this.descriptor.getLine();
        if (n != this.attachedToLine) {
            this.detach();
            this.attachToLineSet(set, n);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof OverrideAnnotation) {
            OverrideAnnotation overrideAnnotation = (OverrideAnnotation)((Object)object);
            return this.descriptor.equals(overrideAnnotation.descriptor);
        }
        return false;
    }

    Descriptor getDescriptor() {
        return this.descriptor;
    }

    public static OverrideAnnotation forDescriptor(Descriptor descriptor) {
        return new OverrideAnnotation(descriptor);
    }

    public static class Descriptor {
        private final String overridenMethod;
        private final String originalMethod;
        private final boolean isImplementing;

        public Descriptor(Method method, Method method2) {
            this.originalMethod = method.refMofId();
            this.overridenMethod = method2.refMofId();
            JavaClass javaClass = (JavaClass)method.getDeclaringClass();
            this.isImplementing = javaClass != null && (javaClass.isInterface() || Modifier.isAbstract(method.getModifiers()));
        }

        public final Method getOriginalMethod() {
            return (Method)JavaMetamodel.getDefaultRepository().getByMofId(this.originalMethod);
        }

        public final Method getOverridenMethod() {
            return (Method)JavaMetamodel.getDefaultRepository().getByMofId(this.overridenMethod);
        }

        public final boolean isOverriding() {
            return !this.isImplementing();
        }

        public final boolean isImplementing() {
            return this.isImplementing;
        }

        public final String getMethodName() {
            try {
                return this.getOverridenMethod().getName();
            }
            catch (NullPointerException nullPointerException) {
                return "";
            }
        }

        public final String getOriginalClassQName() {
            try {
                return this.getOriginalMethod().getDeclaringClass().getName();
            }
            catch (NullPointerException nullPointerException) {
                return "";
            }
        }

        public final boolean equals(Object object) {
            if (object instanceof Descriptor) {
                Descriptor descriptor = (Descriptor)object;
                return (this.originalMethod == null ? descriptor.originalMethod == null : this.originalMethod.equals(descriptor.originalMethod)) && (this.overridenMethod == null ? descriptor.overridenMethod == null : this.overridenMethod.equals(descriptor.overridenMethod));
            }
            return false;
        }

        public final int hashCode() {
            return this.overridenMethod == null ? 0 : this.originalMethod.hashCode();
        }

        final int getLine() {
            Method method = this.getOverridenMethod();
            if (method == null) {
                return -1;
            }
            DataObject dataObject = JavaMetamodel.getManager().getDataObject(method.getResource());
            if (dataObject == null) {
                return -1;
            }
            SourceCookie.Editor editor = (SourceCookie.Editor)dataObject.getCookie(class$org$openide$cookies$SourceCookie$Editor == null ? (class$org$openide$cookies$SourceCookie$Editor = OverrideAnnotation.class$("org.openide.cookies.SourceCookie$Editor")) : class$org$openide$cookies$SourceCookie$Editor);
            if (editor == null) {
                return -1;
            }
            StyledDocument styledDocument = editor.getDocument();
            if (styledDocument == null) {
                return -1;
            }
            int n = JavaMetamodel.getManager().getElementPosition((Element)method).getBegin().getOffset();
            return NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        }
    }
}

