/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.jmi.reflect.InvalidObjectException;
import javax.swing.SwingUtilities;
import org.netbeans.api.mdr.MDRObject;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.TransactionEvent;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.java.JavaEditor;
import org.netbeans.modules.java.OverrideAnnotation;
import org.netbeans.modules.java.settings.JavaSettings;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.TypeClassImpl;
import org.openide.ErrorManager;
import org.openide.cookies.LineCookie;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.RequestProcessor;

final class OverrideAnnotationSupport {
    private final JavaEditor editor;
    private WMDRChangeListener overriddenListener;
    private Request currentRequest;
    private List overrideAnnotations = new ArrayList();
    private boolean isSuspended = false;
    private static final RequestProcessor QUEUE = new RequestProcessor("Overriddens Queue", 1);
    static /* synthetic */ Class class$org$openide$cookies$LineCookie;
    static /* synthetic */ Class class$org$netbeans$modules$java$OverrideAnnotationSupport;

    public OverrideAnnotationSupport(JavaEditor javaEditor) {
        this.editor = javaEditor;
        this.overriddenListener = new WMDRChangeListener(this);
    }

    public void processOverriddenAnnotation() {
        this.processOverriddenAnnotation(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOverriddenAnnotation(boolean bl) {
        if (!this.isEnabled()) {
            return;
        }
        OverrideAnnotationSupport overrideAnnotationSupport = this;
        synchronized (overrideAnnotationSupport) {
            if (this.isSuspended) {
                return;
            }
            if (this.currentRequest != null && !this.currentRequest.cancel()) {
                this.currentRequest.followMe = true;
                return;
            }
            this.currentRequest = new Request();
            QUEUE.post((Runnable)this.currentRequest, 200);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        Object object = this;
        synchronized (object) {
            if (this.isSuspended) {
                return;
            }
            this.isSuspended = true;
            if (this.currentRequest != null && !this.currentRequest.cancel()) {
                this.currentRequest.followMe = false;
            }
        }
        object = new Request(1);
        QUEUE.post((Runnable)object);
    }

    private void dispose() {
        if (this.overriddenListener != null) {
            this.overriddenListener.removeAllElements();
        }
        OverrideAnnotationSupport.detachAnnotations(this.overrideAnnotations);
        this.overrideAnnotations.clear();
    }

    private boolean isEnabled() {
        return JavaSettings.getDefault().getShowOverriding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOverriddenAnnotation(Resource resource, boolean bl) {
        Object object;
        List list;
        if (JMManager.PERF_DEBUG) {
            Thread.dumpStack();
        }
        List list2 = bl ? this.copyAnnotations() : this.overrideAnnotations;
        List list3 = bl ? this.findOverriddenMethods(resource) : this.overrideAnnotations;
        final List list4 = bl ? new ArrayList(list3) : Collections.EMPTY_LIST;
        List list5 = bl ? new ArrayList(list2) : Collections.EMPTY_LIST;
        List list6 = list = bl ? new ArrayList(list2) : this.overrideAnnotations;
        if (this.isSuspended) {
            return;
        }
        if (bl) {
            list4.removeAll(list2);
            list5.removeAll(list3);
            list.retainAll(list3);
            OverrideAnnotationSupport.detachAnnotations(list5);
        }
        if (!(!this.editor.isDocumentLoaded() || list4.isEmpty() && list3.isEmpty())) {
            object = this.editor.getDocument();
            Runnable runnable = new Runnable(){

                public void run() {
                    OverrideAnnotation overrideAnnotation;
                    LineCookie lineCookie = (LineCookie)OverrideAnnotationSupport.this.editor.getDataObject().getCookie(class$org$openide$cookies$LineCookie == null ? (class$org$openide$cookies$LineCookie = OverrideAnnotationSupport.class$("org.openide.cookies.LineCookie")) : class$org$openide$cookies$LineCookie);
                    Line.Set set = lineCookie.getLineSet();
                    Iterator iterator = list4.iterator();
                    while (iterator.hasNext()) {
                        overrideAnnotation = (OverrideAnnotation)((Object)iterator.next());
                        overrideAnnotation.attachToLineSet(set);
                    }
                    iterator = list.iterator();
                    while (iterator.hasNext()) {
                        overrideAnnotation = (OverrideAnnotation)((Object)iterator.next());
                        overrideAnnotation.updateLine(set);
                    }
                }
            };
            if (object != null) {
                JavaMetamodel.getDefaultRepository().beginTrans(false);
                try {
                    object.render(runnable);
                }
                finally {
                    JavaMetamodel.getDefaultRepository().endTrans();
                }
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
        object = list;
        object.addAll(list4);
        this.syncAnnotations((List)object);
    }

    private synchronized List copyAnnotations() {
        return new ArrayList(this.overrideAnnotations);
    }

    private synchronized void syncAnnotations(List list) {
        this.overrideAnnotations = list;
    }

    private void processOverriddenAnnotationImpl(boolean bl) {
        Resource resource = this.editor.getResource();
        if (resource != null) {
            this.processOverriddenAnnotation(resource, bl);
        }
    }

    private List findOverriddenMethods(JavaClass javaClass, Map map) {
        if (map.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        arrayList2.addAll(javaClass.getInterfaces());
        JavaClass javaClass2 = javaClass.getSuperClass();
        HashSet<JavaClass> hashSet = new HashSet<JavaClass>();
        while (javaClass2 != null && hashSet.add(javaClass2)) {
            if (this.isSuspended) {
                return Collections.EMPTY_LIST;
            }
            if (Modifier.isFinal(javaClass2.getModifiers())) break;
            if (this.findOverridenMethods(javaClass2, arrayList2, map, arrayList)) {
                return arrayList;
            }
            javaClass = javaClass2;
            javaClass2 = javaClass.getSuperClass();
        }
        while (!arrayList2.isEmpty()) {
            JavaClass javaClass3 = (JavaClass)arrayList2.remove(0);
            if (!hashSet.add(javaClass3) || !this.findOverridenMethods(javaClass3, arrayList2, map, arrayList)) continue;
            return arrayList;
        }
        return arrayList;
    }

    private boolean findOverridenMethods(JavaClass javaClass, List list, Map map, List list2) {
        this.overriddenListener.addElement(javaClass);
        list.addAll(javaClass.getInterfaces());
        Iterator iterator = javaClass.getContents().iterator();
        while (iterator.hasNext()) {
            Method method;
            int n;
            ClassMember classMember = (ClassMember)iterator.next();
            if (!(classMember instanceof Method) || Modifier.isStatic(n = classMember.getModifiers()) || Modifier.isFinal(n) || !Modifier.isPublic(n) && !Modifier.isProtected(n) || (method = (Method)map.get(classMember)) == null) continue;
            map.remove(method);
            list2.add(new OverrideAnnotation.Descriptor((Method)classMember, method));
            if (!map.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private Map createMethodMap(JavaClass javaClass, Set set) {
        TreeMap<ClassMember, ClassMember> treeMap = new TreeMap<ClassMember, ClassMember>(new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                Method method = (Method)object;
                Method method2 = (Method)object2;
                int n2 = n = method.getName() == null ? -1 : method.getName().compareTo(method2.getName());
                if (n == 0) {
                    List list = method.getParameters();
                    List list2 = method2.getParameters();
                    Iterator iterator = list2.iterator();
                    Iterator iterator2 = list.iterator();
                    while (iterator2.hasNext() && n == 0) {
                        Type type = ((Parameter)iterator2.next()).getType();
                        if (iterator.hasNext()) {
                            Type type2 = ((Parameter)iterator.next()).getType();
                            n = OverrideAnnotationSupport.compareTypes(type, type2);
                            continue;
                        }
                        n = -1;
                    }
                    if (n == 0 && iterator.hasNext()) {
                        n = 1;
                    }
                }
                return n;
            }
        });
        Iterator iterator = javaClass.getContents().iterator();
        while (iterator.hasNext()) {
            ClassMember classMember = (ClassMember)iterator.next();
            if (classMember instanceof Method) {
                int n = classMember.getModifiers();
                if (Modifier.isStatic(n) || Modifier.isPrivate(n)) continue;
                treeMap.put(classMember, classMember);
                continue;
            }
            if (!(classMember instanceof JavaClass)) continue;
            set.add(classMember);
        }
        return treeMap;
    }

    private static int compareTypes(Type type, Type type2) {
        if (type == null || type instanceof UnresolvedClass || type instanceof ParameterizedType && ((ParameterizedType)type).getDefinition() instanceof UnresolvedClass) {
            return -1;
        }
        if (type2 == null || type2 instanceof UnresolvedClass || type2 instanceof ParameterizedType && ((ParameterizedType)type2).getDefinition() instanceof UnresolvedClass) {
            return 1;
        }
        if (type.equals(type2)) {
            return 0;
        }
        type = TypeClassImpl.getRawType((Type)type);
        type2 = TypeClassImpl.getRawType((Type)type2);
        return type.getName() == null ? -1 : type.getName().compareTo(type2.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List findOverriddenMethods(Resource resource) {
        Collection collection;
        JavaMetamodel.getDefaultRepository().beginTrans(false);
        try {
            Object object;
            JMManager jMManager = (JMManager)JavaMetamodel.getManager();
            jMManager.setClassPath(resource);
            jMManager.setSafeTrans(true);
            this.overriddenListener.addElement(resource);
            collection = new HashSet(resource.getClassifiers());
            ArrayList<OverrideAnnotation> arrayList = new ArrayList<OverrideAnnotation>();
            while (!collection.isEmpty()) {
                Object object2;
                object = collection.iterator();
                JavaClass javaClass = (JavaClass)object.next();
                object.remove();
                this.overriddenListener.addElement(javaClass);
                List list = this.findOverriddenMethods(javaClass, this.createMethodMap(javaClass, (Set)collection));
                if (this.isSuspended) {
                    object2 = arrayList;
                    return object2;
                }
                object2 = list.iterator();
                while (object2.hasNext()) {
                    OverrideAnnotation.Descriptor descriptor = (OverrideAnnotation.Descriptor)object2.next();
                    arrayList.add(OverrideAnnotation.forDescriptor(descriptor));
                }
            }
            object = arrayList;
            return object;
        }
        catch (InvalidObjectException invalidObjectException) {
            collection = Collections.EMPTY_LIST;
            return collection;
        }
        finally {
            JavaMetamodel.getDefaultRepository().endTrans();
        }
    }

    private static void detachAnnotations(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Annotation annotation = (Annotation)iterator.next();
            try {
                annotation.detach();
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(16, (Throwable)exception);
            }
        }
    }

    private static class WMDRChangeListener
    implements MDRChangeListener {
        private boolean refresh = false;
        private boolean recompute = false;
        OverrideAnnotationSupport support;
        private Map containers;
        private Resource rsc;

        public WMDRChangeListener(OverrideAnnotationSupport overrideAnnotationSupport) {
            this.support = overrideAnnotationSupport;
        }

        public synchronized void addElement(JavaClass javaClass) {
            ArrayList arrayList;
            if (this.containers == null || this.support.isSuspended) {
                this.containers = new HashMap();
            }
            if ((arrayList = (ArrayList)this.containers.get(javaClass)) == null) {
                arrayList = new ArrayList();
                Iterator iterator = javaClass.getContents().iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof Method)) continue;
                    arrayList.add(e);
                    ((MDRObject)e).addListener((MDRChangeListener)this, 0x101FFFF);
                }
                this.containers.put(javaClass, arrayList);
                ((MDRObject)javaClass).addListener((MDRChangeListener)this, 0x101FFFF);
            }
        }

        public synchronized void addElement(Resource resource) {
            this.rsc = resource;
            ((MDRObject)resource).addListener((MDRChangeListener)this, 0x101FFFF);
            JavaMetamodel.getDefaultRepository().addListener((MDRChangeListener)this, 0x110002);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateMethods(JavaClass javaClass) {
            JavaMetamodel.getDefaultRepository().beginTrans(false);
            try {
                WMDRChangeListener wMDRChangeListener = this;
                synchronized (wMDRChangeListener) {
                    block12: {
                        if (this.containers != null && !this.support.isSuspended) break block12;
                        return;
                    }
                    List list = (List)this.containers.get(javaClass);
                    if (list != null) {
                        Object object;
                        Iterator iterator;
                        ArrayList arrayList = new ArrayList();
                        ArrayList arrayList2 = new ArrayList(list);
                        if (javaClass.isValid()) {
                            iterator = javaClass.getContents().iterator();
                            while (iterator.hasNext()) {
                                object = iterator.next();
                                arrayList2.remove(object);
                                if (!(object instanceof Method) || list.contains(object)) continue;
                                arrayList.add(object);
                                ((MDRObject)object).addListener((MDRChangeListener)this, 0x101FFFF);
                            }
                            list.addAll(arrayList);
                        }
                        list.removeAll(arrayList2);
                        iterator = arrayList2.iterator();
                        while (iterator.hasNext()) {
                            object = (MDRObject)iterator.next();
                            object.removeListener((MDRChangeListener)this);
                        }
                    }
                }
            }
            finally {
                JavaMetamodel.getDefaultRepository().endTrans();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAllElements() {
            JavaMetamodel.getDefaultRepository().beginTrans(false);
            try {
                WMDRChangeListener wMDRChangeListener = this;
                synchronized (wMDRChangeListener) {
                    block11: {
                        if (this.rsc != null) {
                            ((MDRObject)this.rsc).removeListener((MDRChangeListener)this);
                            JavaMetamodel.getDefaultRepository().removeListener((MDRChangeListener)this);
                            this.rsc = null;
                        }
                        if (this.containers != null) break block11;
                        return;
                    }
                    Iterator iterator = this.containers.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        MDRObject mDRObject = (MDRObject)entry.getKey();
                        List list = (List)entry.getValue();
                        mDRObject.removeListener((MDRChangeListener)this);
                        Iterator iterator2 = list.iterator();
                        while (iterator2.hasNext()) {
                            MDRObject mDRObject2 = (MDRObject)iterator2.next();
                            mDRObject2.removeListener((MDRChangeListener)this);
                        }
                        list.clear();
                    }
                    this.containers.clear();
                }
            }
            finally {
                JavaMetamodel.getDefaultRepository().endTrans();
            }
        }

        public void change(MDRChangeEvent mDRChangeEvent) {
            if (this.support.isSuspended) {
                return;
            }
            if (mDRChangeEvent instanceof TransactionEvent) {
                if (this.refresh) {
                    this.support.processOverriddenAnnotation(this.recompute);
                    this.recompute = false;
                    this.refresh = false;
                }
                return;
            }
            if (mDRChangeEvent.getSource() instanceof Element && !((Element)mDRChangeEvent.getSource()).isValid()) {
                return;
            }
            AttributeEvent attributeEvent = (AttributeEvent)mDRChangeEvent;
            String string = attributeEvent.getAttributeName();
            this.refresh = true;
            if (attributeEvent.getSource() instanceof JavaClass) {
                if ("contents".equals(string) && (attributeEvent.getNewElement() instanceof Method || attributeEvent.getOldElement() instanceof Method)) {
                    this.updateMethods((JavaClass)attributeEvent.getSource());
                    this.recompute = true;
                } else if ("superClassName".equals(string) || "interfaceNames".equals(string)) {
                    if (this.containers.containsKey(attributeEvent.getSource())) {
                        this.removeAllElements();
                    }
                    this.recompute = true;
                }
            } else if (attributeEvent.getSource() instanceof Method && ("name".equals(string) || "modifiers".equals(string) || "parameters".equals(string) || "typeName".equals(string))) {
                this.recompute = true;
            }
        }
    }

    private class Request
    implements Runnable {
        private boolean isCanceled = false;
        private boolean isRunning = false;
        private boolean followMe = false;
        private final int type;
        private static final int DEFAULT = 0;
        private static final int CLEAN = 1;
        private static final int REFRESH = 2;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Request() {
            this(0);
        }

        public Request(int n) {
            this.type = n;
        }

        public void run() {
            switch (this.type) {
                case 0: {
                    this.computeAnnotations(true);
                    break;
                }
                case 2: {
                    this.computeAnnotations(false);
                    break;
                }
                case 1: {
                    OverrideAnnotationSupport.this.dispose();
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)("Invalid request type: " + this.type));
                    }
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void computeAnnotations(boolean bl) {
            if (this.isCanceled) {
                return;
            }
            try {
                this.isRunning = true;
                OverrideAnnotationSupport.this.processOverriddenAnnotationImpl(bl);
            }
            finally {
                this.isRunning = false;
            }
            OverrideAnnotationSupport overrideAnnotationSupport = OverrideAnnotationSupport.this;
            synchronized (overrideAnnotationSupport) {
                if (this.followMe) {
                    this.followMe = false;
                    OverrideAnnotationSupport.this.processOverriddenAnnotation(bl);
                }
            }
        }

        public boolean cancel() {
            this.isCanceled = true;
            return !this.isRunning;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$java$OverrideAnnotationSupport == null ? (class$org$netbeans$modules$java$OverrideAnnotationSupport = OverrideAnnotationSupport.class$("org.netbeans.modules.java.OverrideAnnotationSupport")) : class$org$netbeans$modules$java$OverrideAnnotationSupport).desiredAssertionStatus();
        }
    }
}

