/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.jmi.reflect.InvalidObjectException;
import org.netbeans.jmi.javamodel.ErrorInfo;
import org.netbeans.jmi.javamodel.ErrorTypeEnum;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.JavaDataLoader;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.ParserMessage;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.ParsingListener;
import org.openide.src.SourceElement;

public class Parsing {
    private static ParsingListener listener = new ParsingListener(){

        public void resourceParsed(Resource resource) {
            try {
                JavaDataObject javaDataObject = (JavaDataObject)JavaMetamodel.getManager().getDataObject(resource);
                if (javaDataObject != null) {
                    Parsing.fireEvent(javaDataObject, resource);
                }
            }
            catch (InvalidObjectException invalidObjectException) {
                // empty catch block
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addParsingListener(Listener listener) {
        ArrayList arrayList = JavaDataLoader.parsingListeners;
        synchronized (arrayList) {
            JavaDataLoader.parsingListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeParsingListener(Listener listener) {
        ArrayList arrayList = JavaDataLoader.parsingListeners;
        synchronized (arrayList) {
            JavaDataLoader.parsingListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireEvent(JavaDataObject javaDataObject, Resource resource) {
        Event event = new Event(javaDataObject, resource);
        Iterator iterator = null;
        ArrayList arrayList = JavaDataLoader.parsingListeners;
        synchronized (arrayList) {
            List list = (List)JavaDataLoader.parsingListeners.clone();
            iterator = list.iterator();
        }
        while (iterator.hasNext()) {
            ((Listener)iterator.next()).objectParsed(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireEvent(JavaDataObject javaDataObject, Collection collection) {
        Event event = new Event(javaDataObject, collection);
        Iterator iterator = null;
        ArrayList arrayList = JavaDataLoader.parsingListeners;
        synchronized (arrayList) {
            List list = (List)JavaDataLoader.parsingListeners.clone();
            iterator = list.iterator();
        }
        while (iterator.hasNext()) {
            ((Listener)iterator.next()).objectParsed(event);
        }
    }

    static {
        JavaMetamodel.addParsingListener((ParsingListener)listener);
    }

    public static class Event
    extends EventObject {
        static final long serialVersionUID = 8512232095851109211L;
        private Collection messages;
        private final Resource rsc;

        Event(JavaDataObject javaDataObject, Collection collection) {
            super((Object)javaDataObject);
            this.messages = collection;
            this.rsc = null;
        }

        Event(JavaDataObject javaDataObject, Resource resource) {
            super((Object)javaDataObject);
            this.rsc = resource;
        }

        public JavaDataObject getJavaDataObject() {
            return (JavaDataObject)((Object)this.getSource());
        }

        public SourceElement getSourceElement() {
            return this.getJavaDataObject().getSource();
        }

        public synchronized ParserMessage[] getMessages() {
            ParserMessage[] parserMessageArray;
            if (this.messages == null) {
                if (this.rsc == null) {
                    return null;
                }
                parserMessageArray = this.rsc.getErrors();
                this.messages = new ArrayList();
                Iterator iterator = parserMessageArray.iterator();
                while (iterator.hasNext()) {
                    this.messages.add(new ParserMessageImpl((ErrorInfo)iterator.next()));
                }
            }
            parserMessageArray = new ParserMessage[this.messages.size()];
            this.messages.toArray(parserMessageArray);
            return parserMessageArray;
        }
    }

    public static interface Listener
    extends EventListener {
        public void objectParsed(Event var1);
    }

    private static class ParserMessageImpl
    extends ParserMessage {
        private final ErrorInfo errorInfo;

        ParserMessageImpl(ErrorInfo errorInfo) {
            this.errorInfo = errorInfo;
        }

        public Object getSeverity() {
            return this.errorInfo.getSeverity() == ErrorTypeEnum.WARNING ? ParserMessage.WARNING : ParserMessage.ERROR;
        }

        public int getLineNumber() {
            return this.errorInfo.getLineNumber();
        }

        public int getColumn() {
            return this.errorInfo.getColumn();
        }

        public String getDescription() {
            return this.errorInfo.getDescription();
        }
    }
}

