/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.bridge;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.openide.src.Identifier;

class IdentContextSupport {
    Map identifierSet;

    public IdentContextSupport(int n) {
        this.identifierSet = new HashMap(n * 4 / 3);
    }

    public Identifier create(Identifier identifier, int n) {
        Identifier identifier2;
        Reference reference = (Reference)this.identifierSet.get(identifier.getSourceName());
        if (reference != null && (identifier2 = (Identifier)reference.get()) != null && identifier2.getResolutionStatus() == n && identifier2.getFullName() == identifier.getFullName()) {
            return identifier2;
        }
        if (identifier.getResolutionStatus() != n) {
            identifier = Identifier.create((String)identifier.getFullName(), (String)identifier.getSourceName(), (int)n);
        }
        this.identifierSet.put(identifier.getSourceName(), new WeakReference<Identifier>(identifier));
        return identifier;
    }

    public boolean checkContext(Identifier identifier) {
        Reference reference = (Reference)this.identifierSet.get(identifier);
        if (reference == null) {
            return false;
        }
        Identifier identifier2 = (Identifier)reference.get();
        return identifier2 == identifier;
    }
}

