/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.bridge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedList;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.JavaPackageClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.bridge.Binding;
import org.netbeans.modules.java.bridge.DefaultLangModel;
import org.netbeans.modules.java.bridge.ElementImpl;
import org.netbeans.modules.java.bridge.ElementOrder;
import org.netbeans.modules.java.bridge.FeaturesCollection;
import org.netbeans.modules.java.bridge.IdentContextSupport;
import org.netbeans.modules.java.bridge.ImportElement;
import org.netbeans.modules.java.bridge.ImportsCollection;
import org.netbeans.modules.java.bridge.TopClassesCollection;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.Element;
import org.openide.src.Identifier;
import org.openide.src.Import;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.util.Task;

public class SourceElementImpl
extends ElementImpl
implements SourceElement.Impl,
ElementOrder,
PropertyChangeListener {
    private transient FeaturesCollection members;
    transient TopClassesCollection topClasses;
    transient ImportsCollection imports;
    private ElementImpl.ElementListener classesListener;
    private ElementImpl.ElementListener sourceListener;
    private ElementImpl.ElementListener importsListener;
    private IdentContextSupport identSupp;
    private transient Resource resource;
    private transient JavaDataObject javaObject;
    private static final long serialVersionUID = 8506642610861188475L;
    static /* synthetic */ Class class$org$netbeans$modules$java$bridge$ElementImpl;

    public SourceElementImpl(DefaultLangModel defaultLangModel, Resource resource, JavaDataObject javaDataObject) {
        super(defaultLangModel, (RefObject)resource);
        this.resource = resource;
        this.javaObject = javaDataObject;
        this.identSupp = new IdentContextSupport(11);
        this.members = new FeaturesCollection(this);
        this.topClasses = new TopClassesCollection(this.members, resource, this);
        this.imports = new ImportsCollection(this.members, resource);
    }

    public void connectListener() {
        this.sourceListener = new SourceListener(this);
        this.sourceListener.connect();
        this.classesListener = new TopClassesCollection.TopClassesListener(this);
        this.classesListener.connect();
        ResourceImpl resourceImpl = (ResourceImpl)this.resource;
        if (resourceImpl.importsInited()) {
            this.importsListener = new ImportsCollection.ImportsListener(this);
            this.importsListener.connect();
        } else {
            resourceImpl.addImportsListener((PropertyChangeListener)this);
        }
    }

    boolean isResourceValid() {
        return this.resource.isValid();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.importsListener = new ImportsCollection.ImportsListener(this);
        this.importsListener.connect();
    }

    protected void notifyElementCreated() {
    }

    protected void createFromModel(Element element) throws SourceException {
    }

    public Element[] getElements() {
        return this.getClasses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identifier getPackage() {
        this.repository.beginTrans(false);
        try {
            if (this.resource.isValid()) {
                this.setClassPath();
                String string = this.resource.getPackageName();
                Identifier identifier = string != null ? Identifier.create((String)string) : null;
                return identifier;
            }
            Identifier identifier = null;
            return identifier;
        }
        finally {
            this.repository.endTrans(false);
        }
    }

    public Import[] getImports() {
        return this.imports.getImports();
    }

    public ImportElement[] getImportElements() {
        return (ImportElement[])this.imports.getElements();
    }

    public ClassElement getClass(Identifier identifier) {
        return this.topClasses.getClass(identifier);
    }

    public ClassElement[] getClasses() {
        return this.topClasses.getClasses();
    }

    public ClassElement[] getAllClasses() {
        ClassElement[] classElementArray = this.getClasses();
        LinkedList linkedList = new LinkedList();
        for (int i = 0; i < classElementArray.length; ++i) {
            this.addAllClasses(classElementArray[i], linkedList);
        }
        return linkedList.toArray(new ClassElement[0]);
    }

    private void addAllClasses(ClassElement classElement, Collection collection) {
        collection.add(classElement);
        ClassElement[] classElementArray = classElement.getClasses();
        for (int i = 0; i < classElementArray.length; ++i) {
            this.addAllClasses(classElementArray[i], collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPackage(Identifier identifier) throws SourceException {
        this.checkWritable(false);
        this.checkDocument();
        boolean bl = true;
        this.repository.beginTrans(true);
        try {
            if (this.resource.isValid()) {
                this.setClassPath();
                Identifier identifier2 = this.getPackage();
                if (identifier2 == identifier || identifier2 != null && identifier != null && identifier2.getSourceName().equals(identifier.getSourceName())) {
                    bl = false;
                    return;
                }
                JavaPackageClass javaPackageClass = ((JavaModelPackage)this.resource.refImmediatePackage()).getJavaPackage();
                String string = identifier != null ? identifier.getFullName() : "";
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.getEventSource(), "package", identifier2, identifier);
                this.checkVetoablePropertyChange(propertyChangeEvent);
                this.resource.setPackageName(string);
                bl = false;
            } else {
                bl = false;
                this.throwIsInvalid();
            }
        }
        finally {
            this.repository.endTrans(bl);
        }
    }

    public void firePackageChange(Identifier identifier, Identifier identifier2) {
        if (identifier == identifier2 || identifier != null && identifier2 != null && identifier.getSourceName().equals(identifier2.getSourceName())) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.getEventSource(), "package", identifier, identifier2);
        this.fireOwnPropertyChange(propertyChangeEvent);
    }

    public void changeImports(Import[] importArray, int n) throws SourceException {
        this.checkWritable(false);
        this.checkDocument();
        this.imports.changeImports(importArray, n);
    }

    public void changeClasses(ClassElement[] classElementArray, int n) throws SourceException {
        this.checkWritable(false);
        this.checkDocument();
        this.topClasses.changeMembers((Element[])classElementArray, n);
    }

    private void notifyCreate(Element[] elementArray) {
        for (int i = 0; i < elementArray.length; ++i) {
            ElementImpl elementImpl = (ElementImpl)elementArray[i].getCookie(class$org$netbeans$modules$java$bridge$ElementImpl == null ? SourceElementImpl.class$("org.netbeans.modules.java.bridge.ElementImpl") : class$org$netbeans$modules$java$bridge$ElementImpl);
            elementImpl.notifyCreate();
        }
    }

    protected void notifyCreate() {
    }

    private Binding.Source getSourceBinding() {
        return (Binding.Source)this.getBinding();
    }

    public int getStatus() {
        return 0;
    }

    public Task prepare() {
        return Task.EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAtomic(Runnable runnable) {
        boolean bl = true;
        this.repository.beginTrans(true);
        try {
            this.setClassPath();
            runnable.run();
            bl = false;
        }
        finally {
            this.repository.endTrans(bl);
        }
    }

    public void runAtomicAsUser(Runnable runnable) throws SourceException {
        this.runAtomic(runnable);
    }

    public void updateMembers(String string, Element[] elementArray, int[] nArray) {
    }

    protected void checkWritable(boolean bl) throws SourceException {
        SourceException.IO iO = null;
        int n = this.resource.getStatus();
        if ((n & 1) != 0) {
            iO = new SourceException.IO("Source containing generics cannot be modified: " + this.resource.getName());
        } else if ((n & 8) != 0) {
            iO = new SourceException.IO("Source containing annotations cannot be modified: " + this.resource.getName());
        }
        if (iO != null) {
            if (JDK15_CHECKS_DISABLED) {
                if (bl) {
                    ErrorManager.getDefault().notify(1, (Throwable)iO);
                }
            } else {
                throw iO;
            }
        }
    }

    public void setParent(ElementImpl elementImpl) {
    }

    protected SourceElementImpl findSource() {
        return this;
    }

    public Object readResolve() {
        return null;
    }

    protected Element cloneSelf() {
        return null;
    }

    protected Identifier createLocalIdentifier(Identifier identifier, int n) {
        return this.identSupp.create(identifier, n);
    }

    protected boolean checkIdentifierContext(Identifier identifier) {
        return this.identSupp.checkContext(identifier);
    }

    protected boolean parentValid() {
        return this.isValid();
    }

    protected void notifyRemove() {
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return this;
        }
        return this.javaObject.getCookie(clazz);
    }

    static class SourceListener
    extends ElementImpl.ElementListener {
        Identifier packageId = null;

        SourceListener(SourceElementImpl sourceElementImpl) {
            super(sourceElementImpl);
            String string = ((Resource)this.javaElement).getPackageName();
            this.packageId = string != null ? Identifier.create((String)string) : null;
        }

        public void doChange(MDRChangeEvent mDRChangeEvent) {
            super.doChange(mDRChangeEvent);
            if (mDRChangeEvent instanceof AttributeEvent && ((AttributeEvent)mDRChangeEvent).getAttributeName().equals("packageName")) {
                Identifier identifier = this.packageId;
                String string = (String)((AttributeEvent)mDRChangeEvent).getNewElement();
                this.packageId = string != null ? Identifier.create((String)string) : null;
                ((SourceElementImpl)this.impl).firePackageChange(identifier, this.packageId);
            }
        }
    }
}

