/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.codegen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.text.Position;
import org.netbeans.modules.java.bridge.Binding;
import org.netbeans.modules.java.codegen.ContainerImpl;
import org.netbeans.modules.java.codegen.ElementBinding;
import org.netbeans.modules.java.codegen.ExceptionRunnable;
import org.netbeans.modules.java.codegen.PositionComparator;
import org.netbeans.modules.java.codegen.SourceText;
import org.netbeans.modules.java.codegen.TextBinding;
import org.openide.src.Element;
import org.openide.src.MultiPropertyChangeEvent;
import org.openide.src.SourceException;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;

class ContainerSupport
implements TextBinding.Container,
ContainerImpl {
    TreeSet children;
    ElementBinding parent;
    SourceText source;
    boolean separateMembers;
    private static final Comparator CHILD_COMPARATOR = new PositionComparator();
    private static final boolean DEBUG = false;
    public static final int OP_REORDER = 0;
    public static final int OP_INSERT = 1;
    public static final int OP_REPLACE = 2;
    public static final int OP_REMOVE = 3;

    public ContainerSupport(SourceText sourceText, ElementBinding elementBinding) {
        this.source = sourceText;
        this.parent = elementBinding;
        this.children = this.createSet(null);
        this.separateMembers = true;
    }

    private Element getElement() {
        return this.parent.getElement();
    }

    public boolean isEmpty() {
        return this.children == null || this.children.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PositionRef getFirstPosition() {
        ElementBinding elementBinding;
        ContainerSupport containerSupport = this;
        synchronized (containerSupport) {
            if (this.children.isEmpty()) {
                return null;
            }
            elementBinding = (ElementBinding)this.children.first();
        }
        return elementBinding.wholeBounds.getBegin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PositionRef getLastPosition() {
        ElementBinding elementBinding;
        ContainerSupport containerSupport = this;
        synchronized (containerSupport) {
            if (this.children.isEmpty()) {
                return null;
            }
            elementBinding = (ElementBinding)this.children.last();
        }
        return elementBinding.wholeBounds.getEnd();
    }

    protected PositionBounds getContainerBounds() {
        return this.parent.findContainerBounds(this);
    }

    protected TreeSet createSet(Collection collection) {
        TreeSet treeSet = new TreeSet(CHILD_COMPARATOR);
        if (collection != null) {
            treeSet.addAll(collection);
        }
        return treeSet;
    }

    public void updateChildren(Collection collection) {
        ElementBinding elementBinding = null;
        ElementBinding elementBinding2 = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ElementBinding elementBinding3 = (ElementBinding)iterator.next();
            if (elementBinding2 == null) {
                elementBinding2 = elementBinding3;
            }
            elementBinding3.containerRef = this;
            elementBinding = elementBinding3;
        }
        this.children = this.createSet(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ElementBinding findNext(ElementBinding elementBinding) {
        SortedSet<ElementBinding> sortedSet;
        if (elementBinding == null) {
            if (this.children.isEmpty()) {
                return null;
            }
            return (ElementBinding)this.children.first();
        }
        Iterator iterator = this.source.getTreeLock();
        synchronized (iterator) {
            sortedSet = this.children.tailSet(elementBinding);
        }
        if (sortedSet.size() < 2) {
            return null;
        }
        iterator = sortedSet.iterator();
        iterator.next();
        return (ElementBinding)iterator.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ElementBinding findPrevious(ElementBinding elementBinding) {
        SortedSet<ElementBinding> sortedSet;
        if (elementBinding == null) {
            if (this.children.isEmpty()) {
                return null;
            }
            return (ElementBinding)this.children.last();
        }
        Object object = this.source.getTreeLock();
        synchronized (object) {
            sortedSet = this.children.headSet(elementBinding);
        }
        if (sortedSet.size() < 1) {
            return null;
        }
        return sortedSet.last();
    }

    public ElementBinding findBindingAt(int n) {
        Integer n2 = new Integer(n);
        SortedSet<Integer> sortedSet = this.children.tailSet(n2);
        if (sortedSet == null || sortedSet.isEmpty()) {
            return null;
        }
        return ((ElementBinding)sortedSet.iterator().next()).findBindingAt(n);
    }

    public ElementBinding findParent() {
        return this.parent;
    }

    public boolean canInsertAfter(Binding binding) {
        PositionRef positionRef;
        ElementBinding elementBinding;
        PositionRef positionRef2;
        if (!this.source.isAtomicAsUser()) {
            return true;
        }
        ElementBinding elementBinding2 = (ElementBinding)binding;
        PositionBounds positionBounds = this.getContainerBounds();
        if (!this.source.isGeneratorEnabled() || positionBounds == null) {
            return true;
        }
        if (elementBinding2 == null) {
            positionRef2 = this.source.createPos(positionBounds.getBegin().getOffset(), Position.Bias.Forward);
            elementBinding = this.children.isEmpty() ? null : (ElementBinding)this.children.first();
        } else {
            if (!elementBinding2.canInsertAfter()) {
                return false;
            }
            positionRef2 = this.source.createPos(elementBinding2.wholeBounds.getEnd().getOffset(), Position.Bias.Forward);
            SortedSet<ElementBinding> sortedSet = this.children.tailSet(elementBinding2);
            Iterator iterator = sortedSet.iterator();
            iterator.next();
            elementBinding = iterator.hasNext() ? (ElementBinding)iterator.next() : null;
        }
        if (elementBinding != null) {
            positionRef = this.source.createPos(elementBinding.wholeBounds.getBegin().getOffset() - 1, Position.Bias.Forward);
        } else {
            int n = positionBounds.getEnd().getOffset();
            if (n != 0) {
                --n;
            }
            positionRef = this.source.createPos(n, Position.Bias.Forward);
        }
        return this.source.canWriteInside(new PositionBounds(positionRef2, positionRef));
    }

    public void reorder(Map map) throws SourceException {
    }

    public void replace(Binding binding, Binding binding2) throws SourceException {
    }

    public void insert(Binding binding, Binding binding2) throws SourceException {
    }

    public void insertChild(ElementBinding elementBinding, ElementBinding elementBinding2, ElementBinding elementBinding3, PositionBounds positionBounds) throws SourceException {
        boolean bl;
        boolean bl2;
        if (this.separateMembers) {
            bl2 = true;
            bl = true;
        } else {
            bl = elementBinding2 == null;
            bl2 = elementBinding3 == null;
        }
        elementBinding.create(this, elementBinding2, elementBinding3, positionBounds, bl, bl2);
    }

    public void insertChild(ElementBinding elementBinding, ElementBinding elementBinding2, ElementBinding elementBinding3) throws SourceException {
        PositionBounds positionBounds = this.getContainerBounds();
        if (positionBounds == null) {
            PositionRef positionRef = this.parent.getEndPosition();
            positionBounds = new PositionBounds(positionRef, positionRef);
        }
        this.insertChild(elementBinding, elementBinding2, elementBinding3, positionBounds);
    }

    private void doReorder(Map map) throws SourceException {
        Object object;
        ArrayList<PositionRef> arrayList = new ArrayList<PositionRef>(map.size());
        Iterator<Object> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            object = (ElementBinding)iterator.next();
            arrayList.add(((ElementBinding)object).prepareInsert(null, false));
        }
        iterator = arrayList.iterator();
        object = map.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            ElementBinding elementBinding = (ElementBinding)entry.getValue();
            PositionRef positionRef = (PositionRef)iterator.next();
        }
    }

    private void performRemove(MultiPropertyChangeEvent multiPropertyChangeEvent) throws SourceException {
        if (multiPropertyChangeEvent == null) {
            return;
        }
        Collection collection = multiPropertyChangeEvent.getAffectedItems();
        int[] nArray = multiPropertyChangeEvent.getIndices();
        boolean bl = ((Object[])multiPropertyChangeEvent.getNewValue()).length == 0;
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            ElementBinding elementBinding = this.source.findBinding(element);
            boolean bl2 = this.separateMembers ? true : bl;
            elementBinding.remove(bl2, bl2);
            ++n;
        }
    }

    private void performReorder(MultiPropertyChangeEvent multiPropertyChangeEvent, int[] nArray) throws SourceException {
        int n;
        if (multiPropertyChangeEvent == null) {
            return;
        }
        Element[] elementArray = (Element[])multiPropertyChangeEvent.getOldValue();
        Element[] elementArray2 = (Element[])multiPropertyChangeEvent.getNewValue();
        int[] nArray2 = multiPropertyChangeEvent.getIndices();
        ArrayList arrayList = new ArrayList(elementArray.length);
        ArrayList arrayList2 = new ArrayList(elementArray.length);
        ElementBinding[] elementBindingArray = new ElementBinding[elementArray2.length];
        int n2 = 0;
        Object var10_10 = null;
        for (n = 0; n < nArray2.length; ++n) {
            if (nArray2[n] == -1) continue;
            elementBindingArray[nArray2[n]] = this.source.findBinding(elementArray[n]);
            ++n2;
        }
        for (n = 0; n < elementArray2.length; ++n) {
            if (elementBindingArray[n] == null) continue;
            ElementBinding elementBinding = elementBindingArray[n];
            ElementBinding elementBinding2 = n > 0 ? this.source.findBinding(elementArray2[n - 1]) : null;
            ElementBinding elementBinding3 = n < elementArray2.length - 1 ? this.source.findBinding(elementArray2[n + 1]) : null;
            elementBinding.moveTo(elementBinding2, elementBinding3);
        }
    }

    private void performInsert(MultiPropertyChangeEvent multiPropertyChangeEvent) throws SourceException {
        if (multiPropertyChangeEvent == null) {
            return;
        }
        Collection collection = multiPropertyChangeEvent.getAffectedItems();
        int[] nArray = multiPropertyChangeEvent.getIndices();
        Iterator iterator = collection.iterator();
        Element[] elementArray = (Element[])multiPropertyChangeEvent.getNewValue();
        int n = 0;
        int n2 = -1;
        Element[] elementArray2 = (Element[])multiPropertyChangeEvent.getNewValue();
        for (int i = 0; i < collection.size(); ++i) {
            ElementBinding elementBinding;
            ElementBinding elementBinding2;
            int n3;
            Element element = (Element)iterator.next();
            ElementBinding elementBinding3 = this.source.findBinding(element);
            if (n2 < (n3 = nArray[n++])) {
                int n4 = n;
                for (n2 = n3 + 1; n2 < elementArray2.length && n4 < nArray.length && n2 == nArray[n4]; ++n2, ++n4) {
                }
            }
            if (n2 >= elementArray2.length) {
                elementBinding2 = null;
            } else {
                elementBinding2 = this.source.findBinding(elementArray2[n2]);
                PositionRef positionRef = elementBinding2.wholeBounds.getBegin();
            }
            if (n3 == 0) {
                elementBinding = null;
            } else {
                Element element2 = elementArray[n3 - 1];
                elementBinding = this.source.findBinding(element2);
            }
            this.insertChild(elementBinding3, elementBinding, elementBinding2);
        }
    }

    public void changeMembers(final MultiPropertyChangeEvent multiPropertyChangeEvent) throws SourceException {
        if (!this.source.isGeneratorEnabled()) {
            return;
        }
        this.source.runAtomic(this.parent.getElement(), new ExceptionRunnable(){

            public void run() throws Exception {
                ContainerSupport.this.performChangeMembers(multiPropertyChangeEvent);
            }
        });
    }

    private void performChangeMembers(MultiPropertyChangeEvent multiPropertyChangeEvent) throws SourceException {
        int[] nArray;
        List<MultiPropertyChangeEvent> list;
        if (multiPropertyChangeEvent.getEventType() == 5) {
            list = multiPropertyChangeEvent.getComponents();
            nArray = multiPropertyChangeEvent.getIndices();
        } else {
            list = Collections.singletonList(multiPropertyChangeEvent);
            nArray = null;
        }
        MultiPropertyChangeEvent multiPropertyChangeEvent2 = null;
        MultiPropertyChangeEvent multiPropertyChangeEvent3 = null;
        MultiPropertyChangeEvent multiPropertyChangeEvent4 = null;
        Iterator iterator = list.iterator();
        block5: while (iterator.hasNext()) {
            MultiPropertyChangeEvent multiPropertyChangeEvent5 = (MultiPropertyChangeEvent)iterator.next();
            switch (multiPropertyChangeEvent5.getEventType()) {
                case 1: {
                    multiPropertyChangeEvent2 = multiPropertyChangeEvent5;
                    continue block5;
                }
                case 2: {
                    multiPropertyChangeEvent4 = multiPropertyChangeEvent5;
                    continue block5;
                }
                case 4: {
                    multiPropertyChangeEvent3 = multiPropertyChangeEvent5;
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Unknown operation " + multiPropertyChangeEvent5.getEventType());
        }
        this.performRemove(multiPropertyChangeEvent4);
        this.performInsert(multiPropertyChangeEvent2);
        this.performReorder(multiPropertyChangeEvent3, nArray);
        this.computeChildren((Element[])multiPropertyChangeEvent.getNewValue());
    }

    private void computeChildren(Element[] elementArray) {
        ElementBinding[] elementBindingArray = new ElementBinding[elementArray.length];
        for (int i = 0; i < elementArray.length; ++i) {
            elementBindingArray[i] = this.source.findBinding(elementArray[i]);
        }
        this.updateChildren(Arrays.asList(elementBindingArray));
    }

    private class Writer
    implements ExceptionRunnable {
        int operation;
        Map reorderMap;
        ElementBinding previous;
        ElementBinding current;

        Writer(Map map) {
            this.operation = 0;
            this.reorderMap = map;
        }

        Writer(ElementBinding elementBinding, ElementBinding elementBinding2) {
            this.previous = elementBinding;
            this.current = elementBinding2;
            this.operation = 1;
        }

        public void run() throws Exception {
            if (!ContainerSupport.this.source.isGeneratorEnabled()) {
                return;
            }
            switch (this.operation) {
                case 0: 
                case 1: {
                    ContainerSupport.this.doReorder(this.reorderMap);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown operation :" + this.operation);
                }
            }
        }
    }
}

