/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.settings;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import org.netbeans.modules.java.settings.JavaSynchronizationSettings;
import org.netbeans.modules.javacore.JMManager;
import org.openide.options.ContextSystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class JavaSettings
extends ContextSystemOption {
    private static final int currentVersion = 1;
    static final long serialVersionUID = -8522143676848697297L;
    public static final String PROP_SHOW_OVERRIDING = "showOverriding";
    public static final String PROP_SHOW_COMPILE_STATUS = "showCompileStatus";
    public static final String PROP_REPLACEABLE_STRINGS_TABLE = "replaceableStringsTable";
    public static final String PROP_AUTO_PARSING_DELAY = "autoParsingDelay";
    public static final String PROP_PARSING_ERRORS = "parsingErrors";
    public static final int DEFAULT_AUTO_PARSING_DELAY = 2000;
    public static final int DEFAULT_PARSING_ERRORS = 100;
    private static final boolean DEFAULT_SHOW_OVERRIDING = true;
    private int version;
    private static JavaSettings javaSettings;
    public static final String PROP_DEFAULT_ENCODING = "defaultEncoding";
    public static final String ENCODING_PLATFORM_DEFAULT = "";
    private String defaultEncoding = "";

    public String displayName() {
        return JavaSettings.getString("CTL_Java_option");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(JavaSettings.class);
    }

    public JavaSettings() {
        this.addOption(JavaSettings.getJavaSynchronizationSettings());
    }

    public void setReplaceableStringsTable(String string) {
        String string2 = this.getReplaceableStringsTable();
        if (string2.equals(string)) {
            return;
        }
        this.putProperty(PROP_REPLACEABLE_STRINGS_TABLE, string, true);
    }

    public String getReplaceableStringsTable() {
        String string = (String)this.getProperty(PROP_REPLACEABLE_STRINGS_TABLE);
        if (string == null) {
            return "USER=" + System.getProperty("user.name") + "\n";
        }
        return string;
    }

    public Properties getReplaceableStringsProps() {
        Properties properties = new Properties();
        String string = this.getReplaceableStringsTable();
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c > '\u00ff') {
                String string2 = Integer.toHexString(c);
                stringBuffer.append("\\u");
                if (c < '\u1000') {
                    stringBuffer.append("0");
                }
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(c);
        }
        try {
            properties.load(new ByteArrayInputStream(stringBuffer.toString().getBytes()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    public int getAutoParsingDelay() {
        Integer n = (Integer)this.getProperty(PROP_AUTO_PARSING_DELAY);
        if (n == null) {
            return 2000;
        }
        return n;
    }

    public void setParsingErrors(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.putProperty(PROP_PARSING_ERRORS, new Integer(n), true);
    }

    public int getParsingErrors() {
        Integer n = (Integer)this.getProperty(PROP_PARSING_ERRORS);
        if (n == null) {
            return 100;
        }
        return n;
    }

    public boolean getShowOverriding() {
        Boolean bl = (Boolean)this.getProperty(PROP_SHOW_OVERRIDING);
        if (bl == null) {
            return true;
        }
        return bl;
    }

    public void setShowOverriding(boolean bl) {
        Boolean bl2 = (Boolean)this.getProperty(PROP_SHOW_OVERRIDING);
        if (bl2 != null && bl2 == bl) {
            return;
        }
        this.putProperty(PROP_SHOW_OVERRIDING, bl ? Boolean.TRUE : Boolean.FALSE, true);
    }

    public void setAutoParsingDelay(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.putProperty(PROP_AUTO_PARSING_DELAY, new Integer(n));
    }

    public boolean isCompileStatusEnabled() {
        Boolean bl = (Boolean)this.getProperty(PROP_SHOW_COMPILE_STATUS);
        if (bl == null) {
            return true;
        }
        return bl;
    }

    public void enableCompileStatus(boolean bl) {
        if (this.isCompileStatusEnabled() == bl) {
            return;
        }
        this.putProperty(PROP_SHOW_COMPILE_STATUS, bl ? Boolean.TRUE : Boolean.FALSE, true);
    }

    static String getString(String string) {
        return NbBundle.getMessage((Class)JavaSettings.class, (String)string);
    }

    private static JavaSynchronizationSettings getJavaSynchronizationSettings() {
        return (JavaSynchronizationSettings)JavaSynchronizationSettings.findObject((Class)JavaSynchronizationSettings.class, (boolean)true);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        if (objectInput.available() > 0) {
            this.version = objectInput.readInt();
        }
        if (this.version < 1) {
            this.version = 1;
        }
        JMManager.setDefaultEncoding((String)this.defaultEncoding);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this.version);
    }

    public static final JavaSettings getDefault() {
        if (javaSettings == null) {
            javaSettings = (JavaSettings)JavaSettings.findObject((Class)JavaSettings.class, (boolean)true);
        }
        return javaSettings;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public void setDefaultEncoding(String string) {
        String string2 = this.defaultEncoding;
        this.defaultEncoding = string;
        JMManager.setDefaultEncoding((String)string);
        this.firePropertyChange(PROP_DEFAULT_ENCODING, string2, string);
    }
}

