/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.tools;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.jmi.reflect.InvalidObjectException;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.java.settings.JavaSynchronizationSettings;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MethodImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ParameterizedTypeImpl;
import org.openide.ErrorManager;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class JMIInheritanceSupport
implements Runnable,
TaskListener {
    public static final String PROP_FINISHED = "JMIInheritanceSupport.finished";
    private ClassDefinition root;
    private JavaModelPackage modelPackage;
    private Resource resource;
    private Set classes;
    private Map methods;
    private Map tree;
    private List classesList;
    private Set finalMethodsKeys;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private RequestProcessor.Task task = RequestProcessor.getDefault().create((Runnable)this);
    private int nextPosition = -1;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static String getString(String string) {
        return NbBundle.getMessage((Class)JMIInheritanceSupport.class, (String)string);
    }

    public JMIInheritanceSupport(ClassDefinition classDefinition) {
        DataObject dataObject = JavaMetamodel.getManager().getDataObject(classDefinition.getResource());
        if (!$assertionsDisabled && dataObject == null) {
            throw new AssertionError();
        }
        this.root = classDefinition;
        this.resource = classDefinition.getResource();
        this.modelPackage = (JavaModelPackage)classDefinition.refOutermostPackage();
        this.task.addTaskListener((TaskListener)this);
    }

    public ClassDefinition getRootClass() {
        return this.root;
    }

    public void setRootClass(ClassDefinition classDefinition) {
        this.root = classDefinition;
    }

    public Collection getClasses(Collection collection, boolean bl, boolean bl2) {
        if (!this.task.isFinished()) {
            this.task.waitFinished();
        }
        Iterator iterator = this.classesList.iterator();
        while (iterator.hasNext()) {
            JavaClass javaClass = (JavaClass)iterator.next();
            boolean bl3 = javaClass.isInterface();
            if ((bl3 || !bl) && (!bl3 || !bl2)) continue;
            collection.add(javaClass);
        }
        return collection;
    }

    public Collection getAllMethods(Collection collection, boolean bl) {
        if (!this.task.isFinished()) {
            this.task.waitFinished();
        }
        Iterator iterator = this.methods.values().iterator();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            if (bl && (!this.isAbstract(method) || this.isImplemented(method))) continue;
            collection.add(method);
        }
        return collection;
    }

    public Collection getMethods(Collection collection, ClassDefinition classDefinition, boolean bl) {
        if (!this.task.isFinished()) {
            this.task.waitFinished();
        }
        Set set = (Set)this.tree.get(classDefinition);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            MethodKey methodKey = (MethodKey)iterator.next();
            Method method = (Method)this.methods.get(methodKey);
            if (bl && (!this.isAbstract(method) || this.isImplemented(method))) continue;
            collection.add(method);
        }
        return collection;
    }

    public Method overrideMethod(Method method, boolean bl, boolean bl2) {
        try {
            String string = "";
            int n = method.getModifiers() & 0xFFFFFADF;
            if (bl) {
                string = this.createSuperCall(method, this.isImplementedInSuper(this.root, method, false));
            }
            MethodImpl methodImpl = method instanceof MethodImpl ? (MethodImpl)method : (MethodImpl)((ParameterizedTypeImpl.Wrapper)method).getWrappedObject();
            MethodImpl methodImpl2 = (MethodImpl)methodImpl.duplicate((JavaModelPackage)this.root.refImmediatePackage());
            methodImpl2.setJavadocText(bl2 ? methodImpl.getJavadocText() : null);
            methodImpl2.setModifiers(n);
            methodImpl2.setBody(null);
            methodImpl2.fixImports((Element)this.root, (Element)method);
            methodImpl2.setBodyText(string);
            this.addMethod((Method)methodImpl2);
            return methodImpl2;
        }
        catch (InvalidObjectException invalidObjectException) {
            ErrorManager.getDefault().notify((Throwable)invalidObjectException);
            return null;
        }
    }

    private void addMethod(Method method) {
        Object object;
        List list = this.root.getContents();
        if (this.nextPosition != -1) {
            list.add(this.nextPosition, method);
            ++this.nextPosition;
            return;
        }
        int n = -1;
        ListIterator<Method> listIterator = list.listIterator();
        int n2 = 0;
        while (listIterator.hasNext()) {
            object = listIterator.next();
            if (!(object instanceof JavaClass)) {
                n = n2;
            }
            ++n2;
        }
        if (n == -1) {
            list.add(method);
            this.nextPosition = 1;
            return;
        }
        JavaMetamodel javaMetamodel = JavaMetamodel.getManager();
        listIterator = list.listIterator(n + 1);
        while (listIterator.hasPrevious()) {
            object = (NamedElement)listIterator.previous();
            if (javaMetamodel.isElementGuarded(object)) continue;
            listIterator.next();
            listIterator.add(method);
            this.nextPosition = list.indexOf(method) + 1;
            return;
        }
        list.add(0, method);
        this.nextPosition = 1;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public boolean isFinished() {
        return this.task.isFinished();
    }

    public void reset() {
        this.classes = null;
        this.classesList = null;
        this.methods = null;
        this.tree = null;
        this.finalMethodsKeys = null;
        this.task.schedule(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.classes = new HashSet();
        this.classesList = new ArrayList();
        this.methods = new HashMap();
        this.tree = new HashMap();
        this.finalMethodsKeys = new HashSet();
        MDRepository mDRepository = JavaMetamodel.getDefaultRepository();
        mDRepository.beginTrans(false);
        try {
            JavaMetamodel javaMetamodel = JavaMetamodel.getManager();
            javaMetamodel.setClassPath(javaMetamodel.getFileObject(this.root.getResource()), true);
            for (JavaClass javaClass = this.root.getSuperClass(); javaClass != null && this.classes.add(javaClass); javaClass = javaClass.getSuperClass()) {
                this.classesList.add(javaClass);
                HashSet hashSet = new HashSet();
                this.collectMethods(hashSet, javaClass);
                this.tree.put(javaClass, hashSet);
            }
            this.traverseInterfaces(this.classes, this.classesList, this.tree, this.root);
        }
        finally {
            mDRepository.endTrans();
        }
    }

    private void traverseInterfaces(Set set, List list, Map map, ClassDefinition classDefinition) {
        List list2 = classDefinition.getInterfaces();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            JavaClass javaClass = (JavaClass)iterator.next();
            if (!set.add(javaClass)) continue;
            list.add(javaClass);
            HashSet hashSet = new HashSet();
            this.collectMethods(hashSet, javaClass);
            map.put(javaClass, hashSet);
            this.traverseInterfaces(set, list, map, (ClassDefinition)javaClass);
        }
    }

    public void taskFinished(Task task) {
        this.pcs.firePropertyChange(PROP_FINISHED, Boolean.FALSE, Boolean.TRUE);
    }

    private boolean isAbstract(Method method) {
        ClassDefinition classDefinition = method.getDeclaringClass();
        return Modifier.isAbstract(method.getModifiers()) || classDefinition instanceof JavaClass && ((JavaClass)classDefinition).isInterface();
    }

    private boolean isAccessibleMethod(Method method) {
        int n;
        ClassDefinition classDefinition = method.getDeclaringClass();
        int n2 = n = classDefinition instanceof JavaClass ? ((JavaClass)classDefinition).getModifiers() : 0;
        if ((n & 2) != 0 || (n & 7) == 0 && !this.isSamePackage(classDefinition)) {
            return false;
        }
        if (classDefinition instanceof JavaClass && ((JavaClass)classDefinition).isInterface()) {
            return true;
        }
        n = method.getModifiers();
        if ((n & 2) != 0) {
            return false;
        }
        if ((n & 5) != 0) {
            return true;
        }
        return this.isSamePackage(classDefinition);
    }

    private boolean isImplementedInSuper(ClassDefinition classDefinition, Method method, boolean bl) {
        String string = method.getName();
        List list = method.getParameters();
        ArrayList<Type> arrayList = new ArrayList<Type>(list.size());
        ClassDefinition classDefinition2 = list.iterator();
        while (classDefinition2.hasNext()) {
            arrayList.add(((Parameter)classDefinition2.next()).getType());
        }
        HashSet<ClassDefinition> hashSet = new HashSet<ClassDefinition>();
        for (classDefinition2 = bl ? classDefinition : classDefinition.getSuperClass(); classDefinition2 != null && hashSet.add(classDefinition2); classDefinition2 = classDefinition2.getSuperClass()) {
            Method method2 = classDefinition2.getMethod(string, arrayList, false);
            if (method2 == null || Modifier.isAbstract(method2.getModifiers())) continue;
            return true;
        }
        return false;
    }

    private boolean isImplemented(Method method) {
        String string = method.getName();
        List list = method.getParameters();
        ArrayList<Type> arrayList = new ArrayList<Type>(list.size());
        ClassDefinition classDefinition = list.iterator();
        while (classDefinition.hasNext()) {
            arrayList.add(((Parameter)classDefinition.next()).getType());
        }
        classDefinition = this.root;
        ClassDefinition classDefinition2 = classDefinition instanceof ParameterizedType ? ((ParameterizedType)classDefinition).getDefinition() : classDefinition;
        HashSet<ClassDefinition> hashSet = new HashSet<ClassDefinition>();
        hashSet.add(method.getDeclaringClass());
        while (classDefinition != null && hashSet.add(classDefinition2)) {
            Method method2 = classDefinition.getMethod(string, arrayList, false);
            if (method2 != null && !Modifier.isAbstract(method2.getModifiers())) {
                return true;
            }
            classDefinition2 = (classDefinition = classDefinition.getSuperClass()) instanceof ParameterizedType ? ((ParameterizedType)classDefinition).getDefinition() : classDefinition;
        }
        return false;
    }

    private boolean isOverriden(Method method) {
        List list = method.getParameters();
        String string = method.getName();
        ArrayList<Type> arrayList = new ArrayList<Type>(list.size());
        ClassDefinition classDefinition = list.iterator();
        while (classDefinition.hasNext()) {
            arrayList.add(((Parameter)classDefinition.next()).getType());
        }
        HashSet<ClassDefinition> hashSet = new HashSet<ClassDefinition>();
        for (classDefinition = this.root; classDefinition != null && hashSet.add(classDefinition); classDefinition = classDefinition.getSuperClass()) {
            Method method2 = this.root.getMethod(string, arrayList, false);
            if (method2 == method) {
                return false;
            }
            if (method2 == null) continue;
            return true;
        }
        return false;
    }

    private boolean isSamePackage(ClassDefinition classDefinition) {
        String string = this.root.getResource().getPackageName();
        String string2 = classDefinition.getResource().getPackageName();
        return string == null ? string2 == null : string.equals(string2);
    }

    private void collectMethods(Set set, JavaClass javaClass) {
        Iterator iterator = javaClass.getContents().iterator();
        while (iterator.hasNext()) {
            MethodKey methodKey;
            Object e = iterator.next();
            if (!(e instanceof Method)) continue;
            Method method = (Method)e;
            int n = method.getModifiers();
            boolean bl = !Modifier.isStatic(n) && (Modifier.isPublic(n) || Modifier.isProtected(n));
            boolean bl2 = Modifier.isFinal(n);
            if (bl && !bl2 && this.isAccessibleMethod(method) && !this.isOverriden(method)) {
                methodKey = new MethodKey(method);
                if (this.finalMethodsKeys.contains(methodKey) || this.methods.get(methodKey) != null) continue;
                this.methods.put(methodKey, method);
                set.add(methodKey);
                continue;
            }
            if (!bl2 || !bl) continue;
            methodKey = new MethodKey(method);
            this.finalMethodsKeys.add(methodKey);
        }
        iterator = javaClass.getInterfaces().iterator();
        while (iterator.hasNext()) {
            this.collectMethods(set, (JavaClass)iterator.next());
        }
    }

    private String createSuperCall(Method method, boolean bl) {
        String string;
        JavaSynchronizationSettings javaSynchronizationSettings = (JavaSynchronizationSettings)SharedClassObject.findObject((Class)JavaSynchronizationSettings.class, (boolean)true);
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            Type type = method.getParameters().iterator();
            while (type.hasNext()) {
                Parameter parameter = (Parameter)type.next();
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(parameter.getName());
            }
            type = method.getType();
            String string2 = type instanceof PrimitiveType && PrimitiveTypeKindEnum.VOID.equals((Object)((PrimitiveType)type).getKind()) ? NbBundle.getMessage((Class)JMIInheritanceSupport.class, (String)"FMT_CallSuper") : NbBundle.getMessage((Class)JMIInheritanceSupport.class, (String)"FMT_ReturnCallSuper");
            string = MessageFormat.format(string2, JavaModelUtil.resolveImportsForType((Element)this.root, (Type)method.getType()).getName(), method.getName(), stringBuffer);
        } else {
            string = javaSynchronizationSettings.getGenerateReturnAsString(method.getType());
        }
        return string;
    }

    static {
        $assertionsDisabled = !JMIInheritanceSupport.class.desiredAssertionStatus();
    }

    public static class MethodKey {
        private String name;
        private String[] paramTypes;

        public MethodKey(Method method) {
            this.name = method.getName();
            List list = method.getParameters();
            this.paramTypes = new String[list.size()];
            Iterator iterator = list.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                this.paramTypes[n] = ((Parameter)iterator.next()).getType().getName();
                ++n;
            }
        }

        public boolean equals(Object object) {
            if (!(object instanceof MethodKey)) {
                return false;
            }
            return this.name.equals(((MethodKey)object).name) && Arrays.equals(this.paramTypes, ((MethodKey)object).paramTypes);
        }

        public int hashCode() {
            int n = this.paramTypes.length;
            if (n == 0) {
                return 0;
            }
            if (n == 1) {
                return this.paramTypes[0].hashCode();
            }
            return this.paramTypes[0].hashCode() ^ this.paramTypes[n - 1].hashCode();
        }
    }
}

