/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.editors;

import java.awt.Component;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditorSupport;
import javax.swing.JPanel;
import org.netbeans.modules.java.ui.editors.ClassChooserPanel;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.src.ClassElement;
import org.openide.src.Identifier;
import org.openide.src.Type;

public class TypeIdentPE
extends PropertyEditorSupport
implements ExPropertyEditor {
    private static final String ATTR_CUSTOM_TITLE = "title";
    private static final String ATTR_CUSTOM_INPUT = "userInput";
    private static final String ATTR_CLASSPATH_ROOTS = "classPathRoots";
    private static final String ATTR_ACCEPT_CLASSES = "acceptClasses";
    private static final String ATTR_ACCEPT_INTERFACES = "acceptInterfaces";
    private static final String ATTR_DATA_FILTER = "dataFilter";
    PropertyEnv environment;
    boolean acceptClasses = true;
    boolean acceptInterfaces = true;
    boolean validNamesOnly = false;
    PropertyChangeSupport supp;
    ClassChooserPanel customEditor;
    Identifier identifier;

    public String getAsText() {
        if (this.identifier == null) {
            return "";
        }
        return this.identifier.getSourceName();
    }

    public void setAsText(String string) throws IllegalArgumentException {
        Identifier identifier;
        if (string == null || "".equals(string)) {
            identifier = null;
        } else {
            Type type = Type.parse((String)string);
            if (type.isPrimitive()) {
                this.denyPrimitiveType(type);
            } else if (type.isArray()) {
                this.denyArrayType(type);
            }
            ClassElement classElement = this.loadRepresentation(string);
            this.checkInputConstraints(string, classElement);
            identifier = type.getClassName();
        }
        super.setValue(identifier);
    }

    public void setValue(Object object) throws IllegalArgumentException {
        if (!(object instanceof Identifier)) {
            throw new IllegalArgumentException("Invalid value type: " + object.getClass());
        }
        super.setValue(object);
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        FeatureDescriptor featureDescriptor = propertyEnv.getFeatureDescriptor();
        Boolean bl = (Boolean)featureDescriptor.getValue(ATTR_ACCEPT_CLASSES);
        if (bl != null) {
            this.setAcceptClasses(bl);
        }
        if ((bl = (Boolean)featureDescriptor.getValue(ATTR_ACCEPT_INTERFACES)) != null) {
            this.setAcceptInterfaces(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Object object;
        super.addPropertyChangeListener(propertyChangeListener);
        if (this.supp == null) {
            object = this;
            synchronized (object) {
                if (this.supp == null) {
                    this.supp = new PropertyChangeSupport(this);
                }
            }
        }
        object = this.supp;
        synchronized (object) {
            this.supp.addPropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.supp != null) {
            PropertyChangeSupport propertyChangeSupport = this.supp;
            synchronized (propertyChangeSupport) {
                this.supp.removePropertyChangeListener(propertyChangeListener);
            }
        }
        super.removePropertyChangeListener(propertyChangeListener);
    }

    void enableOK(boolean bl) {
        if (this.supp == null) {
            return;
        }
        this.supp.firePropertyChange("propertyValueValid", null, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setAcceptClasses(boolean bl) {
        this.acceptClasses = bl;
    }

    public void setAcceptInterfaces(boolean bl) {
        this.acceptInterfaces = bl;
    }

    public void setValidNamesOnly(boolean bl) {
        this.validNamesOnly = bl;
    }

    public boolean getAcceptClasses() {
        return this.acceptClasses;
    }

    public boolean getAcceptInterfaces() {
        return this.acceptInterfaces;
    }

    public boolean getValidNamesOnly() {
        return this.validNamesOnly;
    }

    private ClassElement loadRepresentation(String string) {
        return ClassElement.forName((String)string);
    }

    private void denyPrimitiveType(Type type) {
        throw new IllegalArgumentException(type.toString() + " is a primitive type. Simple class or interface is required");
    }

    private void denyArrayType(Type type) {
        throw new IllegalArgumentException(type.toString() + " is an array. Simple class or interface is required");
    }

    void checkInputConstraints(String string, ClassElement classElement) throws IllegalArgumentException {
        if (classElement == null) {
            if (!this.getValidNamesOnly()) {
                return;
            }
            throw new IllegalArgumentException("Cannot find class or interface " + string);
        }
        boolean bl = classElement.isClassOrInterface();
        if (bl && !this.getAcceptClasses()) {
            throw new IllegalArgumentException("Class name is not permitted here");
        }
        if (!bl && !this.getAcceptInterfaces()) {
            throw new IllegalArgumentException("Interface name is not permitted here");
        }
    }

    public Component getCustomEditor() {
        Thread.dumpStack();
        return new JPanel();
    }
}

