/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes;

import javax.jmi.reflect.JmiException;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Initializer;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.bridge.ElementImpl;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.cookies.SourceCookie;
import org.openide.loaders.DataObject;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.FieldElement;
import org.openide.src.InitializerElement;
import org.openide.src.MethodElement;
import org.openide.src.SourceElement;

public final class BridgeUtils {
    private static final ThreadLocal isForCookieSet = new ThreadLocal();

    public static RefObject getJavaObject(Element element) {
        ElementImpl elementImpl = (ElementImpl)element.getCookie(Element.Impl.class);
        return elementImpl.getJavaElement();
    }

    private static ClassElement getClassElement(ClassMember classMember) {
        JavaClass javaClass = (JavaClass)classMember.getDeclaringClass();
        if (javaClass == null) {
            BridgeUtils.throwIllegalState(classMember, "none declaring class");
        }
        return BridgeUtils.getElement(javaClass);
    }

    public static Element getElement(ClassMember classMember) {
        ClassElement classElement = null;
        if (classMember instanceof JavaClass) {
            classElement = BridgeUtils.getElement((JavaClass)classMember);
        } else if (classMember instanceof Constructor) {
            classElement = BridgeUtils.getElement((Constructor)classMember);
        } else if (classMember instanceof Field) {
            classElement = BridgeUtils.getElement((Field)classMember);
        } else if (classMember instanceof Initializer) {
            classElement = BridgeUtils.getElement((Initializer)classMember);
        } else if (classMember instanceof Method) {
            classElement = BridgeUtils.getElement((Method)classMember);
        } else {
            throw new IllegalArgumentException("Unknown member: " + classMember);
        }
        return classElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Element getElementForCookieSet(ClassMember classMember) {
        try {
            isForCookieSet.set(Boolean.TRUE);
            Element element = BridgeUtils.getElement(classMember);
            return element;
        }
        finally {
            isForCookieSet.set(Boolean.FALSE);
        }
    }

    public static ClassElement getElement(JavaClass javaClass) {
        SourceCookie sourceCookie;
        DataObject dataObject;
        Resource resource = javaClass.getResource();
        if (resource == null) {
            BridgeUtils.throwIllegalState((ClassMember)javaClass, "missing resource");
        }
        if ((dataObject = JavaMetamodel.getManager().getDataObject(resource)) == null) {
            BridgeUtils.throwIllegalState((ClassMember)javaClass, "missing data object");
        }
        if ((sourceCookie = (SourceCookie)dataObject.getCookie(SourceCookie.class)) == null) {
            if (Boolean.TRUE.equals(isForCookieSet.get())) {
                return null;
            }
            BridgeUtils.throwIllegalState((ClassMember)javaClass, "missing source cookie");
        }
        SourceElement sourceElement = sourceCookie.getSource();
        ClassElement[] classElementArray = javaClass.refImmediateComposite() instanceof JavaClass ? sourceElement.getAllClasses() : sourceElement.getClasses();
        return (ClassElement)BridgeUtils.chooseElement((Element[])classElementArray, (ClassMember)javaClass);
    }

    public static ConstructorElement getElement(Constructor constructor) {
        ClassElement classElement = BridgeUtils.getClassElement((ClassMember)constructor);
        if (classElement == null) {
            return null;
        }
        ConstructorElement[] constructorElementArray = classElement.getConstructors();
        return (ConstructorElement)BridgeUtils.chooseElement((Element[])constructorElementArray, (ClassMember)constructor);
    }

    public static FieldElement getElement(Field field) {
        ClassElement classElement = BridgeUtils.getClassElement((ClassMember)field);
        if (classElement == null) {
            return null;
        }
        FieldElement[] fieldElementArray = classElement.getFields();
        return (FieldElement)BridgeUtils.chooseElement((Element[])fieldElementArray, (ClassMember)field);
    }

    public static MethodElement getElement(Method method) {
        ClassElement classElement = BridgeUtils.getClassElement((ClassMember)method);
        if (classElement == null) {
            return null;
        }
        MethodElement[] methodElementArray = classElement.getMethods();
        return (MethodElement)BridgeUtils.chooseElement((Element[])methodElementArray, (ClassMember)method);
    }

    public static InitializerElement getElement(Initializer initializer) {
        ClassElement classElement = BridgeUtils.getClassElement((ClassMember)initializer);
        if (classElement == null) {
            return null;
        }
        InitializerElement[] initializerElementArray = classElement.getInitializers();
        return (InitializerElement)BridgeUtils.chooseElement((Element[])initializerElementArray, (ClassMember)initializer);
    }

    private static Element chooseElement(Element[] elementArray, ClassMember classMember) {
        for (int i = 0; i < elementArray.length; ++i) {
            Element element = elementArray[i];
            RefObject refObject = BridgeUtils.getJavaObject(element);
            if (!classMember.equals(refObject)) continue;
            return element;
        }
        BridgeUtils.throwIllegalState(classMember, "cannot map class member to source hierarchy element");
        return null;
    }

    private static void throwIllegalState(ClassMember classMember, String string) throws IllegalStateException {
        IllegalStateException illegalStateException = new IllegalStateException(string);
        ErrorManager.getDefault().annotate((Throwable)illegalStateException, 1, classMember.getClass().toString(), null, null, null);
        try {
            ErrorManager.getDefault().annotate((Throwable)illegalStateException, 1, "name: " + classMember.getName(), null, null, null);
            ErrorManager.getDefault().annotate((Throwable)illegalStateException, 1, "member: " + classMember.toString(), null, null, null);
        }
        catch (JmiException jmiException) {
            ErrorManager.getDefault().annotate((Throwable)illegalStateException, 1, null, null, (Throwable)jmiException, null);
        }
        throw illegalStateException;
    }
}

