/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.editors;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.jmi.reflect.JmiException;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.java.ui.nodes.editors.ObjectArrayPanel2;
import org.netbeans.modules.java.ui.nodes.elements.ElementNode;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class IdentifierArrayEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    public static final String JAVA_LANG_OBJECT = "java.lang.Object";
    IdentifierArrayPanel panel;
    boolean ignoreEditor = false;
    boolean ignorePanel = false;
    PropertyEnv env;
    private JavaModelPackage model;

    public String getAsText() {
        MultipartId[] multipartIdArray = (MultipartId[])this.getValue();
        if (multipartIdArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < multipartIdArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(IdentifierArrayEditor.multipartIdToName(multipartIdArray[i]));
        }
        return stringBuffer.toString();
    }

    public static String multipartIdToName(MultipartId multipartId) {
        CharSequence charSequence;
        JavaModelPackage javaModelPackage;
        LinkedList<CharSequence> linkedList = new LinkedList<CharSequence>();
        while (multipartId != null) {
            if (multipartId.getTypeArguments().size() > 0) {
                javaModelPackage = (JavaModelPackage)multipartId.refImmediatePackage();
                NamedElement namedElement = multipartId.getElement();
                charSequence = namedElement.getName();
                charSequence = (String)charSequence + '<';
                Iterator iterator = multipartId.getTypeArguments().iterator();
                while (true) {
                    charSequence = (String)charSequence + ((NamedElement)iterator.next()).getName();
                    if (!iterator.hasNext()) break;
                    charSequence = (String)charSequence + ", ";
                }
                charSequence = (String)charSequence + '>';
            } else {
                charSequence = multipartId.getName();
            }
            linkedList.addFirst(charSequence);
            multipartId = multipartId.getParent();
        }
        charSequence = new StringBuffer();
        javaModelPackage = linkedList.iterator();
        while (javaModelPackage.hasNext()) {
            ((StringBuffer)charSequence).append((String)javaModelPackage.next());
            if (!javaModelPackage.hasNext()) continue;
            ((StringBuffer)charSequence).append('.');
        }
        return ((StringBuffer)charSequence).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsText(String string) throws IllegalArgumentException {
        List list = Collections.EMPTY_LIST;
        try {
            JavaMetamodel.getDefaultRepository().beginTrans(false);
            try {
                list = this.resolveIdentifiers(string);
            }
            finally {
                JavaMetamodel.getDefaultRepository().endTrans();
            }
        }
        catch (JmiException jmiException) {
            ErrorManager.getDefault().notify((Throwable)jmiException);
        }
        MultipartId[] multipartIdArray = new MultipartId[list.size()];
        list.toArray(multipartIdArray);
        this.setValue(multipartIdArray);
    }

    private List resolveIdentifiers(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ", false);
        ArrayList<IllegalArgumentException> arrayList = new ArrayList<IllegalArgumentException>();
        while (stringTokenizer.hasMoreTokens()) {
            IllegalArgumentException illegalArgumentException;
            String string2 = stringTokenizer.nextToken();
            JavaModelPackage javaModelPackage = this.model;
            Type type = javaModelPackage.getType().resolve(string2);
            if (type instanceof PrimitiveType) {
                illegalArgumentException = new IllegalArgumentException();
                String string3 = MessageFormat.format(IdentifierArrayEditor.getString("MSG_InvalidIdentifier"), string2);
                ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, null, string3, null, null);
                throw illegalArgumentException;
            }
            illegalArgumentException = javaModelPackage.getMultipartId().createMultipartId(string2, null, null);
            arrayList.add(illegalArgumentException);
        }
        return arrayList;
    }

    public void setValue(Object object) {
        this.ignoreEditor = true;
        boolean bl = this.ignorePanel;
        this.ignorePanel = false;
        super.setValue(object);
        if (this.panel != null & !bl) {
            this.panel.setIdentifiers((MultipartId[])object);
        }
        this.ignoreEditor = false;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        if (this.panel == null) {
            this.panel = new IdentifierArrayPanel(this.model);
            this.panel.setIdentifiers((MultipartId[])this.getValue());
            this.panel.setMnemonics(this.env);
            this.panel.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (!IdentifierArrayEditor.this.ignoreEditor && "identifiers".equals(propertyChangeEvent.getPropertyName())) {
                        IdentifierArrayEditor.this.ignorePanel = true;
                        IdentifierArrayEditor.this.setValue(propertyChangeEvent.getNewValue());
                        IdentifierArrayEditor.this.ignorePanel = false;
                    }
                }
            });
        }
        return this.panel;
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        this.env = propertyEnv;
        this.model = ElementNode.getModel(propertyEnv.getFeatureDescriptor());
    }

    private static String getString(String string) {
        return NbBundle.getMessage((Class)IdentifierArrayEditor.class, (String)string);
    }

    static class IdentifierArrayPanel
    extends ObjectArrayPanel2 {
        public static final String PROP_IDENTIFIERS = "identifiers";
        MultipartId[] prevValue;
        private final JavaModelPackage javaModel;

        public IdentifierArrayPanel(JavaModelPackage javaModelPackage) {
            this.javaModel = javaModelPackage;
            this.prevValue = new MultipartId[0];
            this.getListComponent().setCellRenderer(new DefaultListCellRenderer(this){
                private final /* synthetic */ IdentifierArrayPanel this$0;
                {
                    this.this$0 = identifierArrayPanel;
                }

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    if (component == this) {
                        this.setText(IdentifierArrayEditor.multipartIdToName((MultipartId)object));
                    }
                    return component;
                }
            });
        }

        public MultipartId[] getIdentifiers() {
            Object[] objectArray = new MultipartId[this.model.size()];
            this.model.copyInto(objectArray);
            return objectArray;
        }

        public void setIdentifiers(MultipartId[] multipartIdArray) {
            this.model = new DefaultListModel();
            if (multipartIdArray != null) {
                for (int i = 0; i < multipartIdArray.length; ++i) {
                    this.model.addElement(multipartIdArray[i]);
                }
            }
            this.getListComponent().setModel(this.model);
            this.modelChanged();
        }

        protected void modelChanged() {
            MultipartId[] multipartIdArray = this.getIdentifiers();
            this.firePropertyChange(PROP_IDENTIFIERS, this.prevValue, multipartIdArray);
            this.prevValue = multipartIdArray;
        }

        protected Object insertNewValue() {
            return this.openInputDialog(null);
        }

        protected Object editValue(Object object) {
            return this.openInputDialog((MultipartId)object);
        }

        protected MultipartId openInputDialog(MultipartId multipartId) {
            Object object;
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(IdentifierArrayEditor.getString("LAB_NewName"), IdentifierArrayEditor.getString("LAB_NewIdentifier"));
            if (multipartId != null) {
                inputLine.setInputText(IdentifierArrayEditor.multipartIdToName(multipartId));
            }
            while ((object = DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine)) == NotifyDescriptor.OK_OPTION) {
                String string = inputLine.getInputText();
                if (!(string == null || "".equals(string) || string.startsWith(".") || string.endsWith(".") || string.indexOf("..") != -1)) {
                    boolean bl = true;
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        if (Utilities.isJavaIdentifier((String)string2)) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        return this.javaModel.getMultipartId().createMultipartId(string, null, null);
                    }
                }
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)IdentifierArrayEditor.getString("MSG_NotValidID")));
            }
            return null;
        }
    }
}

