/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.editors;

import java.beans.FeatureDescriptor;
import java.beans.PropertyEditorSupport;
import java.util.StringTokenizer;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.java.ui.nodes.elements.ElementFormat;
import org.netbeans.modules.java.ui.nodes.elements.ElementNode;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;

public final class TypeEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    public static final String[] LVALUE_TYPES = new String[]{"boolean", "int", "char", "byte", "short", "long", "float", "double", "Object", "String"};
    public static final String[] RVALUE_TYPES = new String[]{"void", "boolean", "int", "char", "byte", "short", "long", "float", "double", "Object", "String"};
    public static final String[] ANNTYPE_VALUE_TYPES = new String[]{"boolean", "int", "char", "byte", "short", "long", "float", "double", "String", "String[]"};
    public static final String ANN_TYPE_EDITOR = "annTypeEditor";
    private boolean acceptsVoid;
    private boolean isAnnTypeEditor = false;
    private JavaModelPackage model;

    public String getAsText() {
        Object object = this.getValue();
        Type type = (Type)object;
        return type == null ? "" : ElementFormat.elementName((NamedElement)type);
    }

    public void setAsText(String string) throws IllegalArgumentException {
        Type type = this.model.getType().resolve(string);
        if (!TypeEditor.isValidTypeSyntax(string)) {
            TypeEditor.throwUserWarning("MSG_InvalidTypeDecl");
        }
        if (this.isAnnTypeEditor) {
            if (!TypeEditor.isValidTypeOfAnnTypeMethod(type)) {
                TypeEditor.throwUserWarning("MSG_InvalidTypeDecl");
            }
        } else if (!this.acceptsVoid && type instanceof PrimitiveType && PrimitiveTypeKindEnum.VOID.equals((Object)((PrimitiveType)type).getKind())) {
            TypeEditor.throwUserWarning("MSG_VoidTypeNotPermitted");
        }
        this.setValue(type);
    }

    private static void throwUserWarning(String string) throws IllegalArgumentException {
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
        ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, null, TypeEditor.getString(string), null, null);
        throw illegalArgumentException;
    }

    public static boolean isValidTypeOfAnnTypeMethod(Type type) {
        Type type2 = type;
        while (type2 instanceof Array) {
            type2 = ((Array)type2).getType();
        }
        if (type2 instanceof PrimitiveType) {
            return !PrimitiveTypeKindEnum.VOID.equals((Object)((PrimitiveType)type2).getKind());
        }
        if (type2 instanceof JavaEnum || type2 instanceof AnnotationType || type2 instanceof UnresolvedClass) {
            return true;
        }
        if (type2 instanceof JavaClass) {
            String string = type2.getName();
            return string.equals(String.class.getName()) || string.equals(Class.class.getName());
        }
        throw new IllegalStateException("unknown type: " + type);
    }

    public static boolean isValidTypeSyntax(String string) {
        if (string.length() == 0 || string.charAt(0) == '<') {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "<,>", true);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (n <= 0 && ",".equals(string2)) {
                return false;
            }
            if ("<".equals(string2)) {
                ++n;
                continue;
            }
            if (!">".equals(string2)) continue;
            if (n <= 0) {
                return false;
            }
            --n;
        }
        return n == 0;
    }

    public void setValue(Object object) {
        if (object != null && !(object instanceof Type)) {
            throw new IllegalArgumentException();
        }
        super.setValue(object);
    }

    public String getJavaInitializationString() {
        return this.getAsText();
    }

    public String[] getTags() {
        if (this.isAnnTypeEditor) {
            return ANNTYPE_VALUE_TYPES;
        }
        return this.acceptsVoid ? RVALUE_TYPES : LVALUE_TYPES;
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        FeatureDescriptor featureDescriptor = propertyEnv.getFeatureDescriptor();
        Object object = featureDescriptor.getValue("acceptVoidType");
        this.acceptsVoid = object instanceof Boolean ? (Boolean)object : true;
        object = featureDescriptor.getValue(ANN_TYPE_EDITOR);
        if (object instanceof Boolean) {
            this.isAnnTypeEditor = (Boolean)object;
        }
        featureDescriptor.setValue("canEditAsText", Boolean.TRUE);
        this.model = ElementNode.getModel(featureDescriptor);
    }

    private static String getString(String string) {
        return NbBundle.getMessage((Class)TypeEditor.class, (String)string);
    }
}

