/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.elements;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.jmi.reflect.JmiException;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Attribute;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.java.ui.nodes.editors.TypeEditor;
import org.netbeans.modules.java.ui.nodes.elements.ElementFormat;
import org.netbeans.modules.java.ui.nodes.elements.SourceEditSupport;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class AnnotationTypeMethodCustomizer
extends JPanel {
    private static final String[] COMMON_TYPES = TypeEditor.ANNTYPE_VALUE_TYPES;
    private final AnnotationType jclass;
    private final Attribute element;
    private boolean isOK = true;
    private JPanel accessPanel;
    private JTextField defValueTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel modifierPanel;
    private JTextField nameTextField;
    private JComboBox returnCombo;

    public AnnotationTypeMethodCustomizer(AnnotationType annotationType, Attribute attribute) {
        this.jclass = annotationType;
        this.element = attribute;
        this.initComponents();
        int n = 1025;
        this.accessPanel.add((Component)SourceEditSupport.createAccessModifiersPanel((ClassMember)attribute, n), "Center");
        this.modifierPanel.add((Component)SourceEditSupport.createOtherModifiersPanel((ClassMember)attribute, n), "Center");
        this.nameTextField.setText(attribute.getName());
        this.returnCombo.setSelectedItem(attribute.getType().getName());
        this.defValueTextField.setText(attribute.getDefaultValueText());
        HelpCtx.setHelpIDString((JComponent)this, (String)"java.annotationTypeMethod.customizer");
        this.jLabel1.setDisplayedMnemonic(AnnotationTypeMethodCustomizer.getString("CTL_Name_Mnemonic").charAt(0));
        this.jLabel2.setDisplayedMnemonic(AnnotationTypeMethodCustomizer.getString("CTL_MethodType_Mnemonic").charAt(0));
        this.jLabel3.setDisplayedMnemonic(AnnotationTypeMethodCustomizer.getString("CTL_DefaultValue_Mnemonic").charAt(0));
        this.initAccessibility();
    }

    public void addNotify() {
        super.addNotify();
        int n = this.nameTextField.getText().length();
        this.nameTextField.setCaretPosition(0);
        this.nameTextField.moveCaretPosition(n);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AnnotationTypeMethodCustomizer.this.nameTextField.requestFocus();
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.nameTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.returnCombo = new JComboBox<String>(COMMON_TYPES);
        this.jLabel3 = new JLabel();
        this.defValueTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.accessPanel = new JPanel();
        this.jLabel5 = new JLabel();
        this.modifierPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(6, 6, 6, 6)));
        this.jLabel1.setLabelFor(this.nameTextField);
        this.jLabel1.setText(NbBundle.getMessage((Class)AnnotationTypeMethodCustomizer.class, (String)"CTL_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.nameTextField.setColumns(25);
        this.nameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                AnnotationTypeMethodCustomizer.this.nameTextFieldFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 8, 0, 0);
        this.add((Component)this.nameTextField, gridBagConstraints);
        this.jLabel2.setLabelFor(this.returnCombo);
        this.jLabel2.setText(NbBundle.getMessage((Class)AnnotationTypeMethodCustomizer.class, (String)"CTL_ReturnType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.returnCombo.setEditable(true);
        this.returnCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnnotationTypeMethodCustomizer.this.returnComboActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.returnCombo, gridBagConstraints);
        this.jLabel3.setLabelFor(this.defValueTextField);
        this.jLabel3.setText(NbBundle.getMessage((Class)AnnotationTypeMethodCustomizer.class, (String)"CTL_DefaultValue"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.defValueTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                AnnotationTypeMethodCustomizer.this.defValueTextFieldFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.defValueTextField, gridBagConstraints);
        this.jLabel4.setLabelFor(this.accessPanel);
        this.jLabel4.setText(NbBundle.getMessage((Class)AnnotationTypeMethodCustomizer.class, (String)"CTL_AccessRights"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.accessPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.accessPanel, gridBagConstraints);
        this.jLabel5.setLabelFor(this.modifierPanel);
        this.jLabel5.setText(NbBundle.getMessage((Class)AnnotationTypeMethodCustomizer.class, (String)"CTL_Modifiers"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.modifierPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.modifierPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void defValueTextFieldFocusLost(FocusEvent focusEvent) {
        if (focusEvent != null && (focusEvent.isTemporary() || !this.isAncestorOf(focusEvent.getOppositeComponent()))) {
            return;
        }
        String string = this.defValueTextField.getText().trim();
        string = string.length() > 0 ? string : null;
        String string2 = this.element.getDefaultValueText();
        boolean bl = false;
        try {
            if (string != null && string.equals(string2) || string == string2) {
                return;
            }
            this.element.setDefaultValueText(string);
            bl = true;
        }
        catch (JmiException jmiException) {
            ErrorManager.getDefault().notify((Throwable)jmiException);
        }
        this.isOK = bl;
        if (!bl) {
            string2 = string2 == null ? "" : string2;
            this.defValueTextField.setText(string2);
        }
    }

    private void returnComboActionPerformed(ActionEvent actionEvent) {
        Object object = this.returnCombo.getSelectedItem();
        if (object == null) {
            return;
        }
        String string = object.toString().trim();
        Type type = this.element.getType();
        boolean bl = false;
        try {
            Type type2 = this.getJModel().getType().resolve(string);
            if (type.equals(type2)) {
                return;
            }
            if (!TypeEditor.isValidTypeSyntax(string)) {
                AnnotationTypeMethodCustomizer.notifyUserWarning("MSG_Not_Valid_Type", "invalid type");
            } else if (!TypeEditor.isValidTypeOfAnnTypeMethod(type2)) {
                AnnotationTypeMethodCustomizer.notifyUserWarning("MSG_Not_Valid_Type", "invalid type");
            } else {
                this.element.setType(type2);
                bl = true;
            }
        }
        catch (JmiException jmiException) {
            ErrorManager.getDefault().notify((Throwable)jmiException);
        }
        this.isOK = bl;
        if (!bl) {
            this.returnCombo.setSelectedItem(ElementFormat.elementName((NamedElement)type));
        }
    }

    private void nameTextFieldFocusLost(FocusEvent focusEvent) {
        if (focusEvent != null && (focusEvent.isTemporary() || !this.isAncestorOf(focusEvent.getOppositeComponent()))) {
            return;
        }
        String string = this.nameTextField.getText().trim();
        String string2 = this.element.getName();
        boolean bl = false;
        try {
            if (!Utilities.isJavaIdentifier((String)string)) {
                AnnotationTypeMethodCustomizer.notifyUserWarning("MSG_Not_Valid_Type", "invalid type");
            } else {
                if (string2.equals(string)) {
                    return;
                }
                if (SourceEditSupport.findAttribute(this.jclass, string) != null) {
                    AnnotationTypeMethodCustomizer.notifyUserWarning("MSG_Used_Identifier", string, "invalid name");
                } else {
                    this.element.setName(string);
                    bl = true;
                }
            }
        }
        catch (JmiException jmiException) {
            ErrorManager.getDefault().notify((Throwable)jmiException);
        }
        this.isOK = bl;
        if (!bl) {
            this.nameTextField.setText(string2);
        }
    }

    private void initAccessibility() {
        this.nameTextField.getAccessibleContext().setAccessibleName(AnnotationTypeMethodCustomizer.getString("ACS_MethodNameTextField"));
        this.nameTextField.getAccessibleContext().setAccessibleDescription(AnnotationTypeMethodCustomizer.getString("ACS_MethodNameTextField"));
        this.defValueTextField.getAccessibleContext().setAccessibleName(AnnotationTypeMethodCustomizer.getString("ACSN_DefaultValue"));
        this.defValueTextField.getAccessibleContext().setAccessibleDescription(AnnotationTypeMethodCustomizer.getString("ACSD_DefaultValue"));
        this.getAccessibleContext().setAccessibleDescription(AnnotationTypeMethodCustomizer.getString("ACSD_AnnotationTypeMethodCustomizer"));
    }

    public boolean isOK() {
        this.nameTextFieldFocusLost(null);
        if (this.isOK) {
            this.returnComboActionPerformed(null);
        }
        if (this.isOK) {
            this.defValueTextFieldFocusLost(null);
        }
        return this.isOK;
    }

    private JavaModelPackage getJModel() {
        return JavaMetamodel.getManager().getJavaExtent((Element)this.jclass);
    }

    private static String getString(String string) {
        return NbBundle.getMessage((Class)AnnotationTypeMethodCustomizer.class, (String)string);
    }

    private static void notifyUserWarning(String string, String string2) {
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string2);
        ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, null, AnnotationTypeMethodCustomizer.getString(string), null, null);
        ErrorManager.getDefault().notify((Throwable)illegalArgumentException);
    }

    private static void notifyUserWarning(String string, String string2, String string3) {
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string3);
        ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, null, NbBundle.getMessage((Class)AnnotationTypeMethodCustomizer.class, (String)string, (Object)string2), null, null);
        ErrorManager.getDefault().notify((Throwable)illegalArgumentException);
    }
}

