/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.modules.java.ui.nodes.SourceNodeFactory;
import org.netbeans.modules.java.ui.nodes.elements.AnnotationTypeChildren;
import org.netbeans.modules.java.ui.nodes.elements.AnnotationTypeFilter;
import org.netbeans.modules.java.ui.nodes.elements.ClassChildren;
import org.netbeans.modules.java.ui.nodes.elements.ClassElementFilter;
import org.netbeans.modules.java.ui.nodes.elements.ElementNode;
import org.netbeans.modules.java.ui.nodes.elements.EnumChildren;
import org.netbeans.modules.java.ui.nodes.elements.EnumFilter;
import org.netbeans.modules.java.ui.nodes.elements.SourceEditSupport;
import org.openide.actions.NewAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.ToolsAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;

public final class Categories {
    private static final Object CATEGORY_FIELDS = new Object();
    private static final Object CATEGORY_METHODS = new Object();
    private static final Object CATEGORY_CONSTRUCTORS = new Object();
    private static final Object CATEGORY_CONSTANTS = new Object();
    private static final Object CATEGORY_ANN_TYPE_METHODS = new Object();
    private static final List CLASS_CATEGORIES;
    private static final List INTERFACE_CATEGORIES;
    private static final List ENUM_CATEGORIES;
    private static final List ANNTYPES_CATEGORIES;
    public static final int FILTER_CATEGORIES = 4096;
    private static final SystemAction[] CATEGORY_ACTIONS;
    static final int[][] FILTERS;
    static final String[] NAMES;
    static final String[] SHORTDESCRS;
    static final String[] CATEGORY_ICONS;

    public static final Children createClassChildren(ClassDefinition classDefinition, SourceNodeFactory sourceNodeFactory, boolean bl) {
        if (ElementNode.getSourceOptions().getCategoriesUsage()) {
            CategorizingChildren categorizingChildren = new CategorizingChildren(sourceNodeFactory, classDefinition, bl);
            ClassElementFilter classElementFilter = new ClassElementFilter();
            classElementFilter.setOrder(new int[]{2, 4, 16, 8, 4096});
            categorizingChildren.setFilter(classElementFilter);
            return categorizingChildren;
        }
        return new ClassChildren(sourceNodeFactory, classDefinition);
    }

    public static final Children createEnumChildren(JavaEnum javaEnum, SourceNodeFactory sourceNodeFactory, boolean bl) {
        if (ElementNode.getSourceOptions().getCategoriesUsage()) {
            CategorizingChildren categorizingChildren = new CategorizingChildren(sourceNodeFactory, (ClassDefinition)javaEnum, bl);
            EnumFilter enumFilter = new EnumFilter();
            enumFilter.setOrder(new int[]{2, 4, 16, 8, 4096});
            categorizingChildren.setFilter(enumFilter);
            return categorizingChildren;
        }
        return new EnumChildren(sourceNodeFactory, javaEnum);
    }

    public static final Children createAnnotationTypeChildren(AnnotationType annotationType, SourceNodeFactory sourceNodeFactory, boolean bl) {
        if (ElementNode.getSourceOptions().getCategoriesUsage()) {
            CategorizingChildren categorizingChildren = new CategorizingChildren(sourceNodeFactory, (ClassDefinition)annotationType, bl);
            AnnotationTypeFilter annotationTypeFilter = new AnnotationTypeFilter();
            annotationTypeFilter.setOrder(new int[]{2, 4, 16, 8, 4096});
            categorizingChildren.setFilter(annotationTypeFilter);
            return categorizingChildren;
        }
        return new AnnotationTypeChildren(sourceNodeFactory, annotationType);
    }

    private static String getString(String string) {
        return NbBundle.getMessage((Class)Categories.class, (String)string);
    }

    static {
        CATEGORY_ACTIONS = new SystemAction[]{SystemAction.get((Class)NewAction.class), null, SystemAction.get((Class)ToolsAction.class), SystemAction.get((Class)PropertiesAction.class)};
        FILTERS = new int[][]{{64}, {32}, {128}, {1024}, {1024}};
        NAMES = new String[]{Categories.getString("Fields"), Categories.getString("Constructors"), Categories.getString("Methods"), Categories.getString("Constants"), Categories.getString("AnnTypeMethods")};
        SHORTDESCRS = new String[]{Categories.getString("Fields_HINT"), Categories.getString("Constructors_HINT"), Categories.getString("Methods_HINT"), Categories.getString("Constants_HINT"), Categories.getString("AnnTypeMethods_HINT")};
        CATEGORY_ICONS = new String[]{"org/openide/src/resources/variables", "org/openide/src/resources/constructors", "org/openide/src/resources/methods", "org/netbeans/modules/java/resources/constants", "org/openide/src/resources/methods"};
        CLASS_CATEGORIES = new ArrayList(4);
        CLASS_CATEGORIES.add(CATEGORY_FIELDS);
        CLASS_CATEGORIES.add(CATEGORY_CONSTRUCTORS);
        CLASS_CATEGORIES.add(CATEGORY_METHODS);
        INTERFACE_CATEGORIES = new ArrayList(2);
        INTERFACE_CATEGORIES.add(CATEGORY_FIELDS);
        INTERFACE_CATEGORIES.add(CATEGORY_METHODS);
        ENUM_CATEGORIES = new ArrayList(4);
        ENUM_CATEGORIES.add(CATEGORY_CONSTANTS);
        ENUM_CATEGORIES.add(CATEGORY_FIELDS);
        ENUM_CATEGORIES.add(CATEGORY_CONSTRUCTORS);
        ENUM_CATEGORIES.add(CATEGORY_METHODS);
        ANNTYPES_CATEGORIES = new ArrayList(2);
        ANNTYPES_CATEGORIES.add(CATEGORY_FIELDS);
        ANNTYPES_CATEGORIES.add(CATEGORY_ANN_TYPE_METHODS);
    }

    static final class ElementCategoryNode
    extends AbstractNode {
        ClassDefinition element;
        int newTypeIndex;

        private static ClassChildren createChildren(SourceNodeFactory sourceNodeFactory, ClassDefinition classDefinition) {
            ClassChildren classChildren = classDefinition instanceof AnnotationType ? new AnnotationTypeChildren(sourceNodeFactory, (AnnotationType)classDefinition) : (classDefinition instanceof JavaEnum ? new EnumChildren(sourceNodeFactory, (JavaEnum)classDefinition) : new ClassChildren(sourceNodeFactory, classDefinition));
            return classChildren;
        }

        ElementCategoryNode(int n, SourceNodeFactory sourceNodeFactory, ClassDefinition classDefinition, boolean bl) {
            this(n, ElementCategoryNode.createChildren(sourceNodeFactory, classDefinition));
            this.element = classDefinition;
            this.newTypeIndex = bl ? n : -1;
            switch (n) {
                case 0: {
                    this.setName("Fields");
                    break;
                }
                case 1: {
                    this.setName("Constructors");
                    break;
                }
                case 2: {
                    this.setName("Methods");
                    break;
                }
                case 3: {
                    this.setName("Constants");
                    break;
                }
                case 4: {
                    this.setName("AnnTypeMethods");
                }
            }
        }

        private ElementCategoryNode(int n, ClassChildren classChildren) {
            super((Children)classChildren);
            this.setDisplayName(NAMES[n]);
            this.setShortDescription(SHORTDESCRS[n]);
            ClassElementFilter classElementFilter = new ClassElementFilter();
            classElementFilter.setOrder(FILTERS[n]);
            classChildren.setFilter(classElementFilter);
            this.systemActions = CATEGORY_ACTIONS;
            this.setIconBase(CATEGORY_ICONS[n]);
        }

        public boolean canCopy() {
            return false;
        }

        public NewType[] getNewTypes() {
            if (!SourceEditSupport.isWriteable((Element)this.element) || !(this.element instanceof JavaClass)) {
                return new NewType[0];
            }
            JavaClass javaClass = (JavaClass)this.element;
            switch (this.newTypeIndex) {
                case 0: {
                    return new NewType[]{new SourceEditSupport.ElementNewType(javaClass, 1)};
                }
                case 1: {
                    return new NewType[]{new SourceEditSupport.ElementNewType(javaClass, 0), new SourceEditSupport.ElementNewType(javaClass, 2)};
                }
                case 2: {
                    return new NewType[]{new SourceEditSupport.ElementNewType(javaClass, 3)};
                }
                case 3: {
                    return new NewType[]{new SourceEditSupport.ElementNewType(javaClass, 7)};
                }
                case 4: {
                    return new NewType[]{new SourceEditSupport.ElementNewType(javaClass, 13)};
                }
            }
            return super.getNewTypes();
        }
    }

    static final class CategorizingChildren
    extends ClassChildren {
        boolean writeable;

        CategorizingChildren(SourceNodeFactory sourceNodeFactory, ClassDefinition classDefinition, boolean bl) {
            super(sourceNodeFactory, classDefinition);
            this.writeable = bl;
        }

        protected Node[] createNodesImpl(Object object) {
            if (object == CATEGORY_FIELDS) {
                return new Node[]{new ElementCategoryNode(0, this.getFactory(), this.element, this.writeable)};
            }
            if (object == CATEGORY_METHODS) {
                return new Node[]{new ElementCategoryNode(2, this.getFactory(), this.element, this.writeable)};
            }
            if (object == CATEGORY_CONSTRUCTORS) {
                return new Node[]{new ElementCategoryNode(1, this.getFactory(), this.element, this.writeable)};
            }
            if (object == CATEGORY_CONSTANTS) {
                return new Node[]{new ElementCategoryNode(3, this.getFactory(), this.element, this.writeable)};
            }
            if (object == CATEGORY_ANN_TYPE_METHODS) {
                return new Node[]{new ElementCategoryNode(4, this.getFactory(), this.element, this.writeable)};
            }
            return super.createNodesImpl(object);
        }

        protected List getKeysOfType(Collection collection, int n) {
            if (n != 4096) {
                return super.getKeysOfType(collection, n);
            }
            if (this.element instanceof JavaEnum) {
                return ENUM_CATEGORIES;
            }
            if (this.element instanceof AnnotationType) {
                return ANNTYPES_CATEGORIES;
            }
            if (this.element instanceof JavaClass && ((JavaClass)this.element).isInterface()) {
                return INTERFACE_CATEGORIES;
            }
            return CLASS_CATEGORIES;
        }

        static {
            ClassChildren.propToFilter.put("classOrInterface", new Integer(4096));
        }
    }
}

