/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.jmi.reflect.InvalidObjectException;
import javax.jmi.reflect.JmiException;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;

final class ChildrenProvider
implements Runnable {
    static final RequestProcessor RP = new RequestProcessor("Java Children Provider");
    private RequestProcessor.Task currentTask;
    private Map nodes = this.initNodeMap();
    private List elements;
    private final KeyHandler keyHandler;

    public ChildrenProvider(KeyHandler keyHandler) {
        this.keyHandler = keyHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Map map;
        List list;
        JMManager.getTransactionMutex().addPriorityThread();
        try {
            list = this.keyHandler.collectKeys();
            map = this.createNodeMap(this.nodes, list);
        }
        catch (InvalidObjectException invalidObjectException) {
            list = Collections.EMPTY_LIST;
            map = Collections.EMPTY_MAP;
        }
        catch (JmiException jmiException) {
            list = Collections.EMPTY_LIST;
            map = Collections.EMPTY_MAP;
            ErrorManager.getDefault().notify(16, (Throwable)jmiException);
        }
        ChildrenProvider childrenProvider = this;
        synchronized (childrenProvider) {
            this.elements = list;
            this.nodes = map;
        }
        this.presentKeys(list, map);
    }

    private void presentKeys(List list, Map map) {
        ArrayList<Node[]> arrayList = new ArrayList<Node[]>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Node[] nodeArray = (Node[])map.get(e);
            arrayList.add(nodeArray);
        }
        this.keyHandler.presentKeys(list, arrayList);
    }

    private Map initNodeMap() {
        WeakHashMap weakHashMap = new WeakHashMap();
        return weakHashMap;
    }

    public synchronized void recomputeChildren() {
        if (this.currentTask == null) {
            this.currentTask = RP.post((Runnable)this);
        } else {
            this.currentTask.schedule(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getNode(Object object) {
        Node[] nodeArray = null;
        ChildrenProvider childrenProvider = this;
        synchronized (childrenProvider) {
            nodeArray = (Node[])this.nodes.get(object);
        }
        return nodeArray == null ? null : nodeArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getKeys() {
        this.computeChildren();
        ChildrenProvider childrenProvider = this;
        synchronized (childrenProvider) {
            return this.elements;
        }
    }

    public void waitFinished() {
        this.computeChildren();
    }

    public void clear() {
        RP.post((Runnable)new CleanTask());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearImpl() {
        ChildrenProvider childrenProvider = this;
        synchronized (childrenProvider) {
            this.elements = Collections.EMPTY_LIST;
            this.nodes = Collections.EMPTY_MAP;
        }
        this.presentKeys(this.elements, this.nodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeChildren() {
        ChildrenProvider childrenProvider = this;
        synchronized (childrenProvider) {
            if (this.currentTask == null) {
                this.recomputeChildren();
            }
        }
        this.currentTask.waitFinished();
    }

    private Map createNodeMap(final Map map, final List list) throws JmiException {
        final Map map2 = this.initNodeMap();
        if (list.isEmpty()) {
            return map2;
        }
        JmiException jmiException = (JmiException)((Object)Children.MUTEX.readAccess(new Mutex.Action(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object run() {
                try {
                    JMManager.getTransactionMutex().addPriorityThread();
                    JavaMetamodel.getDefaultRepository().beginTrans(false);
                    try {
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            Node[] nodeArray;
                            Object e = iterator.next();
                            if (e instanceof Element && !((Element)e).isValid()) {
                                map2.clear();
                                list.clear();
                                nodeArray = null;
                                return nodeArray;
                            }
                            nodeArray = (Node[])map.get(e);
                            if (nodeArray == null) {
                                nodeArray = ChildrenProvider.this.keyHandler.prepareNodes(e);
                            }
                            map2.put(e, nodeArray);
                        }
                        return null;
                    }
                    finally {
                        JavaMetamodel.getDefaultRepository().endTrans();
                    }
                }
                catch (JmiException jmiException) {
                    return jmiException;
                }
            }
        }));
        if (jmiException != null) {
            throw jmiException;
        }
        return map2;
    }

    private final class CleanTask
    implements Runnable {
        private CleanTask() {
        }

        public void run() {
            ChildrenProvider.this.clearImpl();
        }
    }

    static interface KeyHandler {
        public List collectKeys();

        public Node[] prepareNodes(Object var1);

        public void presentKeys(List var1, List var2);
    }
}

