/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.elements;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jmi.reflect.InvalidObjectException;
import javax.jmi.reflect.JmiException;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.MDRChangeSource;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Attribute;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.EnumConstant;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Initializer;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.modules.java.ui.nodes.SourceNodeFactory;
import org.netbeans.modules.java.ui.nodes.elements.ChildrenProvider;
import org.netbeans.modules.java.ui.nodes.elements.ClassElementFilter;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.cookies.FilterCookie;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

public class ClassChildren
extends Children.Keys
implements FilterCookie,
ChildrenProvider.KeyHandler {
    private static int PPP_MASK = 7;
    protected static HashMap propToFilter;
    private static Comparator comparator;
    protected ClassDefinition element;
    protected ClassElementFilter filter;
    private SourceNodeFactory factory;
    private JMIElementListener wPropL;
    private boolean nodesInited = false;
    private final ChildrenProvider chprovider = new ChildrenProvider(this);

    public ClassChildren(SourceNodeFactory sourceNodeFactory, ClassDefinition classDefinition) {
        if (sourceNodeFactory == null) {
            throw new NullPointerException("factory");
        }
        if (classDefinition == null) {
            throw new NullPointerException("element");
        }
        this.element = classDefinition;
        this.factory = sourceNodeFactory;
        this.filter = null;
    }

    protected SourceNodeFactory getFactory() {
        return this.factory;
    }

    public Class getFilterClass() {
        return ClassElementFilter.class;
    }

    public Object getFilter() {
        return this.filter;
    }

    public void setFilter(Object object) {
        if (!(object instanceof ClassElementFilter)) {
            throw new IllegalArgumentException();
        }
        this.filter = (ClassElementFilter)object;
        if (this.nodesInited) {
            this.refreshAllKeys();
        }
    }

    protected void addNotify() {
        super.addNotify();
        if (this.wPropL == null) {
            this.wPropL = new JMIElementListener(this);
        }
        this.refreshAllKeys();
        ((MDRChangeSource)this.element).addListener((MDRChangeListener)this.wPropL);
        this.nodesInited = true;
    }

    protected void removeNotify() {
        this.chprovider.clear();
        this.nodesInited = false;
        super.removeNotify();
    }

    protected final void hookNodeName(Element element) {
        if (element instanceof MDRChangeSource) {
            ((MDRChangeSource)element).addListener((MDRChangeListener)this.wPropL);
        }
    }

    protected final Node[] createNodes(Object object) {
        Node[] nodeArray;
        if (object instanceof Node) {
            nodeArray = new Node[]{new FilterNode((Node)object)};
        } else if (object instanceof Node[]) {
            Node[] nodeArray2 = (Node[])object;
            nodeArray = new Node[nodeArray2.length];
            for (int i = 0; i < nodeArray2.length; ++i) {
                Node node = nodeArray2[i];
                nodeArray[i] = node == null ? node : new FilterNode(node);
            }
        } else {
            nodeArray = new Node[]{this.factory.createErrorNode()};
            ErrorManager.getDefault().notify(16, (Throwable)new IllegalStateException("key: " + object));
        }
        return nodeArray;
    }

    protected Node[] createNodesImpl(Object object) throws JmiException {
        Node node;
        if (object instanceof Method) {
            Method method = (Method)object;
            this.hookNodeName((Element)method);
            node = this.factory.createMethodNode(method);
        } else if (object instanceof Field) {
            Field field = (Field)object;
            this.hookNodeName((Element)field);
            node = this.factory.createFieldNode(field);
        } else if (object instanceof Constructor) {
            node = this.factory.createConstructorNode((Constructor)object);
        } else if (object instanceof JavaEnum) {
            JavaEnum javaEnum = (JavaEnum)object;
            this.hookNodeName((Element)javaEnum);
            node = this.factory.createEnumNode(javaEnum);
        } else if (object instanceof AnnotationType) {
            AnnotationType annotationType = (AnnotationType)object;
            this.hookNodeName((Element)annotationType);
            node = this.factory.createAnnotationTypeNode(annotationType);
        } else if (object instanceof JavaClass) {
            JavaClass javaClass = (JavaClass)object;
            this.hookNodeName((Element)javaClass);
            node = this.factory.createClassNode(javaClass);
        } else {
            node = object instanceof Initializer ? this.factory.createInitializerNode((Initializer)object) : this.factory.createErrorNode();
        }
        return new Node[]{node};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final List collectKeys() {
        List list = new LinkedList();
        int[] nArray = this.getOrder();
        try {
            JavaMetamodel.getDefaultRepository().beginTrans(false);
            try {
                if (!this.element.isValid()) {
                    List list2 = list;
                    return list2;
                }
                List list3 = this.element.getFeatures();
                ArrayList arrayList = new ArrayList(list3.size());
                this.filterModifiers(list3, arrayList);
                int i = 0;
                while (i < nArray.length) {
                    List list4 = this.getKeysOfType(arrayList, nArray[i]);
                    if (this.filter == null || this.filter.isSorted()) {
                        Collections.sort(list4, comparator);
                    }
                    list.addAll(list4);
                    ++i;
                }
                return list;
            }
            finally {
                JavaMetamodel.getDefaultRepository().endTrans();
            }
        }
        catch (InvalidObjectException invalidObjectException) {
            return Collections.EMPTY_LIST;
        }
        catch (JmiException jmiException) {
            ErrorManager.getDefault().notify(16, (Throwable)jmiException);
        }
        return list;
    }

    public Node[] prepareNodes(Object object) {
        return this.createNodesImpl(object);
    }

    public void presentKeys(List list, List list2) {
        JMIElementListener jMIElementListener = this.wPropL;
        if (jMIElementListener != null) {
            jMIElementListener.updateElements(list);
        }
        this.setKeys(list2);
    }

    public Node[] getNodes(boolean bl) {
        if (!bl) {
            return this.getNodes();
        }
        this.chprovider.waitFinished();
        return this.getNodes();
    }

    public Node findChild(String string) {
        Node node = super.findChild(string);
        if (node == null) {
            this.chprovider.waitFinished();
            node = super.findChild(string);
        }
        return node;
    }

    protected void refreshAllKeys() {
        this.refreshKeys(1023);
    }

    protected final void refreshKeys(int n) {
        if (!this.doRefresh(n)) {
            return;
        }
        this.chprovider.recomputeChildren();
    }

    private boolean doRefresh(int n) {
        int[] nArray = this.getOrder();
        for (int i = nArray.length - 1; i >= 0; --i) {
            if ((nArray[i] & n) == 0) continue;
            return true;
        }
        return false;
    }

    protected List getKeysOfType(Collection collection, int n) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        if ((n & 0x100) != 0) {
            linkedList.add(this.element.getSuperClass());
        }
        if ((n & 0x200) != 0) {
            linkedList.addAll(this.element.getInterfaces());
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if ((n & 0x40) != 0 && e instanceof Field && !(e instanceof EnumConstant)) {
                linkedList.add(e);
            } else if ((n & 0x20) != 0 && (e instanceof Constructor || e instanceof Initializer)) {
                linkedList.add(e);
            } else if ((n & 0x80) != 0 && e instanceof Method) {
                linkedList.add(e);
            }
            if (!(e instanceof JavaClass)) continue;
            boolean bl = ((JavaClass)e).isInterface();
            if ((n & 2) != 0 && !bl) {
                linkedList.add(e);
                continue;
            }
            if ((n & 4) == 0 || !bl) continue;
            linkedList.add(e);
        }
        return linkedList;
    }

    protected int[] getOrder() {
        return this.filter == null || this.filter.getOrder() == null ? ClassElementFilter.DEFAULT_ORDER : this.filter.getOrder();
    }

    private int getModifierFilter() {
        if (this.filter == null) {
            return 65543;
        }
        return this.filter.getModifiers();
    }

    private void filterModifiers(Collection collection, Collection collection2) {
        int n = this.getModifierFilter();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ClassMember classMember = (ClassMember)iterator.next();
            int n2 = classMember.getModifiers();
            if ((n2 & PPP_MASK) == 0) {
                n2 += 65536;
            }
            if ((n2 & n) == 0) continue;
            collection2.add(classMember);
        }
    }

    static {
        comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                if (object instanceof NamedElement) {
                    if (object2 instanceof NamedElement) {
                        String string = this.getName((NamedElement)object);
                        String string2 = this.getName((NamedElement)object2);
                        if (string == null || string2 == null) {
                            return 1;
                        }
                        return string.compareToIgnoreCase(string2);
                    }
                    return -1;
                }
                if (object2 instanceof NamedElement) {
                    return 1;
                }
                return 0;
            }

            private String getName(NamedElement namedElement) {
                String string = namedElement instanceof Constructor ? ((Constructor)namedElement).getDeclaringClass().getName() : (namedElement instanceof Initializer ? "" : namedElement.getName());
                return string;
            }
        };
        propToFilter = new HashMap();
        propToFilter.put("classes", new Integer(6));
        propToFilter.put("methods", new Integer(128));
        propToFilter.put("fields", new Integer(64));
        propToFilter.put("constructors", new Integer(32));
        propToFilter.put("initializers", new Integer(32));
    }

    private static final class JMIElementListener
    extends WeakReference
    implements Runnable,
    MDRChangeListener {
        Collection elements;
        MDRChangeSource celem;

        JMIElementListener(ClassChildren classChildren) {
            super(classChildren, Utilities.activeReferenceQueue());
            this.celem = (MDRChangeSource)classChildren.element;
        }

        ClassChildren getClassChildren() {
            Object t = this.get();
            return (ClassChildren)t;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void change(MDRChangeEvent mDRChangeEvent) {
            int n;
            Object object = mDRChangeEvent.getSource();
            if (object instanceof Element && !((Element)object).isValid()) {
                return;
            }
            ClassChildren classChildren = this.getClassChildren();
            if (classChildren == null || !(mDRChangeEvent instanceof AttributeEvent)) {
                return;
            }
            AttributeEvent attributeEvent = (AttributeEvent)mDRChangeEvent;
            String string = attributeEvent.getAttributeName();
            if (object != classChildren.element) {
                if (!(object instanceof Element) || string != null && "name" != string) return;
                n = this.chooseFilter((Element)object);
            } else if ("contents".equals(string)) {
                Element element = (Element)attributeEvent.getOldElement();
                element = element == null ? (Element)attributeEvent.getNewElement() : element;
                n = this.chooseFilter(element);
            } else {
                if (!"constants".equals(string)) return;
                n = 1024;
            }
            if (!classChildren.nodesInited) return;
            classChildren.refreshKeys(n);
        }

        int chooseFilter(Element element) {
            int n = element instanceof Method ? 128 : (element instanceof Constructor || element instanceof Initializer ? 32 : (element instanceof Field ? 64 : (element instanceof EnumConstant ? 1024 : (element instanceof Attribute ? 1024 : 30))));
            return n;
        }

        void updateElements(Collection collection) {
            Collection collection2 = this.elements;
            if (collection2 != null) {
                collection2.removeAll(collection);
                this.removeListeners(collection2);
            }
            this.elements = collection;
        }

        public void run() {
            this.celem.removeListener((MDRChangeListener)this);
            this.removeListeners(this.elements);
        }

        private void removeListeners(Collection collection) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof MDRChangeSource)) continue;
                MDRChangeSource mDRChangeSource = (MDRChangeSource)e;
                mDRChangeSource.removeListener((MDRChangeListener)this);
            }
        }
    }
}

