/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.elements;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.jmi.reflect.JmiException;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.ui.nodes.elements.ClassNode;
import org.netbeans.modules.java.ui.nodes.elements.SourceEditSupport;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class ClassCustomizer
extends JPanel {
    private static final String[] COMMON_TYPES = new String[]{"java.lang.Object", "java.awt.Component", "javax.swing.JComponent", "javax.swing.JPanel"};
    private final JavaClass element;
    private final JavaClass jclass;
    private final Resource resource;
    private boolean isOK = true;
    private JPanel accessPanel;
    private JPanel interfacesPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel modifierPanel;
    private JTextField nameTextField;
    private JComboBox superClassCombo;
    private JTextField typeTextField;

    public ClassCustomizer(JavaClass javaClass, JavaClass javaClass2) {
        this(null, javaClass, javaClass2);
    }

    public ClassCustomizer(Resource resource, JavaClass javaClass) {
        this(resource, null, javaClass);
    }

    private ClassCustomizer(Resource resource, JavaClass javaClass, JavaClass javaClass2) {
        this.resource = resource;
        this.jclass = javaClass;
        this.element = javaClass2;
        this.initComponents();
        this.interfacesPanel.setBorder(new TitledBorder(NbBundle.getMessage((Class)ClassCustomizer.class, (String)"CTL_Interfaces")));
        int n = 1025;
        if (resource == null) {
            n |= 0xE;
        }
        if (!javaClass2.isInterface()) {
            n |= 0x10;
        }
        this.accessPanel.add((Component)SourceEditSupport.createAccessModifiersPanel((ClassMember)javaClass2, n), "Center");
        this.modifierPanel.add((Component)SourceEditSupport.createOtherModifiersPanel((ClassMember)javaClass2, n), "Center");
        if (javaClass2.isInterface()) {
            this.superClassCombo.setEnabled(false);
            this.jLabel2.setVisible(false);
            this.superClassCombo.setVisible(false);
        } else {
            JavaClass javaClass3 = javaClass2.getSuperClass();
            this.superClassCombo.setSelectedItem(javaClass3 == null ? "" : javaClass3.getName());
        }
        this.nameTextField.setText(javaClass2.getSimpleName());
        this.interfacesPanel.add((Component)new PropertyPanel(ClassNode.createInterfacesProperty(javaClass2, true), 2), "Center");
        this.jLabel1.setDisplayedMnemonic(NbBundle.getMessage((Class)ClassCustomizer.class, (String)"CTL_Name_Mnemonic").charAt(0));
        this.jLabel2.setDisplayedMnemonic(NbBundle.getMessage((Class)ClassCustomizer.class, (String)"CTL_Type_Mnemonic").charAt(0));
        this.jLabel3.setVisible(false);
        this.typeTextField.setVisible(false);
        this.initAccessibility();
    }

    public void addNotify() {
        super.addNotify();
        int n = this.nameTextField.getText().length();
        this.nameTextField.setCaretPosition(0);
        this.nameTextField.moveCaretPosition(n);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ClassCustomizer.this.nameTextField.requestFocus();
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.nameTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.typeTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.superClassCombo = new JComboBox<String>(COMMON_TYPES);
        this.jLabel4 = new JLabel();
        this.accessPanel = new JPanel();
        this.jLabel5 = new JLabel();
        this.modifierPanel = new JPanel();
        this.interfacesPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(6, 6, 6, 6)));
        this.jLabel1.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage((Class)ClassCustomizer.class, (String)"CTL_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.nameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                ClassCustomizer.this.nameTextFieldFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 8, 0, 0);
        this.add((Component)this.nameTextField, gridBagConstraints);
        this.nameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ClassCustomizer.class, (String)"ACSD_ClassNameTextField"));
        this.jLabel3.setLabelFor(this.typeTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage((Class)ClassCustomizer.class, (String)"CTL_Generic_Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.typeTextField, gridBagConstraints);
        this.typeTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ClassCustomizer.class, (String)"ACSD_ClassType"));
        this.jLabel2.setLabelFor(this.superClassCombo);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage((Class)ClassCustomizer.class, (String)"CTL_Superclass"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.superClassCombo.setEditable(true);
        this.superClassCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassCustomizer.this.superClassComboActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.superClassCombo, gridBagConstraints);
        this.superClassCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ClassCustomizer.class, (String)"ACSD_SuperClass"));
        this.jLabel4.setLabelFor(this.accessPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage((Class)ClassCustomizer.class, (String)"CTL_AccessRights"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.accessPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.accessPanel, gridBagConstraints);
        this.jLabel5.setLabelFor(this.modifierPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage((Class)ClassCustomizer.class, (String)"CTL_Modifiers"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.modifierPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.modifierPanel, gridBagConstraints);
        this.interfacesPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.interfacesPanel, gridBagConstraints);
    }

    private void superClassComboActionPerformed(ActionEvent actionEvent) {
        if (!this.superClassCombo.isEnabled()) {
            return;
        }
        JavaClass javaClass = this.element.getSuperClass();
        String string = javaClass == null ? "" : javaClass.getName();
        Object object = this.superClassCombo.getSelectedItem();
        if (object == null) {
            this.superClassCombo.setSelectedItem(string);
            return;
        }
        String string2 = object.toString().trim();
        boolean bl = false;
        if (!string.equals(string2)) {
            try {
                MultipartId multipartId = this.getJModel().getMultipartId().createMultipartId(string2, null, null);
                this.element.setSuperClassName(multipartId);
                bl = true;
            }
            catch (JmiException jmiException) {
                ErrorManager.getDefault().notify((Throwable)jmiException);
            }
        } else {
            return;
        }
        this.isOK = bl;
        if (!bl) {
            this.superClassCombo.setSelectedItem(string);
        }
    }

    private void nameTextFieldFocusLost(FocusEvent focusEvent) {
        if (focusEvent != null && (focusEvent.isTemporary() || !this.isAncestorOf(focusEvent.getOppositeComponent()))) {
            return;
        }
        String string = this.nameTextField.getText().trim();
        String string2 = this.element.getSimpleName();
        boolean bl = false;
        if (!Utilities.isJavaIdentifier((String)string)) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid name: " + string);
            ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, null, NbBundle.getMessage((Class)ClassCustomizer.class, (String)"MSG_Not_Valid_Identifier"), null, null);
            ErrorManager.getDefault().notify((Throwable)illegalArgumentException);
        } else {
            if (string2.equals(string)) {
                return;
            }
            if (this.resource == null && this.jclass.getInnerClass(string, true) != null) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid name: " + string);
                ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, null, NbBundle.getMessage((Class)ClassCustomizer.class, (String)"MSG_Not_Valid_Identifier"), null, null);
                ErrorManager.getDefault().notify((Throwable)illegalArgumentException);
            } else if (this.jclass == null && SourceEditSupport.findTopLevelClass(this.resource, string) != null) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid name: " + string);
                ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, null, NbBundle.getMessage((Class)ClassCustomizer.class, (String)"MSG_Not_Valid_Identifier"), null, null);
                ErrorManager.getDefault().notify((Throwable)illegalArgumentException);
            } else {
                try {
                    this.element.setSimpleName(string);
                    bl = true;
                }
                catch (JmiException jmiException) {
                    ErrorManager.getDefault().notify((Throwable)jmiException);
                }
            }
        }
        this.isOK = bl;
        if (!bl) {
            this.nameTextField.setText(string2);
        }
    }

    private void initAccessibility() {
        this.nameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)ClassCustomizer.class, (String)"ACS_ClassNameTextField"));
        this.nameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ClassCustomizer.class, (String)"ACS_ClassNameTextField"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ClassCustomizer.class, (String)"ACSD_ClassCustomizerDialog"));
    }

    public boolean isOK() {
        this.superClassComboActionPerformed(null);
        if (this.isOK) {
            this.nameTextFieldFocusLost(null);
        }
        return this.isOK;
    }

    private JavaModelPackage getJModel() {
        return this.jclass != null ? JavaMetamodel.getManager().getJavaExtent((Element)this.jclass) : JavaMetamodel.getManager().getJavaExtent((Element)this.resource);
    }
}

