/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.elements;

import java.beans.FeatureDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jmi.reflect.JmiException;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.GenericElement;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.modules.java.ui.nodes.editors.IdentifierArrayEditor;
import org.netbeans.modules.java.ui.nodes.elements.ElementFormat;
import org.netbeans.modules.java.ui.nodes.elements.ElementNode;
import org.netbeans.modules.java.ui.nodes.elements.IconResolver;
import org.netbeans.modules.java.ui.nodes.elements.SourceEditSupport;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.datatransfer.NewType;

public final class ClassNode
extends ElementNode {
    private static final String[] ICON_AFFECTING_PROPERTIES = new String[]{"modifiers"};
    private static final Map mapClassAttributeName;
    private static final Map mapInterfaceAttributeName;
    private boolean isInterface;
    private boolean isSheetCreated = false;
    private DataObject sourceDO;
    static /* synthetic */ Class array$Lorg$netbeans$jmi$javamodel$MultipartId;

    public ClassNode(JavaClass javaClass, Children children, boolean bl) {
        super((Element)javaClass, children, bl);
        this.init(javaClass);
    }

    private void init(JavaClass javaClass) {
        this.isInterface = javaClass.isInterface();
        this.setElementFormat0(ClassNode.getElementFormat(this.isInterface));
        this.superSetName(javaClass.getSimpleName());
        this.setIconBase(this.resolveIconBase());
        this.sourceDO = JavaMetamodel.getManager().getDataObject(javaClass.getResource());
    }

    private JavaClass getJavaClass() {
        return (JavaClass)this.element;
    }

    protected String resolveIconBase() {
        return IconResolver.getIconBaseForJavaClass(this.getJavaClass());
    }

    protected String[] getIconAffectingProperties() {
        return ICON_AFFECTING_PROPERTIES;
    }

    protected ElementFormat getElementFormatProperty() {
        return ClassNode.getElementFormat(this.isInterface);
    }

    protected ElementFormat getHintElementFormat() {
        return this.isInterface ? ClassNode.getSourceOptions().getInterfaceElementLongFormat() : ClassNode.getSourceOptions().getClassElementLongFormat();
    }

    private static ElementFormat getElementFormat(boolean bl) {
        return bl ? ClassNode.getSourceOptions().getInterfaceElementFormat() : ClassNode.getSourceOptions().getClassElementFormat();
    }

    protected Map getAttributeNameMap() {
        return this.isInterface ? mapInterfaceAttributeName : mapClassAttributeName;
    }

    protected ElementNode.ChangeDescriptor handleAttributeChange(AttributeEvent attributeEvent) {
        ElementNode.ChangeDescriptor changeDescriptor = super.handleAttributeChange(attributeEvent);
        Object object = attributeEvent.getSource();
        if (object != this.element || !((JavaClass)object).isValid()) {
            return changeDescriptor;
        }
        String string = attributeEvent.getAttributeName();
        JavaClass javaClass = this.getJavaClass();
        if ("modifiers".equals(string) && javaClass.isInterface() != this.isInterface) {
            this.isInterface = !this.isInterface;
            this.elementFormat = ClassNode.getElementFormat(this.isInterface);
            changeDescriptor.iconBase = this.resolveIconBase();
            changeDescriptor.displayName = this.getElementFormat().format((Element)javaClass);
            changeDescriptor.shortDescription = this.getShortDescription();
            if (this.isSheetCreated) {
                changeDescriptor.sheet = new Sheet();
            }
        }
        return changeDescriptor;
    }

    protected void processChange(ElementNode.ChangeDescriptor changeDescriptor) {
        if (changeDescriptor.sheet != null) {
            Sheet.Set set = this.getSheet().get("properties");
            this.configureSheetSet(set, this.isInterface);
            changeDescriptor.sheet = null;
        }
        super.processChange(changeDescriptor);
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        this.configureSheetSet(set, this.isInterface);
        this.isSheetCreated = true;
        return sheet;
    }

    private void configureSheetSet(Sheet.Set set, boolean bl) {
        set.put(this.createModifiersProperty(this.writeable));
        set.put(ClassNode.createNameProperty((NamedElement)this.getJavaClass()));
        set.put(this.createTypeParametersProperty());
        if (bl) {
            set.remove("superclass");
        } else {
            set.put(this.createSuperclassProperty(this.writeable));
        }
        set.put(this.createInterfacesProperty(this.writeable));
    }

    protected Node.Property createSuperclassProperty(boolean bl) {
        return new ElementNode.ElementProp("superclass", String.class, bl){

            public Object getValue() {
                MultipartId multipartId = ClassNode.this.getJavaClass().getSuperClassName();
                return multipartId == null ? "" : IdentifierArrayEditor.multipartIdToName(multipartId);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(object);
                if (!(object instanceof String)) {
                    throw new IllegalArgumentException();
                }
                String string = ((String)object).trim();
                if (string != null && !"".equals(string)) {
                    boolean bl = true;
                    try {
                        JavaMetamodel.getDefaultRepository().beginTrans(true);
                        try {
                            JavaModelPackage javaModelPackage = JavaMetamodel.getManager().getJavaExtent((Element)ClassNode.this.getJavaClass());
                            MultipartId multipartId = javaModelPackage.getMultipartId().createMultipartId(string, null, null);
                            ClassNode.this.getJavaClass().setSuperClassName(multipartId);
                            bl = false;
                        }
                        finally {
                            JavaMetamodel.getDefaultRepository().endTrans(bl);
                        }
                    }
                    catch (JmiException jmiException) {
                        IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                        illegalArgumentException.initCause(jmiException);
                        throw jmiException;
                    }
                }
            }
        };
    }

    protected Node.Property createInterfacesProperty(boolean bl) {
        Node.Property property = ClassNode.createInterfacesProperty(this.getJavaClass(), bl);
        if (this.isInterface) {
            property.setDisplayName(ClassNode.getString("PROP_superInterfaces"));
            property.setShortDescription(ClassNode.getString("HINT_superInterfaces"));
        }
        property.setValue("changeImmediate", (Object)Boolean.FALSE);
        ClassNode.setModel((Element)this.getJavaClass(), (FeatureDescriptor)property);
        return property;
    }

    Node.Property createTypeParametersProperty() {
        Node.Property property = ClassNode.createTypeParametersProperty("typeParameters", (GenericElement)this.getJavaClass(), false);
        property.setValue("changeImmediate", (Object)Boolean.FALSE);
        return property;
    }

    public NewType[] getNewTypes() {
        if (this.writeable) {
            boolean bl;
            boolean bl2 = bl = this.sourceDO != null ? SourceEditSupport.isJDK15Supported(this.sourceDO.getPrimaryFile()) : false;
            if (this.isInterface) {
                return SourceEditSupport.createInterfaceNewTypes(this.getJavaClass(), bl);
            }
            return SourceEditSupport.createClassNewTypes(this.getJavaClass(), bl);
        }
        return super.getNewTypes();
    }

    public static Node.Property createInterfacesProperty(JavaClass javaClass, boolean bl) {
        InterfacesProperty interfacesProperty = new InterfacesProperty(javaClass, bl);
        ClassNode.setModel((Element)javaClass, (FeatureDescriptor)((Object)interfacesProperty));
        return interfacesProperty;
    }

    static {
        mapInterfaceAttributeName = new HashMap();
        mapInterfaceAttributeName.put("modifiers", "modifiers");
        mapInterfaceAttributeName.put("name", "name");
        mapInterfaceAttributeName.put("interfaceNames", "interfaces");
        mapClassAttributeName = new HashMap(mapInterfaceAttributeName);
        mapClassAttributeName.put("superClassName", "superclass");
    }

    private static final class InterfacesProperty
    extends ElementNode.ElementProp {
        private final JavaClass element;

        public InterfacesProperty(JavaClass javaClass, boolean bl) {
            super("interfaces", array$Lorg$netbeans$jmi$javamodel$MultipartId == null ? (array$Lorg$netbeans$jmi$javamodel$MultipartId = ClassNode.class$("[Lorg.netbeans.jmi.javamodel.MultipartId;")) : array$Lorg$netbeans$jmi$javamodel$MultipartId, bl);
            this.element = javaClass;
        }

        protected PropertyEditor createPropertyEditor() {
            return new IdentifierArrayEditor();
        }

        public Object getValue() {
            return this.element.getInterfaceNames().toArray(new MultipartId[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            super.setValue(object);
            if (!(object instanceof MultipartId[])) {
                throw new IllegalArgumentException();
            }
            boolean bl = true;
            try {
                JavaMetamodel.getDefaultRepository().beginTrans(true);
                try {
                    List list = this.element.getInterfaceNames();
                    list.clear();
                    list.addAll(Arrays.asList((MultipartId[])object));
                    bl = false;
                }
                finally {
                    JavaMetamodel.getDefaultRepository().endTrans(bl);
                }
            }
            catch (JmiException jmiException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                illegalArgumentException.initCause(jmiException);
                throw jmiException;
            }
        }
    }
}

