/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.elements;

import java.awt.EventQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.jmi.reflect.JmiException;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.MDRChangeSource;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.java.ui.nodes.elements.ElementFormat;
import org.netbeans.modules.java.ui.nodes.elements.ElementNode;
import org.netbeans.modules.java.ui.nodes.elements.IconResolver;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Utilities;

public final class ConstructorNode
extends ElementNode {
    private static final Map mapAttributeName = new HashMap();

    public ConstructorNode(Constructor constructor, boolean bl) {
        super((Element)constructor, Children.LEAF, bl);
        this.setElementFormat0(this.getElementFormatProperty());
        this.superSetName(((JavaClass)constructor.getDeclaringClass()).getSimpleName());
        NameListener.getInstance(this, constructor);
    }

    protected String resolveIconBase() {
        return IconResolver.getIconBaseForConstructor(this.getConstructor());
    }

    protected ElementFormat getElementFormatProperty() {
        return ConstructorNode.getSourceOptions().getConstructorElementFormat();
    }

    protected ElementFormat getHintElementFormat() {
        return ConstructorNode.getSourceOptions().getConstructorElementLongFormat();
    }

    protected Map getAttributeNameMap() {
        return mapAttributeName;
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        set.put(this.createModifiersProperty(this.writeable));
        set.put(this.createNameProperty());
        set.put(this.createParametersProperty(false));
        set.put(this.createExceptionsProperty(this.writeable));
        return sheet;
    }

    public boolean canRename() {
        return false;
    }

    private Node.Property createNameProperty() {
        return new ElementNode.ElementProp("name", String.class, false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object getValue() throws IllegalAccessException, InvocationTargetException {
                String string;
                JavaMetamodel.getDefaultRepository().beginTrans(false);
                try {
                    String string2;
                    ClassDefinition classDefinition = ConstructorNode.this.getConstructor().getDeclaringClass();
                    string = string2 = classDefinition instanceof JavaClass ? ((JavaClass)classDefinition).getSimpleName() : classDefinition.getName();
                }
                catch (Throwable throwable) {
                    try {
                        JavaMetamodel.getDefaultRepository().endTrans();
                        throw throwable;
                    }
                    catch (JmiException jmiException) {
                        throw new InvocationTargetException(jmiException);
                    }
                }
                JavaMetamodel.getDefaultRepository().endTrans();
                return string;
            }
        };
    }

    private Node.Property createParametersProperty(boolean bl) {
        Node.Property property = ConstructorNode.createParametersProperty((CallableFeature)this.getConstructor(), bl);
        property.setValue("changeImmediate", (Object)Boolean.FALSE);
        return property;
    }

    private Node.Property createExceptionsProperty(boolean bl) {
        Node.Property property = ConstructorNode.createExceptionsProperty((CallableFeature)this.getConstructor(), bl);
        property.setValue("changeImmediate", (Object)Boolean.FALSE);
        return property;
    }

    private Constructor getConstructor() {
        return (Constructor)this.element;
    }

    static {
        mapAttributeName.put("modifiers", "modifiers");
        mapAttributeName.put("name", "name");
        mapAttributeName.put("parameters", "parameters");
        mapAttributeName.put("exceptionNames", "exceptions");
    }

    private static final class NameListener
    extends WeakReference
    implements MDRChangeListener,
    Runnable {
        private final JavaClass declClass;

        public static NameListener getInstance(ConstructorNode constructorNode, Constructor constructor) {
            JavaClass javaClass = (JavaClass)constructor.getDeclaringClass();
            MDRChangeSource mDRChangeSource = (MDRChangeSource)javaClass;
            NameListener nameListener = new NameListener(constructorNode, javaClass);
            mDRChangeSource.addListener((MDRChangeListener)nameListener, 0x101FFFF);
            return nameListener;
        }

        private NameListener(ConstructorNode constructorNode, JavaClass javaClass) {
            super(constructorNode, Utilities.activeReferenceQueue());
            this.declClass = javaClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void change(MDRChangeEvent mDRChangeEvent) {
            if (!(mDRChangeEvent instanceof AttributeEvent)) {
                return;
            }
            ConstructorNode constructorNode = (ConstructorNode)this.get();
            AttributeEvent attributeEvent = (AttributeEvent)mDRChangeEvent;
            String string = attributeEvent.getAttributeName();
            ElementFormat elementFormat = null;
            if (constructorNode != null && (string == null || "name".equals(string)) && (elementFormat = constructorNode.getElementFormat()).dependsOnProperty(string)) {
                String[] stringArray = new String[2];
                JavaMetamodel.getDefaultRepository().beginTrans(false);
                try {
                    try {
                        if (this.declClass.isValid()) {
                            stringArray[0] = elementFormat.format(constructorNode.element);
                            stringArray[1] = this.declClass.getSimpleName();
                        }
                    }
                    finally {
                        JavaMetamodel.getDefaultRepository().endTrans();
                    }
                }
                catch (JmiException jmiException) {
                    ErrorManager.getDefault().notify(16, (Throwable)jmiException);
                }
                if (stringArray[0] != null) {
                    EventQueue.invokeLater(new Runnable(this, constructorNode, stringArray){
                        private final /* synthetic */ ConstructorNode val$node;
                        private final /* synthetic */ String[] val$names;
                        private final /* synthetic */ NameListener this$0;
                        {
                            this.this$0 = nameListener;
                            this.val$node = constructorNode;
                            this.val$names = stringArray;
                        }

                        public void run() {
                            this.val$node.setDisplayName(this.val$names[0]);
                            this.val$node.superSetName(this.val$names[1]);
                            this.val$node.superPropertyChange("name", null, null);
                        }
                    });
                }
            }
        }

        public void run() {
            ((MDRChangeSource)this.declClass).removeListener((MDRChangeListener)this);
        }
    }
}

