/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.elements;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.jmi.reflect.JmiException;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.EnumConstant;
import org.netbeans.jmi.javamodel.GenericElement;
import org.netbeans.jmi.javamodel.Initializer;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.jmi.javamodel.TypedElement;
import org.netbeans.modules.java.ui.nodes.editors.IdentifierArrayEditor;
import org.netbeans.modules.java.ui.nodes.editors.MethodParameterArrayEditor;
import org.netbeans.modules.java.ui.nodes.editors.TypeParameterArrayEditor;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.util.NbBundle;

public final class ElementFormat
extends Format {
    static final long serialVersionUID = 3775521938640169753L;
    private static final String PROPERTIES_NAMES_INDEX = "mnfCtrscpaieMT";
    private static final String[] PROPERTIES_NAMES = new String[]{"modifiers", "name", "name", "name", "type", "return", "superclass", "static", "parameters", "parameters", "interfaces", "exceptions", "modifiers", "typeParameters"};
    private static final byte STATUS_OUTSIDE = 0;
    private static final byte STATUS_INSIDE = 1;
    private static final byte STATUS_RBRACE = 2;
    private String pattern;
    private boolean source;
    private transient LinkedList list;

    public ElementFormat(String string) {
        this.applyPattern(string);
        this.source = true;
    }

    public void setSourceFormat(boolean bl) {
        this.source = bl;
    }

    public boolean isSourceFormat() {
        return this.source;
    }

    public String getPattern() {
        return this.pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        StringBuffer stringBuffer2;
        JavaModel.getJavaRepository().beginTrans(false);
        try {
            Element element = (Element)object;
            JavaModel.setClassPath((Resource)element.getResource());
            Iterator iterator = this.list.iterator();
            while (iterator.hasNext()) {
                stringBuffer2 = iterator.next();
                if (stringBuffer2 instanceof String) {
                    stringBuffer.append((String)((Object)stringBuffer2));
                    continue;
                }
                ((Tag)((Object)stringBuffer2)).format(element, stringBuffer);
            }
            stringBuffer2 = stringBuffer;
        }
        catch (Throwable throwable) {
            try {
                JavaModel.getJavaRepository().endTrans();
                throw throwable;
            }
            catch (ClassCastException classCastException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(NbBundle.getMessage((Class)ElementFormat.class, (String)"MSG_badArgument"));
                illegalArgumentException.initCause(classCastException);
                throw illegalArgumentException;
            }
            catch (JmiException jmiException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("format failed");
                illegalArgumentException.initCause(jmiException);
                throw illegalArgumentException;
            }
        }
        JavaModel.getJavaRepository().endTrans();
        return stringBuffer2;
    }

    public String format(Element element) {
        return this.format(element, new StringBuffer(), null).toString();
    }

    public boolean dependsOnProperty(String string) {
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            int n;
            Object e = iterator.next();
            if (!(e instanceof Tag) || !PROPERTIES_NAMES[n = PROPERTIES_NAMES_INDEX.indexOf(((Tag)e).kind)].equals(string)) continue;
            return true;
        }
        return false;
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.applyPattern(this.pattern);
    }

    private void applyPattern(String string) {
        this.pattern = string;
        this.list = new LinkedList();
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "{}", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            switch (n) {
                case 0: {
                    if (string2.equals("}")) {
                        throw new IllegalArgumentException(NbBundle.getMessage((Class)ElementFormat.class, (String)"MSG_badPattern"));
                    }
                    if (string2.equals("{")) {
                        n = 1;
                        break;
                    }
                    this.list.add(string2);
                    break;
                }
                case 1: {
                    if (string2.equals("{") || string2.equals("}")) {
                        throw new IllegalArgumentException(NbBundle.getMessage((Class)ElementFormat.class, (String)"MSG_badPattern"));
                    }
                    this.list.add(this.createTag(string2));
                    n = 2;
                    break;
                }
                case 2: {
                    if (!string2.equals("}")) {
                        throw new IllegalArgumentException(NbBundle.getMessage((Class)ElementFormat.class, (String)"MSG_badPattern"));
                    }
                    n = 0;
                }
            }
        }
    }

    private Tag createTag(String string) {
        if (string.length() > 0) {
            char c = string.charAt(0);
            String[] stringArray = new String[]{};
            if (string.length() > 1) {
                if (string.length() < 2 || string.charAt(1) != ',') {
                    throw new IllegalArgumentException(NbBundle.getMessage((Class)ElementFormat.class, (String)"MSG_badPattern"));
                }
                stringArray = this.parseParams(string.substring(2));
            }
            if ("mnfCtrscM".indexOf(c) != -1) {
                switch (stringArray.length) {
                    case 0: {
                        return new Tag(c, "", "");
                    }
                    case 2: {
                        return new Tag(c, stringArray[0], stringArray[1]);
                    }
                }
            } else if ("paieT".indexOf(c) != -1) {
                switch (stringArray.length) {
                    case 0: {
                        return new ArrayTag(c, "", "", ", ");
                    }
                    case 2: {
                        return new ArrayTag(c, stringArray[0], stringArray[1], ", ");
                    }
                    case 3: {
                        return new ArrayTag(c, stringArray[0], stringArray[1], stringArray[2]);
                    }
                }
            }
        }
        throw new IllegalArgumentException(NbBundle.getMessage((Class)ElementFormat.class, (String)"MSG_badPattern"));
    }

    private String[] parseParams(String string) {
        String[] stringArray;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", true);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            if (bl2) {
                stringBuffer.append((String)stringArray);
                if (!stringArray.endsWith("\"")) continue;
                if (stringBuffer.length() > 1) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
                arrayList.add(stringBuffer.toString());
                stringBuffer.setLength(0);
                bl2 = false;
                bl = true;
                continue;
            }
            if (stringArray.equals(",")) {
                if (bl) {
                    bl = false;
                    continue;
                }
                arrayList.add("");
                continue;
            }
            if (bl) {
                throw new IllegalArgumentException(NbBundle.getMessage((Class)ElementFormat.class, (String)"MSG_badPattern"));
            }
            Object object = stringArray;
            if (stringArray.startsWith("\"")) {
                if (stringArray.endsWith("\"") && stringArray.length() > 1) {
                    object = stringArray.length() <= 2 ? "" : stringArray.substring(1, stringArray.length() - 1);
                } else {
                    stringBuffer.append(stringArray.substring(1));
                    bl2 = true;
                    continue;
                }
            }
            arrayList.add(object);
            bl = true;
            stringBuffer.setLength(0);
        }
        if (!bl) {
            arrayList.add("");
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static String elementName(NamedElement namedElement) throws JmiException {
        if (namedElement instanceof JavaClass) {
            return ((JavaClass)namedElement).getSimpleName();
        }
        if (namedElement instanceof Constructor) {
            JavaClass javaClass = (JavaClass)((Constructor)namedElement).getDeclaringClass();
            return javaClass.getSimpleName();
        }
        return namedElement.getName();
    }

    private static String elementFullName(NamedElement namedElement) throws JmiException {
        if (namedElement instanceof JavaClass) {
            return namedElement.getName();
        }
        if (!(namedElement instanceof ClassMember)) {
            return ElementFormat.elementName(namedElement);
        }
        JavaClass javaClass = (JavaClass)((ClassMember)namedElement).getDeclaringClass();
        StringBuffer stringBuffer = new StringBuffer(30).append(javaClass.getName()).append('.');
        if (namedElement instanceof Constructor) {
            stringBuffer.append(javaClass.getSimpleName());
        } else {
            stringBuffer.append(namedElement.getName());
        }
        return stringBuffer.toString();
    }

    private static void resolveClassName(JavaClass javaClass, StringBuffer stringBuffer) {
        ClassDefinition classDefinition = javaClass.getDeclaringClass();
        if (!(classDefinition instanceof JavaClass)) {
            stringBuffer.append(javaClass.getSimpleName());
            return;
        }
        ElementFormat.resolveClassName((JavaClass)classDefinition, stringBuffer);
        stringBuffer.append('.').append(javaClass.getSimpleName());
    }

    public String toString() {
        return this.pattern;
    }

    private static final class ArrayTag
    extends Tag {
        String delim;
        static final long serialVersionUID = 2060398944304753010L;

        ArrayTag(char c, String string, String string2, String string3) {
            super(c, string, string2);
            this.delim = string3;
        }

        private void identifiers2String(List list, StringBuffer stringBuffer) throws JmiException {
            Iterator iterator = list.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(this.delim);
                } else {
                    bl = true;
                }
                MultipartId multipartId = (MultipartId)iterator.next();
                stringBuffer.append(IdentifierArrayEditor.multipartIdToName(multipartId));
            }
        }

        void format(Element element, StringBuffer stringBuffer) {
            try {
                int n = stringBuffer.length();
                stringBuffer.append(this.prefix);
                switch (this.kind) {
                    case 'e': {
                        this.identifiers2String(((CallableFeature)element).getExceptionNames(), stringBuffer);
                        break;
                    }
                    case 'a': 
                    case 'p': {
                        if (element instanceof EnumConstant) {
                            ArrayTag.constantParams2String((EnumConstant)element, stringBuffer);
                            break;
                        }
                        List list = ((CallableFeature)element).getParameters();
                        stringBuffer.append(MethodParameterArrayEditor.params2String(list.toArray(new Parameter[0]), this.delim, this.kind == 'p'));
                        break;
                    }
                    case 'i': {
                        this.identifiers2String(((JavaClass)element).getInterfaceNames(), stringBuffer);
                        break;
                    }
                    case 'T': {
                        this.typeParams2String((GenericElement)element, stringBuffer);
                    }
                }
                if (stringBuffer.length() > n + this.prefix.length()) {
                    stringBuffer.append(this.suffix);
                } else {
                    stringBuffer.setLength(n);
                }
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$ui$nodes$elements$ElementFormat == null ? (class$org$netbeans$modules$java$ui$nodes$elements$ElementFormat = ElementFormat.class$("org.netbeans.modules.java.ui.nodes.elements.ElementFormat")) : class$org$netbeans$modules$java$ui$nodes$elements$ElementFormat), (String)"MSG_badPattern"));
            }
        }

        private static void constantParams2String(EnumConstant enumConstant, StringBuffer stringBuffer) throws JmiException {
            String string = enumConstant.getInitialValueText();
            stringBuffer.append(string != null ? string : "");
        }

        private void typeParams2String(GenericElement genericElement, StringBuffer stringBuffer) throws JmiException {
            TypeParameter[] typeParameterArray = genericElement.getTypeParameters().toArray(new TypeParameter[0]);
            String string = TypeParameterArrayEditor.params2String(typeParameterArray, this.delim);
            stringBuffer.append(string);
        }
    }

    private static class Tag
    implements Serializable {
        char kind;
        String prefix;
        String suffix;
        static final long serialVersionUID = 4946774706959011193L;

        Tag(char c, String string, String string2) {
            this.kind = c;
            this.prefix = string;
            this.suffix = string2;
        }

        void format(Element element, StringBuffer stringBuffer) {
            try {
                int n = stringBuffer.length();
                stringBuffer.append(this.prefix);
                switch (this.kind) {
                    case 'm': {
                        stringBuffer.append(Modifier.toString(((ClassMember)element).getModifiers() & 0xFFFFFDFF));
                        break;
                    }
                    case 'n': {
                        stringBuffer.append(ElementFormat.elementName((NamedElement)element));
                        break;
                    }
                    case 'f': {
                        stringBuffer.append(ElementFormat.elementFullName((NamedElement)element));
                        break;
                    }
                    case 'C': {
                        ElementFormat.resolveClassName((JavaClass)element, stringBuffer);
                        break;
                    }
                    case 't': {
                        stringBuffer.append(((TypedElement)element).getType().getName());
                        break;
                    }
                    case 'r': {
                        stringBuffer.append(((TypedElement)element).getType().getName());
                        break;
                    }
                    case 's': {
                        JavaClass javaClass = ((JavaClass)element).getSuperClass();
                        if (javaClass == null) break;
                        stringBuffer.append(ElementFormat.elementFullName((NamedElement)javaClass));
                        break;
                    }
                    case 'c': {
                        int n2 = ((Initializer)element).getModifiers();
                        if (!Modifier.isStatic(n2)) break;
                        stringBuffer.append(Modifier.toString(8));
                        break;
                    }
                    case 'M': {
                        stringBuffer.append(Modifier.isInterface(((ClassMember)element).getModifiers()) ? "interface" : "class");
                    }
                }
                if (stringBuffer.length() > n + this.prefix.length()) {
                    stringBuffer.append(this.suffix);
                } else {
                    stringBuffer.setLength(n);
                }
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$ui$nodes$elements$ElementFormat == null ? (class$org$netbeans$modules$java$ui$nodes$elements$ElementFormat = ElementFormat.class$("org.netbeans.modules.java.ui.nodes.elements.ElementFormat")) : class$org$netbeans$modules$java$ui$nodes$elements$ElementFormat), (String)"MSG_badPattern"));
            }
        }
    }
}

