/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.elements;

import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.jmi.reflect.InvalidObjectException;
import javax.jmi.reflect.JmiException;
import javax.swing.Action;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.MDRChangeSource;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.GenericElement;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.jmi.javamodel.TypedElement;
import org.netbeans.modules.java.JavaEditor;
import org.netbeans.modules.java.ui.nodes.editors.IdentifierArrayEditor;
import org.netbeans.modules.java.ui.nodes.editors.MethodParameterArrayEditor;
import org.netbeans.modules.java.ui.nodes.editors.ModifierEditor;
import org.netbeans.modules.java.ui.nodes.editors.TypeEditor;
import org.netbeans.modules.java.ui.nodes.editors.TypeParameterArrayEditor;
import org.netbeans.modules.java.ui.nodes.elements.ElementFormat;
import org.netbeans.modules.java.ui.nodes.elements.ElementProperties2;
import org.netbeans.modules.java.ui.nodes.elements.IconStrings;
import org.netbeans.modules.java.ui.nodes.elements.SourceEditSupport;
import org.netbeans.modules.java.ui.nodes.elements.SourceOptions;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.text.PositionBounds;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public abstract class ElementNode
extends AbstractNode
implements IconStrings,
ElementProperties2 {
    private static ElementFormat invalidFormat;
    private static final String[] ICON_AFFECTING_PROPERTIES;
    protected Element element;
    protected ElementFormat elementFormat = new ElementFormat("");
    protected boolean writeable;
    private SystemAction preferredAction;
    private JMIElementListener wElementL;
    private final InstanceContent lkpContent;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class array$Lorg$netbeans$jmi$javamodel$Parameter;
    static /* synthetic */ Class array$Lorg$netbeans$jmi$javamodel$MultipartId;
    static /* synthetic */ Class class$org$netbeans$jmi$javamodel$Type;
    static /* synthetic */ Class class$org$netbeans$modules$java$ui$nodes$elements$FieldNode;
    static /* synthetic */ Class array$Lorg$netbeans$jmi$javamodel$TypeParameter;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$netbeans$modules$java$JavaEditor;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;

    public ElementNode(Element element, Children children, boolean bl) {
        this(element, children, bl, new InstanceContent());
    }

    private ElementNode(Element element, Children children, boolean bl, InstanceContent instanceContent) {
        super(children, (Lookup)new AbstractLookup((AbstractLookup.Content)instanceContent));
        this.element = element;
        this.writeable = bl;
        this.lkpContent = instanceContent;
        this.setIconBase(this.resolveIconBase());
        this.setDisplayName(this.getElementFormat().format(element));
        this.setShortDescription(this.getHintElementFormat().format(element));
        if (element instanceof MDRChangeSource) {
            this.wElementL = (JMIElementListener)this.createJMIElementListener();
            ((MDRChangeSource)element).addListener((MDRChangeListener)this.wElementL);
        }
        this.displayFormat = null;
        instanceContent.add((Object)new OpenCookieImpl(this));
        instanceContent.add((Object)element);
        Resource resource = this.element.getResource();
        DataObject dataObject = JavaMetamodel.getManager().getDataObject(resource);
        if (dataObject != null) {
            instanceContent.add((Object)dataObject);
            dataObject.addPropertyChangeListener((PropertyChangeListener)new DOListener(this, dataObject));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws IOException {
        boolean bl = true;
        try {
            JavaMetamodel.getDefaultRepository().beginTrans(true);
            try {
                this.element.refDelete();
                bl = false;
            }
            finally {
                JavaMetamodel.getDefaultRepository().endTrans(bl);
            }
        }
        catch (JmiException jmiException) {
            IOException iOException = new IOException();
            iOException.initCause(jmiException);
            throw iOException;
        }
        super.destroy();
    }

    protected abstract String resolveIconBase();

    protected String[] getIconAffectingProperties() {
        return ICON_AFFECTING_PROPERTIES;
    }

    public final ElementFormat getElementFormat() {
        return this.elementFormat;
    }

    public final void setElementFormat(ElementFormat elementFormat) {
        this.setDisplayName(elementFormat.format(this.element));
        this.elementFormat = elementFormat;
    }

    protected abstract ElementFormat getElementFormatProperty();

    final void setElementFormat0(ElementFormat elementFormat) {
        try {
            this.setElementFormat(elementFormat);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setElementFormat(ElementNode.getInvalidFormat());
        }
    }

    static ElementFormat getInvalidFormat() {
        if (invalidFormat != null) {
            return invalidFormat;
        }
        invalidFormat = new ElementFormat(ElementNode.getString("FMT_InvalidFormat"));
        return invalidFormat;
    }

    protected abstract ElementFormat getHintElementFormat();

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return this.isWriteable();
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public void setActions(SystemAction[] systemActionArray, SystemAction systemAction) {
        this.systemActions = systemActionArray;
        this.preferredAction = systemAction;
    }

    public Action getPreferredAction() {
        Object object = this.preferredAction;
        if (object == null) {
            object = super.getPreferredAction();
        }
        return object;
    }

    void superFireCookieChange() {
        this.fireCookieChange();
    }

    public boolean equals(Object object) {
        return object instanceof ElementNode && this.element.equals(((ElementNode)object).element);
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    boolean isWriteable() {
        return this.writeable && SourceEditSupport.isWriteable(this.element);
    }

    void superSetName(String string) {
        super.setName(string);
    }

    void superPropertyChange(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
    }

    void superShortDescriptionChange(String string, String string2) {
        super.fireShortDescriptionChange(string, string2);
    }

    MDRChangeListener createJMIElementListener() {
        JMIElementListener jMIElementListener = new JMIElementListener(this);
        return jMIElementListener;
    }

    protected ChangeDescriptor handleAttributeChange(AttributeEvent attributeEvent) {
        Object object = attributeEvent.getSource();
        ChangeDescriptor changeDescriptor = new ChangeDescriptor();
        if (object != this.element || !((Element)object).isValid()) {
            return changeDescriptor;
        }
        String string = attributeEvent.getAttributeName();
        String string2 = this.mapAttributeName(string);
        if (string2 == null) {
            changeDescriptor.displayName = this.getElementFormat().format(this.element);
            changeDescriptor.shortDescription = this.getHintElementFormat().format(this.element);
            changeDescriptor.iconBase = this.resolveIconBase();
        } else {
            if (this.getElementFormat().dependsOnProperty(string2)) {
                changeDescriptor.displayName = this.getElementFormat().format(this.element);
            }
            String[] stringArray = this.getIconAffectingProperties();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string2)) continue;
                changeDescriptor.iconBase = this.resolveIconBase();
                break;
            }
            if (string2.equals("name")) {
                changeDescriptor.name = ((NamedElement)this.element).getName();
            }
            if (this.getHintElementFormat().dependsOnProperty(string2)) {
                changeDescriptor.shortDescription = this.getHintElementFormat().format(this.element);
            }
        }
        return changeDescriptor;
    }

    protected void processChange(ChangeDescriptor changeDescriptor) {
        if (changeDescriptor.displayName != null) {
            this.setDisplayName(changeDescriptor.displayName);
        }
        if (changeDescriptor.iconBase != null) {
            this.setIconBase(changeDescriptor.iconBase);
        }
        if (changeDescriptor.name != null) {
            this.superSetName(changeDescriptor.name);
        }
        if (changeDescriptor.shortDescription != null) {
            this.setShortDescription(changeDescriptor.shortDescription);
        }
        if (changeDescriptor.sheet != null) {
            this.setSheet(changeDescriptor.sheet);
        }
    }

    protected abstract Map getAttributeNameMap();

    final String mapAttributeName(String string) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        String string2 = (String)this.getAttributeNameMap().get(string);
        return string2 == null ? string : string2;
    }

    static String getString(String string) {
        return NbBundle.getMessage((Class)ElementNode.class, (String)string);
    }

    private static void fireChangesInAWTThread(final ElementNode elementNode, final ChangeDescriptor changeDescriptor) {
        Mutex.EVENT.writeAccess(new Runnable(){

            public void run() {
                elementNode.processChange(changeDescriptor);
            }
        });
    }

    private DataObject getDataObject() {
        return (DataObject)this.getCookie(DataObject.class);
    }

    public static Node.Property createNameProperty(NamedElement namedElement) {
        NameProperty nameProperty = new NameProperty(namedElement);
        return nameProperty;
    }

    public static Node.Property createParametersProperty(CallableFeature callableFeature, boolean bl) {
        ParametersProperty parametersProperty = new ParametersProperty(callableFeature, bl);
        ElementNode.setModel((Element)callableFeature, (FeatureDescriptor)((Object)parametersProperty));
        return parametersProperty;
    }

    public static Node.Property createExceptionsProperty(CallableFeature callableFeature, boolean bl) {
        ExceptionsProperty exceptionsProperty = new ExceptionsProperty(callableFeature, bl);
        ElementNode.setModel((Element)callableFeature, (FeatureDescriptor)((Object)exceptionsProperty));
        return exceptionsProperty;
    }

    public static Node.Property createTypeProperty(String string, TypedElement typedElement, boolean bl) {
        TypeProperty typeProperty = new TypeProperty(string, typedElement, bl);
        ElementNode.setModel((Element)typedElement, (FeatureDescriptor)((Object)typeProperty));
        return typeProperty;
    }

    public static Node.Property createTypeParametersProperty(String string, GenericElement genericElement, boolean bl) {
        TypeParametersProperty typeParametersProperty = new TypeParametersProperty(string, genericElement, bl);
        ElementNode.setModel((Element)genericElement, (FeatureDescriptor)((Object)typeParametersProperty));
        return typeParametersProperty;
    }

    public static Node.Property createModifiersProperty(ClassMember classMember, boolean bl) {
        int n;
        try {
            n = SourceEditSupport.getModifiersMask(classMember);
        }
        catch (JmiException jmiException) {
            ErrorManager.getDefault().notify(16, (Throwable)jmiException);
            n = 65535;
        }
        return ElementNode.createModifiersProperty(classMember, bl, n);
    }

    public static Node.Property createModifiersProperty(ClassMember classMember, boolean bl, int n) {
        ModifiersProperty modifiersProperty = new ModifiersProperty(classMember, bl, n);
        ElementNode.setModel((Element)classMember, (FeatureDescriptor)((Object)modifiersProperty));
        return modifiersProperty;
    }

    public static void setModel(Element element, FeatureDescriptor featureDescriptor) {
        JavaModelPackage javaModelPackage = JavaMetamodel.getManager().getJavaExtent(element);
        featureDescriptor.setValue("JavaModelPackage", javaModelPackage);
    }

    public static JavaModelPackage getModel(FeatureDescriptor featureDescriptor) {
        JavaModelPackage javaModelPackage = (JavaModelPackage)featureDescriptor.getValue("JavaModelPackage");
        if (javaModelPackage == null) {
            javaModelPackage = JavaMetamodel.getManager().getDefaultExtent();
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("missing JavaModelPackage"));
        }
        return javaModelPackage;
    }

    protected Node.Property createModifiersProperty(boolean bl) {
        Node.Property property = ElementNode.createModifiersProperty((ClassMember)this.element, bl);
        property.setValue("changeImmediate", (Object)Boolean.FALSE);
        return property;
    }

    protected static SourceOptions getSourceOptions() {
        return SourceOptions.getInstance();
    }

    static {
        $assertionsDisabled = !ElementNode.class.desiredAssertionStatus();
        ICON_AFFECTING_PROPERTIES = new String[]{"modifiers"};
    }

    private static final class DOListener
    extends WeakReference
    implements PropertyChangeListener,
    Runnable {
        private DataObject dobj;

        public DOListener(ElementNode elementNode, DataObject dataObject) {
            super(elementNode, Utilities.activeReferenceQueue());
            this.dobj = dataObject;
            DOListener.updateCookies(dataObject, elementNode);
        }

        public void initialize() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            ElementNode elementNode = (ElementNode)this.get();
            if (elementNode == null) {
                return;
            }
            if (string == null || "cookie".equals(string)) {
                DOListener.updateCookies(this.dobj, elementNode);
            }
        }

        private static void updateCookies(DataObject dataObject, ElementNode elementNode) {
            SaveCookie saveCookie;
            SaveCookie saveCookie2 = (SaveCookie)dataObject.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = ElementNode.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie);
            if (saveCookie2 != (saveCookie = (SaveCookie)elementNode.getLookup().lookup(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = ElementNode.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie))) {
                if (saveCookie != null) {
                    elementNode.lkpContent.remove((Object)saveCookie);
                }
                if (saveCookie2 != null) {
                    elementNode.lkpContent.add((Object)saveCookie2);
                }
            }
        }

        public void run() {
            this.dobj.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    private static final class OpenCookieImpl
    implements OpenCookie {
        private final ElementNode node;

        public OpenCookieImpl(ElementNode elementNode) {
            this.node = elementNode;
        }

        public void open() {
            try {
                DataObject dataObject = this.node.getDataObject();
                PositionBounds positionBounds = JavaMetamodel.getManager().getElementPosition(this.node.element);
                if (positionBounds == null) {
                    return;
                }
                ((JavaEditor)dataObject.getCookie(class$org$netbeans$modules$java$JavaEditor == null ? (class$org$netbeans$modules$java$JavaEditor = ElementNode.class$("org.netbeans.modules.java.JavaEditor")) : class$org$netbeans$modules$java$JavaEditor)).openAt(positionBounds.getBegin());
            }
            catch (InvalidObjectException invalidObjectException) {
                // empty catch block
            }
        }
    }

    private static final class NameProperty
    extends ElementProp {
        private final NamedElement element;

        public NameProperty(NamedElement namedElement) {
            super("name", class$java$lang$String == null ? (class$java$lang$String = ElementNode.class$("java.lang.String")) : class$java$lang$String, false);
            this.element = namedElement;
        }

        public Object getValue() {
            return this.element.getName();
        }
    }

    private static final class ModifiersProperty
    extends ElementProp {
        private final ClassMember element;
        private final int mask;

        private ModifiersProperty(ClassMember classMember, boolean bl, int n) {
            super("modifiers", class$java$lang$Integer == null ? (class$java$lang$Integer = ElementNode.class$("java.lang.Integer")) : class$java$lang$Integer, bl);
            this.element = classMember;
            this.mask = n;
        }

        public Object getValue() {
            return new Integer(this.element.getModifiers());
        }

        public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            super.setValue(object);
            if (!(object instanceof Integer)) {
                throw new IllegalArgumentException();
            }
            int n = (Integer)object;
            int n2 = this.element.getModifiers();
            int n3 = (n & this.mask) + (n2 & ~this.mask);
            this.element.setModifiers(n3);
        }

        public PropertyEditor createPropertyEditor() {
            return new ModifierEditor(this.mask);
        }
    }

    private static final class TypeParametersProperty
    extends ElementProp {
        private final GenericElement element;

        public TypeParametersProperty(String string, GenericElement genericElement, boolean bl) {
            super(string, array$Lorg$netbeans$jmi$javamodel$TypeParameter == null ? (array$Lorg$netbeans$jmi$javamodel$TypeParameter = ElementNode.class$("[Lorg.netbeans.jmi.javamodel.TypeParameter;")) : array$Lorg$netbeans$jmi$javamodel$TypeParameter, false);
            this.element = genericElement;
        }

        protected PropertyEditor createPropertyEditor() {
            return new TypeParameterArrayEditor();
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.element.getTypeParameters().toArray(new TypeParameter[0]);
        }

        public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            throw new InvocationTargetException(new UnsupportedOperationException());
        }
    }

    private static final class TypeProperty
    extends ElementProp {
        private final TypedElement element;

        public TypeProperty(String string, TypedElement typedElement, boolean bl) {
            super(string, class$org$netbeans$jmi$javamodel$Type == null ? (class$org$netbeans$jmi$javamodel$Type = ElementNode.class$("org.netbeans.jmi.javamodel.Type")) : class$org$netbeans$jmi$javamodel$Type, bl);
            this.element = typedElement;
        }

        public PropertyEditor createPropertyEditor() {
            return new TypeEditor();
        }

        public Object getValue() {
            return this.element.getType();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            super.setValue(object);
            if (!(object instanceof Type)) {
                throw new IllegalArgumentException();
            }
            Type type = (Type)object;
            boolean bl = true;
            try {
                JavaMetamodel.getDefaultRepository().beginTrans(true);
                try {
                    this.element.setType(type);
                    bl = false;
                }
                finally {
                    JavaMetamodel.getDefaultRepository().endTrans(bl);
                }
            }
            catch (JmiException jmiException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                illegalArgumentException.initCause(jmiException);
                ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, null, NbBundle.getMessage((Class)(class$org$netbeans$modules$java$ui$nodes$elements$FieldNode == null ? (class$org$netbeans$modules$java$ui$nodes$elements$FieldNode = ElementNode.class$("org.netbeans.modules.java.ui.nodes.elements.FieldNode")) : class$org$netbeans$modules$java$ui$nodes$elements$FieldNode), (String)"MSG_InvalidTypeDecl"), null, null);
                throw illegalArgumentException;
            }
        }
    }

    private static final class ExceptionsProperty
    extends ElementProp {
        private final CallableFeature element;

        public ExceptionsProperty(CallableFeature callableFeature, boolean bl) {
            super("exceptions", array$Lorg$netbeans$jmi$javamodel$MultipartId == null ? (array$Lorg$netbeans$jmi$javamodel$MultipartId = ElementNode.class$("[Lorg.netbeans.jmi.javamodel.MultipartId;")) : array$Lorg$netbeans$jmi$javamodel$MultipartId, bl);
            this.element = callableFeature;
        }

        protected PropertyEditor createPropertyEditor() {
            return new IdentifierArrayEditor();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValue() {
            MultipartId[] multipartIdArray = null;
            try {
                JavaMetamodel.getDefaultRepository().beginTrans(false);
                try {
                    if (this.element.isValid()) {
                        List list = this.element.getExceptionNames();
                        multipartIdArray = list.toArray(new MultipartId[list.size()]);
                    }
                }
                finally {
                    JavaMetamodel.getDefaultRepository().endTrans();
                }
            }
            catch (JmiException jmiException) {
                ErrorManager.getDefault().notify((Throwable)jmiException);
            }
            return multipartIdArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            super.setValue(object);
            if (!(object instanceof MultipartId[])) {
                throw new IllegalArgumentException();
            }
            boolean bl = true;
            try {
                JavaMetamodel.getDefaultRepository().beginTrans(true);
                try {
                    List list = this.element.getExceptionNames();
                    list.clear();
                    list.addAll(Arrays.asList((MultipartId[])object));
                    bl = false;
                }
                finally {
                    JavaMetamodel.getDefaultRepository().endTrans(bl);
                }
            }
            catch (JmiException jmiException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                illegalArgumentException.initCause(jmiException);
                throw illegalArgumentException;
            }
        }
    }

    private static final class ParametersProperty
    extends ElementProp {
        private final CallableFeature element;

        private ParametersProperty(CallableFeature callableFeature, boolean bl) {
            super("parameters", array$Lorg$netbeans$jmi$javamodel$Parameter == null ? (array$Lorg$netbeans$jmi$javamodel$Parameter = ElementNode.class$("[Lorg.netbeans.jmi.javamodel.Parameter;")) : array$Lorg$netbeans$jmi$javamodel$Parameter, bl);
            this.element = callableFeature;
        }

        public Object getValue() {
            List list = this.element.getParameters();
            return list.toArray(new Parameter[list.size()]);
        }

        public PropertyEditor createPropertyEditor() {
            return new MethodParameterArrayEditor(this.canWrite());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            super.setValue(object);
            if (!(object instanceof Parameter[])) {
                throw new IllegalArgumentException();
            }
            boolean bl = true;
            try {
                JavaMetamodel.getDefaultRepository().beginTrans(true);
                try {
                    List list = this.element.getParameters();
                    list.clear();
                    list.addAll(Arrays.asList((Parameter[])object));
                    bl = false;
                }
                finally {
                    JavaMetamodel.getDefaultRepository().endTrans(bl);
                }
            }
            catch (JmiException jmiException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                illegalArgumentException.initCause(jmiException);
                throw illegalArgumentException;
            }
        }
    }

    static abstract class ElementProp
    extends PropertySupport {
        private Reference editor = null;

        public ElementProp(String string, Class clazz, boolean bl) {
            super(string, clazz, ElementNode.getString("PROP_" + string), ElementNode.getString("HINT_" + string), true, bl);
        }

        public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (!this.canWrite()) {
                throw new IllegalAccessException(ElementNode.getString("MSG_Cannot_Write"));
            }
        }

        public final PropertyEditor getPropertyEditor() {
            PropertyEditor propertyEditor;
            if (this.editor == null || (propertyEditor = (PropertyEditor)this.editor.get()) == null) {
                propertyEditor = this.createPropertyEditor();
                this.editor = new SoftReference<PropertyEditor>(propertyEditor);
            }
            return propertyEditor;
        }

        protected PropertyEditor createPropertyEditor() {
            return super.getPropertyEditor();
        }
    }

    static final class ChangeDescriptor {
        String displayName;
        String name;
        String iconBase;
        String shortDescription;
        Sheet sheet;

        public ChangeDescriptor(String string, String string2, String string3, String string4) {
            this.displayName = string;
            this.iconBase = string2;
            this.name = string3;
            this.shortDescription = string4;
            this.sheet = null;
        }

        public ChangeDescriptor() {
        }
    }

    static final class JMIElementListener
    extends WeakReference
    implements MDRChangeListener,
    Runnable {
        private final Element element;
        static final /* synthetic */ boolean $assertionsDisabled;

        public JMIElementListener(ElementNode elementNode) {
            super(elementNode, Utilities.activeReferenceQueue());
            this.element = elementNode.element;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void change(MDRChangeEvent mDRChangeEvent) {
            ElementNode elementNode = (ElementNode)this.get();
            if (elementNode == null) {
                return;
            }
            if (!mDRChangeEvent.isOfType(0x101FFFF)) {
                return;
            }
            AttributeEvent attributeEvent = (AttributeEvent)mDRChangeEvent;
            String string = attributeEvent.getAttributeName();
            try {
                ChangeDescriptor changeDescriptor;
                JavaMetamodel.getDefaultRepository().beginTrans(false);
                try {
                    changeDescriptor = elementNode.handleAttributeChange(attributeEvent);
                }
                finally {
                    JavaMetamodel.getDefaultRepository().endTrans(false);
                }
                if (!$assertionsDisabled && changeDescriptor == null) {
                    throw new AssertionError();
                }
                ElementNode.fireChangesInAWTThread(elementNode, changeDescriptor);
                this.fireRegisteredProperties(string);
            }
            catch (JmiException jmiException) {
                ErrorManager.getDefault().notify(16, (Throwable)jmiException);
            }
        }

        public void run() {
            ((MDRChangeSource)this.element).removeListener((MDRChangeListener)this);
        }

        private void fireRegisteredProperties(String string) {
            ElementNode elementNode = (ElementNode)this.get();
            if (elementNode == null) {
                return;
            }
            if (string == null || (string = (String)elementNode.getAttributeNameMap().get(string)) != null) {
                elementNode.superPropertyChange(string, null, null);
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$java$ui$nodes$elements$ElementNode == null ? (class$org$netbeans$modules$java$ui$nodes$elements$ElementNode = ElementNode.class$("org.netbeans.modules.java.ui.nodes.elements.ElementNode")) : class$org$netbeans$modules$java$ui$nodes$elements$ElementNode).desiredAssertionStatus();
        }
    }
}

