/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.elements;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.jmi.reflect.JmiException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.jmi.javamodel.EnumConstant;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.modules.java.ui.nodes.elements.FieldCustomizer;
import org.netbeans.modules.java.ui.nodes.elements.SourceEditSupport;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class EnumConstantCustomizer
extends JPanel {
    private final JavaEnum jclass;
    private EnumConstant constant;
    private boolean isOK = true;
    private JLabel nameLabel;
    private JTextField nameTextField;

    public EnumConstantCustomizer(JavaEnum javaEnum, EnumConstant enumConstant) {
        this.jclass = javaEnum;
        this.constant = enumConstant;
        this.initComponents();
        this.nameTextField.setText(enumConstant.getName());
        HelpCtx.setHelpIDString((JComponent)this, (String)"java.enumconstant.customizer");
        this.initAccessibility();
    }

    public boolean isOK() {
        this.nameTextFieldFocusLost(null);
        return this.isOK;
    }

    private void initAccessibility() {
        this.nameTextField.getAccessibleContext().setAccessibleName(EnumConstantCustomizer.getString("ACSN_ConstantNameTextField"));
        this.nameTextField.getAccessibleContext().setAccessibleDescription(EnumConstantCustomizer.getString("ACSD_ConstantNameTextField"));
        this.getAccessibleContext().setAccessibleDescription("ACSD_ConstantCustomizerDialog");
    }

    private static String getString(String string) {
        return NbBundle.getMessage((Class)EnumConstantCustomizer.class, (String)string);
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.nameLabel.setLabelFor(this.nameTextField);
        this.nameLabel.setText(NbBundle.getMessage((Class)EnumConstantCustomizer.class, (String)"CTL_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(12, 12, 0, 8);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.nameTextField.setColumns(25);
        this.nameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                EnumConstantCustomizer.this.nameTextFieldFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 11);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.nameTextField, gridBagConstraints);
    }

    private void nameTextFieldFocusLost(FocusEvent focusEvent) {
        if (focusEvent != null && (focusEvent.isTemporary() || !this.isAncestorOf(focusEvent.getOppositeComponent()))) {
            return;
        }
        String string = this.nameTextField.getText().trim();
        String string2 = this.constant.getName();
        boolean bl = false;
        IllegalArgumentException illegalArgumentException = null;
        if (!Utilities.isJavaIdentifier((String)string)) {
            illegalArgumentException = new IllegalArgumentException("Invalid name");
            ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, null, NbBundle.getMessage((Class)FieldCustomizer.class, (String)"MSG_Not_Valid_Identifier"), null, null);
        } else {
            if (string2.equals(string)) {
                return;
            }
            if (SourceEditSupport.findConstant(this.jclass, string) != null) {
                illegalArgumentException = new IllegalArgumentException("Invalid name");
                ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, null, NbBundle.getMessage((Class)FieldCustomizer.class, (String)"MSG_Used_Identifier", (Object)string), null, null);
            } else {
                try {
                    this.constant.setName(string);
                    bl = true;
                }
                catch (JmiException jmiException) {
                    ErrorManager.getDefault().notify((Throwable)jmiException);
                }
            }
        }
        this.isOK = bl;
        if (!bl) {
            this.nameTextField.setText(string2);
        }
        if (illegalArgumentException != null) {
            ErrorManager.getDefault().notify((Throwable)illegalArgumentException);
        }
    }
}

