/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.elements;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.jmi.reflect.JmiException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.ui.nodes.elements.ClassNode;
import org.netbeans.modules.java.ui.nodes.elements.SourceEditSupport;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class EnumCustomizer
extends JPanel {
    private final JavaEnum element;
    private final JavaClass jclass;
    private final Resource resource;
    private boolean isOK = true;
    private JPanel accessPanel;
    private JPanel interfacesPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel modifierPanel;
    private JTextField nameTextField;

    public EnumCustomizer(JavaClass javaClass, JavaEnum javaEnum) {
        this(null, javaClass, javaEnum);
    }

    public EnumCustomizer(Resource resource, JavaEnum javaEnum) {
        this(resource, null, javaEnum);
    }

    private EnumCustomizer(Resource resource, JavaClass javaClass, JavaEnum javaEnum) {
        this.resource = resource;
        this.jclass = javaClass;
        this.element = javaEnum;
        this.initComponents();
        this.interfacesPanel.setBorder(new TitledBorder(NbBundle.getMessage((Class)EnumCustomizer.class, (String)"CTL_Interfaces")));
        int n = 1024;
        if (resource == null) {
            n |= 0xF;
        }
        if (!javaEnum.isInterface()) {
            n |= 0x10;
        }
        this.accessPanel.add((Component)SourceEditSupport.createAccessModifiersPanel((ClassMember)javaEnum, n), "Center");
        this.modifierPanel.add((Component)SourceEditSupport.createOtherModifiersPanel((ClassMember)javaEnum, n), "Center");
        this.nameTextField.setText(javaEnum.getSimpleName());
        this.interfacesPanel.add((Component)new PropertyPanel(ClassNode.createInterfacesProperty((JavaClass)javaEnum, true), 2), "Center");
        HelpCtx.setHelpIDString((JComponent)this, (String)"java.enum.customizer");
        this.jLabel1.setDisplayedMnemonic(NbBundle.getMessage((Class)EnumCustomizer.class, (String)"CTL_Name_Mnemonic").charAt(0));
        this.initAccessibility();
    }

    public void addNotify() {
        super.addNotify();
        int n = this.nameTextField.getText().length();
        this.nameTextField.setCaretPosition(0);
        this.nameTextField.moveCaretPosition(n);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EnumCustomizer.this.nameTextField.requestFocus();
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.nameTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.accessPanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.modifierPanel = new JPanel();
        this.interfacesPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(6, 6, 6, 6)));
        this.jLabel1.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage((Class)EnumCustomizer.class, (String)"CTL_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.nameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                EnumCustomizer.this.nameTextFieldFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 8, 0, 0);
        this.add((Component)this.nameTextField, gridBagConstraints);
        this.jLabel2.setLabelFor(this.accessPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage((Class)EnumCustomizer.class, (String)"CTL_AccessRights"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.accessPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.accessPanel, gridBagConstraints);
        this.jLabel3.setLabelFor(this.modifierPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage((Class)EnumCustomizer.class, (String)"CTL_Modifiers"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.modifierPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.modifierPanel, gridBagConstraints);
        this.interfacesPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.interfacesPanel, gridBagConstraints);
    }

    private void nameTextFieldFocusLost(FocusEvent focusEvent) {
        if (focusEvent != null && (focusEvent.isTemporary() || !this.isAncestorOf(focusEvent.getOppositeComponent()))) {
            return;
        }
        String string = this.nameTextField.getText().trim();
        String string2 = this.element.getSimpleName();
        boolean bl = false;
        if (!Utilities.isJavaIdentifier((String)string)) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid name: " + string);
            ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, null, NbBundle.getMessage((Class)EnumCustomizer.class, (String)"MSG_Not_Valid_Identifier"), null, null);
            ErrorManager.getDefault().notify((Throwable)illegalArgumentException);
        } else {
            if (string2.equals(string)) {
                return;
            }
            if (this.resource == null && this.jclass.getInnerClass(string, true) != null) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid name: " + string);
                ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, null, NbBundle.getMessage((Class)EnumCustomizer.class, (String)"MSG_Not_Valid_Identifier"), null, null);
                ErrorManager.getDefault().notify((Throwable)illegalArgumentException);
            } else if (this.jclass == null && SourceEditSupport.findTopLevelClass(this.resource, string) != null) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid name: " + string);
                ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, null, NbBundle.getMessage((Class)EnumCustomizer.class, (String)"MSG_Not_Valid_Identifier"), null, null);
                ErrorManager.getDefault().notify((Throwable)illegalArgumentException);
            } else {
                try {
                    this.element.setSimpleName(string);
                    bl = true;
                }
                catch (JmiException jmiException) {
                    ErrorManager.getDefault().notify((Throwable)jmiException);
                }
            }
        }
        this.isOK = bl;
        if (!bl) {
            this.nameTextField.setText(string2);
        }
    }

    private void initAccessibility() {
        this.nameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)EnumCustomizer.class, (String)"ACS_EnumNameTextField"));
        this.nameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)EnumCustomizer.class, (String)"ACS_EnumNameTextField"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)EnumCustomizer.class, (String)"ACSD_EnumCustomizerDialog"));
    }

    public boolean isOK() {
        this.nameTextFieldFocusLost(null);
        return this.isOK;
    }
}

