/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.elements;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.jmi.reflect.JmiException;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.java.ui.nodes.editors.TypeEditor;
import org.netbeans.modules.java.ui.nodes.elements.ElementFormat;
import org.netbeans.modules.java.ui.nodes.elements.SourceEditSupport;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class FieldCustomizer
extends JPanel {
    private final Field element;
    private final JavaClass jclass;
    private static final String[] COMMON_TYPES = TypeEditor.LVALUE_TYPES;
    private boolean isOK = true;
    private JPanel accessPanel;
    private JEditorPane initValueEditor;
    private JPanel initValuePanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JScrollPane jScrollPane1;
    private JPanel modifierPanel;
    private JTextField nameTextField;
    private JComboBox typeCombo;

    public FieldCustomizer(JavaClass javaClass, Field field) {
        this.element = field;
        this.jclass = javaClass;
        this.initComponents();
        int n = javaClass.isInterface() ? 25 : 223;
        this.accessPanel.add((Component)SourceEditSupport.createAccessModifiersPanel((ClassMember)field, n), "Center");
        this.modifierPanel.add((Component)SourceEditSupport.createOtherModifiersPanel((ClassMember)field, n), "Center");
        this.nameTextField.setText(field.getName());
        this.typeCombo.setSelectedItem(ElementFormat.elementName((NamedElement)field.getType()));
        this.initValueEditor.setText(field.getInitialValueText());
        this.jLabel1.setDisplayedMnemonic(NbBundle.getMessage((Class)FieldCustomizer.class, (String)"CTL_Name_Mnemonic").charAt(0));
        this.jLabel2.setDisplayedMnemonic(NbBundle.getMessage((Class)FieldCustomizer.class, (String)"CTL_Type_Mnemonic").charAt(0));
        this.jLabel5.setDisplayedMnemonic(NbBundle.getMessage((Class)FieldCustomizer.class, (String)"CTL_InitValue_Mnemonic").charAt(0));
        this.initAccessibility();
    }

    public void addNotify() {
        super.addNotify();
        int n = this.nameTextField.getText().length();
        this.nameTextField.setCaretPosition(0);
        this.nameTextField.moveCaretPosition(n);
        this.nameTextField.requestFocus();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FieldCustomizer.this.nameTextField.requestFocus();
            }
        });
    }

    private JavaModelPackage getJModel() {
        return JavaMetamodel.getManager().getJavaExtent((Element)this.jclass);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.nameTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.typeCombo = new JComboBox<String>(COMMON_TYPES);
        this.jLabel3 = new JLabel();
        this.accessPanel = new JPanel();
        this.jLabel4 = new JLabel();
        this.modifierPanel = new JPanel();
        this.jLabel5 = new JLabel();
        this.initValuePanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.initValueEditor = new JEditorPane();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(6, 6, 6, 6)));
        this.jLabel1.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage((Class)FieldCustomizer.class, (String)"CTL_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.nameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                FieldCustomizer.this.nameTextFieldFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 8, 0, 0);
        this.add((Component)this.nameTextField, gridBagConstraints);
        this.nameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)FieldCustomizer.class, (String)"ACSD_FieldNameTextField"));
        this.jLabel2.setLabelFor(this.typeCombo);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage((Class)FieldCustomizer.class, (String)"CTL_Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.typeCombo.setEditable(true);
        this.typeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FieldCustomizer.this.jComboBox1ActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.typeCombo, gridBagConstraints);
        this.typeCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)FieldCustomizer.class, (String)"ACSD_FieldType"));
        this.jLabel3.setLabelFor(this.accessPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage((Class)FieldCustomizer.class, (String)"CTL_AccessRights"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.accessPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.accessPanel, gridBagConstraints);
        this.jLabel4.setLabelFor(this.modifierPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage((Class)FieldCustomizer.class, (String)"CTL_Modifiers"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.modifierPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.modifierPanel, gridBagConstraints);
        this.jLabel5.setLabelFor(this.initValueEditor);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage((Class)FieldCustomizer.class, (String)"CTL_InitValue"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.initValuePanel.setLayout(new BorderLayout());
        this.initValueEditor.setContentType("text/x-java");
        this.initValueEditor.setPreferredSize(new Dimension(302, 200));
        this.initValueEditor.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                FieldCustomizer.this.initValueEditorFocusLost(focusEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.initValueEditor);
        this.initValuePanel.add((Component)this.jScrollPane1, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.initValuePanel, gridBagConstraints);
    }

    private void jComboBox1ActionPerformed(ActionEvent actionEvent) {
        Object object = this.typeCombo.getSelectedItem();
        if (object == null) {
            return;
        }
        String string = object.toString().trim();
        Type type = this.element.getType();
        boolean bl = false;
        try {
            Type type2 = this.getJModel().getType().resolve(string);
            if (type.equals(type2)) {
                return;
            }
            if (!TypeEditor.isValidTypeSyntax(string)) {
                FieldCustomizer.notifyUserWarning("MSG_Not_Valid_Type", "invalid type");
            } else if (type2 instanceof PrimitiveType && PrimitiveTypeKindEnum.VOID.equals((Object)((PrimitiveType)type2).getKind())) {
                FieldCustomizer.notifyUserWarning("MSG_Not_Valid_Type", "invalid type");
            } else {
                this.element.setType(type2);
                bl = true;
            }
        }
        catch (JmiException jmiException) {
            ErrorManager.getDefault().notify((Throwable)jmiException);
        }
        this.isOK = bl;
        if (!bl) {
            this.typeCombo.setSelectedItem(ElementFormat.elementName((NamedElement)type));
        }
    }

    private void initValueEditorFocusLost(FocusEvent focusEvent) {
        if (focusEvent != null && (focusEvent.isTemporary() || !this.isAncestorOf(focusEvent.getOppositeComponent()))) {
            return;
        }
        String string = this.initValueEditor.getText();
        String string2 = this.element.getInitialValueText();
        boolean bl = false;
        if (!string.equals(string2)) {
            try {
                this.element.setInitialValueText(string);
                bl = true;
            }
            catch (JmiException jmiException) {
                ErrorManager.getDefault().notify((Throwable)jmiException);
            }
        } else {
            return;
        }
        this.isOK = bl;
        if (!bl) {
            this.initValueEditor.setText(string2);
        }
    }

    private void nameTextFieldFocusLost(FocusEvent focusEvent) {
        if (focusEvent != null && (focusEvent.isTemporary() || !this.isAncestorOf(focusEvent.getOppositeComponent()))) {
            return;
        }
        String string = this.nameTextField.getText().trim();
        String string2 = this.element.getName();
        boolean bl = false;
        try {
            if (!Utilities.isJavaIdentifier((String)string)) {
                FieldCustomizer.notifyUserWarning("MSG_Not_Valid_Identifier", "invalid name");
            } else {
                if (string2.equals(string)) {
                    return;
                }
                if (this.jclass.getField(string, true) != null) {
                    FieldCustomizer.notifyUserWarning("MSG_Used_Identifier", string, "invalid name");
                } else {
                    this.element.setName(string);
                    bl = true;
                }
            }
        }
        catch (JmiException jmiException) {
            ErrorManager.getDefault().notify((Throwable)jmiException);
        }
        this.isOK = bl;
        if (!bl) {
            this.nameTextField.setText(string2);
        }
    }

    private void initAccessibility() {
        this.nameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)FieldCustomizer.class, (String)"ACS_FieldNameTextField"));
        this.nameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)FieldCustomizer.class, (String)"ACS_FieldNameTextField"));
        this.initValueEditor.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)FieldCustomizer.class, (String)"ACSN_InitValueEditorPane"));
        this.initValueEditor.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)FieldCustomizer.class, (String)"ACSD_InitValueEditorPane"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)FieldCustomizer.class, (String)"ACSD_FieldCustomizerDialog"));
    }

    public boolean isOK() {
        this.nameTextFieldFocusLost(null);
        if (this.isOK) {
            this.initValueEditorFocusLost(null);
        }
        if (this.isOK) {
            this.jComboBox1ActionPerformed(null);
        }
        return this.isOK;
    }

    private static void notifyUserWarning(String string, String string2) {
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string2);
        ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, null, NbBundle.getMessage((Class)FieldCustomizer.class, (String)string), null, null);
        ErrorManager.getDefault().notify((Throwable)illegalArgumentException);
    }

    private static void notifyUserWarning(String string, String string2, String string3) {
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string3);
        ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, null, NbBundle.getMessage((Class)FieldCustomizer.class, (String)string, (Object)string2), null, null);
        ErrorManager.getDefault().notify((Throwable)illegalArgumentException);
    }
}

