/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.elements;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jmi.reflect.JmiException;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.java.ui.nodes.editors.TypeEditor;
import org.netbeans.modules.java.ui.nodes.elements.ElementFormat;
import org.netbeans.modules.java.ui.nodes.elements.ElementNode;
import org.netbeans.modules.java.ui.nodes.elements.SourceEditSupport;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.TypeClassImpl;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class MethodCustomizer
extends JPanel {
    private static final String[] COMMON_TYPES = TypeEditor.RVALUE_TYPES;
    private final JavaClass jclass;
    private final CallableFeature element;
    private final Method method;
    private final boolean isConstructor;
    private boolean isOK = true;
    private JPanel accessPanel;
    private JPanel exceptionsPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JTabbedPane jTabbedPane1;
    private JPanel modifierPanel;
    private JTextField nameTextField;
    private JPanel paramsPanel;
    private JComboBox returnCombo;
    private JTextField typeTextField;

    public MethodCustomizer(JavaClass javaClass, CallableFeature callableFeature) {
        int n;
        this.jclass = javaClass;
        this.element = callableFeature;
        this.isConstructor = !(callableFeature instanceof Method);
        this.method = this.isConstructor ? null : (Method)callableFeature;
        this.initComponents();
        if (javaClass.isInterface()) {
            n = 1025;
        } else {
            n = 7;
            if (!this.isConstructor) {
                n |= 0x538;
            }
        }
        this.accessPanel.add((Component)SourceEditSupport.createAccessModifiersPanel((ClassMember)callableFeature, n), "Center");
        PropertyPanel propertyPanel = SourceEditSupport.createOtherModifiersPanel((ClassMember)callableFeature, n);
        Node.Property property = propertyPanel.getProperty();
        String string = String.valueOf('\uffff');
        property.setValue("ModifierPanel_Modifier_Abstract_Mnemonic", string);
        property.setValue("ModifierPanel_Modifier_Final_Mnemonic", string);
        property.setValue("ModifierPanel_Modifier_Static_Mnemonic", string);
        property.setValue("ModifierPanel_Modifier_Synchronized_Mnemonic", string);
        property.setValue("ModifierPanel_Modifier_Transient_Mnemonic", string);
        property.setValue("ModifierPanel_Modifier_Volatile_Mnemonic", string);
        property.setValue("ModifierPanel_Modifier_Native_Mnemonic", string);
        this.modifierPanel.add((Component)propertyPanel, "Center");
        if (this.isConstructor) {
            this.nameTextField.setText(javaClass.getSimpleName());
            this.nameTextField.setEnabled(false);
            this.returnCombo.setEnabled(false);
        } else {
            this.nameTextField.setText(callableFeature.getName());
            this.returnCombo.setSelectedItem(ElementFormat.elementName((NamedElement)this.method.getType()));
        }
        PropertyPanel propertyPanel2 = new PropertyPanel(ElementNode.createParametersProperty(callableFeature, true), 2);
        property = propertyPanel2.getProperty();
        property.setValue("mnemonic_Add", MethodCustomizer.getString("CTL_Parameters_Mnemonic_Add"));
        property.setValue("mnemonic_Remove", MethodCustomizer.getString("CTL_Parameters_Mnemonic_Remove"));
        property.setValue("mnemonic_Up", MethodCustomizer.getString("CTL_Parameters_Mnemonic_Up"));
        property.setValue("mnemonic_Down", MethodCustomizer.getString("CTL_Parameters_Mnemonic_Down"));
        property.setValue("mnemonic_Edit", MethodCustomizer.getString("CTL_Parameters_Mnemonic_Edit"));
        this.paramsPanel.add((Component)propertyPanel2, "Center");
        PropertyPanel propertyPanel3 = new PropertyPanel(ElementNode.createExceptionsProperty(callableFeature, true), 2);
        property = propertyPanel3.getProperty();
        property.setValue("mnemonic_Add", MethodCustomizer.getString("CTL_Parameters_Mnemonic_Add"));
        property.setValue("mnemonic_Remove", MethodCustomizer.getString("CTL_Parameters_Mnemonic_Remove"));
        property.setValue("mnemonic_Up", MethodCustomizer.getString("CTL_Parameters_Mnemonic_Up"));
        property.setValue("mnemonic_Down", MethodCustomizer.getString("CTL_Parameters_Mnemonic_Down"));
        property.setValue("mnemonic_Edit", MethodCustomizer.getString("CTL_Parameters_Mnemonic_Edit"));
        this.exceptionsPanel.add((Component)propertyPanel3, "Center");
        this.jLabel1.setDisplayedMnemonic(MethodCustomizer.getString("CTL_Name_Mnemonic").charAt(0));
        this.jLabel2.setDisplayedMnemonic(MethodCustomizer.getString("CTL_MethodType_Mnemonic").charAt(0));
        this.jLabel3.setVisible(false);
        this.typeTextField.setVisible(false);
        this.initAccessibility();
    }

    public void addNotify() {
        super.addNotify();
        int n = this.nameTextField.getText().length();
        this.nameTextField.setCaretPosition(0);
        this.nameTextField.moveCaretPosition(n);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MethodCustomizer.this.nameTextField.requestFocus();
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.nameTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.typeTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.returnCombo = new JComboBox<String>(COMMON_TYPES);
        this.jLabel4 = new JLabel();
        this.accessPanel = new JPanel();
        this.jLabel5 = new JLabel();
        this.modifierPanel = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.paramsPanel = new JPanel();
        this.exceptionsPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(6, 6, 6, 6)));
        this.jLabel1.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage((Class)MethodCustomizer.class, (String)"CTL_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.nameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                MethodCustomizer.this.nameTextFieldFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 8, 0, 0);
        this.add((Component)this.nameTextField, gridBagConstraints);
        this.nameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)MethodCustomizer.class, (String)"ACSD_MethodNameTextField"));
        this.jLabel3.setLabelFor(this.typeTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage((Class)MethodCustomizer.class, (String)"CTL_Generic_Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.typeTextField, gridBagConstraints);
        this.typeTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)MethodCustomizer.class, (String)"ACSD_MethodType"));
        this.jLabel2.setLabelFor(this.returnCombo);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage((Class)MethodCustomizer.class, (String)"CTL_ReturnType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.returnCombo.setEditable(true);
        this.returnCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MethodCustomizer.this.returnComboActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.returnCombo, gridBagConstraints);
        this.returnCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)MethodCustomizer.class, (String)"ACSD_MethodReturnType"));
        this.jLabel4.setLabelFor(this.accessPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getBundle((Class)MethodCustomizer.class).getString("CTL_AccessRights"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.accessPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.accessPanel, gridBagConstraints);
        this.jLabel5.setLabelFor(this.modifierPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage((Class)MethodCustomizer.class, (String)"CTL_Modifiers"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.modifierPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.modifierPanel, gridBagConstraints);
        this.paramsPanel.setLayout(new BorderLayout());
        this.paramsPanel.setBorder(new EmptyBorder(new Insets(0, 0, 10, 0)));
        this.jTabbedPane1.addTab(NbBundle.getMessage((Class)MethodCustomizer.class, (String)"CTL_Parameters"), this.paramsPanel);
        this.exceptionsPanel.setLayout(new BorderLayout());
        this.exceptionsPanel.setBorder(new EmptyBorder(new Insets(0, 0, 10, 0)));
        this.jTabbedPane1.addTab(NbBundle.getMessage((Class)MethodCustomizer.class, (String)"CTL_Exceptions"), this.exceptionsPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jTabbedPane1, gridBagConstraints);
    }

    private void returnComboActionPerformed(ActionEvent actionEvent) {
        Object object = this.returnCombo.getSelectedItem();
        if (this.isConstructor || object == null) {
            return;
        }
        String string = object.toString().trim();
        Type type = this.method.getType();
        boolean bl = false;
        try {
            Type type2 = this.getJModel().getType().resolve(string);
            if (type.equals(type2)) {
                return;
            }
            if (!TypeEditor.isValidTypeSyntax(string)) {
                MethodCustomizer.notifyUserWarning("MSG_Not_Valid_Type", "invalid type");
            } else {
                this.method.setType(type2);
                bl = true;
            }
        }
        catch (JmiException jmiException) {
            ErrorManager.getDefault().notify((Throwable)jmiException);
        }
        this.isOK = bl;
        if (!bl) {
            this.returnCombo.setSelectedItem(ElementFormat.elementName((NamedElement)type));
        }
    }

    private void nameTextFieldFocusLost(FocusEvent focusEvent) {
        if (focusEvent != null && (focusEvent.isTemporary() || !this.isAncestorOf(focusEvent.getOppositeComponent())) || this.isConstructor) {
            return;
        }
        String string = this.nameTextField.getText().trim();
        String string2 = this.method.getName();
        boolean bl = false;
        try {
            if (focusEvent == null) {
                Method method;
                if (!string2.equals(string)) {
                    if (!Utilities.isJavaIdentifier((String)string)) {
                        MethodCustomizer.notifyUserWarning("MSG_Not_Valid_Identifier", "invalid name");
                        this.isOK = false;
                        this.nameTextField.setText(string2);
                        return;
                    }
                    this.method.setName(string);
                }
                if ((method = this.jclass.getMethod(string, MethodCustomizer.params2Types(this.element.getParameters()), true)) != null) {
                    Type type;
                    Type type2 = TypeClassImpl.getRawType((Type)this.element.getType());
                    if (type2 instanceof UnresolvedClass && !((type = this.getJModel().getType().resolve("java.lang." + type2.getName())) instanceof UnresolvedClass)) {
                        type2 = type;
                    }
                    if (method.getDeclaringClass() == this.jclass) {
                        MethodCustomizer.notifyUserWarning("MSG_Used_Identifier", string, "invalid name");
                    } else if (TypeClassImpl.getRawType((Type)method.getType()) != type2) {
                        MethodCustomizer.notifyUserWarning("MSG_Another_Return_Type", string, "invalid name");
                    } else if (Modifier.isFinal(method.getModifiers())) {
                        MethodCustomizer.notifyUserWarning("MSG_Final_Method_Overriden", method.getDeclaringClass().getName(), "invalid name");
                    } else {
                        bl = true;
                    }
                } else {
                    bl = true;
                }
            } else if (!Utilities.isJavaIdentifier((String)string)) {
                MethodCustomizer.notifyUserWarning("MSG_Not_Valid_Identifier", "invalid name");
            } else {
                if (string2.equals(string)) {
                    return;
                }
                this.method.setName(string);
                bl = true;
            }
        }
        catch (JmiException jmiException) {
            ErrorManager.getDefault().notify((Throwable)jmiException);
        }
        this.isOK = bl;
        if (!bl) {
            this.nameTextField.setText(string2);
        }
    }

    private void initAccessibility() {
        this.nameTextField.getAccessibleContext().setAccessibleName(MethodCustomizer.getString("ACS_MethodNameTextField"));
        this.nameTextField.getAccessibleContext().setAccessibleDescription(MethodCustomizer.getString("ACS_MethodNameTextField"));
        this.getAccessibleContext().setAccessibleDescription(MethodCustomizer.getString("ACSD_MethodCustomizerDialog"));
    }

    public boolean isOK() {
        this.nameTextFieldFocusLost(null);
        if (this.isOK) {
            this.returnComboActionPerformed(null);
        }
        return this.isOK;
    }

    private JavaModelPackage getJModel() {
        return JavaMetamodel.getManager().getJavaExtent((Element)this.jclass);
    }

    private static String getString(String string) {
        return NbBundle.getMessage((Class)MethodCustomizer.class, (String)string);
    }

    private static void notifyUserWarning(String string, String string2) {
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string2);
        ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, null, MethodCustomizer.getString(string), null, null);
        ErrorManager.getDefault().notify((Throwable)illegalArgumentException);
    }

    private static void notifyUserWarning(String string, String string2, String string3) {
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string3);
        ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, null, NbBundle.getMessage((Class)MethodCustomizer.class, (String)string, (Object)string2), null, null);
        ErrorManager.getDefault().notify((Throwable)illegalArgumentException);
    }

    private static List params2Types(List list) {
        ArrayList<Type> arrayList = new ArrayList<Type>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            Type type = parameter.getType();
            arrayList.add(type);
        }
        return arrayList;
    }
}

