/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.elements;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jmi.reflect.InvalidObjectException;
import javax.jmi.reflect.JmiException;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.api.mdr.events.InstanceEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.MDRChangeSource;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.ui.nodes.JavaSourceNodeFactory;
import org.netbeans.modules.java.ui.nodes.SourceNodeFactory;
import org.netbeans.modules.java.ui.nodes.elements.ChildrenProvider;
import org.netbeans.modules.java.ui.nodes.elements.SourceEditSupport;
import org.netbeans.modules.java.ui.nodes.elements.SourceElementFilter;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.cookies.FilterCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

public class SourceChildren
extends Children.Keys
implements FilterCookie,
ChildrenProvider.KeyHandler {
    static final Object NOT_KEY;
    static final Object ERROR_KEY;
    private static int PPP_MASK;
    protected Resource element;
    protected SourceElementFilter filter;
    protected SourceNodeFactory factory;
    private JMIListener wElementL;
    private boolean nodesInited = false;
    private final ChildrenProvider chprovider = new ChildrenProvider(this);
    private final ClassesListener CLS_LISTENER = new ClassesListener(this);
    private DataObject resourceHolder;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SourceChildren() {
        this(JavaSourceNodeFactory.getDefault(), null);
    }

    public SourceChildren(Resource resource) {
        this(JavaSourceNodeFactory.getDefault(), resource);
    }

    public SourceChildren(SourceNodeFactory sourceNodeFactory) {
        this(sourceNodeFactory, null);
    }

    public SourceChildren(SourceNodeFactory sourceNodeFactory, Resource resource) {
        this.element = resource;
        this.factory = sourceNodeFactory;
        this.filter = new SourceElementFilter();
        this.resourceHolder = resource != null ? JavaMetamodel.getManager().getDataObject(resource) : null;
    }

    public Class getFilterClass() {
        return SourceElementFilter.class;
    }

    public Object getFilter() {
        return this.filter;
    }

    public void setFilter(Object object) {
        if (!(object instanceof SourceElementFilter)) {
            throw new IllegalArgumentException();
        }
        this.filter = (SourceElementFilter)object;
        if (this.nodesInited) {
            this.refreshAllKeys();
        }
    }

    protected Resource createResource() {
        return null;
    }

    protected void addNotify() {
        this.setKeys(Collections.singletonList(NOT_KEY));
        ChildrenProvider.RP.post(new Runnable(){

            public void run() {
                Resource resource = SourceChildren.this.element == null ? SourceChildren.this.createResource() : null;
                SourceChildren.this.setElementImpl(resource);
                if (resource != null) {
                    if (SourceChildren.this.wElementL == null) {
                        SourceChildren.this.wElementL = new JMIListener(SourceChildren.this, (MDRChangeSource)resource);
                    }
                    ((MDRChangeSource)resource).addListener((MDRChangeListener)SourceChildren.this.wElementL);
                }
                SourceChildren.this.refreshAllKeys();
                SourceChildren.this.nodesInited = true;
            }
        });
    }

    protected void removeNotify() {
        ChildrenProvider.RP.post(new Runnable(){

            public void run() {
                Resource resource = SourceChildren.this.element;
                if (resource != null) {
                    ((MDRChangeSource)resource).removeListener((MDRChangeListener)SourceChildren.this.wElementL);
                }
                SourceChildren.this.CLS_LISTENER.updateClasses(Collections.EMPTY_LIST);
                SourceChildren.this.chprovider.clear();
                SourceChildren.this.nodesInited = false;
            }
        });
    }

    protected Node[] createNodes(Object object) {
        Node[] nodeArray;
        if (NOT_KEY.equals(object)) {
            nodeArray = new Node[]{this.factory.createWaitNode()};
        } else if (object instanceof Node) {
            nodeArray = new Node[]{new FilterNode((Node)object)};
        } else if (object instanceof Node[]) {
            Node[] nodeArray2 = (Node[])object;
            nodeArray = new Node[nodeArray2.length];
            for (int i = 0; i < nodeArray2.length; ++i) {
                Node node = nodeArray2[i];
                nodeArray[i] = node == null ? node : new FilterNode(node);
            }
        } else if (ERROR_KEY.equals(object)) {
            nodeArray = new Node[]{this.factory.createWaitNode()};
        } else {
            nodeArray = new Node[]{this.factory.createErrorNode()};
            ErrorManager.getDefault().notify(16, (Throwable)new IllegalStateException("key: " + object));
        }
        return nodeArray;
    }

    private Node[] createNodesImpl(Object object) throws JmiException {
        Node node = object instanceof JavaEnum ? this.factory.createEnumNode((JavaEnum)object) : (object instanceof AnnotationType ? this.factory.createAnnotationTypeNode((AnnotationType)object) : (object instanceof JavaClass ? this.factory.createClassNode((JavaClass)object) : (NOT_KEY.equals(object) ? this.factory.createWaitNode() : this.factory.createErrorNode())));
        return new Node[]{node};
    }

    public Node[] getNodes(boolean bl) {
        if (!bl || this.element == null) {
            return this.getNodes();
        }
        this.chprovider.waitFinished();
        return this.getNodes();
    }

    public Node findChild(String string) {
        Node node = super.findChild(string);
        if (node == null) {
            this.chprovider.waitFinished();
            node = super.findChild(string);
        }
        return node;
    }

    public Resource getElement() {
        return this.element;
    }

    public void setElement(final Resource resource) {
        ChildrenProvider.RP.post(new Runnable(){

            public void run() {
                SourceChildren.this.setElementImpl(resource);
            }
        });
    }

    private void setElementImpl(Resource resource) {
        if (this.element != null) {
            ((MDRChangeSource)this.element).removeListener((MDRChangeListener)this.wElementL);
        }
        this.element = resource;
        this.CLS_LISTENER.updateClasses(Collections.EMPTY_LIST);
        if (resource != null) {
            if (this.resourceHolder == null) {
                this.resourceHolder = JavaMetamodel.getManager().getDataObject(resource);
            }
            if (this.wElementL == null) {
                this.wElementL = new JMIListener(this, (MDRChangeSource)resource);
            } else {
                this.wElementL.source = (MDRChangeSource)resource;
            }
            ((MDRChangeSource)resource).addListener((MDRChangeListener)this.wElementL);
        }
        if (this.nodesInited) {
            this.refreshAllKeys();
        }
    }

    private void refreshAllKeys() {
        if (!$assertionsDisabled && !ChildrenProvider.RP.isRequestProcessorThread()) {
            throw new AssertionError();
        }
        if (this.element == null) {
            List<Object> list = Collections.singletonList(ERROR_KEY);
            this.setKeys(list);
        } else {
            if (!this.nodesInited) {
                List<Object> list = Collections.singletonList(NOT_KEY);
                this.setKeys(list);
            }
            this.chprovider.recomputeChildren();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List collectKeysImpl() {
        Resource resource = this.element;
        if (resource == null) {
            return Collections.EMPTY_LIST;
        }
        int[] nArray = this.filter == null || this.filter.getOrder() == null ? SourceElementFilter.DEFAULT_ORDER : this.filter.getOrder();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        try {
            JavaMetamodel.getDefaultRepository().beginTrans(false);
            try {
                if (!resource.isValid()) {
                    linkedList.add(ERROR_KEY);
                    LinkedList<Object> linkedList2 = linkedList;
                    return linkedList2;
                }
                int i = 0;
                while (i < nArray.length) {
                    this.addKeysOfType(resource, linkedList, nArray[i]);
                    ++i;
                }
                return linkedList;
            }
            finally {
                JavaMetamodel.getDefaultRepository().endTrans();
            }
        }
        catch (InvalidObjectException invalidObjectException) {
            linkedList.clear();
            linkedList.add(ERROR_KEY);
            return linkedList;
        }
        catch (JmiException jmiException) {
            ErrorManager.getDefault().notify(16, (Throwable)jmiException);
        }
        return linkedList;
    }

    private void addKeysOfType(Resource resource, Collection collection, int n) {
        List list;
        if (n == 1) {
            return;
        }
        if (this.filter != null && this.filter.isAllClasses()) {
            list = SourceEditSupport.getAllClasses(resource);
            this.CLS_LISTENER.updateClasses(list);
        } else {
            list = resource.getClassifiers();
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JavaClass javaClass = (JavaClass)iterator.next();
            int n2 = javaClass.getModifiers();
            if ((n2 & PPP_MASK) == 0) {
                n2 += 65536;
            }
            if ((this.filter.getModifiers() & n2) == 0) continue;
            if (javaClass instanceof JavaEnum) {
                if ((n & 0x10) == 0) continue;
                collection.add(javaClass);
                continue;
            }
            if (javaClass.isInterface()) {
                if ((n & 4) == 0) continue;
                collection.add(javaClass);
                continue;
            }
            if ((n & 2) == 0) continue;
            collection.add(javaClass);
        }
    }

    public List collectKeys() {
        return this.collectKeysImpl();
    }

    public Node[] prepareNodes(Object object) {
        return this.createNodesImpl(object);
    }

    public void presentKeys(List list, List list2) {
        this.setKeys(list2);
    }

    static {
        $assertionsDisabled = !SourceChildren.class.desiredAssertionStatus();
        NOT_KEY = new Object();
        ERROR_KEY = new Object();
        PPP_MASK = 7;
    }

    private static final class ClassesListener
    implements MDRChangeListener {
        private SourceChildren sc;
        private List classes;

        public ClassesListener(SourceChildren sourceChildren) {
            this.sc = sourceChildren;
            this.classes = Collections.EMPTY_LIST;
        }

        public void updateClasses(List list) {
            ArrayList arrayList = new ArrayList(list);
            arrayList.removeAll(this.classes);
            this.classes.removeAll(list);
            this.addListeners(arrayList);
            this.removeListeners(this.classes);
            this.classes = new ArrayList(list);
        }

        public void change(MDRChangeEvent mDRChangeEvent) {
            ChildrenProvider.RP.post(new Runnable(this, mDRChangeEvent){
                private final /* synthetic */ MDRChangeEvent val$e;
                private final /* synthetic */ ClassesListener this$0;
                {
                    this.this$0 = classesListener;
                    this.val$e = mDRChangeEvent;
                }

                public void run() {
                    ClassesListener.access$1000(this.this$0, this.val$e, ClassesListener.access$900(this.this$0));
                }
            });
        }

        private void processChange(MDRChangeEvent mDRChangeEvent, SourceChildren sourceChildren) {
            if (mDRChangeEvent instanceof AttributeEvent) {
                if (sourceChildren.element == null) {
                    return;
                }
                AttributeEvent attributeEvent = (AttributeEvent)mDRChangeEvent;
                if ("contents".equals(attributeEvent.getAttributeName()) && sourceChildren.nodesInited) {
                    Element element = (Element)attributeEvent.getOldElement();
                    Element element2 = element = element == null ? (Element)attributeEvent.getNewElement() : element;
                    if (element != null && element instanceof JavaClass) {
                        sourceChildren.refreshAllKeys();
                    }
                }
            }
        }

        private void addListeners(List list) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof MDRChangeSource)) continue;
                MDRChangeSource mDRChangeSource = (MDRChangeSource)e;
                mDRChangeSource.addListener((MDRChangeListener)this);
            }
        }

        private void removeListeners(List list) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof MDRChangeSource)) continue;
                MDRChangeSource mDRChangeSource = (MDRChangeSource)e;
                mDRChangeSource.removeListener((MDRChangeListener)this);
            }
        }

        static /* synthetic */ SourceChildren access$900(ClassesListener classesListener) {
            return classesListener.sc;
        }

        static /* synthetic */ void access$1000(ClassesListener classesListener, MDRChangeEvent mDRChangeEvent, SourceChildren sourceChildren) {
            classesListener.processChange(mDRChangeEvent, sourceChildren);
        }
    }

    private static final class JMIListener
    extends WeakReference
    implements MDRChangeListener,
    Runnable {
        private MDRChangeSource source;

        public JMIListener(SourceChildren sourceChildren, MDRChangeSource mDRChangeSource) {
            super(sourceChildren, Utilities.activeReferenceQueue());
            this.source = mDRChangeSource;
        }

        public void change(MDRChangeEvent mDRChangeEvent) {
            SourceChildren sourceChildren = (SourceChildren)this.get();
            if (sourceChildren == null) {
                return;
            }
            ChildrenProvider.RP.post(new Runnable(this, mDRChangeEvent, sourceChildren){
                private final /* synthetic */ MDRChangeEvent val$e;
                private final /* synthetic */ SourceChildren val$sc;
                private final /* synthetic */ JMIListener this$0;
                {
                    this.this$0 = jMIListener;
                    this.val$e = mDRChangeEvent;
                    this.val$sc = sourceChildren;
                }

                public void run() {
                    JMIListener.access$700(this.this$0, this.val$e, this.val$sc);
                }
            });
        }

        private void processChange(MDRChangeEvent mDRChangeEvent, SourceChildren sourceChildren) {
            InstanceEvent instanceEvent;
            RefObject refObject;
            if (mDRChangeEvent instanceof AttributeEvent) {
                if (sourceChildren.element == null || !sourceChildren.element.isValid()) {
                    return;
                }
                AttributeEvent attributeEvent = (AttributeEvent)mDRChangeEvent;
                if ("classifiers".equals(attributeEvent.getAttributeName()) && sourceChildren.nodesInited) {
                    sourceChildren.refreshAllKeys();
                }
            } else if (mDRChangeEvent instanceof InstanceEvent && (refObject = (instanceEvent = (InstanceEvent)mDRChangeEvent).getInstance()) == sourceChildren.element && !sourceChildren.element.isValid()) {
                DataObject dataObject = sourceChildren.resourceHolder;
                if (dataObject != null && dataObject.isValid()) {
                    Resource resource = JavaMetamodel.getManager().getResource(dataObject.getPrimaryFile());
                    sourceChildren.setElement(resource);
                } else {
                    sourceChildren.setElement(null);
                }
            }
        }

        public void run() {
            this.source.removeListener((MDRChangeListener)this);
        }

        static /* synthetic */ void access$700(JMIListener jMIListener, MDRChangeEvent mDRChangeEvent, SourceChildren sourceChildren) {
            jMIListener.processChange(mDRChangeEvent, sourceChildren);
        }
    }
}

