/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.elements;

import java.awt.Component;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.jmi.reflect.JmiException;
import javax.swing.JComponent;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Attribute;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.EnumConstant;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Initializer;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.java.JavaNode;
import org.netbeans.modules.java.ui.nodes.editors.ModifierEditor;
import org.netbeans.modules.java.ui.nodes.elements.AnnotationTypeCustomizer;
import org.netbeans.modules.java.ui.nodes.elements.AnnotationTypeMethodCustomizer;
import org.netbeans.modules.java.ui.nodes.elements.ClassCustomizer;
import org.netbeans.modules.java.ui.nodes.elements.ElementNode;
import org.netbeans.modules.java.ui.nodes.elements.EnumConstantCustomizer;
import org.netbeans.modules.java.ui.nodes.elements.EnumCustomizer;
import org.netbeans.modules.java.ui.nodes.elements.FieldCustomizer;
import org.netbeans.modules.java.ui.nodes.elements.MethodCustomizer;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.NewType;

public final class SourceEditSupport {
    static final byte NT_INITIALIZER = 0;
    static final byte NT_FIELD = 1;
    static final byte NT_CONSTRUCTOR = 2;
    static final byte NT_METHOD = 3;
    static final byte NT_INNERCLASS = 4;
    static final byte NT_INNERINTERFACE = 5;
    static final byte NT_INNERENUM = 6;
    static final byte NT_ENUMCONSTANT = 7;
    static final byte NT_CLASS = 8;
    static final byte NT_INTERFACE = 9;
    static final byte NT_ENUM = 10;
    static final byte NT_ANNOTATION_TYPE = 11;
    static final byte NT_INNERANNOTATION_TYPE = 12;
    static final byte NT_ANNOTATION_TYPE_METHOD = 13;
    static final String[] MENU_NAMES = new String[]{SourceEditSupport.getString("MENU_CREATE_BLOCK"), SourceEditSupport.getString("MENU_CREATE_VARIABLE"), SourceEditSupport.getString("MENU_CREATE_CONSTRUCTOR"), SourceEditSupport.getString("MENU_CREATE_METHOD"), SourceEditSupport.getString("MENU_CREATE_INNERCLASS"), SourceEditSupport.getString("MENU_CREATE_INNERINTERFACE"), SourceEditSupport.getString("MENU_CREATE_INNERENUM"), SourceEditSupport.getString("MENU_CREATE_CONSTANT"), SourceEditSupport.getString("MENU_CREATE_CLASS"), SourceEditSupport.getString("MENU_CREATE_INTERFACE"), SourceEditSupport.getString("MENU_CREATE_ENUM"), SourceEditSupport.getString("MENU_CREATE_ANN_TYPE"), SourceEditSupport.getString("MENU_CREATE_INNERANN_TYPE"), SourceEditSupport.getString("MENU_CREATE_ANN_TYPE_METHOD")};
    private static final int ACCESS_MASK = 7;
    private static final int OTHERS_MASK = 3576;

    private static String getString(String string) {
        return NbBundle.getMessage((Class)SourceEditSupport.class, (String)string);
    }

    public static NewType[] createClassNewTypes(JavaClass javaClass, boolean bl) {
        NewType[] newTypeArray = bl ? new NewType[]{new ElementNewType(javaClass, 0), new ElementNewType(javaClass, 1), new ElementNewType(javaClass, 2), new ElementNewType(javaClass, 3), new ElementNewType(javaClass, 4), new ElementNewType(javaClass, 6), new ElementNewType(javaClass, 5), new ElementNewType(javaClass, 12)} : new NewType[]{new ElementNewType(javaClass, 0), new ElementNewType(javaClass, 1), new ElementNewType(javaClass, 2), new ElementNewType(javaClass, 3), new ElementNewType(javaClass, 4), new ElementNewType(javaClass, 5)};
        return newTypeArray;
    }

    public static NewType[] createInterfaceNewTypes(JavaClass javaClass, boolean bl) {
        NewType[] newTypeArray = bl ? new NewType[]{new ElementNewType(javaClass, 1), new ElementNewType(javaClass, 3), new ElementNewType(javaClass, 4), new ElementNewType(javaClass, 6), new ElementNewType(javaClass, 5), new ElementNewType(javaClass, 12)} : new NewType[]{new ElementNewType(javaClass, 1), new ElementNewType(javaClass, 3), new ElementNewType(javaClass, 4), new ElementNewType(javaClass, 5)};
        return newTypeArray;
    }

    public static NewType[] createEnumNewTypes(JavaEnum javaEnum) {
        return new NewType[]{new ElementNewType((JavaClass)javaEnum, 7), new ElementNewType((JavaClass)javaEnum, 0), new ElementNewType((JavaClass)javaEnum, 1), new ElementNewType((JavaClass)javaEnum, 2), new ElementNewType((JavaClass)javaEnum, 3), new ElementNewType((JavaClass)javaEnum, 4), new ElementNewType((JavaClass)javaEnum, 6), new ElementNewType((JavaClass)javaEnum, 5), new ElementNewType((JavaClass)javaEnum, 12)};
    }

    public static NewType[] createInterfaceNewTypes(AnnotationType annotationType) {
        return new NewType[]{new ElementNewType((JavaClass)annotationType, 1), new ElementNewType((JavaClass)annotationType, 13), new ElementNewType((JavaClass)annotationType, 4), new ElementNewType((JavaClass)annotationType, 6), new ElementNewType((JavaClass)annotationType, 5), new ElementNewType((JavaClass)annotationType, 12)};
    }

    public static NewType[] createJavaNodeNewTypes(JavaNode javaNode) {
        NewType[] newTypeArray = SourceEditSupport.isJDK15Supported(javaNode.getDataObject().getPrimaryFile()) ? new NewType[]{new ElementNewType(javaNode, 8), new ElementNewType(javaNode, 10), new ElementNewType(javaNode, 9), new ElementNewType(javaNode, 11)} : new NewType[]{new ElementNewType(javaNode, 8), new ElementNewType(javaNode, 9)};
        return newTypeArray;
    }

    public static boolean isJDK15Supported(FileObject fileObject) {
        String string = SourceLevelQuery.getSourceLevel((FileObject)fileObject);
        return string != null && string.startsWith("1.5");
    }

    static Attribute findAttribute(AnnotationType annotationType, String string) throws JmiException {
        if (annotationType == null) {
            throw new NullPointerException("at");
        }
        if (string == null) {
            throw new NullPointerException("name");
        }
        Iterator iterator = annotationType.getFeatures().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Attribute) || !string.equals(((Attribute)e).getName())) continue;
            return (Attribute)e;
        }
        return null;
    }

    static EnumConstant findConstant(JavaEnum javaEnum, String string) throws JmiException {
        if (javaEnum == null) {
            throw new NullPointerException("en");
        }
        if (string == null) {
            throw new NullPointerException("name");
        }
        Iterator iterator = javaEnum.getConstants().iterator();
        while (iterator.hasNext()) {
            EnumConstant enumConstant = (EnumConstant)iterator.next();
            if (!string.equals(enumConstant.getName())) continue;
            return enumConstant;
        }
        return null;
    }

    static JavaClass findTopLevelClass(Resource resource, String string) throws JmiException {
        if (resource == null) {
            throw new NullPointerException("res");
        }
        if (string == null) {
            throw new NullPointerException("name");
        }
        Iterator iterator = resource.getClassifiers().iterator();
        while (iterator.hasNext()) {
            JavaClass javaClass = (JavaClass)iterator.next();
            if (!string.equals(javaClass.getSimpleName())) continue;
            return javaClass;
        }
        return null;
    }

    static boolean openCustomizer(Component component, String string) {
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)component, ElementNode.getString(string), 2, -1, null, null);
        Object object = DialogDisplayer.getDefault().notify(notifyDescriptor);
        return object == NotifyDescriptor.OK_OPTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isWriteable(Element element) {
        JavaModel.getJavaRepository().beginTrans(false);
        try {
            boolean bl = element.isValid();
            if (bl) {
                FileObject fileObject = JavaModel.getFileObject((Resource)element.getResource());
                bl = fileObject != null && fileObject.canWrite();
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            JavaModel.getJavaRepository().endTrans();
        }
    }

    public static PropertyPanel createAccessModifiersPanel(ClassMember classMember, int n) {
        PropertyPanel propertyPanel = SourceEditSupport.createModifiersPanel(classMember, n &= 7);
        propertyPanel.getProperty().setValue("customEditorType", (Object)ModifierEditor.ACCESS_MODIFIERS_CUSTOM_EDITOR);
        return propertyPanel;
    }

    public static PropertyPanel createOtherModifiersPanel(ClassMember classMember, int n) {
        PropertyPanel propertyPanel = SourceEditSupport.createModifiersPanel(classMember, n &= 0xDF8);
        propertyPanel.getProperty().setValue("customEditorType", (Object)ModifierEditor.OTHERS_MODIFIERS_CUSTOM_EDITOR);
        return propertyPanel;
    }

    public static PropertyPanel createModifiersPanel(ClassMember classMember) {
        return SourceEditSupport.createModifiersPanel(classMember, SourceEditSupport.getModifiersMask(classMember));
    }

    private static PropertyPanel createModifiersPanel(ClassMember classMember, int n) {
        PropertyPanel propertyPanel = new PropertyPanel(ElementNode.createModifiersProperty(classMember, true, n), 2);
        PropertyEditor propertyEditor = propertyPanel.getProperty().getPropertyEditor();
        if (propertyEditor instanceof ModifierEditor) {
            ((ModifierEditor)((Object)propertyEditor)).setMask(n);
        }
        return propertyPanel;
    }

    public static int getModifiersMask(ClassMember classMember) throws JmiException {
        int n = 0;
        if (classMember instanceof Field) {
            n = SourceEditSupport.getModifiersMask((Field)classMember);
        } else if (classMember instanceof Method) {
            n = SourceEditSupport.getModifiersMask((Method)classMember);
        } else if (classMember instanceof Constructor) {
            n = SourceEditSupport.getModifiersMask((Constructor)classMember);
        } else if (classMember instanceof Attribute) {
            n = SourceEditSupport.getAttributeModifiersMask();
        } else if (classMember instanceof JavaClass) {
            n = SourceEditSupport.getModifiersMask((JavaClass)classMember);
        } else {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("SourceNodes.getModifiersMask: unknown member: " + classMember));
        }
        return n;
    }

    private static int getModifiersMask(Field field) throws JmiException {
        if (SourceEditSupport.isDeclaredInInterface((ClassMember)field)) {
            return 25;
        }
        return 223;
    }

    private static int getModifiersMask(Method method) throws JmiException {
        if (SourceEditSupport.isDeclaredInInterface((ClassMember)method)) {
            return 1025;
        }
        return 1343;
    }

    private static int getModifiersMask(Constructor constructor) {
        return 7;
    }

    private static int getAttributeModifiersMask() {
        return 1025;
    }

    private static int getModifiersMask(JavaClass javaClass) throws JmiException {
        int n = 1025;
        if (!javaClass.isInterface()) {
            n |= 0x10;
        }
        if (SourceEditSupport.isInner(javaClass)) {
            n |= 0xE;
        }
        return n;
    }

    private static boolean isInner(JavaClass javaClass) throws JmiException {
        return javaClass.getDeclaringClass() != null;
    }

    private static boolean isDeclaredInInterface(ClassMember classMember) throws JmiException {
        ClassDefinition classDefinition = classMember.getDeclaringClass();
        return classDefinition instanceof JavaClass && ((JavaClass)classDefinition).isInterface();
    }

    public static List getAllClasses(Resource resource) throws JmiException {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = resource.getClassifiers().iterator();
        while (iterator.hasNext()) {
            SourceEditSupport.addAllClasses((JavaClass)iterator.next(), linkedList);
        }
        return linkedList;
    }

    private static void addAllClasses(JavaClass javaClass, List list) throws JmiException {
        list.add(javaClass);
        Iterator iterator = javaClass.getFeatures().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof JavaClass)) continue;
            SourceEditSupport.addAllClasses((JavaClass)e, list);
        }
    }

    static final class ElementNewType
    extends NewType {
        private final JavaClass element;
        private final JavaNode node;
        byte kind;
        private static final String NEW_FIELD_NAME = "newField";
        private static final String NEW_METHOD_NAME = "newMethod";
        private static final String NEW_ANN_TYPE_METHOD_NAME = "newMethod";
        private static final String NEW_INNERCLASS_NAME = "InnerClass";
        private static final String NEW_INNERINTERFACE_NAME = "InnerInterface";
        private static final String NEW_INNERENUM_NAME = "InnerEnum";
        private static final String NEW_INNERANN_TYPE_NAME = "InnerNewAnnotationType";
        private static final String NEW_CLASS_NAME = "NewClass";
        private static final String NEW_INTERFACE_NAME = "NewInterface";
        private static final String NEW_ENUM_NAME = "NewEnum";
        private static final String NEW_ANN_TYPE_NAME = "NewAnnotationType";

        public ElementNewType(JavaClass javaClass, byte by) {
            this.element = javaClass;
            this.node = null;
            this.kind = by;
        }

        public ElementNewType(JavaNode javaNode, byte by) {
            this.element = null;
            this.node = javaNode;
            this.kind = by;
        }

        public String getName() {
            return MENU_NAMES[this.kind];
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx((class$org$netbeans$modules$java$ui$nodes$elements$SourceEditSupport == null ? (class$org$netbeans$modules$java$ui$nodes$elements$SourceEditSupport = SourceEditSupport.class$("org.netbeans.modules.java.ui.nodes.elements.SourceEditSupport")) : class$org$netbeans$modules$java$ui$nodes$elements$SourceEditSupport).getName() + ".newElement" + this.kind);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void create() throws IOException {
            boolean bl = true;
            try {
                JavaModel.getJavaRepository().beginTrans(true);
                try {
                    this.createImpl();
                    bl = false;
                }
                finally {
                    JavaModel.getJavaRepository().endTrans(bl);
                }
            }
            catch (JmiException jmiException) {
                IOException iOException = new IOException();
                iOException.initCause(jmiException);
                throw iOException;
            }
        }

        private void createImpl() throws JmiException {
            JavaModelPackage javaModelPackage = this.getModel();
            switch (this.kind) {
                case 0: {
                    this.createInitializer(javaModelPackage);
                    break;
                }
                case 1: {
                    this.createField(javaModelPackage);
                    break;
                }
                case 2: {
                    this.createConstructor(javaModelPackage);
                    break;
                }
                case 3: {
                    this.createMethod(javaModelPackage);
                    break;
                }
                case 4: {
                    this.createInnerClass(javaModelPackage);
                    break;
                }
                case 5: {
                    this.createInnerInterface(javaModelPackage);
                    break;
                }
                case 6: {
                    this.createInnerEnum(javaModelPackage);
                    break;
                }
                case 7: {
                    this.createConstant(javaModelPackage);
                    break;
                }
                case 8: {
                    this.createClass(javaModelPackage);
                    break;
                }
                case 9: {
                    this.createInterface(javaModelPackage);
                    break;
                }
                case 10: {
                    this.createEnum(javaModelPackage);
                    break;
                }
                case 11: {
                    this.createAnnotationType(javaModelPackage);
                    break;
                }
                case 12: {
                    this.createInnerAnnotationType(javaModelPackage);
                    break;
                }
                case 13: {
                    this.createAnnotationTypeMethod(javaModelPackage);
                    break;
                }
            }
        }

        private void createInnerInterface(JavaModelPackage javaModelPackage) throws JmiException {
            String string = NEW_INNERINTERFACE_NAME;
            int n = 1;
            while (this.element.getInnerClass(string, true) != null) {
                string = "InnerInterface_" + n;
                ++n;
            }
            JavaClass javaClass = javaModelPackage.getJavaClass().createJavaClass(string, null, 1, null, null, null, null, null, null);
            javaClass.setInterface(true);
            ClassCustomizer classCustomizer = new ClassCustomizer(this.element, javaClass);
            if (SourceEditSupport.openCustomizer(classCustomizer, "TIT_NewInnerInterface") && classCustomizer.isOK()) {
                this.addFeature((Feature)javaClass);
            }
        }

        private void createInnerClass(JavaModelPackage javaModelPackage) throws JmiException {
            String string = NEW_INNERCLASS_NAME;
            int n = 1;
            while (this.element.getInnerClass(string, true) != null) {
                string = "InnerClass_" + n;
                ++n;
            }
            JavaClass javaClass = javaModelPackage.getJavaClass().createJavaClass(string, null, 17, null, null, null, null, null, null);
            javaClass.setInterface(false);
            ClassCustomizer classCustomizer = new ClassCustomizer(this.element, javaClass);
            if (SourceEditSupport.openCustomizer(classCustomizer, "TIT_NewInnerClass") && classCustomizer.isOK()) {
                this.addFeature((Feature)javaClass);
            }
        }

        private void createInterface(JavaModelPackage javaModelPackage) throws JmiException {
            String string = NEW_INTERFACE_NAME;
            Resource resource = this.getResource();
            int n = 1;
            while (SourceEditSupport.findTopLevelClass(resource, string) != null) {
                string = "NewInterface_" + n;
                ++n;
            }
            JavaClass javaClass = javaModelPackage.getJavaClass().createJavaClass(string, null, 0, null, null, null, null, null, null);
            javaClass.setInterface(true);
            ClassCustomizer classCustomizer = new ClassCustomizer(resource, javaClass);
            HelpCtx.setHelpIDString((JComponent)classCustomizer, (String)((class$org$netbeans$modules$java$ui$nodes$elements$SourceEditSupport == null ? (class$org$netbeans$modules$java$ui$nodes$elements$SourceEditSupport = SourceEditSupport.class$("org.netbeans.modules.java.ui.nodes.elements.SourceEditSupport")) : class$org$netbeans$modules$java$ui$nodes$elements$SourceEditSupport).getName() + "$AddNewInterface"));
            if (SourceEditSupport.openCustomizer(classCustomizer, "TIT_NewInterface") && classCustomizer.isOK()) {
                resource.getClassifiers().add(javaClass);
            }
        }

        private void createClass(JavaModelPackage javaModelPackage) throws JmiException {
            String string = NEW_CLASS_NAME;
            Resource resource = this.getResource();
            int n = 1;
            while (SourceEditSupport.findTopLevelClass(resource, string) != null) {
                string = "NewClass_" + n;
                ++n;
            }
            JavaClass javaClass = javaModelPackage.getJavaClass().createJavaClass(string, null, 16, null, null, null, null, null, null);
            javaClass.setInterface(false);
            ClassCustomizer classCustomizer = new ClassCustomizer(resource, javaClass);
            HelpCtx.setHelpIDString((JComponent)classCustomizer, (String)((class$org$netbeans$modules$java$ui$nodes$elements$SourceEditSupport == null ? (class$org$netbeans$modules$java$ui$nodes$elements$SourceEditSupport = SourceEditSupport.class$("org.netbeans.modules.java.ui.nodes.elements.SourceEditSupport")) : class$org$netbeans$modules$java$ui$nodes$elements$SourceEditSupport).getName() + "$AddNewClass"));
            if (SourceEditSupport.openCustomizer(classCustomizer, "TIT_NewClass") && classCustomizer.isOK()) {
                resource.getClassifiers().add(javaClass);
            }
        }

        private void createMethod(JavaModelPackage javaModelPackage) throws JmiException {
            Method method = javaModelPackage.getMethod().createMethod();
            Type type = javaModelPackage.getType().resolve(PrimitiveTypeKindEnum.VOID.toString());
            method.setType(type);
            String string = "newMethod";
            int n = 1;
            while (this.element.getMethod(string, Collections.EMPTY_LIST, true) != null) {
                string = "newMethod_" + n;
                ++n;
            }
            method.setName(string);
            method.setModifiers(1);
            MethodCustomizer methodCustomizer = new MethodCustomizer(this.element, (CallableFeature)method);
            boolean bl = false;
            while ((bl = SourceEditSupport.openCustomizer(methodCustomizer, "TIT_NewMethod")) && !methodCustomizer.isOK()) {
            }
            if (bl) {
                this.addFeature((Feature)method);
            }
        }

        private void createConstructor(JavaModelPackage javaModelPackage) throws JmiException {
            MethodCustomizer methodCustomizer;
            Constructor constructor = javaModelPackage.getConstructor().createConstructor();
            if (!(this.element instanceof JavaEnum)) {
                constructor.setModifiers(1);
            }
            if (SourceEditSupport.openCustomizer(methodCustomizer = new MethodCustomizer(this.element, (CallableFeature)constructor), "TIT_NewConstructor") && methodCustomizer.isOK()) {
                this.addFeature((Feature)constructor);
            }
        }

        private void createField(JavaModelPackage javaModelPackage) throws JmiException {
            Field field = javaModelPackage.getField().createField();
            Type type = javaModelPackage.getType().resolve("int");
            field.setType(type);
            String string = NEW_FIELD_NAME;
            int n = 1;
            while (this.element.getField(string, true) != null) {
                string = "newField_" + n;
                ++n;
            }
            field.setName(string);
            n = !this.element.isInterface() ? 1 : 0;
            field.setModifiers(n != 0 ? 2 : 9);
            FieldCustomizer fieldCustomizer = new FieldCustomizer(this.element, field);
            if (SourceEditSupport.openCustomizer(fieldCustomizer, "TIT_NewField") && fieldCustomizer.isOK()) {
                this.addFeature((Feature)field);
            }
        }

        private void createInitializer(JavaModelPackage javaModelPackage) throws JmiException {
            Initializer initializer = javaModelPackage.getInitializer().createInitializer();
            initializer.setModifiers(8);
            this.addFeature((Feature)initializer);
        }

        private void createInnerEnum(JavaModelPackage javaModelPackage) throws JmiException {
            String string = NEW_INNERENUM_NAME;
            int n = 1;
            while (this.element.getInnerClass(string, true) != null) {
                string = "InnerEnum_" + n;
                ++n;
            }
            JavaEnum javaEnum = javaModelPackage.getJavaEnum().createJavaEnum(string, null, 1, null, null, null, null, null, null, null);
            EnumCustomizer enumCustomizer = new EnumCustomizer(this.element, javaEnum);
            if (SourceEditSupport.openCustomizer(enumCustomizer, "TIT_NewInnerEnum") && enumCustomizer.isOK()) {
                this.addFeature((Feature)javaEnum);
            }
        }

        private void createEnum(JavaModelPackage javaModelPackage) throws JmiException {
            String string = NEW_ENUM_NAME;
            Resource resource = this.getResource();
            int n = 1;
            while (SourceEditSupport.findTopLevelClass(resource, string) != null) {
                string = "NewEnum_" + n;
                ++n;
            }
            JavaEnum javaEnum = javaModelPackage.getJavaEnum().createJavaEnum(string, null, 0, null, null, null, null, null, null, null);
            EnumCustomizer enumCustomizer = new EnumCustomizer(resource, javaEnum);
            if (SourceEditSupport.openCustomizer(enumCustomizer, "TIT_NewEnum") && enumCustomizer.isOK()) {
                resource.getClassifiers().add(javaEnum);
            }
        }

        private void createConstant(JavaModelPackage javaModelPackage) throws JmiException {
            String string;
            JavaEnum javaEnum = (JavaEnum)this.element;
            EnumConstant enumConstant = javaModelPackage.getEnumConstant().createEnumConstant();
            String string2 = string = javaEnum.getSimpleName();
            int n = 1;
            while (SourceEditSupport.findConstant(javaEnum, string2) != null) {
                string2 = string + '_' + n;
                ++n;
            }
            enumConstant.setName(string2);
            EnumConstantCustomizer enumConstantCustomizer = new EnumConstantCustomizer(javaEnum, enumConstant);
            if (SourceEditSupport.openCustomizer(enumConstantCustomizer, "TIT_NewConstant") && enumConstantCustomizer.isOK()) {
                javaEnum.getConstants().add(enumConstant);
            }
        }

        private void createInnerAnnotationType(JavaModelPackage javaModelPackage) throws JmiException {
            String string = NEW_INNERANN_TYPE_NAME;
            int n = 1;
            while (this.element.getInnerClass(string, true) != null) {
                string = "InnerNewAnnotationType_" + n;
                ++n;
            }
            AnnotationType annotationType = javaModelPackage.getAnnotationType().createAnnotationType(string, null, 1, null, null, null, null, null, null);
            AnnotationTypeCustomizer annotationTypeCustomizer = new AnnotationTypeCustomizer(this.element, annotationType);
            if (SourceEditSupport.openCustomizer(annotationTypeCustomizer, "TIT_NewInnerAnnType") && annotationTypeCustomizer.isOK()) {
                this.addFeature((Feature)annotationType);
            }
        }

        private void createAnnotationType(JavaModelPackage javaModelPackage) throws JmiException {
            String string = NEW_ANN_TYPE_NAME;
            Resource resource = this.getResource();
            int n = 1;
            while (SourceEditSupport.findTopLevelClass(resource, string) != null) {
                string = "NewAnnotationType_" + n;
                ++n;
            }
            AnnotationType annotationType = javaModelPackage.getAnnotationType().createAnnotationType(string, null, 0, null, null, null, null, null, null);
            AnnotationTypeCustomizer annotationTypeCustomizer = new AnnotationTypeCustomizer(resource, annotationType);
            if (SourceEditSupport.openCustomizer(annotationTypeCustomizer, "TIT_NewAnnType") && annotationTypeCustomizer.isOK()) {
                resource.getClassifiers().add(annotationType);
            }
        }

        private void createAnnotationTypeMethod(JavaModelPackage javaModelPackage) throws JmiException {
            AnnotationType annotationType = (AnnotationType)this.element;
            String string = "newMethod";
            int n = 1;
            while (SourceEditSupport.findAttribute(annotationType, string) != null) {
                string = "newMethod_" + n;
                ++n;
            }
            Type type = javaModelPackage.getType().resolve("java.lang.String");
            Attribute attribute = javaModelPackage.getAttribute().createAttribute(string, null, 0, null, null, null, null, null);
            attribute.setType(type);
            AnnotationTypeMethodCustomizer annotationTypeMethodCustomizer = new AnnotationTypeMethodCustomizer(annotationType, attribute);
            if (SourceEditSupport.openCustomizer(annotationTypeMethodCustomizer, "TIT_NewAnnTypeMethod") && annotationTypeMethodCustomizer.isOK()) {
                this.addFeature((Feature)attribute);
            }
        }

        private void addFeature(Feature feature) {
            ArrayList arrayList = new ArrayList(this.element.getFeatures());
            ListIterator<Feature> listIterator = arrayList.listIterator(arrayList.size());
            ClassMember classMember = listIterator.hasPrevious() ? (ClassMember)listIterator.previous() : null;
            JavaMetamodel javaMetamodel = JavaMetamodel.getManager();
            if (classMember == null || !javaMetamodel.isElementGuarded((Element)classMember)) {
                this.element.getFeatures().add(feature);
                return;
            }
            while ((classMember = (ClassMember)listIterator.previous()) != null && javaMetamodel.isElementGuarded((Element)classMember)) {
            }
            listIterator = this.element.getFeatures().listIterator();
            if (classMember != null) {
                while (listIterator.next() != classMember) {
                }
            }
            listIterator.add(feature);
        }

        private Resource getResource() {
            return JavaModel.getResource((FileObject)this.node.getDataObject().getPrimaryFile());
        }

        private JavaModelPackage getModel() {
            if (this.element != null) {
                return JavaMetamodel.getManager().getJavaExtent((Element)this.element);
            }
            return JavaMetamodel.getManager().getJavaExtent((Element)this.getResource());
        }
    }
}

