/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.wizard;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.nodes.Node;
import org.openide.src.Type;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class JavaWizardIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = -1987345873459L;
    private transient WizardDescriptor.Panel[] panels;
    private static String[] panelNames;
    private static JavaWizardIterator instance;
    private transient int panelIndex = 0;
    private transient TemplateWizard wizardInstance;

    public static synchronized JavaWizardIterator singleton() {
        if (instance == null) {
            instance = new JavaWizardIterator();
        }
        return instance;
    }

    public Set instantiate(TemplateWizard templateWizard) throws IOException, IllegalArgumentException {
        DataObject dataObject = this.instantiateTemplate(templateWizard.getTemplate(), templateWizard.getTargetFolder(), templateWizard.getTargetName());
        final Node node = dataObject.getNodeDelegate();
        final SystemAction systemAction = node.getDefaultAction();
        if (systemAction != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    systemAction.actionPerformed(new ActionEvent(node, 1001, ""));
                }
            });
        }
        return Collections.singleton(dataObject);
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.panelIndex];
    }

    public String name() {
        return "";
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasPrevious() {
        return false;
    }

    public void nextPanel() {
        throw new NoSuchElementException();
    }

    public void previousPanel() {
        throw new NoSuchElementException();
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void initialize(TemplateWizard templateWizard) {
        this.wizardInstance = templateWizard;
        if (this.panels == null) {
            Component component = templateWizard.targetChooser().getComponent();
            panelNames = new String[]{component.getName()};
            if (component instanceof JComponent) {
                ((JComponent)component).putClientProperty("WizardPanel_contentData", panelNames);
            }
            this.panels = new WizardDescriptor.Panel[]{this.wizardInstance.targetChooser()};
        }
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.panels = null;
        this.wizardInstance = null;
    }

    private Object readResolve() {
        return JavaWizardIterator.singleton();
    }

    private DataObject instantiateTemplate(DataObject dataObject, DataFolder dataFolder, String string) throws IOException {
        if (string == null) {
            string = this.getDefaultName(dataObject, dataFolder);
        }
        this.checkValidPackageName(dataFolder);
        this.checkTargetName(dataFolder, string);
        return dataObject.createFromTemplate(dataFolder, string);
    }

    private boolean isValidPackageName(String string) {
        if ("".equals(string)) {
            return true;
        }
        try {
            Type type = Type.parse((String)string);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    private void checkValidPackageName(DataFolder dataFolder) throws IllegalStateException {
        FileObject fileObject = dataFolder.getPrimaryFile();
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        String string = null;
        if (classPath != null) {
            String string2 = classPath.getResourceName(fileObject, '.', false);
            if (this.isValidPackageName(string2)) {
                return;
            }
            string = MessageFormat.format(JavaWizardIterator.getString("FMTERR_IllegalFolderName"), fileObject.getPath(), string2);
        } else {
            string = JavaWizardIterator.getString("ERR_NotInSourcePath");
        }
        throw (IllegalStateException)ErrorManager.getDefault().annotate((Throwable)new IllegalStateException(string), 256, null, string, null, null);
    }

    private boolean checkTargetName(DataFolder dataFolder, String string) {
        if (!Utilities.isJavaIdentifier((String)string)) {
            String string2 = MessageFormat.format(JavaWizardIterator.getString("FMTERR_IllegalTargetName"), string);
            this.notifyError(string2);
            return false;
        }
        FileObject fileObject = dataFolder.getPrimaryFile();
        if (fileObject.getFileObject(string, "java") != null) {
            String string3 = MessageFormat.format(JavaWizardIterator.getString("FMTERR_TargetExists"), string);
            this.notifyError(string3);
            return false;
        }
        return true;
    }

    private void notifyError(String string) {
        this.wizardInstance.putProperty("WizardPanel_errorMessage", (Object)string);
        IllegalStateException illegalStateException = new IllegalStateException(string);
        ErrorManager.getDefault().annotate((Throwable)illegalStateException, 256, null, string, null, null);
        throw illegalStateException;
    }

    private String getDefaultName(DataObject dataObject, DataFolder dataFolder) {
        String string = FileUtil.findFreeFileName((FileObject)dataFolder.getPrimaryFile(), (String)dataObject.getName(), (String)"java");
        return string;
    }

    static String getString(String string) {
        return NbBundle.getMessage((Class)JavaWizardIterator.class, (String)string);
    }

    static char getMnemonic(String string) {
        return JavaWizardIterator.getString(string).charAt(0);
    }
}

