/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.storagemodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.TypeMismatchException;
import javax.jmi.reflect.WrongSizeException;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.mdr.storagemodel.StorableFeatured;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.IOUtils;
import org.netbeans.mdr.util.Logger;

public class AttrCollection
implements Collection {
    protected Collection inner = new ArrayList();
    protected String attrName;
    protected transient StorableFeatured mdrObject;
    protected transient int maxSize;
    protected transient Class type;
    protected transient boolean isRefObject;
    protected transient MOFID metaMofId;
    protected transient boolean isIndexed = false;
    protected boolean needsUnwrap = false;

    public AttrCollection() {
    }

    AttrCollection(StorableFeatured mdrObject, StorableClass.AttributeDescriptor desc) throws StorageException {
        this(mdrObject, desc, null);
    }

    protected AttrCollection(StorableFeatured mdrObject, StorableClass.AttributeDescriptor desc, Collection values) throws StorageException {
        this.mdrObject = mdrObject;
        this.attrName = desc.getName();
        this.cacheValues(desc);
        if (values != null && !values.isEmpty()) {
            this.checkMaxSize(values.size());
            Iterator it = values.iterator();
            while (it.hasNext()) {
                Object value = it.next();
                this.checkType(value);
                this.inner.add(value);
                if (!this.isRefObject) continue;
                this.setAttribComposite((RefObject)value);
            }
        }
    }

    protected AttrCollection(StorableFeatured mdrObject, List values, int maxSize, Class type, String attrName, boolean isRefObject, MOFID metaMofId) {
        this.mdrObject = mdrObject;
        this.inner = values;
        this.maxSize = maxSize;
        this.type = type;
        this.attrName = attrName;
        this.isRefObject = isRefObject;
        this.metaMofId = metaMofId;
    }

    protected synchronized void checkUnwrap() {
        if (this.needsUnwrap) {
            ListIterator it = ((List)this.inner).listIterator();
            while (it.hasNext()) {
                Object temp = it.next();
                if (temp instanceof MOFID) {
                    temp = this.mdrObject.getMdrStorage().getRepository().getByMofId((MOFID)temp);
                    if (temp != null) {
                        it.set(temp);
                        continue;
                    }
                    it.remove();
                    Logger.getDefault().log(16, "Invalid element found in attr. collection - removing.");
                    continue;
                }
                if (temp != null) continue;
                it.remove();
                Logger.getDefault().log(16, "Null found in attr. collection - removing.");
            }
            this.needsUnwrap = false;
        }
    }

    public void read(InputStream stream, StorableFeatured storable) throws IOException {
        int size = IOUtils.readInt(stream);
        this.mdrObject = storable;
        try {
            this.attrName = IOUtils.readString(stream);
            this.cacheValues(storable.getClassProxy().getAttrDesc(this.attrName));
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
        for (int i = 0; i < size; ++i) {
            this.inner.add(IOUtils.read(stream, storable, this.type.getName()));
        }
        this.needsUnwrap = this.isRefObject;
    }

    public void write(OutputStream stream) throws IOException {
        IOUtils.writeInt(stream, this.inner.size());
        IOUtils.writeString(stream, this.attrName);
        Iterator it = this.inner.iterator();
        while (it.hasNext()) {
            IOUtils.write(stream, it.next(), this.mdrObject);
        }
    }

    private void cacheValues(StorableClass.AttributeDescriptor attrDesc) throws StorageException {
        this.type = attrDesc.getType();
        this.maxSize = attrDesc.getMaxSize();
        this.isRefObject = RefObject.class.isAssignableFrom(this.type);
        this.metaMofId = attrDesc.getMofId();
        this.isIndexed = this.mdrObject instanceof StorableObject && attrDesc.isIndexed();
    }

    protected RefObject getMetaElement() {
        try {
            return (RefObject)this.mdrObject.getMdrStorage().getRepository().getByMofId(this.metaMofId);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean add(Object obj) {
        boolean result;
        this.checkType(obj);
        this.checkMaxSize(1);
        this.checkUnwrap();
        this.mdrObject.objectWillChange();
        if (this.isIndexed) {
            ((StorableObject)this.mdrObject).removeFromIndex(this.metaMofId);
        }
        if (result = this.inner.add(obj)) {
            if (this.isRefObject) {
                try {
                    this.setAttribComposite((RefObject)obj);
                }
                catch (StorageException e) {
                    throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
                }
            }
            this.mdrObject.objectChanged();
        }
        if (this.isIndexed) {
            ((StorableObject)this.mdrObject).addToIndex(this.metaMofId);
        }
        return result;
    }

    public boolean addAll(Collection collection) {
        throw new DebugException();
    }

    public void clear() {
        throw new DebugException();
    }

    public Iterator iterator() {
        this.checkUnwrap();
        return new AttrIterator(this.inner.iterator());
    }

    public boolean removeAll(Collection collection) {
        throw new DebugException();
    }

    public boolean retainAll(Collection collection) {
        throw new DebugException();
    }

    public int size() {
        this.checkUnwrap();
        return this.inner.size();
    }

    public boolean contains(Object obj) {
        this.checkUnwrap();
        return this.inner.contains(obj);
    }

    public boolean containsAll(Collection collection) {
        this.checkUnwrap();
        return this.inner.containsAll(collection);
    }

    public boolean isEmpty() {
        this.checkUnwrap();
        return this.inner.isEmpty();
    }

    public boolean remove(Object obj) {
        boolean result;
        this.checkUnwrap();
        this.mdrObject.objectWillChange();
        if (this.isIndexed) {
            ((StorableObject)this.mdrObject).removeFromIndex(this.metaMofId);
        }
        if (result = this.inner.remove(obj)) {
            if (this.isRefObject) {
                try {
                    this.clearAttribComposite((RefObject)obj);
                }
                catch (StorageException e) {
                    throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
                }
            }
            this.mdrObject.objectChanged();
        }
        if (this.isIndexed) {
            ((StorableObject)this.mdrObject).addToIndex(this.metaMofId);
        }
        return result;
    }

    public Object[] toArray() {
        this.checkUnwrap();
        return this.inner.toArray();
    }

    public Object[] toArray(Object[] obj) {
        this.checkUnwrap();
        return this.inner.toArray(obj);
    }

    public boolean equals(Object o) {
        this.checkUnwrap();
        return ((Object)this.inner).equals(o);
    }

    public int hashCode() {
        this.checkUnwrap();
        return ((Object)this.inner).hashCode();
    }

    protected void checkType(Object obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        if (!this.type.isInstance(obj)) {
            throw new TypeMismatchException(this.type, obj, this.getMetaElement(), "Expected type: " + this.type + ", supplied type: " + obj.getClass().getName());
        }
    }

    protected void checkMaxSize(int size) {
        if (this.maxSize != -1 && this.maxSize < size + this.size()) {
            throw new WrongSizeException(this.getMetaElement());
        }
    }

    protected void setAttribComposite(RefObject object) throws StorageException {
        StorableObject storable = (StorableObject)((BaseObjectHandler)object)._getDelegate();
        storable.setComposite(this.mdrObject, storable.getMofId(), this.metaMofId);
    }

    protected void clearAttribComposite(RefObject object) throws StorageException {
        StorableObject storable = (StorableObject)((BaseObjectHandler)object)._getDelegate();
        storable.clearComposite();
    }

    protected class AttrIterator
    implements Iterator {
        private final Iterator inner;
        protected Object lastRead = null;

        public AttrIterator(Iterator inner) {
            this.inner = inner;
        }

        public boolean hasNext() {
            return this.inner.hasNext();
        }

        public Object next() {
            this.lastRead = this.inner.next();
            return this.lastRead;
        }

        public void remove() {
            AttrCollection.this.mdrObject.objectWillChange();
            if (AttrCollection.this.isIndexed) {
                ((StorableObject)AttrCollection.this.mdrObject).removeFromIndex(AttrCollection.this.metaMofId);
            }
            this.inner.remove();
            if (AttrCollection.this.isRefObject) {
                try {
                    AttrCollection.this.clearAttribComposite((RefObject)this.lastRead);
                }
                catch (StorageException e) {
                    throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
                }
            }
            if (AttrCollection.this.isIndexed) {
                ((StorableObject)AttrCollection.this.mdrObject).addToIndex(AttrCollection.this.metaMofId);
            }
            AttrCollection.this.mdrObject.objectChanged();
        }

        public boolean equals(Object o) {
            return this.inner.equals(o);
        }

        public int hashCode() {
            return this.inner.hashCode();
        }
    }
}

