/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor;

import java.awt.Color;
import java.awt.Font;
import java.util.Map;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.TokenCategory;
import org.netbeans.editor.TokenContext;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.modules.db.sql.editor.SQLEditorKit;
import org.netbeans.modules.db.sql.editor.SQLTokenContext;

public class SQLSettingsInitializer
extends Settings.AbstractInitializer {
    public static final String NAME = "sql-settings-initializer";

    public SQLSettingsInitializer() {
        super(NAME);
    }

    public void updateSettingsMap(Class clazz, Map map) {
        if (clazz == BaseKit.class) {
            new SQLTokenColoringInitializer().updateSettingsMap(clazz, map);
        }
        if (clazz == SQLEditorKit.class) {
            SettingsUtil.updateListSetting((Map)map, (String)"token-context-list", (Object[])new TokenContext[]{SQLTokenContext.context});
        }
    }

    static class SQLTokenColoringInitializer
    extends SettingsUtil.TokenColoringInitializer {
        Font boldFont = SettingsDefaults.defaultFont.deriveFont(1);
        Settings.Evaluator lightGraySubst = new SettingsUtil.ForeColorPrintColoringEvaluator(Color.lightGray);

        public SQLTokenColoringInitializer() {
            super((TokenContext)SQLTokenContext.context);
        }

        public Object getTokenColoring(TokenContextPath tokenContextPath, TokenCategory tokenCategory, boolean bl) {
            if (!bl) {
                int n = tokenCategory.getNumericID();
                switch (n) {
                    case 1: {
                        return SettingsDefaults.emptyColoring;
                    }
                    case 2: {
                        return new Coloring(null, Color.gray, null);
                    }
                    case 3: {
                        return new Coloring(null, Color.gray, null);
                    }
                    case 4: {
                        return new Coloring(null, new Color(153, 0, 107), null);
                    }
                    case 6: {
                        return new Coloring(null, Color.blue, null);
                    }
                    case 7: {
                        return new Coloring(null, Color.black, null);
                    }
                    case 11: {
                        return new Coloring(null, Color.black, null);
                    }
                    case 9: 
                    case 10: {
                        return new Coloring(null, new Color(120, 0, 0), null);
                    }
                    case 12: {
                        return new Coloring(this.boldFont, 2, Color.blue.darker().darker(), null);
                    }
                    case 0: {
                        return new Coloring(null, Color.black, Color.pink);
                    }
                }
            } else {
                switch (tokenCategory.getNumericID()) {
                    case 2: 
                    case 3: {
                        return this.lightGraySubst;
                    }
                }
                return SettingsUtil.defaultPrintColoringEvaluator;
            }
            return null;
        }
    }
}

