/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenID;
import org.netbeans.modules.db.sql.editor.SQLTokenContext;
import org.openide.util.NbBundle;

public class SQLSyntax
extends Syntax {
    private static final int ISI_WHITESPACE = 2;
    private static final int ISI_LINE_COMMENT = 4;
    private static final int ISI_BLOCK_COMMENT = 5;
    private static final int ISI_STRING = 6;
    private static final int ISI_STRING_A_QUOTE = 7;
    private static final int ISI_IDENTIFIER = 10;
    private static final int ISA_SLASH = 11;
    private static final int ISA_OPERATOR = 12;
    private static final int ISA_MINUS = 13;
    private static final int ISA_STAR = 20;
    private static final int ISA_STAR_I_BLOCK_COMMENT_END = 21;
    private static final int ISA_EXCLAMATION = 26;
    private static final int ISA_ZERO = 27;
    private static final int ISI_INT = 28;
    private static final int ISI_DOUBLE = 30;
    private static final int ISA_DOT = 33;
    private static final int ISA_COMMA = 34;
    private static final int ISA_SEMICOLON = 35;
    private static final int ISA_LPAREN = 36;
    private static final int ISA_RPAREN = 37;
    private static HashSet keywords = new HashSet();

    public SQLSyntax() {
        this.tokenContextPath = SQLTokenContext.contextPath;
    }

    private static void populateKeywords() {
        String string = NbBundle.getBundle((Class)SQLSyntax.class).getString("LIST_SQLKeywords");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (keywords.contains(string2 = string2.toUpperCase().trim())) continue;
            keywords.add(string2);
        }
    }

    public static String[] getKeywordList() {
        Object[] objectArray = new String[keywords.size()];
        ArrayList arrayList = new ArrayList();
        Iterator iterator = keywords.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            objectArray[n] = string;
            ++n;
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    protected TokenID parseToken() {
        while (this.offset < this.stopOffset) {
            char c = this.buffer[this.offset];
            block0 : switch (this.state) {
                case -1: {
                    switch (c) {
                        case '\'': {
                            this.state = 6;
                            break block0;
                        }
                        case '/': {
                            this.state = 11;
                            break block0;
                        }
                        case '!': 
                        case '(': 
                        case ')': 
                        case '*': 
                        case '+': 
                        case ',': 
                        case ';': 
                        case '<': 
                        case '=': 
                        case '>': {
                            ++this.offset;
                            this.state = -1;
                            return SQLTokenContext.OPERATOR;
                        }
                        case '-': {
                            this.state = 13;
                            break block0;
                        }
                        case '0': {
                            this.state = 27;
                            break block0;
                        }
                        case '.': {
                            this.state = 33;
                            break block0;
                        }
                    }
                    if (Character.isWhitespace(c)) {
                        this.state = 2;
                        break;
                    }
                    if (Character.isDigit(c)) {
                        this.state = 28;
                        break;
                    }
                    this.state = 10;
                    break;
                }
                case 2: {
                    if (Character.isWhitespace(c)) break;
                    this.state = -1;
                    return SQLTokenContext.WHITESPACE;
                }
                case 4: {
                    if (c != '\n') break;
                    this.state = -1;
                    return SQLTokenContext.LINE_COMMENT;
                }
                case 5: {
                    if (c != '*') break;
                    this.state = 21;
                    break;
                }
                case 6: {
                    switch (c) {
                        case '\n': {
                            this.state = -1;
                            return SQLTokenContext.INCOMPLETE_STRING;
                        }
                        case '\'': {
                            ++this.offset;
                            this.state = -1;
                            return SQLTokenContext.STRING;
                        }
                    }
                    break;
                }
                case 10: {
                    if (Character.isLetterOrDigit(c) || c == '_') break;
                    this.state = -1;
                    TokenID tokenID = this.matchKeyword(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
                    if (tokenID != null) {
                        return tokenID;
                    }
                    return SQLTokenContext.IDENTIFIER;
                }
                case 11: {
                    switch (c) {
                        case '*': {
                            this.state = 5;
                            break block0;
                        }
                    }
                    if (!Character.isWhitespace(c) && c != '(') break;
                    this.state = -1;
                    return SQLTokenContext.OPERATOR;
                }
                case 13: {
                    switch (c) {
                        case '-': {
                            this.state = 4;
                            break block0;
                        }
                    }
                    this.state = -1;
                    return SQLTokenContext.OPERATOR;
                }
                case 21: {
                    switch (c) {
                        case '/': {
                            ++this.offset;
                            this.state = -1;
                            return SQLTokenContext.BLOCK_COMMENT;
                        }
                    }
                    --this.offset;
                    this.state = 5;
                    break;
                }
                case 27: {
                    switch (c) {
                        case '.': {
                            this.state = 30;
                            break block0;
                        }
                    }
                    if (Character.isDigit(c)) {
                        this.state = 28;
                        break;
                    }
                    this.state = -1;
                    return SQLTokenContext.INT_LITERAL;
                }
                case 28: {
                    switch (c) {
                        case '.': {
                            this.state = 30;
                            break block0;
                        }
                    }
                    if (Character.isDigit(c)) {
                        this.state = 28;
                        break;
                    }
                    this.state = -1;
                    return SQLTokenContext.INT_LITERAL;
                }
                case 30: {
                    if (c >= '0' && c <= '9') {
                        this.state = 30;
                        break;
                    }
                    this.state = -1;
                    return SQLTokenContext.DOUBLE_LITERAL;
                }
                case 33: {
                    if (Character.isDigit(c)) {
                        this.state = 30;
                        break;
                    }
                    this.state = -1;
                    return SQLTokenContext.DOT;
                }
            }
            ++this.offset;
        }
        if (this.lastBuffer) {
            switch (this.state) {
                case 2: {
                    this.state = -1;
                    return SQLTokenContext.WHITESPACE;
                }
                case 10: {
                    this.state = -1;
                    TokenID tokenID = this.matchKeyword(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
                    if (tokenID != null) {
                        return tokenID;
                    }
                    return SQLTokenContext.IDENTIFIER;
                }
                case 4: {
                    return SQLTokenContext.LINE_COMMENT;
                }
                case 5: 
                case 21: {
                    return SQLTokenContext.BLOCK_COMMENT;
                }
                case 6: {
                    return SQLTokenContext.STRING;
                }
                case 27: 
                case 28: {
                    this.state = -1;
                    return SQLTokenContext.INT_LITERAL;
                }
                case 30: {
                    this.state = -1;
                    return SQLTokenContext.DOUBLE_LITERAL;
                }
                case 33: {
                    this.state = -1;
                    return SQLTokenContext.DOT;
                }
                case 11: {
                    this.state = -1;
                    return SQLTokenContext.OPERATOR;
                }
            }
        }
        switch (this.state) {
            case 2: {
                return SQLTokenContext.WHITESPACE;
            }
        }
        return null;
    }

    public String getStateName(int n) {
        switch (n) {
            case 2: {
                return "ISI_WHITESPACE";
            }
            case 4: {
                return "ISI_LINE_COMMENT";
            }
            case 5: {
                return "ISI_BLOCK_COMMENT";
            }
            case 6: {
                return "ISI_STRING";
            }
            case 7: {
                return "ISI_STRING_A_QUOTE";
            }
            case 10: {
                return "ISI_IDENTIFIER";
            }
            case 11: {
                return "ISA_SLASH";
            }
            case 12: {
                return "ISA_OPERATOR";
            }
            case 13: {
                return "ISA_MINUS";
            }
            case 20: {
                return "ISA_STAR";
            }
            case 21: {
                return "ISA_STAR_I_BLOCK_COMMENT_END";
            }
            case 27: {
                return "ISA_ZERO";
            }
            case 28: {
                return "ISI_INT";
            }
            case 30: {
                return "ISI_DOUBLE";
            }
            case 33: {
                return "ISA_DOT";
            }
            case 34: {
                return "ISA_COMMA";
            }
        }
        return super.getStateName(n);
    }

    public TokenID matchKeyword(char[] cArray, int n, int n2) {
        String string = new String(cArray, n, n2);
        if (keywords.contains(string = string.toUpperCase())) {
            return SQLTokenContext.KEYWORD;
        }
        return null;
    }

    static {
        SQLSyntax.populateKeywords();
    }
}

