/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor.ui.actions;

import java.sql.SQLException;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.api.sql.SQLExecuteCookie;
import org.netbeans.modules.db.sql.editor.ui.actions.ConnectionAction;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

public class RunSQLAction
extends CookieAction {
    private static final ErrorManager LOGGER = ErrorManager.getDefault().getInstance(RunSQLAction.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(1);
    private static final String ICON_PATH = "org/netbeans/modules/db/sql/editor/resources/runsql.png";

    protected Class[] cookieClasses() {
        return new Class[]{SQLExecuteCookie.class};
    }

    protected int mode() {
        return 8;
    }

    protected void performAction(Node[] nodeArray) {
        if (nodeArray.length < 1) {
            return;
        }
        if (LOG) {
            LOGGER.log(1, "Called performAction on node: " + nodeArray[0]);
        }
        EditorCookie editorCookie = (EditorCookie)nodeArray[0].getCookie(EditorCookie.class);
        SQLExecuteCookie sQLExecuteCookie = (SQLExecuteCookie)nodeArray[0].getCookie(SQLExecuteCookie.class);
        if (sQLExecuteCookie == null) {
            if (LOG) {
                LOGGER.log(1, "Called performAction on node without SQLExecuteCookie");
            }
            return;
        }
        DatabaseConnection databaseConnection = ConnectionAction.getConnectionForCookie(sQLExecuteCookie);
        if (databaseConnection == null) {
            if (LOG) {
                LOGGER.log(1, "No database connection selected for node");
            }
            return;
        }
        try {
            sQLExecuteCookie.executeSQL(databaseConnection);
        }
        catch (SQLException sQLException) {
            ErrorManager.getDefault().notify((Throwable)sQLException);
        }
    }

    public String getName() {
        return NbBundle.getMessage((Class)RunSQLAction.class, (String)"LBL_RunSqlAction");
    }

    protected String iconResource() {
        return ICON_PATH;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(RunSQLAction.class);
    }

    protected boolean asynchronous() {
        return false;
    }
}

